/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.ui;

import com.intellij.diff.FrameDiffTool;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeViewDiffRequestProcessor;
import com.intellij.openapi.vcs.changes.ui.ChangesTree;
import com.intellij.openapi.vcs.changes.ui.SimpleTreeDiffRequestProcessor;
import com.intellij.openapi.vcs.changes.ui.VcsTreeModelData;
import com.intellij.util.ui.tree.TreeUtil;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.stream.Stream;
import javax.swing.JComponent;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u000e\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fH\u0016J\u000e\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\r0\fH\u0016J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\rH\u0014J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0014J\u0010\u0010\u0016\u001a\u00020\u00102\u0006\u0010\u0017\u001a\u00020\u0013H\u0002J\u0016\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\u0019\u001a\u00020\u001aH\u0002R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lcom/intellij/openapi/vcs/changes/ui/SimpleTreeDiffRequestProcessor;", "Lcom/intellij/openapi/vcs/changes/ChangeViewDiffRequestProcessor;", "project", "Lcom/intellij/openapi/project/Project;", "place", "", "tree", "Lcom/intellij/openapi/vcs/changes/ui/ChangesTree;", "parentDisposable", "Lcom/intellij/openapi/Disposable;", "(Lcom/intellij/openapi/project/Project;Ljava/lang/String;Lcom/intellij/openapi/vcs/changes/ui/ChangesTree;Lcom/intellij/openapi/Disposable;)V", "getAllChanges", "Ljava/util/stream/Stream;", "Lcom/intellij/openapi/vcs/changes/ChangeViewDiffRequestProcessor$Wrapper;", "getSelectedChanges", "selectChange", "", "change", "shouldAddToolbarBottomBorder", "", "toolbarComponents", "Lcom/intellij/diff/FrameDiffTool$ToolbarComponents;", "updatePreviewLater", "modelUpdateInProgress", "wrap", "treeModelData", "Lcom/intellij/openapi/vcs/changes/ui/VcsTreeModelData;", "intellij.platform.vcs.impl"})
public final class SimpleTreeDiffRequestProcessor
extends ChangeViewDiffRequestProcessor {
    private final ChangesTree tree;

    private final void updatePreviewLater(boolean modelUpdateInProgress) {
        SwingUtilities.invokeLater(new Runnable(this, modelUpdateInProgress){
            final /* synthetic */ SimpleTreeDiffRequestProcessor this$0;
            final /* synthetic */ boolean $modelUpdateInProgress;

            public final void run() {
                if (!this.this$0.isDisposed()) {
                    JComponent jComponent = this.this$0.getComponent();
                    Intrinsics.checkNotNullExpressionValue((Object)jComponent, (String)"component");
                    this.this$0.updatePreview(jComponent.isShowing(), this.$modelUpdateInProgress);
                }
            }
            {
                this.this$0 = simpleTreeDiffRequestProcessor;
                this.$modelUpdateInProgress = bl;
            }
        });
    }

    @NotNull
    public Stream<ChangeViewDiffRequestProcessor.Wrapper> getSelectedChanges() {
        VcsTreeModelData vcsTreeModelData = VcsTreeModelData.selected((JTree)((Object)this.tree));
        Intrinsics.checkNotNullExpressionValue((Object)vcsTreeModelData, (String)"VcsTreeModelData.selected(tree)");
        return this.wrap(vcsTreeModelData);
    }

    @NotNull
    public Stream<ChangeViewDiffRequestProcessor.Wrapper> getAllChanges() {
        VcsTreeModelData vcsTreeModelData = VcsTreeModelData.all((JTree)((Object)this.tree));
        Intrinsics.checkNotNullExpressionValue((Object)vcsTreeModelData, (String)"VcsTreeModelData.all(tree)");
        return this.wrap(vcsTreeModelData);
    }

    @Override
    protected void selectChange(@NotNull ChangeViewDiffRequestProcessor.Wrapper change) {
        Intrinsics.checkNotNullParameter((Object)change, (String)"change");
        DefaultMutableTreeNode defaultMutableTreeNode = TreeUtil.findNodeWithObject((DefaultMutableTreeNode)this.tree.getRoot(), (Object)change.getUserObject());
        if (defaultMutableTreeNode == null) {
            return;
        }
        Intrinsics.checkNotNullExpressionValue((Object)defaultMutableTreeNode, (String)"TreeUtil.findNodeWithObj\u2026nge.userObject) ?: return");
        DefaultMutableTreeNode node2 = defaultMutableTreeNode;
        TreeUtil.selectPath((JTree)((JTree)((Object)this.tree)), (TreePath)TreeUtil.getPathFromRoot((TreeNode)node2), (boolean)false);
    }

    @Override
    protected boolean shouldAddToolbarBottomBorder(@NotNull FrameDiffTool.ToolbarComponents toolbarComponents) {
        Intrinsics.checkNotNullParameter((Object)toolbarComponents, (String)"toolbarComponents");
        return false;
    }

    private final Stream<ChangeViewDiffRequestProcessor.Wrapper> wrap(VcsTreeModelData treeModelData) {
        Stream<ChangeViewDiffRequestProcessor.Wrapper> stream = treeModelData.userObjectsStream(Change.class).map(wrap.1.INSTANCE);
        Intrinsics.checkNotNullExpressionValue(stream, (String)"treeModelData.userObject\u2026map { ChangeWrapper(it) }");
        return stream;
    }

    public SimpleTreeDiffRequestProcessor(@NotNull Project project, @NotNull String place, @NotNull ChangesTree tree, @NotNull Disposable parentDisposable) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)place, (String)"place");
        Intrinsics.checkNotNullParameter((Object)tree, (String)"tree");
        Intrinsics.checkNotNullParameter((Object)parentDisposable, (String)"parentDisposable");
        super(project, place);
        this.tree = tree;
        Disposer.register((Disposable)parentDisposable, (Disposable)this);
        this.tree.addSelectionListener(new Runnable(){

            @Override
            public final void run() {
                this.updatePreviewLater(false);
            }
        }, this);
        this.tree.addPropertyChangeListener("model", new PropertyChangeListener(){

            @Override
            public final void propertyChange(PropertyChangeEvent it) {
                this.updatePreviewLater(false);
            }
        });
        this.updatePreviewLater(false);
    }
}

