/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.ui;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.FileStatusManager;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ui.TreeModelBuilder;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.ColoredListCellRenderer;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.PlatformIcons;
import com.intellij.util.ui.UIUtil;
import com.intellij.vcsUtil.VcsUtil;
import java.io.File;
import javax.swing.JList;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class VirtualFileListCellRenderer
extends ColoredListCellRenderer {
    protected final Project myProject;
    private final FileStatusManager myFileStatusManager;
    private final boolean myIgnoreFileStatus;

    public VirtualFileListCellRenderer(Project project) {
        this(project, false);
    }

    public VirtualFileListCellRenderer(Project project, boolean ignoreFileStatus) {
        this.myProject = project;
        this.myIgnoreFileStatus = ignoreFileStatus;
        this.myFileStatusManager = FileStatusManager.getInstance((Project)project);
    }

    protected void customizeCellRenderer(@NotNull JList list2, Object value2, int index2, boolean selected2, boolean hasFocus) {
        if (list2 == null) {
            VirtualFileListCellRenderer.$$$reportNull$$$0(0);
        }
        FilePath path2 = TreeModelBuilder.getPathForObject(value2);
        this.renderIcon(path2);
        FileStatus fileStatus = this.myIgnoreFileStatus ? FileStatus.NOT_CHANGED : this.getStatus(value2, path2);
        this.append(this.getName(path2), new SimpleTextAttributes(0, fileStatus.getColor(), null));
        this.putParentPath(value2, path2, path2);
        this.setBackground(selected2 ? (hasFocus ? UIUtil.getListSelectionBackground((boolean)true) : UIUtil.getListUnfocusedSelectionBackground()) : UIUtil.getListBackground());
    }

    @Nls
    protected String getName(FilePath path2) {
        return path2.getName();
    }

    protected FileStatus getStatus(Object value2, FilePath path2) {
        VirtualFile virtualFile2;
        FileStatus fileStatus = value2 instanceof Change ? ((Change)value2).getFileStatus() : ((virtualFile2 = path2.getVirtualFile()) != null ? this.myFileStatusManager.getStatus(virtualFile2) : FileStatus.NOT_CHANGED);
        return fileStatus;
    }

    protected void renderIcon(FilePath path2) {
        if (path2.isDirectory()) {
            this.setIcon(PlatformIcons.FOLDER_ICON);
        } else {
            this.setIcon(VcsUtil.getIcon((Project)this.myProject, (FilePath)path2));
        }
    }

    protected void putParentPath(Object value2, FilePath path2, FilePath self) {
        File parentFile = path2.getIOFile().getParentFile();
        if (parentFile != null) {
            String parentPath = parentFile.getPath();
            this.append(" (", SimpleTextAttributes.GRAYED_ATTRIBUTES);
            this.putParentPathImpl(value2, parentPath, self);
            this.append(")", SimpleTextAttributes.GRAYED_ATTRIBUTES);
        }
    }

    protected void putParentPathImpl(Object value2, @NlsSafe String parentPath, FilePath self) {
        this.append(parentPath, SimpleTextAttributes.GRAYED_ATTRIBUTES);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "com/intellij/openapi/vcs/changes/ui/VirtualFileListCellRenderer", "customizeCellRenderer"));
    }
}

