/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.impl;

import com.intellij.ide.impl.ContentManagerWatcher;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.changes.ChangeViewDiffRequestProcessor;
import com.intellij.openapi.vcs.changes.DiffPreview;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserBase;
import com.intellij.openapi.vcs.changes.ui.ChangesTree;
import com.intellij.openapi.vcs.changes.ui.SimpleTreeDiffRequestProcessor;
import com.intellij.openapi.vcs.changes.ui.SimpleTreeEditorDiffPreview;
import com.intellij.openapi.vcs.impl.ChangesBrowserToolWindow;
import com.intellij.openapi.wm.RegisterToolWindowTask;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowAnchor;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.ui.content.Content;
import java.util.function.Supplier;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0007J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0018\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0013\u001a\u00020\u0014H\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/intellij/openapi/vcs/impl/ChangesBrowserToolWindow;", "", "()V", "TOOLWINDOW_ID", "", "createDiffPreview", "Lcom/intellij/openapi/vcs/changes/DiffPreview;", "project", "Lcom/intellij/openapi/project/Project;", "changesBrowser", "Lcom/intellij/openapi/vcs/changes/ui/ChangesBrowserBase;", "disposable", "Lcom/intellij/openapi/Disposable;", "registerRepositoriesToolWindow", "Lcom/intellij/openapi/wm/ToolWindow;", "toolWindowManager", "Lcom/intellij/openapi/wm/ToolWindowManager;", "showTab", "", "content", "Lcom/intellij/ui/content/Content;", "intellij.platform.vcs.impl"})
public final class ChangesBrowserToolWindow {
    @NotNull
    public static final String TOOLWINDOW_ID = "VcsChanges";
    @NotNull
    public static final ChangesBrowserToolWindow INSTANCE;

    @JvmStatic
    public static final void showTab(@NotNull Project project, @NotNull Content content2) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)content2, (String)"content");
        ToolWindowManager toolWindowManager = ToolWindowManager.Companion.getInstance(project);
        ToolWindow toolWindow2 = toolWindowManager.getToolWindow(TOOLWINDOW_ID);
        if (toolWindow2 == null) {
            toolWindow2 = INSTANCE.registerRepositoriesToolWindow(toolWindowManager);
        }
        ToolWindow repoToolWindow = toolWindow2;
        content2.putUserData(Content.SIMPLIFIED_TAB_RENDERING_KEY, (Object)true);
        repoToolWindow.getContentManager().removeAllContents(true);
        repoToolWindow.getContentManager().addContent(content2);
        repoToolWindow.activate(null);
    }

    @JvmStatic
    @NotNull
    public static final DiffPreview createDiffPreview(@NotNull Project project, @NotNull ChangesBrowserBase changesBrowser, @NotNull Disposable disposable2) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)changesBrowser, (String)"changesBrowser");
        Intrinsics.checkNotNullParameter((Object)disposable2, (String)"disposable");
        ChangesTree changesTree = changesBrowser.getViewer();
        Intrinsics.checkNotNullExpressionValue((Object)changesTree, (String)"changesBrowser.viewer");
        SimpleTreeDiffRequestProcessor processor2 = new SimpleTreeDiffRequestProcessor(project, "ChangesToolWindowPreview", changesTree, disposable2);
        ChangeViewDiffRequestProcessor changeViewDiffRequestProcessor = processor2;
        ChangesTree changesTree2 = changesBrowser.getViewer();
        Intrinsics.checkNotNullExpressionValue((Object)changesTree2, (String)"changesBrowser.viewer");
        return new SimpleTreeEditorDiffPreview(project, processor2, changesBrowser, changeViewDiffRequestProcessor, changesTree2){
            final /* synthetic */ Project $project;
            final /* synthetic */ SimpleTreeDiffRequestProcessor $processor;
            final /* synthetic */ ChangesBrowserBase $changesBrowser;

            @NotNull
            protected String getCurrentName() {
                String string;
                String changeName = this.getChangeViewProcessor().getCurrentChangeName();
                if (changeName != null) {
                    String string2 = VcsBundle.message((String)"changes.editor.diff.preview.title", (Object[])new Object[]{changeName});
                    string = string2;
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"VcsBundle.message(\"chang\u2026eview.title\", changeName)");
                } else {
                    String string3 = VcsBundle.message((String)"changes.editor.diff.preview.empty.title", (Object[])new Object[0]);
                    string = string3;
                    Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"VcsBundle.message(\"chang\u2026iff.preview.empty.title\")");
                }
                return string;
            }

            public void returnFocusToTree() {
                block0: {
                    ToolWindow toolWindow2 = ToolWindowManager.Companion.getInstance(this.$project).getToolWindow("VcsChanges");
                    if (toolWindow2 == null) break block0;
                    toolWindow2.activate(null);
                }
            }
            {
                this.$project = $captured_local_variable$0;
                this.$processor = $captured_local_variable$1;
                this.$changesBrowser = $captured_local_variable$2;
                super($super_call_param$3, $super_call_param$4);
            }
        };
    }

    private final ToolWindow registerRepositoriesToolWindow(ToolWindowManager toolWindowManager) {
        ToolWindowAnchor toolWindowAnchor = ToolWindowAnchor.LEFT;
        Intrinsics.checkNotNullExpressionValue((Object)toolWindowAnchor, (String)"ToolWindowAnchor.LEFT");
        ToolWindow toolWindow2 = toolWindowManager.registerToolWindow(new RegisterToolWindowTask(TOOLWINDOW_ID, toolWindowAnchor, null, false, true, true, false, null, null, (Supplier)registerRepositoriesToolWindow.toolWindow.1.INSTANCE, 460, null));
        toolWindow2.getComponent().putClientProperty("HideIdLabel", "true");
        ContentManagerWatcher.watchContentManager(toolWindow2, toolWindow2.getContentManager());
        return toolWindow2;
    }

    private ChangesBrowserToolWindow() {
    }

    static {
        ChangesBrowserToolWindow changesBrowserToolWindow;
        INSTANCE = changesBrowserToolWindow = new ChangesBrowserToolWindow();
    }
}

