/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.impl;

import com.intellij.ide.impl.ContentManagerWatcher;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.vcs.impl.RepositoryBrowser;
import com.intellij.openapi.vcs.impl.RepositoryBrowserPanel;
import com.intellij.openapi.vcs.vfs.AbstractVcsVirtualFile;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.RegisterToolWindowTask;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowAnchor;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentFactory;
import com.intellij.ui.content.ContentManager;
import java.util.function.Supplier;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J(\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\b\b\u0001\u0010\u0011\u001a\u00020\u0004R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/intellij/openapi/vcs/impl/RepositoryBrowser;", "", "()V", "TOOLWINDOW_ID", "", "registerRepositoriesToolWindow", "Lcom/intellij/openapi/wm/ToolWindow;", "toolWindowManager", "Lcom/intellij/openapi/wm/ToolWindowManager;", "showRepositoryBrowser", "", "project", "Lcom/intellij/openapi/project/Project;", "root", "Lcom/intellij/openapi/vcs/vfs/AbstractVcsVirtualFile;", "localRoot", "Lcom/intellij/openapi/vfs/VirtualFile;", "title", "intellij.platform.vcs.impl"})
public final class RepositoryBrowser {
    @NotNull
    public static final String TOOLWINDOW_ID = "Repositories";
    @NotNull
    public static final RepositoryBrowser INSTANCE;

    public final void showRepositoryBrowser(@NotNull Project project, @NotNull AbstractVcsVirtualFile root2, @NotNull VirtualFile localRoot, @NlsContexts.TabTitle @NotNull String title2) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)((Object)root2), (String)"root");
        Intrinsics.checkNotNullParameter((Object)localRoot, (String)"localRoot");
        Intrinsics.checkNotNullParameter((Object)title2, (String)"title");
        ToolWindowManager toolWindowManager = ToolWindowManager.Companion.getInstance(project);
        ToolWindow toolWindow2 = toolWindowManager.getToolWindow(TOOLWINDOW_ID);
        if (toolWindow2 == null) {
            toolWindow2 = this.registerRepositoriesToolWindow(toolWindowManager);
        }
        ToolWindow repoToolWindow = toolWindow2;
        ContentManager contentManager2 = repoToolWindow.getContentManager();
        Intrinsics.checkNotNullExpressionValue((Object)contentManager2, (String)"repoToolWindow.contentManager");
        Content[] contentArray = contentManager2.getContents();
        int n = contentArray.length;
        for (int j = 0; j < n; ++j) {
            RepositoryBrowserPanel component2;
            Content content2;
            Content content3 = content2 = contentArray[j];
            Intrinsics.checkNotNullExpressionValue((Object)content3, (String)"content");
            JComponent jComponent = content3.getComponent();
            if (!(jComponent instanceof RepositoryBrowserPanel)) {
                jComponent = null;
            }
            if ((RepositoryBrowserPanel)jComponent == null) {
                continue;
            }
            if (!Intrinsics.areEqual((Object)((Object)component2.getRoot()), (Object)((Object)root2))) continue;
            repoToolWindow.getContentManager().setSelectedContent(content2);
            return;
        }
        RepositoryBrowserPanel contentPanel2 = new RepositoryBrowserPanel(project, root2, localRoot);
        Content content4 = ContentFactory.SERVICE.getInstance().createContent((JComponent)contentPanel2, title2, true);
        Intrinsics.checkNotNullExpressionValue((Object)content4, (String)"ContentFactory.SERVICE.g\u2026ontentPanel, title, true)");
        Content content5 = content4;
        repoToolWindow.getContentManager().addContent(content5);
        repoToolWindow.getContentManager().setSelectedContent(content5, true);
        repoToolWindow.activate(null);
    }

    private final ToolWindow registerRepositoriesToolWindow(ToolWindowManager toolWindowManager) {
        ToolWindowAnchor toolWindowAnchor = ToolWindowAnchor.LEFT;
        Intrinsics.checkNotNullExpressionValue((Object)toolWindowAnchor, (String)"ToolWindowAnchor.LEFT");
        ToolWindow toolWindow2 = toolWindowManager.registerToolWindow(new RegisterToolWindowTask(TOOLWINDOW_ID, toolWindowAnchor, null, false, true, true, false, null, null, (Supplier)registerRepositoriesToolWindow.toolWindow.1.INSTANCE, 460, null));
        ContentManagerWatcher.watchContentManager(toolWindow2, toolWindow2.getContentManager());
        return toolWindow2;
    }

    private RepositoryBrowser() {
    }

    static {
        RepositoryBrowser repositoryBrowser;
        INSTANCE = repositoryBrowser = new RepositoryBrowser();
    }
}

