/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.impl;

import com.intellij.openapi.editor.Document;
import com.intellij.openapi.localVcs.UpToDateLineNumberProvider;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.ex.LineStatusTracker;
import com.intellij.openapi.vcs.impl.LineStatusTrackerManager;
import com.intellij.openapi.vcs.impl.LineStatusTrackerManagerI;
import org.jetbrains.annotations.Nullable;

public class UpToDateLineNumberProviderImpl
implements UpToDateLineNumberProvider {
    private final Document myDocument;
    private final LineStatusTrackerManagerI myLineStatusTrackerManagerI;

    public UpToDateLineNumberProviderImpl(Document document, Project project) {
        this.myDocument = document;
        this.myLineStatusTrackerManagerI = LineStatusTrackerManager.getInstance(project);
    }

    public boolean isRangeChanged(int start2, int end) {
        LineStatusTracker<?> tracker2 = this.getTracker();
        if (tracker2 == null) {
            return false;
        }
        return tracker2.isRangeModified(start2, end);
    }

    public boolean isLineChanged(int currentNumber) {
        LineStatusTracker<?> tracker2 = this.getTracker();
        if (tracker2 == null) {
            return false;
        }
        return tracker2.isLineModified(currentNumber);
    }

    public int getLineNumber(int currentNumber) {
        LineStatusTracker<?> tracker2 = this.getTracker();
        if (tracker2 == null) {
            return currentNumber;
        }
        return tracker2.transferLineToVcs(currentNumber, false);
    }

    public int getLineCount() {
        LineStatusTracker<?> tracker2 = this.getTracker();
        if (tracker2 == null) {
            return this.myDocument.getLineCount();
        }
        return tracker2.getVcsDocument().getLineCount();
    }

    @Nullable
    private LineStatusTracker<?> getTracker() {
        LineStatusTracker<?> tracker2 = this.myLineStatusTrackerManagerI.getLineStatusTracker(this.myDocument);
        return tracker2 != null && tracker2.isOperational() ? tracker2 : null;
    }
}

