/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.readOnlyHandler;

import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.readOnlyHandler.HandleType;
import com.intellij.openapi.vcs.readOnlyHandler.HandleTypeFactory;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ListWithSelection;

class FileInfo {
    private final VirtualFile myFile;
    private final ListWithSelection<HandleType> myHandleType = new ListWithSelection();

    FileInfo(VirtualFile file2, Project project) {
        this.myFile = file2;
        this.myHandleType.add((Object)HandleType.USE_FILE_SYSTEM);
        this.myHandleType.selectFirst();
        for (HandleTypeFactory factory2 : (HandleTypeFactory[])HandleTypeFactory.EP_NAME.getExtensions((AreaInstance)project)) {
            HandleType handleType = factory2.createHandleType(file2);
            if (handleType == null) continue;
            this.myHandleType.add((Object)handleType);
            this.myHandleType.select((Object)handleType);
        }
    }

    public VirtualFile getFile() {
        return this.myFile;
    }

    public HandleType getSelectedHandleType() {
        return (HandleType)this.myHandleType.getSelection();
    }

    public boolean hasVersionControl() {
        return this.myHandleType.size() > 1;
    }

    public ListWithSelection<HandleType> getHandleType() {
        return this.myHandleType;
    }
}

