/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.readOnlyHandler;

import com.intellij.ide.IdeEventQueue;
import com.intellij.ide.presentation.VirtualFilePresentation;
import com.intellij.navigation.TargetPresentation;
import com.intellij.navigation.TargetPresentationBuilder;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.fileTypes.FileTypesBundle;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.readOnlyHandler.FileInfo;
import com.intellij.openapi.vcs.readOnlyHandler.HandleType;
import com.intellij.openapi.vcs.readOnlyHandler.PresentableFileInfo;
import com.intellij.openapi.vcs.readOnlyHandler.ReadOnlyStatusDialog;
import com.intellij.openapi.vfs.ReadonlyStatusHandler;
import com.intellij.openapi.vfs.ReadonlyStatusHandlerBase;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@com.intellij.openapi.components.State(name="ReadonlyStatusHandler", storages={@Storage(value="$WORKSPACE_FILE$")})
public final class ReadonlyStatusHandlerImpl
extends ReadonlyStatusHandlerBase
implements PersistentStateComponent<State> {
    private final Project myProject;
    private boolean myClearReadOnlyInTests;
    private State myState;

    public ReadonlyStatusHandlerImpl(@NotNull Project project) {
        if (project == null) {
            ReadonlyStatusHandlerImpl.$$$reportNull$$$0(0);
        }
        super(project);
        this.myState = new State();
        this.myProject = project;
    }

    @NotNull
    public State getState() {
        State state = this.myState;
        if (state == null) {
            ReadonlyStatusHandlerImpl.$$$reportNull$$$0(1);
        }
        return state;
    }

    public void loadState(@NotNull State state) {
        if (state == null) {
            ReadonlyStatusHandlerImpl.$$$reportNull$$$0(2);
        }
        this.myState = state;
    }

    @NotNull
    protected ReadonlyStatusHandler.OperationStatus ensureFilesWritable(@NotNull Collection<? extends VirtualFile> originalFiles, Collection<? extends VirtualFile> files2) {
        List fileInfos;
        if (originalFiles == null) {
            ReadonlyStatusHandlerImpl.$$$reportNull$$$0(3);
        }
        if ((fileInfos = files2.stream().filter(vf -> vf != null && !vf.isWritable() && vf.isInLocalFileSystem()).map(vf -> new FileInfo((VirtualFile)vf, this.myProject)).collect(Collectors.toList())).isEmpty()) {
            ReadonlyStatusHandler.OperationStatus operationStatus = ReadonlyStatusHandlerImpl.createResultStatus(originalFiles, files2);
            if (operationStatus == null) {
                ReadonlyStatusHandlerImpl.$$$reportNull$$$0(4);
            }
            return operationStatus;
        }
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            if (this.myClearReadOnlyInTests) {
                ReadonlyStatusHandlerImpl.processFiles(new ArrayList(fileInfos), null);
            }
            ReadonlyStatusHandler.OperationStatus operationStatus = ReadonlyStatusHandlerImpl.createResultStatus(originalFiles, files2);
            if (operationStatus == null) {
                ReadonlyStatusHandlerImpl.$$$reportNull$$$0(5);
            }
            return operationStatus;
        }
        int savedEventCount = IdeEventQueue.getInstance().getEventCount();
        if (this.myState.SHOW_DIALOG) {
            List presentableFileInfos = (List)ActionUtil.underModalProgress((Project)this.myProject, (String)FileTypesBundle.message("progress.title.resolving.filetype", new Object[0]), () -> this.createPresentableFileInfos(fileInfos));
            new ReadOnlyStatusDialog(this.myProject, presentableFileInfos).show();
        } else {
            ReadonlyStatusHandlerImpl.processFiles(new ArrayList(fileInfos), null);
        }
        IdeEventQueue.getInstance().setEventCount(savedEventCount);
        ReadonlyStatusHandler.OperationStatus operationStatus = ReadonlyStatusHandlerImpl.createResultStatus(originalFiles, files2);
        if (operationStatus == null) {
            ReadonlyStatusHandlerImpl.$$$reportNull$$$0(6);
        }
        return operationStatus;
    }

    private List<PresentableFileInfo> createPresentableFileInfos(List<FileInfo> fileInfos) {
        return ContainerUtil.map(fileInfos, fileInfo -> {
            TargetPresentationBuilder builder2 = TargetPresentation.builder((String)fileInfo.getFile().getPresentableName()).icon(VirtualFilePresentation.getIcon(fileInfo.getFile())).presentableText(fileInfo.getFile().getPresentableName());
            VirtualFile vfParent = fileInfo.getFile().getParent();
            if (vfParent != null) {
                builder2 = builder2.locationText(vfParent.getPresentableUrl());
            }
            return new PresentableFileInfo(fileInfo.getFile(), builder2.presentation(), this.myProject);
        });
    }

    public static void processFiles(@NotNull List<? extends FileInfo> fileInfos, @Nullable String changelist) {
        if (fileInfos == null) {
            ReadonlyStatusHandlerImpl.$$$reportNull$$$0(7);
        }
        FileInfo[] copy2 = fileInfos.toArray(new FileInfo[0]);
        MultiMap handleTypeToFile = new MultiMap();
        for (FileInfo fileInfo : copy2) {
            handleTypeToFile.putValue((Object)fileInfo.getSelectedHandleType(), (Object)fileInfo.getFile());
        }
        for (HandleType handleType : handleTypeToFile.keySet()) {
            handleType.processFiles(handleTypeToFile.get((Object)handleType), changelist);
        }
        for (FileInfo fileInfo : copy2) {
            if (fileInfo.getFile().exists() && !fileInfo.getFile().isWritable()) continue;
            fileInfos.remove(fileInfo);
        }
    }

    @TestOnly
    public void setClearReadOnlyInTests(boolean clearReadOnlyInTests) {
        assert (ApplicationManager.getApplication().isUnitTestMode());
        this.myClearReadOnlyInTests = clearReadOnlyInTests;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vcs/readOnlyHandler/ReadonlyStatusHandlerImpl";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "originalFiles";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileInfos";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vcs/readOnlyHandler/ReadonlyStatusHandlerImpl";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getState";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "ensureFilesWritable";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 6: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "loadState";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "ensureFilesWritable";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "processFiles";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static final class State {
        public boolean SHOW_DIALOG = true;

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            State state = (State)o;
            return this.SHOW_DIALOG == state.SHOW_DIALOG;
        }

        public int hashCode() {
            return this.SHOW_DIALOG ? 1 : 0;
        }
    }
}

