/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.roots;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsRoot;
import com.intellij.openapi.vcs.VcsRootChecker;
import com.intellij.openapi.vcs.impl.projectlevelman.AllVcses;
import com.intellij.openapi.vcs.roots.VcsRootDetector;
import com.intellij.openapi.vcs.roots.VcsRootScanner;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileVisitor;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class VcsRootDetectorImpl
implements VcsRootDetector {
    private static final Logger LOG = Logger.getInstance(VcsRootDetectorImpl.class);
    @NotNull
    private final Project myProject;
    @Nullable
    private Collection<DetectedVcsRoot> myDetectedRoots;
    @NotNull
    private final Object LOCK;

    VcsRootDetectorImpl(@NotNull Project project) {
        if (project == null) {
            VcsRootDetectorImpl.$$$reportNull$$$0(0);
        }
        this.LOCK = new Object();
        this.myProject = project;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    public Collection<VcsRoot> detect() {
        Object object = this.LOCK;
        // MONITORENTER : object
        Collection<VcsRoot> roots2 = this.scanForRootsInContentRoots();
        this.myDetectedRoots = ContainerUtil.map(roots2, x$0 -> new DetectedVcsRoot((VcsRoot)x$0));
        Collection<VcsRoot> collection = roots2;
        // MONITOREXIT : object
        if (collection != null) return collection;
        VcsRootDetectorImpl.$$$reportNull$$$0(1);
        return collection;
    }

    @NotNull
    public Collection<VcsRoot> detect(@Nullable VirtualFile startDir) {
        Collection<VcsRoot> collection = startDir == null ? Collections.emptyList() : Collections.unmodifiableSet(this.scanForDirectory(startDir));
        if (collection == null) {
            VcsRootDetectorImpl.$$$reportNull$$$0(2);
        }
        return collection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    public Collection<VcsRoot> getOrDetect() {
        Object object = this.LOCK;
        // MONITORENTER : object
        if (this.myDetectedRoots != null) {
            List list2 = ContainerUtil.mapNotNull(this.myDetectedRoots, it -> it.toVcsRoot(this.myProject));
            // MONITOREXIT : object
            if (list2 != null) return list2;
            VcsRootDetectorImpl.$$$reportNull$$$0(3);
            return list2;
        }
        Collection<VcsRoot> collection = this.detect();
        // MONITOREXIT : object
        if (collection != null) return collection;
        VcsRootDetectorImpl.$$$reportNull$$$0(4);
        return collection;
    }

    @NotNull
    private Set<VcsRoot> scanForDirectory(@NotNull VirtualFile dirToScan) {
        if (dirToScan == null) {
            VcsRootDetectorImpl.$$$reportNull$$$0(5);
        }
        if (!VcsRootChecker.EXTENSION_POINT_NAME.hasAnyExtensions()) {
            Set<VcsRoot> set2 = Collections.emptySet();
            if (set2 == null) {
                VcsRootDetectorImpl.$$$reportNull$$$0(6);
            }
            return set2;
        }
        HashSet<VcsRoot> detectedRoots = new HashSet<VcsRoot>();
        HashMap<VirtualFile, Boolean> scannedDirs = new HashMap<VirtualFile, Boolean>();
        this.scanForRootsInsideDir(this.myProject, dirToScan, null, scannedDirs, detectedRoots);
        detectedRoots.addAll(this.scanForRootsAboveDirs(Collections.singletonList(dirToScan), scannedDirs, detectedRoots));
        HashSet<VcsRoot> hashSet = detectedRoots;
        if (hashSet == null) {
            VcsRootDetectorImpl.$$$reportNull$$$0(7);
        }
        return hashSet;
    }

    @NotNull
    private Collection<VcsRoot> scanForRootsInContentRoots() {
        if (this.myProject.isDisposed() || !VcsRootChecker.EXTENSION_POINT_NAME.hasAnyExtensions()) {
            List<VcsRoot> list2 = Collections.emptyList();
            if (list2 == null) {
                VcsRootDetectorImpl.$$$reportNull$$$0(8);
            }
            return list2;
        }
        ArrayList<VirtualFile> contentRoots = new ArrayList<VirtualFile>(Arrays.asList(ProjectRootManager.getInstance((Project)this.myProject).getContentRoots()));
        VirtualFile baseDir = this.myProject.getBaseDir();
        if (baseDir != null && !contentRoots.contains(baseDir)) {
            contentRoots.add(baseDir);
        }
        HashSet<VcsRoot> detectedRoots = new HashSet<VcsRoot>();
        HashSet<VirtualFile> skipDirs = new HashSet<VirtualFile>();
        HashMap<VirtualFile, Boolean> scannedDirs = new HashMap<VirtualFile, Boolean>();
        contentRoots.sort(Comparator.comparing(root2 -> -root2.getPath().length()));
        for (VirtualFile dir : contentRoots) {
            this.scanForRootsInsideDir(this.myProject, dir, skipDirs, scannedDirs, detectedRoots);
            skipDirs.add(dir);
        }
        detectedRoots.addAll(this.scanForRootsAboveDirs(contentRoots, scannedDirs, detectedRoots));
        HashSet<VcsRoot> hashSet = detectedRoots;
        if (hashSet == null) {
            VcsRootDetectorImpl.$$$reportNull$$$0(9);
        }
        return hashSet;
    }

    private void scanForRootsInsideDir(@NotNull Project project, @NotNull VirtualFile root2, @Nullable Set<VirtualFile> skipDirs, @NotNull Map<VirtualFile, Boolean> scannedDirs, @NotNull Set<VcsRoot> result2) {
        if (project == null) {
            VcsRootDetectorImpl.$$$reportNull$$$0(10);
        }
        if (root2 == null) {
            VcsRootDetectorImpl.$$$reportNull$$$0(11);
        }
        if (scannedDirs == null) {
            VcsRootDetectorImpl.$$$reportNull$$$0(12);
        }
        if (result2 == null) {
            VcsRootDetectorImpl.$$$reportNull$$$0(13);
        }
        VcsRootScanner.visitDirsRecursivelyWithoutExcluded(project, root2, false, dir -> {
            if (skipDirs != null && skipDirs.contains(dir)) {
                return VirtualFileVisitor.SKIP_CHILDREN;
            }
            if (scannedDirs.containsKey(dir)) {
                return VirtualFileVisitor.CONTINUE;
            }
            VcsRoot vcsRoot = this.getVcsRootFor((VirtualFile)dir, null);
            scannedDirs.put((VirtualFile)dir, vcsRoot != null);
            if (vcsRoot != null) {
                LOG.debug("Found VCS ", new Object[]{vcsRoot.getVcs(), " in ", vcsRoot.getPath(), " under ", root2});
                result2.add(vcsRoot);
            }
            return VirtualFileVisitor.CONTINUE;
        });
    }

    @NotNull
    private Collection<VcsRoot> scanForRootsAboveDirs(@NotNull Collection<VirtualFile> dirsToScan, @NotNull Map<VirtualFile, Boolean> scannedDirs, @NotNull Collection<VcsRoot> detectedRoots) {
        if (dirsToScan == null) {
            VcsRootDetectorImpl.$$$reportNull$$$0(14);
        }
        if (scannedDirs == null) {
            VcsRootDetectorImpl.$$$reportNull$$$0(15);
        }
        if (detectedRoots == null) {
            VcsRootDetectorImpl.$$$reportNull$$$0(16);
        }
        HashSet<VirtualFile> skipDirs = new HashSet<VirtualFile>();
        for (VcsRoot root2 : detectedRoots) {
            skipDirs.add(root2.getPath());
        }
        ContainerUtil.addIfNotNull(skipDirs, (Object)VfsUtil.getUserHomeDir());
        HashSet<VcsRoot> result2 = new HashSet<VcsRoot>();
        for (VirtualFile dir : dirsToScan) {
            this.scanForRootsAboveDir(dir, scannedDirs, skipDirs, result2);
        }
        HashSet<VcsRoot> hashSet = result2;
        if (hashSet == null) {
            VcsRootDetectorImpl.$$$reportNull$$$0(17);
        }
        return hashSet;
    }

    private void scanForRootsAboveDir(@NotNull VirtualFile root2, @NotNull Map<VirtualFile, Boolean> scannedDirs, @NotNull Set<VirtualFile> skipDirs, @NotNull Set<VcsRoot> result2) {
        VirtualFile parent;
        Pattern ignorePattern;
        if (root2 == null) {
            VcsRootDetectorImpl.$$$reportNull$$$0(18);
        }
        if (scannedDirs == null) {
            VcsRootDetectorImpl.$$$reportNull$$$0(19);
        }
        if (skipDirs == null) {
            VcsRootDetectorImpl.$$$reportNull$$$0(20);
        }
        if (result2 == null) {
            VcsRootDetectorImpl.$$$reportNull$$$0(21);
        }
        if (VcsRootScanner.isUnderIgnoredDirectory(this.myProject, ignorePattern = VcsRootScanner.parseDirIgnorePattern(), root2)) {
            return;
        }
        VirtualFile virtualFile2 = parent = root2.isDirectory() ? root2 : root2.getParent();
        while (parent != null) {
            if (!skipDirs.add(parent)) {
                return;
            }
            if (scannedDirs.get(parent) == Boolean.TRUE) {
                return;
            }
            if (!scannedDirs.containsKey(parent)) {
                VcsRoot vcsRoot = this.getVcsRootFor(parent, root2);
                scannedDirs.put(parent, vcsRoot != null);
                if (vcsRoot != null) {
                    LOG.debug("Found VCS ", new Object[]{vcsRoot.getVcs(), " in ", vcsRoot.getPath(), " above ", root2});
                    result2.add(vcsRoot);
                    return;
                }
            }
            parent = parent.getParent();
        }
    }

    @Nullable
    private VcsRoot getVcsRootFor(@NotNull VirtualFile maybeRoot, @Nullable VirtualFile dirToCheckForIgnore) {
        if (maybeRoot == null) {
            VcsRootDetectorImpl.$$$reportNull$$$0(22);
        }
        ProgressManager.checkCanceled();
        String path2 = maybeRoot.getPath();
        ProjectLevelVcsManager projectLevelVcsManager = ProjectLevelVcsManager.getInstance((Project)this.myProject);
        return (VcsRoot)VcsRootChecker.EXTENSION_POINT_NAME.computeSafeIfAny(checker -> {
            if (checker.isRoot(path2) && (dirToCheckForIgnore == null || !checker.isIgnored(maybeRoot, dirToCheckForIgnore))) {
                AbstractVcs vcs = projectLevelVcsManager.findVcsByName(checker.getSupportedVcs().getName());
                return vcs == null ? null : new VcsRoot(vcs, maybeRoot);
            }
            return null;
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 17: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 17: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vcs/roots/VcsRootDetectorImpl";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dirToScan";
                break;
            }
            case 11: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 12: 
            case 15: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scannedDirs";
                break;
            }
            case 13: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dirsToScan";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "detectedRoots";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "skipDirs";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "maybeRoot";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vcs/roots/VcsRootDetectorImpl";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "detect";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getOrDetect";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "scanForDirectory";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "scanForRootsInContentRoots";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "scanForRootsAboveDirs";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 17: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "scanForDirectory";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "scanForRootsInsideDir";
                break;
            }
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "scanForRootsAboveDirs";
                break;
            }
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "scanForRootsAboveDir";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "getVcsRootFor";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 17: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static final class DetectedVcsRoot {
        @Nullable
        private final String myVcsName;
        @NotNull
        private final VirtualFile myPath;

        private DetectedVcsRoot(@NotNull VcsRoot root2) {
            if (root2 == null) {
                DetectedVcsRoot.$$$reportNull$$$0(0);
            }
            AbstractVcs vcs = root2.getVcs();
            this.myVcsName = vcs != null ? vcs.getName() : null;
            this.myPath = root2.getPath();
        }

        @Nullable
        public VcsRoot toVcsRoot(@NotNull Project project) {
            if (project == null) {
                DetectedVcsRoot.$$$reportNull$$$0(1);
            }
            if (this.myVcsName == null) {
                return null;
            }
            AbstractVcs vcs = AllVcses.getInstance(project).getByName(this.myVcsName);
            return vcs != null ? new VcsRoot(vcs, this.myPath) : null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "root";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/openapi/vcs/roots/VcsRootDetectorImpl$DetectedVcsRoot";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "toVcsRoot";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

