/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.ui;

import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.codeInsight.daemon.impl.TrafficLightRenderer;
import com.intellij.codeInsight.intention.IntentionManager;
import com.intellij.codeInspection.ex.InspectionProfileWrapper;
import com.intellij.ide.ui.LafManager;
import com.intellij.ide.ui.LafManagerListener;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.SpellCheckingEditorCustomizationProvider;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.impl.EditorMarkupModelImpl;
import com.intellij.openapi.fileTypes.FileTypes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.CommitMessageI;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.VcsDataKeys;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.ui.AdditionalPageAtBottomEditorCustomization;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.EditorCustomization;
import com.intellij.ui.EditorTextField;
import com.intellij.ui.EditorTextFieldProvider;
import com.intellij.ui.ErrorStripeEditorCustomization;
import com.intellij.ui.SeparatorFactory;
import com.intellij.ui.SoftWrapsEditorCustomization;
import com.intellij.ui.TitledSeparator;
import com.intellij.ui.components.JBLoadingPanel;
import com.intellij.util.ObjectUtils;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.components.BorderLayoutPanel;
import com.intellij.vcs.commit.CommitMessageUi;
import com.intellij.vcs.commit.message.BodyLimitSettings;
import com.intellij.vcs.commit.message.CommitMessageInspectionProfile;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.LayoutManager;
import java.util.HashSet;
import java.util.function.Supplier;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CommitMessage
extends JPanel
implements Disposable,
DataProvider,
CommitMessageUi,
CommitMessageI,
LafManagerListener {
    public static final Key<CommitMessage> DATA_KEY = Key.create((String)"Vcs.CommitMessage.Panel");
    public static final Key<Supplier<Iterable<Change>>> CHANGES_SUPPLIER_KEY = Key.create((String)"Vcs.CommitMessage.CompletionContext");
    @NotNull
    private final JBLoadingPanel myLoadingPanel;
    @Nullable
    @Nls
    private final String myMessagePlaceholder;
    @NotNull
    private static final EditorCustomization COLOR_SCHEME_FOR_CURRENT_UI_THEME_CUSTOMIZATION = editor2 -> {
        editor2.setBackgroundColor(null);
        editor2.setColorsScheme(CommitMessage.getCommitMessageColorScheme());
    };
    @NotNull
    private final EditorTextField myEditorField;
    @Nullable
    private final TitledSeparator mySeparator;

    @NotNull
    private static EditorColorsScheme getCommitMessageColorScheme() {
        boolean isEditorDark;
        boolean isLaFDark = ColorUtil.isDark((Color)UIUtil.getPanelBackground());
        EditorColorsScheme editorColorsScheme = isLaFDark == (isEditorDark = EditorColorsManager.getInstance().isDarkEditor()) ? EditorColorsManager.getInstance().getGlobalScheme() : EditorColorsManager.getInstance().getSchemeForCurrentUITheme();
        if (editorColorsScheme == null) {
            CommitMessage.$$$reportNull$$$0(0);
        }
        return editorColorsScheme;
    }

    public CommitMessage(@NotNull Project project) {
        if (project == null) {
            CommitMessage.$$$reportNull$$$0(1);
        }
        this(project, true, true, true);
    }

    public CommitMessage(@NotNull Project project, boolean withSeparator, boolean showToolbar, boolean runInspections) {
        if (project == null) {
            CommitMessage.$$$reportNull$$$0(2);
        }
        this(project, withSeparator, showToolbar, runInspections, null);
    }

    public CommitMessage(@NotNull Project project, boolean withSeparator, boolean showToolbar, boolean runInspections, @Nullable @Nls String messagePlaceholder) {
        if (project == null) {
            CommitMessage.$$$reportNull$$$0(3);
        }
        super(new BorderLayout());
        this.myMessagePlaceholder = messagePlaceholder;
        this.myEditorField = CommitMessage.createCommitMessageEditor(project, runInspections);
        this.myEditorField.getDocument().putUserData(DATA_KEY, (Object)this);
        this.myEditorField.setPlaceholder(this.myMessagePlaceholder);
        this.myLoadingPanel = new JBLoadingPanel((LayoutManager)new BorderLayout(), (Disposable)this, 0);
        this.myLoadingPanel.add((Component)((Object)this.myEditorField), (Object)"Center");
        this.add((Component)this.myLoadingPanel, "Center");
        if (withSeparator) {
            this.mySeparator = SeparatorFactory.createSeparator((String)VcsBundle.message((String)"label.commit.comment", (Object[])new Object[0]), (JComponent)this.myEditorField.getComponent());
            BorderLayoutPanel separatorPanel = JBUI.Panels.simplePanel().addToBottom((Component)this.mySeparator).addToTop(Box.createVerticalGlue());
            BorderLayoutPanel labelPanel = (BorderLayoutPanel)JBUI.Panels.simplePanel((Component)separatorPanel).withBorder(BorderFactory.createEmptyBorder());
            if (showToolbar) {
                labelPanel.addToRight((Component)this.createToolbar(true));
            }
            this.add((Component)labelPanel, "North");
        } else {
            this.mySeparator = null;
            if (showToolbar) {
                this.add((Component)this.createToolbar(false), "East");
            }
        }
        this.setBorder(BorderFactory.createEmptyBorder());
        this.updateOnInspectionProfileChanged(project);
        ApplicationManager.getApplication().getMessageBus().connect((Disposable)this).subscribe(LafManagerListener.TOPIC, (Object)this);
    }

    public void stopLoading() {
        this.myLoadingPanel.stopLoading();
        this.myEditorField.setEnabled(true);
        this.myEditorField.setPlaceholder(this.myMessagePlaceholder);
    }

    public void startLoading() {
        this.myEditorField.setEnabled(false);
        this.myEditorField.setPlaceholder(null);
        this.myLoadingPanel.startLoading();
    }

    private void updateOnInspectionProfileChanged(@NotNull Project project) {
        if (project == null) {
            CommitMessage.$$$reportNull$$$0(4);
        }
        project.getMessageBus().connect((Disposable)this).subscribe(CommitMessageInspectionProfile.TOPIC, () -> {
            Editor editor2 = this.myEditorField.getEditor();
            if (editor2 instanceof EditorEx) {
                RightMarginCustomization.customize(project, (EditorEx)editor2);
            }
        });
    }

    public void lookAndFeelChanged(@NotNull LafManager source) {
        Editor editor2;
        if (source == null) {
            CommitMessage.$$$reportNull$$$0(5);
        }
        if ((editor2 = this.myEditorField.getEditor()) instanceof EditorEx) {
            COLOR_SCHEME_FOR_CURRENT_UI_THEME_CUSTOMIZATION.customize((EditorEx)editor2);
        }
    }

    @NotNull
    private JComponent createToolbar(boolean horizontal) {
        ActionToolbar toolbar = ActionManager.getInstance().createActionToolbar("CommitMessage", CommitMessage.getToolbarActions(), horizontal);
        toolbar.setReservePlaceAutoPopupIcon(false);
        toolbar.getComponent().setBorder(BorderFactory.createEmptyBorder());
        toolbar.setTargetComponent((JComponent)this);
        JComponent jComponent = toolbar.getComponent();
        if (jComponent == null) {
            CommitMessage.$$$reportNull$$$0(6);
        }
        return jComponent;
    }

    @Override
    @Nullable
    public Object getData(@NotNull @NonNls String dataId) {
        if (dataId == null) {
            CommitMessage.$$$reportNull$$$0(7);
        }
        if (VcsDataKeys.COMMIT_MESSAGE_CONTROL.is(dataId)) {
            return this;
        }
        return null;
    }

    public void setSeparatorText(@NotNull @NlsContexts.Separator String text2) {
        if (text2 == null) {
            CommitMessage.$$$reportNull$$$0(8);
        }
        if (this.mySeparator != null) {
            this.mySeparator.setText(text2);
        }
    }

    public void setCommitMessage(@Nullable String currentDescription) {
        this.setText(currentDescription);
    }

    @NotNull
    private static EditorTextField createCommitMessageEditor(@NotNull Project project, boolean runInspections) {
        if (project == null) {
            CommitMessage.$$$reportNull$$$0(9);
        }
        HashSet<EditorCustomization> features = new HashSet<EditorCustomization>();
        features.add(new RightMarginCustomization(project));
        features.add(SoftWrapsEditorCustomization.ENABLED);
        features.add(AdditionalPageAtBottomEditorCustomization.DISABLED);
        features.add(COLOR_SCHEME_FOR_CURRENT_UI_THEME_CUSTOMIZATION);
        if (runInspections) {
            features.add(ErrorStripeEditorCustomization.ENABLED);
            features.add(new InspectionCustomization(project));
        } else {
            ContainerUtil.addIfNotNull(features, (Object)SpellCheckingEditorCustomizationProvider.getInstance().getEnabledCustomization());
        }
        EditorTextField editorField2 = EditorTextFieldProvider.getInstance().getEditorField(FileTypes.PLAIN_TEXT.getLanguage(), project, features);
        editorField2.setFontInheritedFromLAF(false);
        EditorTextField editorTextField2 = editorField2;
        if (editorTextField2 == null) {
            CommitMessage.$$$reportNull$$$0(10);
        }
        return editorTextField2;
    }

    public static boolean isCommitMessage(@NotNull PsiElement element2) {
        Document document;
        if (element2 == null) {
            CommitMessage.$$$reportNull$$$0(11);
        }
        return (document = PsiDocumentManager.getInstance((Project)element2.getProject()).getDocument(element2.getContainingFile())) != null && document.getUserData(DATA_KEY) != null;
    }

    @Nullable
    public static Editor getEditor(@NotNull Document document) {
        CommitMessage commitMessage2;
        if (document == null) {
            CommitMessage.$$$reportNull$$$0(12);
        }
        return (commitMessage2 = (CommitMessage)document.getUserData(DATA_KEY)) != null ? commitMessage2.getEditorField().getEditor() : null;
    }

    @NotNull
    private static ActionGroup getToolbarActions() {
        ActionGroup actionGroup2 = (ActionGroup)ActionManager.getInstance().getAction("Vcs.MessageActionGroup");
        if (actionGroup2 == null) {
            CommitMessage.$$$reportNull$$$0(13);
        }
        return actionGroup2;
    }

    @NotNull
    public EditorTextField getEditorField() {
        EditorTextField editorTextField2 = this.myEditorField;
        if (editorTextField2 == null) {
            CommitMessage.$$$reportNull$$$0(14);
        }
        return editorTextField2;
    }

    @NotNull
    public String getText() {
        String string = this.getComment();
        if (string == null) {
            CommitMessage.$$$reportNull$$$0(15);
        }
        return string;
    }

    public void setText(@Nullable String initialMessage) {
        this.myEditorField.setText(initialMessage == null ? "" : StringUtil.convertLineSeparators((String)initialMessage));
    }

    public void focus() {
        this.requestFocusInMessage();
    }

    @NotNull
    public String getComment() {
        String string = StringUtil.trimTrailing((String)this.myEditorField.getDocument().getCharsSequence().toString());
        if (string == null) {
            CommitMessage.$$$reportNull$$$0(16);
        }
        return string;
    }

    public void requestFocusInMessage() {
        IdeFocusManager.getGlobalInstance().doWhenFocusSettlesDown(() -> IdeFocusManager.getGlobalInstance().requestFocus((Component)((Object)this.myEditorField), true));
        this.myEditorField.selectAll();
    }

    /*
     * WARNING - void declaration
     */
    @RequiresEdt
    public void setChangesSupplier(@NotNull Supplier<Iterable<Change>> supplier2) {
        void changesSupplier;
        ApplicationManager.getApplication().assertIsDispatchThread();
        if (changesSupplier == null) {
            CommitMessage.$$$reportNull$$$0(17);
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        this.myEditorField.getDocument().putUserData(CHANGES_SUPPLIER_KEY, (Object)changesSupplier);
    }

    public void dispose() {
        this.removeAll();
        this.myEditorField.getDocument().putUserData(DATA_KEY, null);
        this.myEditorField.getDocument().putUserData(CHANGES_SUPPLIER_KEY, null);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 17: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 17: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vcs/ui/CommitMessage";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataId";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "changesSupplier";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getCommitMessageColorScheme";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vcs/ui/CommitMessage";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "createToolbar";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "createCommitMessageEditor";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getToolbarActions";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getEditorField";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getComment";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "updateOnInspectionProfileChanged";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "lookAndFeelChanged";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getData";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "setSeparatorText";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "createCommitMessageEditor";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "isCommitMessage";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getEditor";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "setChangesSupplier";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 17: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class ConditionalTrafficLightRenderer
    extends TrafficLightRenderer {
        ConditionalTrafficLightRenderer(@NotNull Project project, @NotNull Document document) {
            if (project == null) {
                ConditionalTrafficLightRenderer.$$$reportNull$$$0(0);
            }
            if (document == null) {
                ConditionalTrafficLightRenderer.$$$reportNull$$$0(1);
            }
            super(project, document);
        }

        @Override
        protected void refresh(@Nullable EditorMarkupModelImpl editorMarkupModel) {
            super.refresh(editorMarkupModel);
            if (editorMarkupModel != null) {
                editorMarkupModel.setTrafficLightIconVisible(this.hasHighSeverities(this.getErrorCount()));
            }
        }

        private boolean hasHighSeverities(int @NotNull [] errorCount) {
            if (errorCount == null) {
                ConditionalTrafficLightRenderer.$$$reportNull$$$0(2);
            }
            HighlightSeverity minSeverity = ((HighlightDisplayLevel)ObjectUtils.notNull((Object)HighlightDisplayLevel.find((String)"TYPO"), (Object)HighlightDisplayLevel.DO_NOT_SHOW)).getSeverity();
            for (int i2 = 0; i2 < errorCount.length; ++i2) {
                if (errorCount[i2] <= 0 || this.getSeverityRegistrar().compare(this.getSeverityRegistrar().getSeverityByIndex(i2), minSeverity) <= 0) continue;
                return true;
            }
            return false;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "document";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "errorCount";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/openapi/vcs/ui/CommitMessage$ConditionalTrafficLightRenderer";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "hasHighSeverities";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class InspectionCustomization
    implements EditorCustomization {
        @NotNull
        private final Project myProject;

        InspectionCustomization(@NotNull Project project) {
            if (project == null) {
                InspectionCustomization.$$$reportNull$$$0(0);
            }
            this.myProject = project;
        }

        @Override
        public void customize(@NotNull EditorEx editor2) {
            PsiFile file2;
            if (editor2 == null) {
                InspectionCustomization.$$$reportNull$$$0(1);
            }
            if ((file2 = PsiDocumentManager.getInstance((Project)this.myProject).getPsiFile((Document)editor2.getDocument())) != null) {
                file2.putUserData(InspectionProfileWrapper.CUSTOMIZATION_KEY, profile -> new InspectionProfileWrapper(CommitMessageInspectionProfile.getInstance(this.myProject)));
            }
            editor2.putUserData(IntentionManager.SHOW_INTENTION_OPTIONS_KEY, false);
            ((EditorMarkupModelImpl)editor2.getMarkupModel()).setErrorStripeRenderer(new ConditionalTrafficLightRenderer(this.myProject, editor2.getDocument()));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "editor";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/openapi/vcs/ui/CommitMessage$InspectionCustomization";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "customize";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static final class RightMarginCustomization
    implements EditorCustomization {
        @NotNull
        private final Project myProject;

        private RightMarginCustomization(@NotNull Project project) {
            if (project == null) {
                RightMarginCustomization.$$$reportNull$$$0(0);
            }
            this.myProject = project;
        }

        @Override
        public void customize(@NotNull EditorEx editor2) {
            if (editor2 == null) {
                RightMarginCustomization.$$$reportNull$$$0(1);
            }
            RightMarginCustomization.customize(this.myProject, editor2);
        }

        private static void customize(@NotNull Project project, @NotNull EditorEx editor2) {
            if (project == null) {
                RightMarginCustomization.$$$reportNull$$$0(2);
            }
            if (editor2 == null) {
                RightMarginCustomization.$$$reportNull$$$0(3);
            }
            BodyLimitSettings settings = CommitMessageInspectionProfile.getBodyLimitSettings(project);
            editor2.getSettings().setRightMargin(settings.getRightMargin());
            editor2.getSettings().setRightMarginShown(settings.isShowRightMargin());
            editor2.getSettings().setWrapWhenTypingReachesRightMargin(settings.isWrapOnTyping());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "editor";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/openapi/vcs/ui/CommitMessage$RightMarginCustomization";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "customize";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

