/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.update;

import com.intellij.configurationStore.StoreReloadManager;
import com.intellij.configurationStore.StoreUtil;
import com.intellij.history.Label;
import com.intellij.history.LocalHistory;
import com.intellij.history.LocalHistoryAction;
import com.intellij.ide.errorTreeView.HotfixData;
import com.intellij.internal.statistic.StructuredIdeActivity;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.UpdateInBackground;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.progress.util.BackgroundTaskUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsActions;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.AbstractVcsHelper;
import com.intellij.openapi.vcs.ActionType;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.VcsExceptionsHotFixer;
import com.intellij.openapi.vcs.VcsNotifier;
import com.intellij.openapi.vcs.actions.AbstractVcsAction;
import com.intellij.openapi.vcs.actions.DescindingFilesFilter;
import com.intellij.openapi.vcs.actions.VcsContext;
import com.intellij.openapi.vcs.changes.RemoteRevisionsCache;
import com.intellij.openapi.vcs.changes.VcsAnnotationRefresher;
import com.intellij.openapi.vcs.changes.VcsDirtyScopeManager;
import com.intellij.openapi.vcs.changes.actions.VcsStatisticsCollector;
import com.intellij.openapi.vcs.changes.committed.CommittedChangesCache;
import com.intellij.openapi.vcs.ex.ProjectLevelVcsManagerEx;
import com.intellij.openapi.vcs.update.ActionInfo;
import com.intellij.openapi.vcs.update.FileGroup;
import com.intellij.openapi.vcs.update.RefreshVFsSynchronously;
import com.intellij.openapi.vcs.update.RestoreUpdateTree;
import com.intellij.openapi.vcs.update.ScopeInfo;
import com.intellij.openapi.vcs.update.SequentialUpdatesContext;
import com.intellij.openapi.vcs.update.UpdateEnvironment;
import com.intellij.openapi.vcs.update.UpdateFilesHelper;
import com.intellij.openapi.vcs.update.UpdateInfoTree;
import com.intellij.openapi.vcs.update.UpdateOrStatusOptionsDialog;
import com.intellij.openapi.vcs.update.UpdateSession;
import com.intellij.openapi.vcs.update.UpdatedFiles;
import com.intellij.openapi.vcs.update.UpdatedFilesListener;
import com.intellij.openapi.vcs.update.UpdatedFilesReverseSide;
import com.intellij.openapi.vcs.versionBrowser.CommittedChangeList;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.psi.search.scope.packageSet.NamedScope;
import com.intellij.util.Consumer;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.ui.OptionsDialog;
import com.intellij.vcs.ViewUpdateInfoNotification;
import com.intellij.vcsUtil.VcsUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractCommonUpdateAction
extends AbstractVcsAction
implements UpdateInBackground {
    private static final Logger LOG = Logger.getInstance(AbstractCommonUpdateAction.class);
    private final boolean myAlwaysVisible;
    private final ActionInfo myActionInfo;
    private final ScopeInfo myScopeInfo;

    protected AbstractCommonUpdateAction(ActionInfo actionInfo, ScopeInfo scopeInfo, boolean alwaysVisible) {
        this.myActionInfo = actionInfo;
        this.myScopeInfo = scopeInfo;
        this.myAlwaysVisible = alwaysVisible;
    }

    @NlsActions.ActionText
    private String getCompleteActionName(VcsContext dataContext) {
        return this.myActionInfo.getActionName(this.myScopeInfo.getScopeName(dataContext, this.myActionInfo));
    }

    @Override
    protected void actionPerformed(@NotNull VcsContext context2) {
        if (context2 == null) {
            AbstractCommonUpdateAction.$$$reportNull$$$0(0);
        }
        Project project = context2.getProject();
        boolean showUpdateOptions = this.myActionInfo.showOptions(project);
        LOG.debug("project: " + project + ", show update options: " + showUpdateOptions);
        if (project == null) {
            return;
        }
        try {
            FilePath[] filePaths = this.myScopeInfo.getRoots(context2, this.myActionInfo);
            FilePath[] roots2 = DescindingFilesFilter.filterDescindingFiles(this.filterRoots(filePaths, context2), project);
            if (roots2.length == 0) {
                LOG.debug("No roots found.");
                return;
            }
            Map<AbstractVcs, Collection<FilePath>> vcsToVirtualFiles = this.createVcsToFilesMap(roots2, project);
            for (AbstractVcs vcs : vcsToVirtualFiles.keySet()) {
                UpdateEnvironment updateEnvironment = this.myActionInfo.getEnvironment(vcs);
                if (updateEnvironment == null || updateEnvironment.validateOptions(vcsToVirtualFiles.get(vcs))) continue;
                LOG.debug("Options not valid for files: " + vcsToVirtualFiles);
                return;
            }
            if (showUpdateOptions || OptionsDialog.shiftIsPressed((int)context2.getModifiers())) {
                this.showOptionsDialog(vcsToVirtualFiles, project, context2);
            }
            if (ApplicationManager.getApplication().isDispatchThread()) {
                StoreUtil.saveDocumentsAndProjectSettings(project);
            }
            Updater task2 = new Updater(project, roots2, vcsToVirtualFiles, this.myActionInfo, this.getTemplatePresentation().getText()){

                @Override
                public void onSuccess() {
                    super.onSuccess();
                    AbstractCommonUpdateAction.this.onSuccess();
                }
            };
            if (ApplicationManager.getApplication().isUnitTestMode()) {
                task2.run((ProgressIndicator)new EmptyProgressIndicator());
            } else {
                ProgressManager.getInstance().run((Task)task2);
            }
        }
        catch (ProcessCanceledException processCanceledException) {
            // empty catch block
        }
    }

    protected void onSuccess() {
    }

    private static boolean someSessionWasCanceled(List<? extends UpdateSession> updateSessions) {
        for (UpdateSession updateSession : updateSessions) {
            if (!updateSession.isCanceled()) continue;
            return true;
        }
        return false;
    }

    @NlsContexts.NotificationContent
    private static String getAllFilesAreUpToDateMessage(FilePath[] roots2) {
        if (roots2.length == 1 && !roots2[0].isDirectory()) {
            return VcsBundle.message((String)"message.text.file.is.up.to.date", (Object[])new Object[0]);
        }
        return VcsBundle.message((String)"message.text.all.files.are.up.to.date", (Object[])new Object[0]);
    }

    private void showOptionsDialog(Map<AbstractVcs, Collection<FilePath>> updateEnvToVirtualFiles, Project project, VcsContext dataContext) {
        UpdateOrStatusOptionsDialog dialogOrStatus;
        LinkedHashMap<Configurable, AbstractVcs> envToConfMap = this.createConfigurableToEnvMap(updateEnvToVirtualFiles);
        LOG.debug("configurables map: " + envToConfMap);
        if (!envToConfMap.isEmpty() && !(dialogOrStatus = this.myActionInfo.createOptionsDialog(project, envToConfMap, this.myScopeInfo.getScopeName(dataContext, this.myActionInfo))).showAndGet()) {
            throw new ProcessCanceledException();
        }
    }

    private LinkedHashMap<Configurable, AbstractVcs> createConfigurableToEnvMap(Map<AbstractVcs, Collection<FilePath>> updateEnvToVirtualFiles) {
        LinkedHashMap<Configurable, AbstractVcs> envToConfMap = new LinkedHashMap<Configurable, AbstractVcs>();
        for (AbstractVcs vcs : updateEnvToVirtualFiles.keySet()) {
            Configurable configurable2 = this.myActionInfo.getEnvironment(vcs).createConfigurable(updateEnvToVirtualFiles.get(vcs));
            if (configurable2 == null) continue;
            envToConfMap.put(configurable2, vcs);
        }
        return envToConfMap;
    }

    private Map<AbstractVcs, Collection<FilePath>> createVcsToFilesMap(FilePath @NotNull [] roots2, @NotNull Project project) {
        if (project == null) {
            AbstractCommonUpdateAction.$$$reportNull$$$0(1);
        }
        if (roots2 == null) {
            AbstractCommonUpdateAction.$$$reportNull$$$0(2);
        }
        MultiMap resultPrep = MultiMap.createSet();
        for (FilePath file2 : roots2) {
            UpdateEnvironment updateEnvironment;
            AbstractVcs vcs = VcsUtil.getVcsFor((Project)project, (FilePath)file2);
            if (vcs == null || (updateEnvironment = this.myActionInfo.getEnvironment(vcs)) == null) continue;
            resultPrep.putValue((Object)vcs, (Object)file2);
        }
        HashMap<AbstractVcs, Collection<FilePath>> result2 = new HashMap<AbstractVcs, Collection<FilePath>>();
        for (Map.Entry entry2 : resultPrep.entrySet()) {
            AbstractVcs vcs = (AbstractVcs)entry2.getKey();
            result2.put(vcs, vcs.filterUniqueRoots(new ArrayList((Collection)entry2.getValue()), FilePath::getVirtualFile));
        }
        return result2;
    }

    private FilePath @NotNull [] filterRoots(FilePath[] roots2, VcsContext vcsContext) {
        ArrayList<FilePath> result2 = new ArrayList<FilePath>();
        Project project = vcsContext.getProject();
        assert (project != null);
        for (FilePath file2 : roots2) {
            VirtualFile[] vcsRoots;
            AbstractVcs vcs = VcsUtil.getVcsFor((Project)project, (FilePath)file2);
            if (vcs == null) continue;
            if (!this.myScopeInfo.filterExistsInVcs() || AbstractVcs.fileInVcsByFileStatus((Project)project, (FilePath)file2)) {
                UpdateEnvironment updateEnvironment = this.myActionInfo.getEnvironment(vcs);
                if (updateEnvironment == null) continue;
                result2.add(file2);
                continue;
            }
            VirtualFile virtualFile2 = file2.getVirtualFile();
            if (virtualFile2 == null || !virtualFile2.isDirectory()) continue;
            for (VirtualFile vcsRoot : vcsRoots = ProjectLevelVcsManager.getInstance((Project)vcsContext.getProject()).getAllVersionedRoots()) {
                if (!VfsUtilCore.isAncestor((VirtualFile)virtualFile2, (VirtualFile)vcsRoot, (boolean)false)) continue;
                result2.add(file2);
            }
        }
        FilePath[] filePathArray = result2.toArray(new FilePath[0]);
        if (filePathArray == null) {
            AbstractCommonUpdateAction.$$$reportNull$$$0(3);
        }
        return filePathArray;
    }

    protected abstract boolean filterRootsBeforeAction();

    @Override
    protected void update(@NotNull VcsContext vcsContext, @NotNull Presentation presentation2) {
        FilePath[] roots2;
        Project project;
        if (vcsContext == null) {
            AbstractCommonUpdateAction.$$$reportNull$$$0(4);
        }
        if (presentation2 == null) {
            AbstractCommonUpdateAction.$$$reportNull$$$0(5);
        }
        if ((project = vcsContext.getProject()) == null) {
            presentation2.setEnabledAndVisible(false);
            return;
        }
        ProjectLevelVcsManager vcsManager2 = ProjectLevelVcsManager.getInstance((Project)project);
        boolean underVcs = vcsManager2.hasActiveVcss();
        if (!underVcs) {
            presentation2.setEnabledAndVisible(false);
            return;
        }
        Object actionName = this.getCompleteActionName(vcsContext);
        if (this.myActionInfo.showOptions(project) || OptionsDialog.shiftIsPressed((int)vcsContext.getModifiers())) {
            actionName = (String)actionName + "...";
        }
        presentation2.setText((String)actionName);
        if (AbstractCommonUpdateAction.supportingVcsesAreEmpty(vcsManager2, this.myActionInfo)) {
            presentation2.setEnabledAndVisible(false);
            return;
        }
        if (this.filterRootsBeforeAction() && (roots2 = this.filterRoots(this.myScopeInfo.getRoots(vcsContext, this.myActionInfo), vcsContext)).length == 0) {
            presentation2.setVisible(this.myAlwaysVisible);
            presentation2.setEnabled(false);
            return;
        }
        presentation2.setVisible(true);
        presentation2.setEnabled(!vcsManager2.isBackgroundVcsOperationRunning());
    }

    private static boolean supportingVcsesAreEmpty(ProjectLevelVcsManager vcsManager2, ActionInfo actionInfo) {
        AbstractVcs[] allActiveVcss;
        for (AbstractVcs activeVcs : allActiveVcss = vcsManager2.getAllActiveVcss()) {
            if (actionInfo.getEnvironment(activeVcs) == null) continue;
            return false;
        }
        return true;
    }

    public static boolean showsCustomNotification(@NotNull Collection<? extends AbstractVcs> vcss) {
        if (vcss == null) {
            AbstractCommonUpdateAction.$$$reportNull$$$0(6);
        }
        return ContainerUtil.all(vcss, vcs -> {
            UpdateEnvironment environment2 = vcs.getUpdateEnvironment();
            return environment2 != null && environment2.hasCustomNotification();
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "roots";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vcs/update/AbstractCommonUpdateAction";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vcsContext";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "presentation";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vcss";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vcs/update/AbstractCommonUpdateAction";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "filterRoots";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "createVcsToFilesMap";
                break;
            }
            case 3: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "showsCustomNotification";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    @ApiStatus.Internal
    public static class Updater
    extends Task.Backgroundable {
        private final ProjectLevelVcsManagerEx myProjectLevelVcsManager;
        protected UpdatedFiles myUpdatedFiles;
        private final FilePath[] myRoots;
        private final Map<AbstractVcs, Collection<FilePath>> myVcsToVirtualFiles;
        private final Map<HotfixData, List<VcsException>> myGroupedExceptions;
        private final List<UpdateSession> myUpdateSessions;
        private int myUpdateNumber;
        private final Map<AbstractVcs, SequentialUpdatesContext> myContextInfo;
        private final VcsDirtyScopeManager myDirtyScopeManager;
        private Label myBefore;
        private Label myAfter;
        private LocalHistoryAction myLocalHistoryAction;
        private final ActionInfo myActionInfo;
        @Nls
        private final String myActionName;

        public Updater(Project project, FilePath[] roots2, Map<AbstractVcs, Collection<FilePath>> vcsToVirtualFiles, ActionInfo actionInfo, @NlsContexts.ProgressTitle String actionName) {
            super(project, actionName, true);
            this.myProjectLevelVcsManager = ProjectLevelVcsManagerEx.getInstanceEx(project);
            this.myDirtyScopeManager = VcsDirtyScopeManager.getInstance((Project)this.myProject);
            this.myRoots = roots2;
            this.myVcsToVirtualFiles = vcsToVirtualFiles;
            this.myUpdatedFiles = UpdatedFiles.create();
            this.myGroupedExceptions = new HashMap<HotfixData, List<VcsException>>();
            this.myUpdateSessions = new ArrayList<UpdateSession>();
            this.myActionInfo = actionInfo;
            this.myActionName = actionName;
            this.myContextInfo = new HashMap<AbstractVcs, SequentialUpdatesContext>();
            this.myUpdateNumber = 1;
        }

        private void reset() {
            this.myUpdatedFiles = UpdatedFiles.create();
            this.myGroupedExceptions.clear();
            this.myUpdateSessions.clear();
            ++this.myUpdateNumber;
        }

        public void run(@NotNull ProgressIndicator indicator2) {
            if (indicator2 == null) {
                Updater.$$$reportNull$$$0(0);
            }
            this.runImpl();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void runImpl() {
            StoreReloadManager.getInstance().blockReloadingProjectOnExternalChanges();
            this.myProjectLevelVcsManager.startBackgroundVcsOperation();
            this.myBefore = LocalHistory.getInstance().putSystemLabel(this.myProject, VcsBundle.message((String)"update.label.before.update", (Object[])new Object[0]));
            this.myLocalHistoryAction = LocalHistory.getInstance().startAction(VcsBundle.message((String)"local.history.update.from.vcs", (Object[])new Object[0]));
            ProgressIndicator progressIndicator = ProgressManager.getInstance().getProgressIndicator();
            if (progressIndicator != null) {
                progressIndicator.setIndeterminate(false);
            }
            StructuredIdeActivity activity = VcsStatisticsCollector.UPDATE_ACTIVITY.started(this.myProject);
            try {
                int toBeProcessed = this.myVcsToVirtualFiles.size();
                int processed2 = 0;
                for (AbstractVcs vcs : this.myVcsToVirtualFiles.keySet()) {
                    UpdateEnvironment updateEnvironment = this.myActionInfo.getEnvironment(vcs);
                    updateEnvironment.fillGroups(this.myUpdatedFiles);
                    Collection<FilePath> files2 = this.myVcsToVirtualFiles.get(vcs);
                    SequentialUpdatesContext context2 = this.myContextInfo.get(vcs);
                    Ref refContext = new Ref((Object)context2);
                    UpdateSession updateSession = this.performUpdate(progressIndicator, updateEnvironment, files2, (Ref<SequentialUpdatesContext>)refContext);
                    this.myContextInfo.put(vcs, (SequentialUpdatesContext)refContext.get());
                    ++processed2;
                    if (progressIndicator != null) {
                        progressIndicator.setFraction((double)processed2 / (double)toBeProcessed);
                        progressIndicator.setText2("");
                    }
                    List exceptionList = updateSession.getExceptions();
                    this.gatherExceptions(vcs, exceptionList);
                    this.myUpdateSessions.add(updateSession);
                }
            }
            finally {
                try {
                    ProgressManager.progress((String)VcsBundle.message((String)"progress.text.synchronizing.files", (Object[])new Object[0]));
                    this.doVfsRefresh();
                }
                finally {
                    this.myProjectLevelVcsManager.stopBackgroundVcsOperation();
                    BackgroundTaskUtil.syncPublisher(this.myProject, UpdatedFilesListener.UPDATED_FILES).consume(UpdatedFilesReverseSide.getPathsFromUpdatedFiles((UpdatedFiles)this.myUpdatedFiles));
                    activity.finished();
                }
            }
        }

        @NotNull
        protected UpdateSession performUpdate(ProgressIndicator progressIndicator, UpdateEnvironment updateEnvironment, Collection<FilePath> files2, Ref<SequentialUpdatesContext> refContext) {
            UpdateSession updateSession = updateEnvironment.updateDirectories(files2.toArray(new FilePath[0]), this.myUpdatedFiles, progressIndicator, refContext);
            if (updateSession == null) {
                Updater.$$$reportNull$$$0(1);
            }
            return updateSession;
        }

        private void gatherExceptions(AbstractVcs vcs, List<VcsException> exceptionList) {
            VcsExceptionsHotFixer fixer = vcs.getVcsExceptionsHotFixer();
            if (fixer == null) {
                this.putExceptions(null, exceptionList);
            } else {
                this.putExceptions(fixer.groupExceptions(ActionType.update, exceptionList));
            }
        }

        private void putExceptions(Map<HotfixData, List<VcsException>> map2) {
            for (Map.Entry<HotfixData, List<VcsException>> entry2 : map2.entrySet()) {
                this.putExceptions(entry2.getKey(), entry2.getValue());
            }
        }

        private void putExceptions(HotfixData key, @NotNull List<? extends VcsException> list2) {
            if (list2 == null) {
                Updater.$$$reportNull$$$0(2);
            }
            if (list2.isEmpty()) {
                return;
            }
            this.myGroupedExceptions.computeIfAbsent(key, k -> new ArrayList()).addAll(list2);
        }

        private void doVfsRefresh() {
            LOG.info("Calling refresh files after update for roots: " + Arrays.toString(this.myRoots));
            RefreshVFsSynchronously.updateAllChanged(this.myUpdatedFiles);
            this.notifyAnnotations();
        }

        private void notifyAnnotations() {
            final VcsAnnotationRefresher refresher = BackgroundTaskUtil.syncPublisher(this.myProject, VcsAnnotationRefresher.LOCAL_CHANGES_CHANGED);
            UpdateFilesHelper.iterateFileGroupFilesDeletedOnServerFirst(this.myUpdatedFiles, new UpdateFilesHelper.Callback(){

                @Override
                public void onFile(String filePath, String groupId2) {
                    refresher.dirty(filePath);
                }
            });
        }

        @NotNull
        private Notification prepareNotification(@NotNull UpdateInfoTree tree, boolean someSessionWasCancelled, @NotNull List<? extends UpdateSession> updateSessions) {
            NotificationType type;
            if (tree == null) {
                Updater.$$$reportNull$$$0(3);
            }
            if (updateSessions == null) {
                Updater.$$$reportNull$$$0(4);
            }
            int allFilesCount = this.getUpdatedFilesCount();
            String additionalContent = StringUtil.nullize((String)updateSessions.stream().map(UpdateSession::getAdditionalNotificationContent).filter(Objects::nonNull).collect(Collectors.joining(", ")));
            String title2 = someSessionWasCancelled ? VcsBundle.message((String)"update.notification.title.project.partially.updated", (Object[])new Object[0]) : VcsBundle.message((String)"update.notification.title.count.files.updated", (Object[])new Object[]{allFilesCount});
            Object content2 = someSessionWasCancelled ? VcsBundle.message((String)"update.notification.content.files.updated", (Object[])new Object[]{allFilesCount}) : StringUtil.notNullize((String)Updater.prepareScopeUpdatedText(tree));
            NotificationType notificationType = type = someSessionWasCancelled ? NotificationType.WARNING : NotificationType.INFORMATION;
            if (additionalContent != null) {
                if (!((String)content2).isEmpty()) {
                    content2 = (String)content2 + "<br/>";
                }
                content2 = (String)content2 + additionalContent;
            }
            Notification notification = VcsNotifier.STANDARD_NOTIFICATION.createNotification(title2, (String)content2, type).setDisplayId("vcs.project.partially.updated");
            if (notification == null) {
                Updater.$$$reportNull$$$0(5);
            }
            return notification;
        }

        private int getUpdatedFilesCount() {
            return this.myUpdatedFiles.getTopLevelGroups().stream().mapToInt(Updater::getFilesCount).sum();
        }

        private static int getFilesCount(@NotNull FileGroup group2) {
            if (group2 == null) {
                Updater.$$$reportNull$$$0(6);
            }
            return group2.getFiles().size() + group2.getChildren().stream().mapToInt(g -> Updater.getFilesCount(g)).sum();
        }

        @Nullable
        @Nls
        private static String prepareScopeUpdatedText(@NotNull UpdateInfoTree tree) {
            if (tree == null) {
                Updater.$$$reportNull$$$0(7);
            }
            String scopeText = null;
            NamedScope scopeFilter = tree.getFilterScope();
            if (scopeFilter != null) {
                int filteredFiles = tree.getFilteredFilesCount();
                String filterName = scopeFilter.getPresentableName();
                scopeText = filteredFiles == 0 ? VcsBundle.message((String)"update.file.name.wasn.t.modified", (Object[])new Object[]{filterName}) : VcsBundle.message((String)"update.filtered.files.count.in.filter.name", (Object[])new Object[]{filteredFiles, filterName});
            }
            return scopeText;
        }

        public void onSuccess() {
            this.onSuccessImpl(false);
        }

        private void onSuccessImpl(boolean wasCanceled) {
            boolean updateSuccess;
            if (!this.myProject.isOpen() || this.myProject.isDisposed()) {
                StoreReloadManager.getInstance().unblockReloadingProjectOnExternalChanges();
                LocalHistory.getInstance().putSystemLabel(this.myProject, VcsBundle.message((String)"local.history.update.from.vcs", (Object[])new Object[0]));
                return;
            }
            boolean continueChain = false;
            for (SequentialUpdatesContext context2 : this.myContextInfo.values()) {
                continueChain |= context2 != null && context2.shouldFail();
            }
            boolean continueChainFinal = continueChain;
            boolean someSessionWasCancelled = wasCanceled || AbstractCommonUpdateAction.someSessionWasCanceled(this.myUpdateSessions);
            for (UpdateSession updateSession : this.myUpdateSessions) {
                updateSession.onRefreshFilesCompleted();
            }
            if (this.myLocalHistoryAction != null) {
                this.myLocalHistoryAction.finish();
            }
            this.myAfter = LocalHistory.getInstance().putSystemLabel(this.myProject, VcsBundle.message((String)"update.label.after.update", (Object[])new Object[0]));
            if (this.myActionInfo.canChangeFileStatus()) {
                final ArrayList files2 = new ArrayList();
                RemoteRevisionsCache revisionsCache = RemoteRevisionsCache.getInstance(this.myProject);
                revisionsCache.invalidate(this.myUpdatedFiles);
                UpdateFilesHelper.iterateFileGroupFiles(this.myUpdatedFiles, new UpdateFilesHelper.Callback(){

                    @Override
                    public void onFile(String filePath, String groupId2) {
                        @NonNls String path2 = VfsUtilCore.pathToUrl((String)filePath.replace(File.separatorChar, '/'));
                        VirtualFile file2 = VirtualFileManager.getInstance().findFileByUrl(path2);
                        if (file2 != null) {
                            files2.add(file2);
                        }
                    }
                });
                this.myDirtyScopeManager.filesDirty(files2, null);
            }
            boolean bl = updateSuccess = !someSessionWasCancelled && this.myGroupedExceptions.isEmpty();
            if (this.myProject.isDisposed()) {
                StoreReloadManager.getInstance().unblockReloadingProjectOnExternalChanges();
                return;
            }
            if (!this.myGroupedExceptions.isEmpty()) {
                if (continueChainFinal) {
                    this.gatherContextInterruptedMessages();
                }
                AbstractVcsHelper.getInstance((Project)this.myProject).showErrors(this.myGroupedExceptions, VcsBundle.message((String)"message.title.vcs.update.errors", (Object[])new Object[]{this.myActionName}));
            } else if (someSessionWasCancelled) {
                ProgressManager.progress((String)VcsBundle.message((String)"progress.text.updating.canceled", (Object[])new Object[0]));
            } else {
                ProgressManager.progress((String)VcsBundle.message((String)"progress.text.updating.done", (Object[])new Object[0]));
            }
            boolean noMerged = this.myUpdatedFiles.getGroupById("MERGED_WITH_CONFLICTS").isEmpty();
            if (this.myUpdatedFiles.isEmpty() && this.myGroupedExceptions.isEmpty()) {
                NotificationType type;
                String content2;
                if (someSessionWasCancelled) {
                    content2 = VcsBundle.message((String)"progress.text.updating.canceled", (Object[])new Object[0]);
                    type = NotificationType.WARNING;
                } else {
                    content2 = AbstractCommonUpdateAction.getAllFilesAreUpToDateMessage(this.myRoots);
                    type = NotificationType.INFORMATION;
                }
                VcsNotifier.getInstance(this.myProject).notify(VcsNotifier.STANDARD_NOTIFICATION.createNotification(content2, type).setDisplayId("vcs.project.update.finished"));
            } else if (!this.myUpdatedFiles.isEmpty()) {
                if (this.myUpdateSessions.size() == 1 && AbstractCommonUpdateAction.showsCustomNotification(this.myVcsToVirtualFiles.keySet())) {
                    this.myUpdateSessions.get(0).showNotification();
                } else {
                    UpdateInfoTree tree = this.showUpdateTree(continueChainFinal && updateSuccess && noMerged, someSessionWasCancelled);
                    CommittedChangesCache cache2 = CommittedChangesCache.getInstance(this.myProject);
                    cache2.processUpdatedFiles(this.myUpdatedFiles, (Consumer<? super List<CommittedChangeList>>)((Consumer)incomingChangeLists -> tree.setChangeLists((List<? extends CommittedChangeList>)incomingChangeLists)));
                    Notification notification = this.prepareNotification(tree, someSessionWasCancelled, this.myUpdateSessions);
                    notification.addAction((AnAction)new ViewUpdateInfoNotification(this.myProject, tree, VcsBundle.message((String)"update.notification.content.view", (Object[])new Object[0]), notification));
                    VcsNotifier.getInstance(this.myProject).notify(notification);
                }
            }
            StoreReloadManager.getInstance().unblockReloadingProjectOnExternalChanges();
            if (continueChainFinal && updateSuccess) {
                if (!noMerged) {
                    this.showContextInterruptedError();
                } else {
                    this.reset();
                    ProgressManager.getInstance().run((Task)this);
                }
            }
        }

        private void showContextInterruptedError() {
            this.gatherContextInterruptedMessages();
            AbstractVcsHelper.getInstance((Project)this.myProject).showErrors(this.myGroupedExceptions, VcsBundle.message((String)"message.title.vcs.update.errors", (Object[])new Object[]{this.myActionName}));
        }

        private void gatherContextInterruptedMessages() {
            for (Map.Entry<AbstractVcs, SequentialUpdatesContext> entry2 : this.myContextInfo.entrySet()) {
                SequentialUpdatesContext context2 = entry2.getValue();
                if (context2 == null || !context2.shouldFail()) continue;
                VcsException exception = new VcsException(context2.getMessageWhenInterruptedBeforeStart());
                this.gatherExceptions(entry2.getKey(), Collections.singletonList(exception));
            }
        }

        @NotNull
        private UpdateInfoTree showUpdateTree(boolean willBeContinued, boolean wasCanceled) {
            RestoreUpdateTree restoreUpdateTree = RestoreUpdateTree.getInstance(this.myProject);
            restoreUpdateTree.registerUpdateInformation(this.myUpdatedFiles, this.myActionInfo);
            String text2 = this.myActionName + (String)(willBeContinued || this.myUpdateNumber > 1 ? "#" + this.myUpdateNumber : "");
            UpdateInfoTree updateInfoTree = Objects.requireNonNull(this.myProjectLevelVcsManager.showUpdateProjectInfo(this.myUpdatedFiles, text2, this.myActionInfo, wasCanceled));
            updateInfoTree.setBefore(this.myBefore);
            updateInfoTree.setAfter(this.myAfter);
            updateInfoTree.setCanGroupByChangeList(this.canGroupByChangelist(this.myVcsToVirtualFiles.keySet()));
            UpdateInfoTree updateInfoTree2 = updateInfoTree;
            if (updateInfoTree2 == null) {
                Updater.$$$reportNull$$$0(8);
            }
            return updateInfoTree2;
        }

        private boolean canGroupByChangelist(Set<? extends AbstractVcs> abstractVcses) {
            if (this.myActionInfo.canGroupByChangelist()) {
                for (AbstractVcs abstractVcs : abstractVcses) {
                    if (abstractVcs.getCachingCommittedChangesProvider() == null) continue;
                    return true;
                }
            }
            return false;
        }

        public void onCancel() {
            this.onSuccessImpl(true);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 5: 
                case 8: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 5: 
                case 8: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "indicator";
                    break;
                }
                case 1: 
                case 5: 
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/vcs/update/AbstractCommonUpdateAction$Updater";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "list";
                    break;
                }
                case 3: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "tree";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "updateSessions";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "group";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/vcs/update/AbstractCommonUpdateAction$Updater";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "performUpdate";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "prepareNotification";
                    break;
                }
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[1] = "showUpdateTree";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "run";
                    break;
                }
                case 1: 
                case 5: 
                case 8: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "putExceptions";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "prepareNotification";
                    break;
                }
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "getFilesCount";
                    break;
                }
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "prepareScopeUpdatedText";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 5: 
                case 8: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

