/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs.impl.http;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.ex.http.HttpFileSystem;
import com.intellij.openapi.vfs.ex.http.HttpVirtualFileListener;
import com.intellij.openapi.vfs.impl.http.HttpVirtualFile;
import com.intellij.openapi.vfs.impl.http.HttpVirtualFileImpl;
import com.intellij.openapi.vfs.impl.http.RemoteFileManager;
import com.intellij.openapi.vfs.impl.http.RemoteFileManagerImpl;
import com.intellij.openapi.vfs.impl.http.RemoteFileState;
import com.intellij.util.Urls;
import java.io.IOException;
import java.io.Serializable;
import org.jetbrains.annotations.NotNull;

public abstract class HttpFileSystemBase
extends HttpFileSystem {
    private final String myProtocol;

    public HttpFileSystemBase(String protocol) {
        this.myProtocol = protocol;
    }

    public VirtualFile findFileByPath(@NotNull String path2) {
        if (path2 == null) {
            HttpFileSystemBase.$$$reportNull$$$0(0);
        }
        return this.findFileByPath(path2, false);
    }

    public VirtualFile findFileByPath(@NotNull String path2, boolean isDirectory) {
        if (path2 == null) {
            HttpFileSystemBase.$$$reportNull$$$0(1);
        }
        return HttpFileSystemBase.getRemoteFileManager().getOrCreateFile(null, Urls.newFromIdea((CharSequence)VirtualFileManager.constructUrl((String)this.myProtocol, (String)path2)), path2, isDirectory);
    }

    public void addFileListener(@NotNull HttpVirtualFileListener listener2) {
        if (listener2 == null) {
            HttpFileSystemBase.$$$reportNull$$$0(2);
        }
        HttpFileSystemBase.getRemoteFileManager().addFileListener(listener2);
    }

    public void addFileListener(@NotNull HttpVirtualFileListener listener2, @NotNull Disposable parentDisposable) {
        if (listener2 == null) {
            HttpFileSystemBase.$$$reportNull$$$0(3);
        }
        if (parentDisposable == null) {
            HttpFileSystemBase.$$$reportNull$$$0(4);
        }
        HttpFileSystemBase.getRemoteFileManager().addFileListener(listener2, parentDisposable);
    }

    public void removeFileListener(@NotNull HttpVirtualFileListener listener2) {
        if (listener2 == null) {
            HttpFileSystemBase.$$$reportNull$$$0(5);
        }
        HttpFileSystemBase.getRemoteFileManager().removeFileListener(listener2);
    }

    public boolean isFileDownloaded(@NotNull VirtualFile file2) {
        if (file2 == null) {
            HttpFileSystemBase.$$$reportNull$$$0(6);
        }
        return file2 instanceof HttpVirtualFile && ((HttpVirtualFile)file2).getFileInfo().getState() == RemoteFileState.DOWNLOADED;
    }

    @NotNull
    public VirtualFile createChild(@NotNull VirtualFile parent, @NotNull String name2, boolean isDirectory) {
        String parentPath;
        if (parent == null) {
            HttpFileSystemBase.$$$reportNull$$$0(7);
        }
        if (name2 == null) {
            HttpFileSystemBase.$$$reportNull$$$0(8);
        }
        boolean hasEndSlash = (parentPath = parent.getPath()).charAt(parentPath.length() - 1) == '/';
        HttpVirtualFileImpl httpVirtualFileImpl = HttpFileSystemBase.getRemoteFileManager().getOrCreateFile((HttpVirtualFileImpl)parent, Urls.newFromIdea((CharSequence)(parent.getUrl() + (Serializable)(hasEndSlash ? "" : Character.valueOf('/')) + name2)), parentPath + (Serializable)(hasEndSlash ? "" : Character.valueOf('/')) + name2, isDirectory);
        if (httpVirtualFileImpl == null) {
            HttpFileSystemBase.$$$reportNull$$$0(9);
        }
        return httpVirtualFileImpl;
    }

    @NotNull
    public VirtualFile createChildDirectory(Object requestor, @NotNull VirtualFile vDir, @NotNull String dirName) throws IOException {
        if (vDir == null) {
            HttpFileSystemBase.$$$reportNull$$$0(10);
        }
        if (dirName == null) {
            HttpFileSystemBase.$$$reportNull$$$0(11);
        }
        VirtualFile virtualFile2 = this.createChild(vDir, dirName, true);
        if (virtualFile2 == null) {
            HttpFileSystemBase.$$$reportNull$$$0(12);
        }
        return virtualFile2;
    }

    @NotNull
    public VirtualFile createChildFile(Object requestor, @NotNull VirtualFile vDir, @NotNull String fileName) throws IOException {
        if (vDir == null) {
            HttpFileSystemBase.$$$reportNull$$$0(13);
        }
        if (fileName == null) {
            HttpFileSystemBase.$$$reportNull$$$0(14);
        }
        VirtualFile virtualFile2 = this.createChild(vDir, fileName, false);
        if (virtualFile2 == null) {
            HttpFileSystemBase.$$$reportNull$$$0(15);
        }
        return virtualFile2;
    }

    @NotNull
    public String extractPresentableUrl(@NotNull String path2) {
        if (path2 == null) {
            HttpFileSystemBase.$$$reportNull$$$0(16);
        }
        String string = VirtualFileManager.constructUrl((String)this.myProtocol, (String)path2);
        if (string == null) {
            HttpFileSystemBase.$$$reportNull$$$0(17);
        }
        return string;
    }

    public VirtualFile refreshAndFindFileByPath(@NotNull String path2) {
        if (path2 == null) {
            HttpFileSystemBase.$$$reportNull$$$0(18);
        }
        return this.findFileByPath(path2);
    }

    public void refresh(boolean asynchronous) {
    }

    @NotNull
    public String getProtocol() {
        String string = this.myProtocol;
        if (string == null) {
            HttpFileSystemBase.$$$reportNull$$$0(19);
        }
        return string;
    }

    private static RemoteFileManagerImpl getRemoteFileManager() {
        return (RemoteFileManagerImpl)RemoteFileManager.getInstance();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 9: 
            case 12: 
            case 15: 
            case 17: 
            case 19: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 9: 
            case 12: 
            case 15: 
            case 17: 
            case 19: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 2: 
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentDisposable";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 9: 
            case 12: 
            case 15: 
            case 17: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vfs/impl/http/HttpFileSystemBase";
                break;
            }
            case 10: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vDir";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dirName";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vfs/impl/http/HttpFileSystemBase";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "createChild";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "createChildDirectory";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "createChildFile";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "extractPresentableUrl";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getProtocol";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "findFileByPath";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "addFileListener";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "removeFileListener";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isFileDownloaded";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "createChild";
                break;
            }
            case 9: 
            case 12: 
            case 15: 
            case 17: 
            case 19: {
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "createChildDirectory";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "createChildFile";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "extractPresentableUrl";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "refreshAndFindFileByPath";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 9: 
            case 12: 
            case 15: 
            case 17: 
            case 19: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

