/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs.newvfs;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.util.PingProgress;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.AsyncFileListener;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.newvfs.BulkFileListener;
import com.intellij.openapi.vfs.newvfs.CompoundVFileEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.openapi.vfs.newvfs.persistent.PersistentFS;
import com.intellij.openapi.vfs.newvfs.persistent.PersistentFSImpl;
import com.intellij.util.containers.CollectionFactory;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.HashingStrategy;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Internal
public final class AsyncEventSupport {
    private static final Logger LOG = Logger.getInstance(AsyncEventSupport.class);
    @ApiStatus.Internal
    public static final ExtensionPointName<AsyncFileListener> EP_NAME = new ExtensionPointName("com.intellij.vfs.asyncListener");
    @NotNull
    private static final Set<List<? extends VFileEvent>> ourAsyncProcessedEvents = CollectionFactory.createCustomHashingStrategySet((HashingStrategy)HashingStrategy.identity());
    @NotNull
    private static final Map<List<? extends VFileEvent>, List<AsyncFileListener.ChangeApplier>> ourAppliers = CollectionFactory.createSmallMemoryFootprintMap((int)1);

    public static void startListening() {
        Application app2 = ApplicationManager.getApplication();
        Disposer.register((Disposable)app2, () -> AsyncEventSupport.ensureAllEventsProcessed());
        app2.getMessageBus().connect().subscribe(VirtualFileManager.VFS_CHANGES, (Object)new BulkFileListener(){

            public void before(@NotNull @NotNull List<? extends @NotNull VFileEvent> events) {
                if (events == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (ourAsyncProcessedEvents.contains(events)) {
                    return;
                }
                List<AsyncFileListener.ChangeApplier> appliers = AsyncEventSupport.runAsyncListeners(events);
                ourAppliers.put(events, appliers);
                AsyncEventSupport.beforeVfsChange(appliers);
            }

            public void after(@NotNull @NotNull List<? extends @NotNull VFileEvent> events) {
                if (events == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (ourAsyncProcessedEvents.contains(events)) {
                    return;
                }
                List<AsyncFileListener.ChangeApplier> appliers = ourAppliers.remove(events);
                AsyncEventSupport.afterVfsChange(appliers);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "events";
                objectArray2[1] = "com/intellij/openapi/vfs/newvfs/AsyncEventSupport$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "before";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "after";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }

    private static void ensureAllEventsProcessed() {
        LOG.assertTrue(ourAsyncProcessedEvents.isEmpty(), (Object)("Some VFS events were not properly processed " + ourAsyncProcessedEvents));
        LOG.assertTrue(ourAppliers.isEmpty(), (Object)("Some VFS events were not processed after VFS change performed " + ourAppliers));
    }

    /*
     * Exception decompiling
     */
    @NotNull
    static List<AsyncFileListener.ChangeApplier> runAsyncListeners(@NotNull List<? extends VFileEvent> events) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [2[CATCHBLOCK]], but top level block is 1[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static void markAsynchronouslyProcessedEvents(@NotNull List<? extends VFileEvent> events) {
        if (events == null) {
            AsyncEventSupport.$$$reportNull$$$0(3);
        }
        ourAsyncProcessedEvents.add(events);
    }

    public static void unmarkAsynchronouslyProcessedEvents(@NotNull List<? extends VFileEvent> events) {
        if (events == null) {
            AsyncEventSupport.$$$reportNull$$$0(4);
        }
        LOG.assertTrue(ourAsyncProcessedEvents.remove(events));
    }

    private static void beforeVfsChange(@NotNull List<? extends AsyncFileListener.ChangeApplier> appliers) {
        if (appliers == null) {
            AsyncEventSupport.$$$reportNull$$$0(5);
        }
        for (AsyncFileListener.ChangeApplier changeApplier : appliers) {
            PingProgress.interactWithEdtProgress();
            try {
                changeApplier.beforeVfsChange();
            }
            catch (Throwable e) {
                LOG.error(e);
            }
        }
    }

    private static void afterVfsChange(@NotNull List<? extends AsyncFileListener.ChangeApplier> appliers) {
        if (appliers == null) {
            AsyncEventSupport.$$$reportNull$$$0(6);
        }
        for (AsyncFileListener.ChangeApplier changeApplier : appliers) {
            PingProgress.interactWithEdtProgress();
            try {
                changeApplier.afterVfsChange();
            }
            catch (ProcessCanceledException e) {
                throw e;
            }
            catch (Throwable e) {
                LOG.error(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void processEventsFromRefresh(@NotNull List<? extends CompoundVFileEvent> events, @NotNull List<? extends AsyncFileListener.ChangeApplier> appliers, boolean asyncProcessing) {
        if (events == null) {
            AsyncEventSupport.$$$reportNull$$$0(7);
        }
        if (appliers == null) {
            AsyncEventSupport.$$$reportNull$$$0(8);
        }
        ApplicationManager.getApplication().assertWriteAccessAllowed();
        AsyncEventSupport.beforeVfsChange(appliers);
        try {
            ((PersistentFSImpl)PersistentFS.getInstance()).processEventsImpl(events, asyncProcessing);
        }
        catch (Throwable e) {
            LOG.error(e);
        }
        finally {
            AsyncEventSupport.afterVfsChange(appliers);
        }
    }

    private static /* synthetic */ void lambda$runAsyncListeners$1(List appliers, AsyncFileListener listener2, List events) throws RuntimeException {
        ContainerUtil.addIfNotNull((Collection)appliers, (Object)listener2.prepareChange(events));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "events";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vfs/newvfs/AsyncEventSupport";
                break;
            }
            case 5: 
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "appliers";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vfs/newvfs/AsyncEventSupport";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "runAsyncListeners";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "runAsyncListeners";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "markAsynchronouslyProcessedEvents";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "unmarkAsynchronouslyProcessedEvents";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "beforeVfsChange";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "afterVfsChange";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "processEventsFromRefresh";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

