/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs.newvfs;

import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileAttributes;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.InvalidVirtualFileAccessException;
import com.intellij.openapi.vfs.VFileProperty;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.ex.temp.TempFileSystem;
import com.intellij.openapi.vfs.newvfs.ChildInfoImpl;
import com.intellij.openapi.vfs.newvfs.LocalFileSystemRefreshWorker;
import com.intellij.openapi.vfs.newvfs.NewVirtualFile;
import com.intellij.openapi.vfs.newvfs.NewVirtualFileSystem;
import com.intellij.openapi.vfs.newvfs.VfsEventGenerationHelper;
import com.intellij.openapi.vfs.newvfs.events.ChildInfo;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.openapi.vfs.newvfs.impl.FakeVirtualFile;
import com.intellij.openapi.vfs.newvfs.impl.VirtualDirectoryImpl;
import com.intellij.openapi.vfs.newvfs.impl.VirtualFileSystemEntry;
import com.intellij.openapi.vfs.newvfs.persistent.BatchingFileSystem;
import com.intellij.openapi.vfs.newvfs.persistent.PersistentFS;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ThrowableRunnable;
import com.intellij.util.containers.CollectionFactory;
import com.intellij.util.containers.ContainerUtil;
import it.unimi.dsi.fastutil.objects.ObjectOpenCustomHashSet;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class RefreshWorker {
    private final boolean myIsRecursive;
    private final Deque<NewVirtualFile> myRefreshQueue;
    private final VfsEventGenerationHelper myHelper;
    private volatile boolean myCancelled;
    private final LocalFileSystemRefreshWorker myLocalFileSystemRefreshWorker;
    static Consumer<? super VirtualFile> ourTestListener;

    RefreshWorker(@NotNull NewVirtualFile refreshRoot, boolean isRecursive) {
        if (refreshRoot == null) {
            RefreshWorker.$$$reportNull$$$0(0);
        }
        this.myRefreshQueue = new ArrayDeque<NewVirtualFile>(100);
        this.myHelper = new VfsEventGenerationHelper();
        boolean canUseNioRefresher = refreshRoot.isInLocalFileSystem() && !(refreshRoot.getFileSystem() instanceof TempFileSystem) && Registry.is((String)"vfs.use.nio-based.local.refresh.worker");
        this.myLocalFileSystemRefreshWorker = canUseNioRefresher ? new LocalFileSystemRefreshWorker(refreshRoot, isRecursive) : null;
        this.myIsRecursive = isRecursive;
        this.myRefreshQueue.addLast(refreshRoot);
    }

    @NotNull
    List<VFileEvent> getEvents() {
        if (this.myLocalFileSystemRefreshWorker != null) {
            List<VFileEvent> list2 = this.myLocalFileSystemRefreshWorker.getEvents();
            if (list2 == null) {
                RefreshWorker.$$$reportNull$$$0(1);
            }
            return list2;
        }
        List<VFileEvent> list3 = this.myHelper.getEvents();
        if (list3 == null) {
            RefreshWorker.$$$reportNull$$$0(2);
        }
        return list3;
    }

    void cancel() {
        if (this.myLocalFileSystemRefreshWorker != null) {
            this.myLocalFileSystemRefreshWorker.cancel();
        }
        this.myCancelled = true;
    }

    void scan() {
        if (this.myLocalFileSystemRefreshWorker != null) {
            this.myLocalFileSystemRefreshWorker.scan();
            return;
        }
        NewVirtualFile root2 = this.myRefreshQueue.removeFirst();
        NewVirtualFileSystem fs = root2.getFileSystem();
        if (root2.isDirectory()) {
            fs = PersistentFS.replaceWithNativeFS(fs);
        }
        PersistentFS persistence = PersistentFS.getInstance();
        FileAttributes attributes2 = fs.getAttributes((VirtualFile)root2);
        if (attributes2 == null) {
            this.myHelper.scheduleDeletion((VirtualFile)root2);
            root2.markClean();
            return;
        }
        this.checkAndScheduleChildRefresh(fs, persistence, root2.getParent(), root2, attributes2);
        if (root2.isDirty() && root2.isDirectory() && this.myRefreshQueue.isEmpty()) {
            this.queueDirectory(root2);
        }
        try {
            this.processQueue(fs, persistence);
        }
        catch (RefreshCancelledException e) {
            VfsEventGenerationHelper.LOG.trace("refresh cancelled");
        }
    }

    private void queueDirectory(@NotNull NewVirtualFile root2) {
        if (root2 == null) {
            RefreshWorker.$$$reportNull$$$0(3);
        }
        if (root2 instanceof VirtualDirectoryImpl) {
            this.myRefreshQueue.addLast(root2);
        } else {
            VfsEventGenerationHelper.LOG.error("not a directory: " + root2 + " (" + root2.getClass());
        }
    }

    private void processQueue(@NotNull NewVirtualFileSystem fs, @NotNull PersistentFS persistence) throws RefreshCancelledException {
        if (fs == null) {
            RefreshWorker.$$$reportNull$$$0(4);
        }
        if (persistence == null) {
            RefreshWorker.$$$reportNull$$$0(5);
        }
        block2: while (!this.myRefreshQueue.isEmpty()) {
            boolean succeeded;
            VirtualDirectoryImpl dir = (VirtualDirectoryImpl)this.myRefreshQueue.removeFirst();
            boolean fullSync = dir.allChildrenLoaded();
            do {
                this.myHelper.beginTransaction();
                try {
                    succeeded = fullSync ? this.fullDirRefresh(fs, persistence, dir) : this.partialDirRefresh(fs, persistence, dir);
                }
                catch (InvalidVirtualFileAccessException e) {
                    this.myHelper.endTransaction(false);
                    continue block2;
                }
                this.myHelper.endTransaction(succeeded);
                if (succeeded || !VfsEventGenerationHelper.LOG.isTraceEnabled()) continue;
                VfsEventGenerationHelper.LOG.trace("retry: " + dir);
            } while (!succeeded);
            if (!this.myIsRecursive) continue;
            dir.markClean();
        }
    }

    private boolean fullDirRefresh(@NotNull NewVirtualFileSystem fs, @NotNull PersistentFS persistence, @NotNull VirtualDirectoryImpl dir) {
        ObjectOpenCustomHashSet actualNames;
        Pair<List<String>, List<VirtualFile>> snapshot;
        if (fs == null) {
            RefreshWorker.$$$reportNull$$$0(6);
        }
        if (persistence == null) {
            RefreshWorker.$$$reportNull$$$0(7);
        }
        if (dir == null) {
            RefreshWorker.$$$reportNull$$$0(8);
        }
        if ((snapshot = LocalFileSystemRefreshWorker.getDirectorySnapshot(dir)) == null) {
            return false;
        }
        List persistedNames = (List)snapshot.getFirst();
        List children2 = (List)snapshot.getSecond();
        Map<String, FileAttributes> childrenWithAttributes = fs instanceof BatchingFileSystem ? ((BatchingFileSystem)fs).listWithAttributes((VirtualFile)dir) : null;
        String[] listDir = childrenWithAttributes != null ? ArrayUtil.toStringArray(childrenWithAttributes.keySet()) : fs.list((VirtualFile)dir);
        Object[] upToDateNames = VfsUtil.filterNames((String[])listDir);
        HashSet newNames = new HashSet(upToDateNames.length);
        ContainerUtil.addAll(newNames, (Object[])upToDateNames);
        if (dir.allChildrenLoaded() && children2.size() < upToDateNames.length) {
            for (VirtualFile child3 : children2) {
                newNames.remove(child3.getName());
            }
        } else {
            newNames.removeAll(persistedNames);
        }
        HashSet deletedNames = new HashSet(persistedNames);
        ContainerUtil.removeAll(deletedNames, (Object[])upToDateNames);
        ObjectOpenCustomHashSet objectOpenCustomHashSet = actualNames = dir.isCaseSensitive() ? null : (ObjectOpenCustomHashSet)CollectionFactory.createFilePathSet((String[])upToDateNames, (boolean)false);
        if (VfsEventGenerationHelper.LOG.isTraceEnabled()) {
            VfsEventGenerationHelper.LOG.trace("current=" + persistedNames + " +" + newNames + " -" + deletedNames);
        }
        ArrayList<ChildInfo> newKids = new ArrayList<ChildInfo>(newNames.size());
        for (String newName2 : newNames) {
            this.checkCancelled(dir);
            ChildInfo record = RefreshWorker.childRecord(fs, (VirtualFile)dir, newName2, false);
            if (record != null) {
                newKids.add(record);
                continue;
            }
            if (!VfsEventGenerationHelper.LOG.isTraceEnabled()) continue;
            VfsEventGenerationHelper.LOG.trace("[+] fs=" + fs + " dir=" + dir + " name=" + newName2);
        }
        ArrayList<Pair> updatedMap = new ArrayList<Pair>(children2.size() - deletedNames.size());
        List chs = ContainerUtil.filter((Collection)children2, file2 -> !deletedNames.contains(file2.getName()));
        if (fs instanceof BatchingFileSystem) {
            Set names2 = ContainerUtil.map2Set((Collection)chs, file2 -> file2.getName());
            Map map2 = ContainerUtil.filter(childrenWithAttributes, s -> names2.contains(s));
            HashMap<String, VirtualFile> nameToFile = new HashMap<String, VirtualFile>();
            for (VirtualFile virtualFile2 : chs) {
                nameToFile.put(virtualFile2.getName(), virtualFile2);
            }
            for (Map.Entry entry2 : map2.entrySet()) {
                String name2 = (String)entry2.getKey();
                FileAttributes attributes2 = (FileAttributes)entry2.getValue();
                updatedMap.add(Pair.create((Object)((VirtualFile)nameToFile.get(name2)), (Object)attributes2));
            }
        } else {
            for (VirtualFile child4 : chs) {
                this.checkCancelled(dir);
                updatedMap.add(new Pair((Object)child4, (Object)fs.getAttributes(child4)));
            }
        }
        if (this.isFullScanDirectoryChanged(dir, persistedNames, children2)) {
            return false;
        }
        for (String name3 : deletedNames) {
            VirtualFileSystemEntry child2 = dir.findChild(name3);
            if (child2 == null) continue;
            if (this.checkAndScheduleFileNameChange((ObjectOpenCustomHashSet<String>)actualNames, (VirtualFile)child2)) {
                newKids.removeIf(newKidCandidate -> StringUtil.equalsIgnoreCase((CharSequence)newKidCandidate.getName(), (CharSequence)child2.getName()));
                continue;
            }
            this.myHelper.scheduleDeletion((VirtualFile)child2);
        }
        for (ChildInfo record : newKids) {
            this.myHelper.scheduleCreation((VirtualFile)dir, record.getName().toString(), record.getFileAttributes(), record.getSymlinkTarget(), (ThrowableRunnable<RefreshCancelledException>)((ThrowableRunnable)() -> this.checkCancelled(dir)));
        }
        for (Pair pair : updatedMap) {
            NewVirtualFile child2 = (NewVirtualFile)pair.first;
            this.checkCancelled(child2);
            FileAttributes childAttributes = (FileAttributes)pair.second;
            if (childAttributes != null) {
                this.checkAndScheduleChildRefresh(fs, persistence, dir, child2, childAttributes);
                this.checkAndScheduleFileNameChange((ObjectOpenCustomHashSet<String>)actualNames, (VirtualFile)child2);
                continue;
            }
            if (VfsEventGenerationHelper.LOG.isTraceEnabled()) {
                VfsEventGenerationHelper.LOG.trace("[x] fs=" + fs + " dir=" + dir + " name=" + child2.getName());
            }
            this.myHelper.scheduleDeletion((VirtualFile)child2);
        }
        return !this.isFullScanDirectoryChanged(dir, persistedNames, children2);
    }

    private boolean isFullScanDirectoryChanged(@NotNull VirtualDirectoryImpl dir, @NotNull List<String> names2, @NotNull List<? extends VirtualFile> children2) {
        if (dir == null) {
            RefreshWorker.$$$reportNull$$$0(9);
        }
        if (names2 == null) {
            RefreshWorker.$$$reportNull$$$0(10);
        }
        if (children2 == null) {
            RefreshWorker.$$$reportNull$$$0(11);
        }
        return (Boolean)ReadAction.compute(() -> {
            this.checkCancelled(dir);
            return LocalFileSystemRefreshWorker.areChildrenOrNamesChanged(dir, names2, children2);
        });
    }

    private boolean partialDirRefresh(@NotNull NewVirtualFileSystem fs, @NotNull PersistentFS persistence, @NotNull VirtualDirectoryImpl dir) {
        if (fs == null) {
            RefreshWorker.$$$reportNull$$$0(12);
        }
        if (persistence == null) {
            RefreshWorker.$$$reportNull$$$0(13);
        }
        if (dir == null) {
            RefreshWorker.$$$reportNull$$$0(14);
        }
        Pair snapshot = (Pair)ReadAction.compute(() -> {
            this.checkCancelled(dir);
            return new Pair((Object)dir.getCachedChildren(), dir.getSuspiciousNames());
        });
        List cached = (List)snapshot.getFirst();
        List wanted = (List)snapshot.getSecond();
        ObjectOpenCustomHashSet actualNames = dir.isCaseSensitive() || cached.isEmpty() ? null : (ObjectOpenCustomHashSet)CollectionFactory.createFilePathSet((String[])VfsUtil.filterNames((String[])fs.list((VirtualFile)dir)), (boolean)false);
        if (VfsEventGenerationHelper.LOG.isTraceEnabled()) {
            VfsEventGenerationHelper.LOG.trace("cached=" + cached + " actual=" + actualNames + " suspicious=" + wanted);
        }
        ArrayList<Pair> existingMap = new ArrayList<Pair>(cached.size());
        for (VirtualFile child2 : cached) {
            this.checkCancelled(dir);
            existingMap.add(new Pair((Object)child2, (Object)fs.getAttributes(child2)));
        }
        ArrayList<ChildInfo> newKids = new ArrayList<ChildInfo>(wanted.size());
        for (String name2 : wanted) {
            if (name2.isEmpty()) continue;
            this.checkCancelled(dir);
            ChildInfo record = RefreshWorker.childRecord(fs, (VirtualFile)dir, name2, true);
            if (record == null) continue;
            newKids.add(record);
        }
        if (this.isDirectoryChanged(dir, cached, wanted)) {
            return false;
        }
        for (Pair pair : existingMap) {
            NewVirtualFile child3 = (NewVirtualFile)pair.first;
            this.checkCancelled(child3);
            FileAttributes childAttributes = (FileAttributes)pair.second;
            if (childAttributes != null) {
                this.checkAndScheduleChildRefresh(fs, persistence, dir, child3, childAttributes);
                this.checkAndScheduleFileNameChange((ObjectOpenCustomHashSet<String>)actualNames, (VirtualFile)child3);
                continue;
            }
            this.myHelper.scheduleDeletion((VirtualFile)child3);
        }
        for (ChildInfo record : newKids) {
            this.myHelper.scheduleCreation((VirtualFile)dir, record.getName().toString(), record.getFileAttributes(), record.getSymlinkTarget(), (ThrowableRunnable<RefreshCancelledException>)((ThrowableRunnable)() -> this.checkCancelled(dir)));
        }
        return !this.isDirectoryChanged(dir, cached, wanted);
    }

    private boolean isDirectoryChanged(@NotNull VirtualDirectoryImpl dir, @NotNull List<VirtualFile> cached, @NotNull List<String> wanted) {
        if (dir == null) {
            RefreshWorker.$$$reportNull$$$0(15);
        }
        if (cached == null) {
            RefreshWorker.$$$reportNull$$$0(16);
        }
        if (wanted == null) {
            RefreshWorker.$$$reportNull$$$0(17);
        }
        return (Boolean)ReadAction.compute(() -> {
            this.checkCancelled(dir);
            return !cached.equals(dir.getCachedChildren()) || !wanted.equals(dir.getSuspiciousNames());
        });
    }

    @Nullable
    private static ChildInfo childRecord(NewVirtualFileSystem fs, VirtualFile dir, String name2, boolean canonicalize) {
        String symlinkTarget;
        FakeVirtualFile file2 = new FakeVirtualFile(dir, name2);
        FileAttributes attributes2 = fs.getAttributes((VirtualFile)file2);
        if (attributes2 == null) {
            return null;
        }
        boolean isEmptyDir = attributes2.isDirectory() && !fs.hasChildren((VirtualFile)file2);
        String string = symlinkTarget = attributes2.isSymLink() ? fs.resolveSymLink((VirtualFile)file2) : null;
        if (canonicalize) {
            name2 = fs.getCanonicallyCasedName((VirtualFile)file2);
        }
        return new ChildInfoImpl(name2, attributes2, (ChildInfo[])(isEmptyDir ? ChildInfo.EMPTY_ARRAY : null), symlinkTarget);
    }

    private void checkCancelled(@NotNull NewVirtualFile stopAt) throws RefreshCancelledException {
        Consumer<? super VirtualFile> testListener;
        if (stopAt == null) {
            RefreshWorker.$$$reportNull$$$0(18);
        }
        if ((testListener = ourTestListener) != null) {
            testListener.accept((VirtualFile)stopAt);
        }
        if (this.myCancelled) {
            NewVirtualFile file2;
            if (VfsEventGenerationHelper.LOG.isTraceEnabled()) {
                VfsEventGenerationHelper.LOG.trace("cancelled at: " + stopAt);
            }
            RefreshWorker.forceMarkDirty(stopAt);
            while ((file2 = this.myRefreshQueue.pollFirst()) != null) {
                RefreshWorker.forceMarkDirty(file2);
            }
            throw new RefreshCancelledException();
        }
    }

    private static void forceMarkDirty(@NotNull NewVirtualFile file2) {
        if (file2 == null) {
            RefreshWorker.$$$reportNull$$$0(19);
        }
        file2.markClean();
        file2.markDirty();
    }

    private void checkAndScheduleChildRefresh(@NotNull NewVirtualFileSystem fs, @NotNull PersistentFS persistence, @Nullable NewVirtualFile parent, @NotNull NewVirtualFile child2, @NotNull FileAttributes childAttributes) {
        if (fs == null) {
            RefreshWorker.$$$reportNull$$$0(20);
        }
        if (persistence == null) {
            RefreshWorker.$$$reportNull$$$0(21);
        }
        if (child2 == null) {
            RefreshWorker.$$$reportNull$$$0(22);
        }
        if (childAttributes == null) {
            RefreshWorker.$$$reportNull$$$0(23);
        }
        if (!VfsEventGenerationHelper.checkDirty(child2)) {
            return;
        }
        if (this.checkAndScheduleFileTypeChange(fs, parent, child2, childAttributes)) {
            child2.markClean();
            return;
        }
        this.myHelper.checkWritableAttributeChange((VirtualFile)child2, persistence.isWritable((VirtualFile)child2), childAttributes.isWritable());
        if (SystemInfo.isWindows) {
            this.myHelper.checkHiddenAttributeChange((VirtualFile)child2, child2.is(VFileProperty.HIDDEN), childAttributes.isHidden());
        }
        if (childAttributes.isSymLink()) {
            this.myHelper.checkSymbolicLinkChange((VirtualFile)child2, child2.getCanonicalPath(), fs.resolveSymLink((VirtualFile)child2));
        }
        if (!childAttributes.isDirectory()) {
            long oltTS = persistence.getTimeStamp((VirtualFile)child2);
            long newTS = childAttributes.lastModified;
            long oldLength = persistence.getLastRecordedLength((VirtualFile)child2);
            long newLength = childAttributes.length;
            this.myHelper.checkContentChanged((VirtualFile)child2, oltTS, newTS, oldLength, newLength);
            child2.markClean();
        } else if (this.myIsRecursive) {
            this.queueDirectory(child2);
        }
    }

    private boolean checkAndScheduleFileTypeChange(@NotNull NewVirtualFileSystem fs, @Nullable NewVirtualFile parent, @NotNull NewVirtualFile child2, @NotNull FileAttributes childAttributes) {
        if (fs == null) {
            RefreshWorker.$$$reportNull$$$0(24);
        }
        if (child2 == null) {
            RefreshWorker.$$$reportNull$$$0(25);
        }
        if (childAttributes == null) {
            RefreshWorker.$$$reportNull$$$0(26);
        }
        boolean currentIsDirectory = child2.isDirectory();
        boolean upToDateIsDirectory = childAttributes.isDirectory();
        boolean currentIsSymlink = child2.is(VFileProperty.SYMLINK);
        boolean upToDateIsSymlink = childAttributes.isSymLink();
        boolean currentIsSpecial = child2.is(VFileProperty.SPECIAL);
        boolean upToDateIsSpecial = childAttributes.isSpecial();
        if (currentIsDirectory != upToDateIsDirectory || currentIsSymlink != upToDateIsSymlink || currentIsSpecial != upToDateIsSpecial) {
            this.myHelper.scheduleDeletion((VirtualFile)child2);
            if (parent != null) {
                String symlinkTarget = upToDateIsSymlink ? fs.resolveSymLink((VirtualFile)child2) : null;
                this.myHelper.scheduleCreation((VirtualFile)parent, child2.getName(), childAttributes, symlinkTarget, (ThrowableRunnable<RefreshCancelledException>)((ThrowableRunnable)() -> this.checkCancelled(parent)));
            } else {
                VfsEventGenerationHelper.LOG.error("transgender orphan: " + child2 + " " + childAttributes);
            }
            return true;
        }
        return false;
    }

    private boolean checkAndScheduleFileNameChange(@Nullable ObjectOpenCustomHashSet<String> actualNames, @NotNull VirtualFile child2) {
        String currentName;
        String actualName;
        if (child2 == null) {
            RefreshWorker.$$$reportNull$$$0(27);
        }
        if (actualNames != null && (actualName = (String)actualNames.get((Object)(currentName = child2.getName()))) != null && !currentName.equals(actualName)) {
            this.myHelper.scheduleAttributeChange(child2, "name", currentName, actualName);
            return true;
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refreshRoot";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vfs/newvfs/RefreshWorker";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 4: 
            case 6: 
            case 12: 
            case 20: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fs";
                break;
            }
            case 5: 
            case 7: 
            case 13: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "persistence";
                break;
            }
            case 8: 
            case 9: 
            case 14: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dir";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "names";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "children";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cached";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "wanted";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stopAt";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 22: 
            case 25: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "child";
                break;
            }
            case 23: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "childAttributes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vfs/newvfs/RefreshWorker";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getEvents";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "queueDirectory";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "processQueue";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "fullDirRefresh";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "isFullScanDirectoryChanged";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "partialDirRefresh";
                break;
            }
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "isDirectoryChanged";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "checkCancelled";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "forceMarkDirty";
                break;
            }
            case 20: 
            case 21: 
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "checkAndScheduleChildRefresh";
                break;
            }
            case 24: 
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "checkAndScheduleFileTypeChange";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "checkAndScheduleFileNameChange";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    static class RefreshCancelledException
    extends RuntimeException {
        RefreshCancelledException() {
        }

        @Override
        public synchronized Throwable fillInStackTrace() {
            return this;
        }
    }
}

