/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs.newvfs.persistent;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.vfs.newvfs.persistent.PersistentFSAttributeAccessor;
import com.intellij.openapi.vfs.newvfs.persistent.PersistentFSConnection;
import com.intellij.openapi.vfs.newvfs.persistent.PersistentFSContentAccessor;
import com.intellij.util.BitUtil;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class PersistentFSRecordAccessor {
    private static final Logger LOG = Logger.getInstance(PersistentFSRecordAccessor.class);
    static final int FREE_RECORD_FLAG = 1024;
    private static final int ALL_VALID_FLAGS = 2047;
    @NotNull
    private final PersistentFSContentAccessor myPersistentFSContentAccessor;
    @NotNull
    private final PersistentFSAttributeAccessor myPersistentFSAttributeAccessor;
    private final PersistentFSConnection myFSConnection;
    @NotNull
    private final IntList myNewFreeRecords;

    PersistentFSRecordAccessor(@NotNull PersistentFSContentAccessor contentAccessor, @NotNull PersistentFSAttributeAccessor attributeAccessor, @NotNull PersistentFSConnection connection) {
        if (contentAccessor == null) {
            PersistentFSRecordAccessor.$$$reportNull$$$0(0);
        }
        if (attributeAccessor == null) {
            PersistentFSRecordAccessor.$$$reportNull$$$0(1);
        }
        if (connection == null) {
            PersistentFSRecordAccessor.$$$reportNull$$$0(2);
        }
        this.myNewFreeRecords = new IntArrayList();
        this.myPersistentFSContentAccessor = contentAccessor;
        this.myPersistentFSAttributeAccessor = attributeAccessor;
        this.myFSConnection = connection;
    }

    void addToFreeRecordsList(int id2) throws IOException {
        this.myFSConnection.markDirty();
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            this.myNewFreeRecords.add(id2);
        }
        this.myFSConnection.getRecords().setFlags(id2, 1024);
    }

    int createRecord() throws IOException {
        PersistentFSConnection connection = this.myFSConnection;
        connection.markDirty();
        int free = connection.getFreeRecord();
        if (free == 0) {
            int fileLength = this.length();
            LOG.assertTrue(fileLength % 40 == 0, (Object)("record file length = " + fileLength + ", record size = 40"));
            int newRecord = fileLength / 40;
            connection.getRecords().cleanRecord(newRecord);
            assert (fileLength + 40 == this.length());
            return newRecord;
        }
        this.deleteContentAndAttributes(free);
        connection.getRecords().cleanRecord(free);
        return free;
    }

    void checkSanity() throws IOException {
        PersistentFSConnection connection = this.myFSConnection;
        long t = System.currentTimeMillis();
        int fileLength = this.length();
        assert (fileLength % 40 == 0);
        int recordCount = fileLength / 40;
        IntArrayList usedAttributeRecordIds = new IntArrayList();
        IntArrayList validAttributeIds = new IntArrayList();
        for (int id2 = 2; id2 < recordCount; ++id2) {
            int flags = connection.getRecords().doGetFlags(id2);
            LOG.assertTrue((flags & 0xFFFFF800) == 0, (Object)("Invalid flags: 0x" + Integer.toHexString(flags) + ", id: " + id2));
            boolean isFreeRecord = connection.getFreeRecords().contains(id2);
            if (BitUtil.isSet((int)flags, (int)1024)) {
                LOG.assertTrue(isFreeRecord, (Object)("Record, marked free, not in free list: " + id2));
                continue;
            }
            LOG.assertTrue(!isFreeRecord, (Object)("Record, not marked free, in free list: " + id2));
            this.checkRecordSanity(id2, recordCount, (IntList)usedAttributeRecordIds, (IntList)validAttributeIds);
        }
        t = System.currentTimeMillis() - t;
        LOG.info("Sanity check took " + t + " ms");
    }

    boolean isDeleted(int id2) throws IOException {
        return BitUtil.isSet((int)this.myFSConnection.getRecords().doGetFlags(id2), (int)1024) || this.myNewFreeRecords.contains(id2);
    }

    private void checkRecordSanity(int id2, int recordCount, @NotNull IntList usedAttributeRecordIds, @NotNull IntList validAttributeIds) throws IOException {
        if (usedAttributeRecordIds == null) {
            PersistentFSRecordAccessor.$$$reportNull$$$0(3);
        }
        if (validAttributeIds == null) {
            PersistentFSRecordAccessor.$$$reportNull$$$0(4);
        }
        PersistentFSConnection connection = this.myFSConnection;
        int parentId = connection.getRecords().getParent(id2);
        assert (parentId >= 0 && parentId < recordCount);
        if (parentId > 0 && connection.getRecords().getParent(parentId) > 0) {
            int parentFlags = connection.getRecords().doGetFlags(parentId);
            assert (!BitUtil.isSet((int)parentFlags, (int)1024)) : parentId + ": " + Integer.toHexString(parentFlags);
            assert (BitUtil.isSet((int)parentFlags, (int)2)) : parentId + ": " + Integer.toHexString(parentFlags);
        }
        String name2 = this.getName(id2);
        LOG.assertTrue(parentId == 0 || name2.length() != 0, (Object)("File with empty name found under " + this.getName(parentId) + ", id=" + id2));
        this.myPersistentFSContentAccessor.checkContentsStorageSanity(id2);
        this.myPersistentFSAttributeAccessor.checkAttributesStorageSanity(id2, usedAttributeRecordIds, validAttributeIds);
        long length = connection.getRecords().getLength(id2);
        assert (length >= -1L) : "Invalid file length found for " + name2 + ": " + length;
    }

    @NotNull
    IntList getNewFreeRecords() {
        IntList intList = this.myNewFreeRecords;
        if (intList == null) {
            PersistentFSRecordAccessor.$$$reportNull$$$0(5);
        }
        return intList;
    }

    @Nullable
    private String getName(int fileId) throws IOException {
        return this.myFSConnection.getNames().valueOf(this.myFSConnection.getRecords().getNameId(fileId));
    }

    private int length() {
        return (int)this.myFSConnection.getRecords().length();
    }

    private void deleteContentAndAttributes(int id2) throws IOException {
        this.myPersistentFSContentAccessor.deleteContent(id2);
        this.myPersistentFSAttributeAccessor.deleteAttributes(id2);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contentAccessor";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attributeAccessor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "connection";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "usedAttributeRecordIds";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "validAttributeIds";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vfs/newvfs/persistent/PersistentFSRecordAccessor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vfs/newvfs/persistent/PersistentFSRecordAccessor";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getNewFreeRecords";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "checkRecordSanity";
                break;
            }
            case 5: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

