/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.wm.impl;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.lightEdit.LightEditService;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.util.NlsActions;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.util.BitUtil;
import java.awt.Component;
import java.awt.event.KeyEvent;
import javax.swing.JFrame;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ProjectWindowAction
extends ToggleAction
implements DumbAware {
    private ProjectWindowAction myPrevious;
    private ProjectWindowAction myNext;
    @NotNull
    private final String myProjectName;
    @NotNull
    private final String myProjectLocation;

    public ProjectWindowAction(@NlsSafe @NotNull String projectName, @NotNull String projectLocation, ProjectWindowAction previous) {
        if (projectName == null) {
            ProjectWindowAction.$$$reportNull$$$0(0);
        }
        if (projectLocation == null) {
            ProjectWindowAction.$$$reportNull$$$0(1);
        }
        this.myProjectName = projectName;
        this.myProjectLocation = projectLocation;
        if (previous != null) {
            this.myPrevious = previous;
            this.myNext = previous.myNext;
            this.myNext.myPrevious = this;
            this.myPrevious.myNext = this;
        } else {
            this.myPrevious = this;
            this.myNext = this;
        }
        this.getTemplatePresentation().setText(projectName, false);
    }

    public void dispose() {
        if (this.myPrevious == this) {
            assert (this.myNext == this);
            return;
        }
        if (this.myNext == this) {
            assert (false);
            return;
        }
        this.myPrevious.myNext = this.myNext;
        this.myNext.myPrevious = this.myPrevious;
    }

    public ProjectWindowAction getPrevious() {
        return this.myPrevious;
    }

    public ProjectWindowAction getNext() {
        return this.myNext;
    }

    @NotNull
    public String getProjectLocation() {
        String string = this.myProjectLocation;
        if (string == null) {
            ProjectWindowAction.$$$reportNull$$$0(2);
        }
        return string;
    }

    @NotNull
    public String getProjectName() {
        String string = this.myProjectName;
        if (string == null) {
            ProjectWindowAction.$$$reportNull$$$0(3);
        }
        return string;
    }

    @Nullable
    private Project findProject() {
        Project[] projects;
        if ("LightEdit".equals(this.myProjectName)) {
            return LightEditService.getInstance().getProject();
        }
        for (Project project : projects = ProjectManager.getInstance().getOpenProjects()) {
            if (!this.myProjectLocation.equals(project.getPresentableUrl())) continue;
            return project;
        }
        return null;
    }

    public boolean isSelected(@NotNull AnActionEvent e) {
        Project project;
        if (e == null) {
            ProjectWindowAction.$$$reportNull$$$0(4);
        }
        if ((project = (Project)e.getData(CommonDataKeys.PROJECT)) == null) {
            return false;
        }
        return this.myProjectLocation.equals(project.getPresentableUrl());
    }

    public void setSelected(@NotNull AnActionEvent e, boolean selected2) {
        if (e == null) {
            ProjectWindowAction.$$$reportNull$$$0(5);
        }
        if (!selected2) {
            return;
        }
        Project project = this.findProject();
        if (project == null) {
            return;
        }
        JFrame projectFrame = WindowManager.getInstance().getFrame(project);
        if (projectFrame == null) {
            return;
        }
        int frameState = projectFrame.getExtendedState();
        if (SystemInfo.isMac && BitUtil.isSet((int)projectFrame.getExtendedState(), (int)1) && e.getInputEvent() instanceof KeyEvent) {
            return;
        }
        if (BitUtil.isSet((int)frameState, (int)1)) {
            projectFrame.setExtendedState(BitUtil.set((int)frameState, (int)1, (boolean)false));
        }
        projectFrame.toFront();
        IdeFocusManager.getGlobalInstance().doWhenFocusSettlesDown(() -> {
            Component mostRecentFocusOwner = projectFrame.getMostRecentFocusOwner();
            if (mostRecentFocusOwner != null) {
                IdeFocusManager.getGlobalInstance().requestFocus(mostRecentFocusOwner, true);
            }
        });
    }

    @NonNls
    public String toString() {
        return this.getTemplatePresentation().getText() + " previous: " + this.myPrevious.getTemplatePresentation().getText() + " next: " + this.myNext.getTemplatePresentation().getText();
    }

    @NlsActions.ActionText
    @Nullable
    public String getTemplateText() {
        return IdeBundle.message((String)"action.switch.project.text", (Object[])new Object[0]);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectName";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectLocation";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/wm/impl/ProjectWindowAction";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/wm/impl/ProjectWindowAction";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getProjectLocation";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getProjectName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isSelected";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "setSelected";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

