/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.wm.impl;

import com.intellij.ide.ui.UISettings;
import com.intellij.ide.ui.UISettingsListener;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.wm.ToolWindowAnchor;
import com.intellij.openapi.wm.impl.StripeButton;
import com.intellij.openapi.wm.impl.ToolWindowManagerImpl;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.Gray;
import com.intellij.ui.paint.LinePainter2D;
import com.intellij.ui.paint.RectanglePainter;
import com.intellij.util.ui.JBSwingUtilities;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.StartupUiUtil;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class Stripe
extends JPanel
implements UISettingsListener {
    private static final Dimension EMPTY_SIZE = new Dimension();
    static final Key<Rectangle> VIRTUAL_BOUNDS = Key.create((String)"Virtual stripe bounds");
    private final int anchor;
    private final List<StripeButton> buttons = new ArrayList<StripeButton>();
    private Dimension preferredSize;
    private StripeButton myDragButton;
    private Rectangle myDropRectangle;
    private final Rectangle myDrawRectangle = new Rectangle();
    private JComponent myDragButtonImage;
    private LayoutData myLastLayoutData;
    private boolean myFinishingDrop;
    static final int DROP_DISTANCE_SENSITIVITY = 200;

    Stripe(int anchor2) {
        super(new GridBagLayout());
        this.setOpaque(true);
        this.anchor = anchor2;
        this.setBorder(new AdaptiveBorder());
    }

    public boolean isEmpty() {
        return this.buttons.isEmpty();
    }

    public void reset() {
        this.buttons.clear();
        this.preferredSize = null;
        this.myLastLayoutData = null;
        this.removeAll();
        this.revalidate();
    }

    public void uiSettingsChanged(@NotNull UISettings uiSettings) {
        if (uiSettings == null) {
            Stripe.$$$reportNull$$$0(0);
        }
        this.updatePresentation();
    }

    void addButton(@NotNull StripeButton button4, @NotNull Comparator<? super StripeButton> comparator2) {
        if (button4 == null) {
            Stripe.$$$reportNull$$$0(1);
        }
        if (comparator2 == null) {
            Stripe.$$$reportNull$$$0(2);
        }
        this.preferredSize = null;
        this.buttons.add(button4);
        this.buttons.sort(comparator2);
        this.add(button4);
    }

    void removeButton(@NotNull StripeButton button4) {
        if (button4 == null) {
            Stripe.$$$reportNull$$$0(3);
        }
        this.preferredSize = null;
        this.buttons.remove(button4);
        this.remove(button4);
        this.revalidate();
    }

    @Override
    public void invalidate() {
        this.preferredSize = null;
        super.invalidate();
    }

    @Override
    public void doLayout() {
        if (!this.myFinishingDrop) {
            this.myLastLayoutData = this.recomputeBounds(true, this.getSize(), false);
        }
    }

    private LayoutData recomputeBounds(boolean setBounds, Dimension toFitWith, boolean noDrop) {
        boolean processDrop;
        LayoutData data2 = new LayoutData();
        int horizontalOffset = this.getHeight();
        data2.eachY = 0;
        data2.size = new Dimension();
        data2.horizontal = this.isHorizontal();
        data2.dragInsertPosition = -1;
        if (data2.horizontal) {
            data2.eachX = horizontalOffset - 1;
            data2.eachY = 1;
        } else {
            data2.eachX = 0;
        }
        if (this.myDragButton != null) {
            data2.shouldSwapCoordinates = this.getAnchor().isHorizontal() != this.myDragButton.getAnchor().isHorizontal();
        }
        data2.fitSize = toFitWith != null ? toFitWith : new Dimension();
        Point point = this.myDropRectangle != null ? this.myDropRectangle.getLocation() : new Point(-1, -1);
        SwingUtilities.convertPointToScreen(point, this);
        boolean bl = processDrop = this.isDroppingButton() && this.containsPoint(point) && !noDrop;
        if (toFitWith == null) {
            for (StripeButton button4 : this.buttons) {
                if (!button4.isVisible()) continue;
                Dimension eachSize = button4.getPreferredSize();
                data2.fitSize.width = Math.max(eachSize.width, data2.fitSize.width);
                data2.fitSize.height = Math.max(eachSize.height, data2.fitSize.height);
            }
        }
        int gap = 0;
        if (toFitWith != null) {
            LayoutData layoutData = this.recomputeBounds(false, null, true);
            gap = data2.horizontal ? toFitWith.width - horizontalOffset - layoutData.size.width - data2.eachX : toFitWith.height - layoutData.size.height - data2.eachY;
            if (processDrop) {
                gap = data2.horizontal ? (gap -= data2.shouldSwapCoordinates ? this.myDropRectangle.height : this.myDropRectangle.width) : (gap -= data2.shouldSwapCoordinates ? this.myDropRectangle.width : this.myDropRectangle.height);
            }
            gap = Math.max(gap, 0);
        }
        boolean sidesStarted = false;
        for (StripeButton button5 : this.getButtonsToLayOut()) {
            int insertOrder = button5.getWindowInfo().getOrder();
            Dimension eachSize = button5.getPreferredSize();
            if (!sidesStarted && button5.getWindowInfo().isSplit()) {
                if (processDrop) {
                    this.tryDroppingOnGap(data2, gap, button5.getWindowInfo().getOrder());
                }
                if (data2.horizontal) {
                    data2.eachX += gap;
                    data2.size.width += gap;
                } else {
                    data2.eachY += gap;
                    data2.size.height += gap;
                }
                sidesStarted = true;
            }
            if (processDrop && !data2.dragTargetChosen) {
                int distance2;
                if (data2.horizontal) {
                    distance2 = this.myDropRectangle.x - data2.eachX;
                    if (distance2 < eachSize.width / 2 || this.myDropRectangle.x + (data2.shouldSwapCoordinates ? this.myDropRectangle.height : this.myDropRectangle.width) < eachSize.width / 2) {
                        data2.dragInsertPosition = insertOrder;
                        data2.dragToSide = sidesStarted;
                        this.layoutDragButton(data2);
                        data2.dragTargetChosen = true;
                    }
                } else {
                    distance2 = this.myDropRectangle.y - data2.eachY;
                    if (distance2 < eachSize.height / 2 || this.myDropRectangle.y + (data2.shouldSwapCoordinates ? this.myDropRectangle.width : this.myDropRectangle.height) < eachSize.height / 2) {
                        data2.dragInsertPosition = insertOrder;
                        data2.dragToSide = sidesStarted;
                        this.layoutDragButton(data2);
                        data2.dragTargetChosen = true;
                    }
                }
            }
            Stripe.layoutButton(data2, button5, setBounds);
        }
        if (!sidesStarted && processDrop) {
            this.tryDroppingOnGap(data2, gap, -1);
        }
        if (this.isDroppingButton()) {
            Dimension dragSize = this.myDragButton.getPreferredSize();
            if (data2.shouldSwapCoordinates) {
                Stripe.swap(dragSize);
            }
            data2.size.width = Math.max(data2.size.width, dragSize.width);
            data2.size.height = Math.max(data2.size.height, dragSize.height);
        }
        if (processDrop && !data2.dragTargetChosen) {
            data2.dragInsertPosition = -1;
            data2.dragToSide = true;
            this.layoutDragButton(data2);
            data2.dragTargetChosen = true;
        }
        return data2;
    }

    private void tryDroppingOnGap(LayoutData data2, int gap, int insertOrder) {
        int sideDistance;
        int nonSideDistance;
        if (data2.dragTargetChosen) {
            return;
        }
        if (data2.horizontal) {
            nonSideDistance = this.myDropRectangle.x - data2.eachX;
            sideDistance = data2.eachX + gap - this.myDropRectangle.x;
        } else {
            nonSideDistance = this.myDropRectangle.y - data2.eachY;
            sideDistance = data2.eachY + gap - this.myDropRectangle.y;
        }
        nonSideDistance = Math.max(0, nonSideDistance);
        if (sideDistance > 0) {
            if (nonSideDistance > sideDistance) {
                data2.dragInsertPosition = insertOrder;
                data2.dragToSide = true;
            } else {
                data2.dragInsertPosition = -1;
                data2.dragToSide = false;
            }
            data2.dragTargetChosen = true;
            this.layoutDragButton(data2, gap);
        }
    }

    private void layoutDragButton(LayoutData data2) {
        this.layoutDragButton(data2, 0);
    }

    private void layoutDragButton(LayoutData data2, int gap) {
        this.myDrawRectangle.x = data2.eachX;
        this.myDrawRectangle.y = data2.eachY;
        Stripe.layoutButton(data2, this.myDragButtonImage, false);
        if (data2.horizontal) {
            this.myDrawRectangle.width = data2.eachX - this.myDrawRectangle.x;
            this.myDrawRectangle.height = data2.fitSize.height;
            if (data2.dragToSide) {
                this.myDrawRectangle.x = data2.dragInsertPosition == -1 ? this.getWidth() - this.getHeight() - this.myDrawRectangle.width : (this.myDrawRectangle.x += gap);
            }
        } else {
            this.myDrawRectangle.width = data2.fitSize.width;
            this.myDrawRectangle.height = data2.eachY - this.myDrawRectangle.y;
            if (data2.dragToSide) {
                this.myDrawRectangle.y = data2.dragInsertPosition == -1 ? this.getHeight() - this.myDrawRectangle.height : (this.myDrawRectangle.y += gap);
            }
        }
    }

    @NotNull
    private List<StripeButton> getButtonsToLayOut() {
        ArrayList<StripeButton> result2 = new ArrayList<StripeButton>();
        ArrayList<StripeButton> tools = new ArrayList<StripeButton>();
        ArrayList<StripeButton> sideTools = new ArrayList<StripeButton>();
        for (StripeButton button4 : this.buttons) {
            if (!button4.isVisible()) continue;
            if (button4.getWindowInfo().isSplit()) {
                sideTools.add(button4);
                continue;
            }
            tools.add(button4);
        }
        result2.addAll(tools);
        result2.addAll(sideTools);
        ArrayList<StripeButton> arrayList = result2;
        if (arrayList == null) {
            Stripe.$$$reportNull$$$0(4);
        }
        return arrayList;
    }

    @NotNull
    public ToolWindowAnchor getAnchor() {
        ToolWindowAnchor toolWindowAnchor = ToolWindowAnchor.get((int)this.anchor);
        if (toolWindowAnchor == null) {
            Stripe.$$$reportNull$$$0(5);
        }
        return toolWindowAnchor;
    }

    private static void layoutButton(@NotNull LayoutData data2, @NotNull JComponent button4, boolean setBounds) {
        if (data2 == null) {
            Stripe.$$$reportNull$$$0(6);
        }
        if (button4 == null) {
            Stripe.$$$reportNull$$$0(7);
        }
        Dimension eachSize = button4.getPreferredSize();
        if (data2.shouldSwapCoordinates && !(button4 instanceof StripeButton)) {
            Stripe.swap(eachSize);
        }
        if (setBounds) {
            int width = data2.horizontal ? eachSize.width : data2.fitSize.width;
            int height = data2.horizontal ? data2.fitSize.height : eachSize.height;
            button4.setBounds(data2.eachX, data2.eachY, width, height);
        }
        if (data2.horizontal) {
            int deltaX = eachSize.width;
            data2.eachX += deltaX;
            data2.size.width += deltaX;
            data2.size.height = Math.max(data2.size.height, eachSize.height);
        } else {
            int deltaY = eachSize.height;
            data2.eachY += deltaY;
            data2.size.width = Math.max(data2.size.width, eachSize.width);
            data2.size.height += deltaY;
        }
    }

    private static void swap(Dimension d) {
        int tmp = d.width;
        d.width = d.height;
        d.height = tmp;
    }

    public void startDrag() {
        this.revalidate();
        this.repaint();
    }

    public void stopDrag() {
        this.revalidate();
        this.repaint();
    }

    @Nullable
    public StripeButton getButtonFor(@NotNull String toolWindowId) {
        if (toolWindowId == null) {
            Stripe.$$$reportNull$$$0(8);
        }
        for (StripeButton button4 : this.buttons) {
            if (!button4.getId().equals(toolWindowId)) continue;
            return button4;
        }
        return null;
    }

    public void setOverlayed(boolean overlayed) {
        if (Registry.is((String)"disable.toolwindow.overlay")) {
            return;
        }
        Color bg = UIUtil.getPanelBackground();
        if (overlayed) {
            this.setBackground(ColorUtil.toAlpha((Color)bg, (int)190));
        } else {
            this.setBackground(bg);
        }
    }

    private boolean isHorizontal() {
        return this.anchor == 1 || this.anchor == 3;
    }

    @Override
    public Dimension getPreferredSize() {
        if (this.preferredSize == null) {
            this.preferredSize = this.buttons.isEmpty() ? EMPTY_SIZE : this.recomputeBounds((boolean)false, null, (boolean)false).size;
        }
        return this.preferredSize;
    }

    void updatePresentation() {
        for (StripeButton button4 : this.buttons) {
            button4.updatePresentation();
        }
    }

    boolean containsPoint(@NotNull Point screenPoint) {
        Rectangle bounds2;
        if (screenPoint == null) {
            Stripe.$$$reportNull$$$0(9);
        }
        Point point = screenPoint.getLocation();
        SwingUtilities.convertPointFromScreen(point, this.isVisible() ? this : this.getParent());
        int width = this.getWidth();
        int height = this.getHeight();
        if (!this.isVisible() && (bounds2 = (Rectangle)UIUtil.getClientProperty((Object)this, VIRTUAL_BOUNDS)) != null) {
            point.x -= bounds2.x;
            point.y -= bounds2.y;
            width = bounds2.width;
            height = bounds2.height;
        }
        int areaSize = Math.min(Math.min(this.getParent().getWidth() / 2, this.getParent().getHeight() / 2), JBUI.scale((int)200));
        Point[] points = new Point[]{new Point(0, 0), new Point(width, 0), new Point(width, height), new Point(0, height)};
        switch (this.anchor) {
            case 1: {
                Stripe.updateLocation(points, 1, 2, 0, 0, areaSize);
                Stripe.updateLocation(points, 0, 3, 0, 0, areaSize);
                break;
            }
            case 2: {
                Stripe.updateLocation(points, 0, 1, 1, 0, areaSize);
                Stripe.updateLocation(points, 3, 2, 1, -1, areaSize);
                break;
            }
            case 3: {
                Stripe.updateLocation(points, 3, 0, 1, -1, areaSize);
                Stripe.updateLocation(points, 2, 1, -1, -1, areaSize);
                break;
            }
            case 4: {
                Stripe.updateLocation(points, 1, 0, -1, 0, areaSize);
                Stripe.updateLocation(points, 2, 3, -1, 1, areaSize);
            }
        }
        return new Polygon(new int[]{points[0].x, points[1].x, points[2].x, points[3].x}, new int[]{points[0].y, points[1].y, points[2].y, points[3].y}, 4).contains(point);
    }

    private static void updateLocation(Point[] points, int indexBase, int indexDest, int xSign, int ySign, int areaSize) {
        points[indexDest].setLocation(points[indexBase].x + xSign * areaSize, points[indexBase].y + ySign * areaSize);
    }

    public void finishDrop(@NotNull ToolWindowManagerImpl manager2) {
        if (manager2 == null) {
            Stripe.$$$reportNull$$$0(10);
        }
        if (this.myLastLayoutData == null || !this.isDroppingButton()) {
            return;
        }
        String id2 = this.myDragButton.toolWindow.getId();
        this.myFinishingDrop = true;
        manager2.setSideToolAndAnchor(id2, ToolWindowAnchor.get((int)this.anchor), this.myLastLayoutData.dragInsertPosition, this.myLastLayoutData.dragToSide);
        manager2.invokeLater(this::resetDrop);
    }

    public void resetDrop() {
        this.myDragButton = null;
        this.myDragButtonImage = null;
        this.myFinishingDrop = false;
        this.preferredSize = null;
        this.revalidate();
        this.repaint();
    }

    void processDropButton(@NotNull StripeButton button4, @NotNull JComponent buttonImage, Point screenPoint) {
        if (button4 == null) {
            Stripe.$$$reportNull$$$0(11);
        }
        if (buttonImage == null) {
            Stripe.$$$reportNull$$$0(12);
        }
        if (!this.isDroppingButton()) {
            BufferedImage image = button4.createDragImage();
            buttonImage.paint(image.getGraphics());
            this.myDragButton = button4;
            this.myDragButtonImage = buttonImage;
            this.preferredSize = null;
        }
        Point point = new Point(screenPoint);
        SwingUtilities.convertPointFromScreen(point, this);
        this.myDropRectangle = new Rectangle(point, buttonImage.getSize());
        this.revalidate();
        this.repaint();
    }

    @Nullable
    Boolean getDropToSide() {
        if (this.myLastLayoutData == null || !this.myLastLayoutData.dragTargetChosen) {
            return null;
        }
        return this.myLastLayoutData.dragToSide;
    }

    private boolean isDroppingButton() {
        return this.myDragButton != null;
    }

    @Override
    public String toString() {
        @NonNls String anchor2 = null;
        switch (this.anchor) {
            case 1: {
                anchor2 = "TOP";
                break;
            }
            case 3: {
                anchor2 = "BOTTOM";
                break;
            }
            case 2: {
                anchor2 = "LEFT";
                break;
            }
            case 4: {
                anchor2 = "RIGHT";
            }
        }
        return this.getClass().getName() + " " + anchor2;
    }

    @Override
    protected Graphics getComponentGraphics(Graphics g) {
        return JBSwingUtilities.runGlobalCGTransform((JComponent)this, (Graphics)super.getComponentGraphics(g));
    }

    @Override
    protected void paintComponent(@NotNull Graphics g) {
        if (g == null) {
            Stripe.$$$reportNull$$$0(13);
        }
        super.paintComponent(g);
        if (!this.myFinishingDrop && this.isDroppingButton()) {
            g.setColor(this.getBackground().brighter());
            g.fillRect(0, 0, this.getWidth(), this.getHeight());
            if (this.myDrawRectangle != null) {
                g.setColor(JBUI.CurrentTheme.DragAndDrop.Area.BACKGROUND);
                RectanglePainter.FILL.paint((Graphics2D)g, this.myDrawRectangle.x, this.myDrawRectangle.y, this.myDrawRectangle.width, this.myDrawRectangle.height, null);
            }
        }
        if (StartupUiUtil.isUnderDarcula()) {
            return;
        }
        ToolWindowAnchor anchor2 = this.getAnchor();
        g.setColor(new Color(255, 255, 255, 40));
        Rectangle r = this.getBounds();
        if (anchor2 == ToolWindowAnchor.LEFT || anchor2 == ToolWindowAnchor.RIGHT) {
            LinePainter2D.paint((Graphics2D)((Graphics2D)g), (double)0.0, (double)0.0, (double)0.0, (double)r.height);
            LinePainter2D.paint((Graphics2D)((Graphics2D)g), (double)(r.width - 2), (double)0.0, (double)(r.width - 2), (double)r.height);
        } else {
            LinePainter2D.paint((Graphics2D)((Graphics2D)g), (double)0.0, (double)1.0, (double)r.width, (double)1.0);
            LinePainter2D.paint((Graphics2D)((Graphics2D)g), (double)0.0, (double)(r.height - 1), (double)r.width, (double)(r.height - 1));
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "uiSettings";
                break;
            }
            case 1: 
            case 3: 
            case 7: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "button";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "comparator";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/wm/impl/Stripe";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toolWindowId";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "screenPoint";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buttonImage";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "g";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/wm/impl/Stripe";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getButtonsToLayOut";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getAnchor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "uiSettingsChanged";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "addButton";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "removeButton";
                break;
            }
            case 4: 
            case 5: {
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "layoutButton";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getButtonFor";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "containsPoint";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "finishDrop";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "processDropButton";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "paintComponent";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static final class LayoutData {
        int eachX;
        int eachY;
        Dimension size;
        Dimension fitSize;
        boolean horizontal;
        boolean dragTargetChosen;
        boolean dragToSide;
        boolean shouldSwapCoordinates;
        int dragInsertPosition;

        private LayoutData() {
        }
    }

    private static final class AdaptiveBorder
    implements Border {
        private AdaptiveBorder() {
        }

        @Override
        public void paintBorder(@NotNull Component c, Graphics g, int x, int y, int width, int height) {
            if (c == null) {
                AdaptiveBorder.$$$reportNull$$$0(0);
            }
            Insets insets = ((JComponent)c).getInsets();
            g.setColor(UIUtil.CONTRAST_BORDER_COLOR);
            AdaptiveBorder.drawBorder((Graphics2D)g, x, y, width, height, insets);
        }

        private static void drawBorder(Graphics2D g, int x, int y, int width, int height, Insets insets) {
            if (insets.top == 1) {
                LinePainter2D.paint((Graphics2D)g, (double)x, (double)y, (double)(x + width), (double)y);
            }
            if (insets.right == 1) {
                LinePainter2D.paint((Graphics2D)g, (double)(x + width - 1), (double)y, (double)(x + width - 1), (double)(y + height));
            }
            if (insets.left == 1) {
                LinePainter2D.paint((Graphics2D)g, (double)x, (double)y, (double)x, (double)(y + height));
            }
            if (insets.bottom == 1) {
                LinePainter2D.paint((Graphics2D)g, (double)x, (double)(y + height - 1), (double)(x + width), (double)(y + height - 1));
            }
            if (!StartupUiUtil.isUnderDarcula()) {
                return;
            }
            Color c = g.getColor();
            if (insets.top == 2) {
                g.setColor(c);
                LinePainter2D.paint((Graphics2D)g, (double)x, (double)y, (double)(x + width), (double)y);
                g.setColor((Color)Gray._85);
                LinePainter2D.paint((Graphics2D)g, (double)x, (double)(y + 1), (double)(x + width), (double)(y + 1));
            }
            if (insets.right == 2) {
                g.setColor((Color)Gray._85);
                LinePainter2D.paint((Graphics2D)g, (double)(x + width - 1), (double)y, (double)(x + width - 1), (double)(y + height));
                g.setColor(c);
                LinePainter2D.paint((Graphics2D)g, (double)(x + width - 2), (double)y, (double)(x + width - 2), (double)(y + height));
            }
            if (insets.left == 2) {
                g.setColor((Color)Gray._85);
                LinePainter2D.paint((Graphics2D)g, (double)(x + 1), (double)y, (double)(x + 1), (double)(y + height));
                g.setColor(c);
                LinePainter2D.paint((Graphics2D)g, (double)x, (double)y, (double)x, (double)(y + height));
            }
        }

        @Override
        public Insets getBorderInsets(@NotNull Component c) {
            Stripe stripe;
            ToolWindowAnchor anchor2;
            if (c == null) {
                AdaptiveBorder.$$$reportNull$$$0(1);
            }
            if ((anchor2 = (stripe = (Stripe)c).getAnchor()) == ToolWindowAnchor.LEFT) {
                return new Insets(1, 0, 0, 1);
            }
            if (anchor2 == ToolWindowAnchor.RIGHT) {
                return new Insets(1, 1, 0, 0);
            }
            if (anchor2 == ToolWindowAnchor.TOP) {
                return new Insets(1, 0, 0, 0);
            }
            return new Insets(1, 0, 0, 0);
        }

        @Override
        public boolean isBorderOpaque() {
            return true;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "c";
            objectArray2[1] = "com/intellij/openapi/wm/impl/Stripe$AdaptiveBorder";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "paintBorder";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getBorderInsets";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

