/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.wm.impl;

import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.SystemInfoRt;
import com.intellij.ui.mac.MacDockDelegate;
import com.intellij.ui.win.WinDockDelegate;
import org.jetbrains.annotations.Nullable;

public final class SystemDock {
    @Nullable
    private static final Delegate impl;

    public static synchronized void updateMenu() {
        try {
            if (impl != null) {
                impl.updateRecentProjectsMenu();
            }
        }
        catch (Throwable err) {
            Logger.getInstance(SystemDock.class).error(err);
        }
    }

    static {
        Delegate delegate2 = null;
        Application app2 = ApplicationManager.getApplication();
        if (app2 != null && !app2.isUnitTestMode()) {
            if (SystemInfoRt.isMac) {
                delegate2 = MacDockDelegate.getInstance();
            } else if (SystemInfoRt.isWindows) {
                delegate2 = WinDockDelegate.getInstance();
            }
        }
        impl = delegate2;
    }

    public static interface Delegate {
        public void updateRecentProjectsMenu();
    }
}

