/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.wm.impl.content;

import com.intellij.CommonBundle;
import com.intellij.icons.AllIcons;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.actions.PinActiveTabAction;
import com.intellij.ide.impl.DataManagerImpl;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionPopupMenu;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.actionSystem.ex.CustomComponentAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.ui.JBPopupMenu;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopupStep;
import com.intellij.openapi.ui.popup.PopupStep;
import com.intellij.openapi.ui.popup.util.BaseListPopupStep;
import com.intellij.openapi.util.BusyObject;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ex.ToolWindowEx;
import com.intellij.openapi.wm.impl.InternalDecoratorImpl;
import com.intellij.openapi.wm.impl.ToolWindowImpl;
import com.intellij.openapi.wm.impl.content.BaseLabel;
import com.intellij.openapi.wm.impl.content.ContentLabel;
import com.intellij.openapi.wm.impl.content.ContentTabLabel;
import com.intellij.openapi.wm.impl.content.SingleContentLayout;
import com.intellij.openapi.wm.impl.content.SingleContentSupplier;
import com.intellij.openapi.wm.impl.content.TabContentLayout;
import com.intellij.openapi.wm.impl.content.ToolWindowContentUi;
import com.intellij.ui.MouseDragHelper;
import com.intellij.ui.PopupHandler;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.components.panels.HorizontalLayout;
import com.intellij.ui.components.panels.NonOpaquePanel;
import com.intellij.ui.content.AlertIcon;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentManager;
import com.intellij.ui.content.impl.ContentManagerImpl;
import com.intellij.ui.tabs.JBTabPainter;
import com.intellij.ui.tabs.JBTabs;
import com.intellij.ui.tabs.JBTabsEx;
import com.intellij.ui.tabs.JBTabsPosition;
import com.intellij.ui.tabs.TabInfo;
import com.intellij.ui.tabs.TabsListener;
import com.intellij.ui.tabs.impl.JBTabsImpl;
import com.intellij.ui.tabs.impl.MorePopupAware;
import com.intellij.ui.tabs.impl.TabLabel;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.AbstractLayoutManager;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u000b\b\u0000\u0018\u00002\u00020\u0001:\b-./01234B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001c\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00102\n\b\u0002\u0010\u0012\u001a\u0004\u0018\u00010\u0010H\u0003J$\u0010\u0013\u001a\u00020\f2\u0006\u0010\u0014\u001a\u00020\u00102\u0006\u0010\u0015\u001a\u00020\u00162\n\b\u0002\u0010\u0017\u001a\u0004\u0018\u00010\u000eH\u0002J\n\u0010\u0018\u001a\u0004\u0018\u00010\u0019H\u0002J\n\u0010\u001a\u001a\u0004\u0018\u00010\u001bH\u0002J\u0018\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001b2\u0006\u0010\u001f\u001a\u00020 H\u0002J\b\u0010!\u001a\u00020\"H\u0014J\b\u0010#\u001a\u00020\u001dH\u0016J\b\u0010$\u001a\u00020\u001dH\u0016J\b\u0010%\u001a\u00020\u001dH\u0002J\b\u0010&\u001a\u00020\u001dH\u0002J\b\u0010'\u001a\u00020\u001dH\u0016J\u0010\u0010(\u001a\u00020\u001d2\u0006\u0010)\u001a\u00020*H\u0014J\u0018\u0010+\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001b2\u0006\u0010\u001f\u001a\u00020 H\u0002J\u000e\u0010,\u001a\u0004\u0018\u00010 *\u00020\u001bH\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0018\u00010\bR\u00020\u0000X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00065"}, d2={"Lcom/intellij/openapi/wm/impl/content/SingleContentLayout;", "Lcom/intellij/openapi/wm/impl/content/TabContentLayout;", "ui", "Lcom/intellij/openapi/wm/impl/content/ToolWindowContentUi;", "(Lcom/intellij/openapi/wm/impl/content/ToolWindowContentUi;)V", "isSingleContentView", "", "tabAdapter", "Lcom/intellij/openapi/wm/impl/content/SingleContentLayout$TabAdapter;", "toolbars", "", "Lcom/intellij/openapi/wm/impl/content/SingleContentLayout$ToolbarType;", "Lcom/intellij/openapi/actionSystem/ActionToolbar;", "wrapper", "Ljavax/swing/JComponent;", "createProcessName", "", "title", "prefix", "createToolbar", "place", "group", "Lcom/intellij/openapi/actionSystem/ActionGroup;", "target", "findTopLevelContentManager", "Lcom/intellij/ui/content/impl/ContentManagerImpl;", "getSingleContentOrNull", "Lcom/intellij/ui/content/Content;", "initSingleContentView", "", "content", "supplier", "Lcom/intellij/openapi/wm/impl/content/SingleContentSupplier;", "isToDrawTabs", "Lcom/intellij/openapi/wm/impl/content/TabContentLayout$TabsDrawMode;", "layout", "rebuild", "resetSingleContentView", "tryUpdateContentView", "update", "updateIdLabel", "label", "Lcom/intellij/openapi/wm/impl/content/BaseLabel;", "updateSingleContentView", "getSupplier", "CloseCurrentContentAction", "ExtendedTitleActionsGroup", "FakeContent", "HorizontalTabLayoutWithHiddenControl", "MyInvisibleAction", "MyRedispatchMouseEventListener", "TabAdapter", "ToolbarType", "intellij.platform.ide.impl"})
public final class SingleContentLayout
extends TabContentLayout {
    private boolean isSingleContentView;
    private TabAdapter tabAdapter;
    private final Map<ToolbarType, ActionToolbar> toolbars;
    private JComponent wrapper;

    @Override
    public void update() {
        super.update();
        this.tryUpdateContentView();
    }

    @Override
    public void rebuild() {
        super.rebuild();
        this.tryUpdateContentView();
    }

    private final SingleContentSupplier getSupplier(Content $this$getSupplier) {
        SingleContentSupplier singleContentSupplier;
        JComponent jComponent = $this$getSupplier.getComponent();
        if (!(jComponent instanceof DataProvider)) {
            jComponent = null;
        }
        DataProvider dataProvider = (DataProvider)((Object)jComponent);
        if (dataProvider != null) {
            DataProvider dataProvider2 = dataProvider;
            DataKey<SingleContentSupplier> dataKey = SingleContentSupplier.KEY;
            boolean bl = false;
            boolean bl2 = false;
            DataProvider p1 = dataProvider2;
            boolean bl3 = false;
            singleContentSupplier = dataKey.getData(p1);
        } else {
            singleContentSupplier = null;
        }
        return singleContentSupplier;
    }

    private final Content getSingleContentOrNull() {
        Object object = this.findTopLevelContentManager();
        return object != null && (object = ((ContentManagerImpl)object).getContentsRecursively()) != null ? (Content)CollectionsKt.singleOrNull((List)object) : null;
    }

    private final ContentManagerImpl findTopLevelContentManager() {
        ToolWindowContentUi toolWindowContentUi = this.myUi;
        Intrinsics.checkNotNullExpressionValue((Object)toolWindowContentUi, (String)"myUi");
        InternalDecoratorImpl internalDecoratorImpl = InternalDecoratorImpl.findTopLevelDecorator(toolWindowContentUi.getComponent());
        Object object = internalDecoratorImpl != null ? internalDecoratorImpl.getContentManager() : null;
        if (!(object instanceof ContentManagerImpl)) {
            object = null;
        }
        return (ContentManagerImpl)object;
    }

    private final void tryUpdateContentView() {
        ToolWindowEx toolwindow;
        SingleContentSupplier contentSupplier;
        Content currentContent;
        Content content2 = currentContent = this.getSingleContentOrNull();
        SingleContentSupplier singleContentSupplier = contentSupplier = content2 != null ? this.getSupplier(content2) : null;
        if (contentSupplier != null) {
            if (this.isSingleContentView) {
                this.updateSingleContentView(currentContent, contentSupplier);
            } else {
                this.initSingleContentView(currentContent, contentSupplier);
            }
        } else if (this.isSingleContentView) {
            this.resetSingleContentView();
        }
        ToolWindow $this$castSafelyTo$iv = this.myUi.getWindow();
        boolean $i$f$castSafelyTo = false;
        ToolWindow toolWindow2 = $this$castSafelyTo$iv;
        if (!(toolWindow2 instanceof ToolWindowEx)) {
            toolWindow2 = null;
        }
        if ((toolwindow = (ToolWindowEx)toolWindow2) != null) {
            ActionGroup group2;
            ToolWindowEx.ToolWindowDecoration toolWindowDecoration = toolwindow.getDecoration();
            Object object = group2 = toolWindowDecoration != null ? toolWindowDecoration.getActionGroup() : null;
            if (this.isSingleContentView) {
                if (!(group2 instanceof ExtendedTitleActionsGroup)) {
                    AnAction[] anActionArray = new AnAction[2];
                    anActionArray[0] = (AnAction)new PinActiveTabAction();
                    Separator separator2 = Separator.create();
                    Intrinsics.checkNotNullExpressionValue((Object)separator2, (String)"Separator.create()");
                    anActionArray[1] = (AnAction)separator2;
                    toolwindow.setAdditionalGearActions((ActionGroup)new ExtendedTitleActionsGroup(group2, anActionArray));
                }
            } else if (group2 instanceof ExtendedTitleActionsGroup) {
                toolwindow.setAdditionalGearActions(((ExtendedTitleActionsGroup)group2).getOriginActions());
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void initSingleContentView(Content content2, SingleContentSupplier supplier2) {
        void $this$apply;
        SingleContentLayout it222;
        JBTabs jBTabs = supplier2.getTabs();
        JBTabPainter jBTabPainter = this.tabPainter;
        Intrinsics.checkNotNullExpressionValue((Object)jBTabPainter, (String)"tabPainter");
        ToolWindowContentUi toolWindowContentUi = this.myUi;
        Intrinsics.checkNotNullExpressionValue((Object)toolWindowContentUi, (String)"myUi");
        TabAdapter tabAdapter = new TabAdapter(content2, jBTabs, jBTabPainter, toolWindowContentUi);
        boolean bl = false;
        boolean bl2 = false;
        TabAdapter tabAdapter2 = tabAdapter;
        SingleContentLayout singleContentLayout = this;
        boolean bl3 = false;
        Disposer.register((Disposable)((Disposable)content2), (Disposable)((Disposable)it222));
        ToolWindowContentUi toolWindowContentUi2 = this.myUi;
        Intrinsics.checkNotNullExpressionValue((Object)toolWindowContentUi2, (String)"myUi");
        toolWindowContentUi2.getTabComponent().add((Component)((Object)it222));
        Unit unit = Unit.INSTANCE;
        singleContentLayout.tabAdapter = tabAdapter;
        boolean bl4 = this.toolbars.isEmpty();
        bl = false;
        bl2 = false;
        if (_Assertions.ENABLED && !bl4) {
            boolean it222 = false;
            String it222 = "Assertion failed";
            throw (Throwable)((Object)new AssertionError((Object)it222));
        }
        ActionGroup actionGroup2 = supplier2.getToolbarActions();
        if (actionGroup2 != null) {
            ActionGroup actionGroup3 = actionGroup2;
            bl = false;
            bl2 = false;
            ActionGroup mainActionGroup = actionGroup3;
            boolean bl5 = false;
            this.toolbars.put(ToolbarType.MAIN, this.createToolbar(supplier2.getMainToolbarPlace(), mainActionGroup, content2.getComponent()));
        }
        SingleContentLayout singleContentLayout2 = this;
        bl = false;
        bl2 = false;
        it222 = singleContentLayout2;
        boolean $i$a$-let-SingleContentLayout$initSingleContentView$42 = false;
        DefaultActionGroup contentActions = new DefaultActionGroup();
        contentActions.add((AnAction)new CloseCurrentContentAction());
        contentActions.add((AnAction)Separator.create());
        contentActions.addAll((Collection)supplier2.getContentActions());
        contentActions.add((AnAction)new MyInvisibleAction());
        ActionToolbar actionToolbar = this.createToolbar(supplier2.getContentToolbarPlace(), (ActionGroup)contentActions, content2.getComponent());
        boolean bl6 = false;
        boolean bl7 = false;
        ActionToolbar actionToolbar2 = actionToolbar;
        ToolbarType toolbarType = ToolbarType.CLOSE_GROUP;
        Map<ToolbarType, ActionToolbar> map2 = this.toolbars;
        boolean bl8 = false;
        $this$apply.setReservePlaceAutoPopupIcon(false);
        $this$apply.setLayoutPolicy(0);
        Unit unit2 = Unit.INSTANCE;
        map2.put(toolbarType, actionToolbar);
        Map<ToolbarType, ActionToolbar> $this$forEach$iv = this.toolbars;
        boolean $i$f$forEach = false;
        Map<ToolbarType, ActionToolbar> map3 = $this$forEach$iv;
        boolean it32 = false;
        Iterator<Map.Entry<ToolbarType, ActionToolbar>> $i$a$-let-SingleContentLayout$initSingleContentView$42 = map3.entrySet().iterator();
        while ($i$a$-let-SingleContentLayout$initSingleContentView$42.hasNext()) {
            Map.Entry<ToolbarType, ActionToolbar> element$iv;
            Map.Entry<ToolbarType, ActionToolbar> $dstr$_u24__u24$toolbar = element$iv = $i$a$-let-SingleContentLayout$initSingleContentView$42.next();
            boolean bl9 = false;
            Map.Entry<ToolbarType, ActionToolbar> entry2 = $dstr$_u24__u24$toolbar;
            boolean bl10 = false;
            ActionToolbar toolbar = entry2.getValue();
            ToolWindowContentUi toolWindowContentUi3 = this.myUi;
            Intrinsics.checkNotNullExpressionValue((Object)toolWindowContentUi3, (String)"myUi");
            toolWindowContentUi3.getTabComponent().add(toolbar.getComponent());
        }
        singleContentLayout2 = new NonOpaquePanel((LayoutManager)new HorizontalLayout(0));
        bl = false;
        boolean bl11 = false;
        SingleContentLayout it32 = singleContentLayout2;
        singleContentLayout = this;
        boolean bl12 = false;
        new MyRedispatchMouseEventListener((Function1<? super MouseEvent, Unit>)((Function1)new Function1<MouseEvent, Unit>(this){
            final /* synthetic */ SingleContentLayout this$0;
            {
                this.this$0 = singleContentLayout;
                super(1);
            }

            public final void invoke(@NotNull MouseEvent e) {
                block1: {
                    Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                    if (!SwingUtilities.isLeftMouseButton(e)) break block1;
                    ToolWindowContentUi toolWindowContentUi = this.this$0.myUi;
                    Intrinsics.checkNotNullExpressionValue((Object)toolWindowContentUi, (String)"myUi");
                    JPanel jPanel2 = toolWindowContentUi.getTabComponent();
                    Intrinsics.checkNotNullExpressionValue((Object)jPanel2, (String)"myUi.tabComponent");
                    Container container = jPanel2.getParent();
                    if (container != null) {
                        Container container2 = container;
                        boolean bl = false;
                        boolean bl2 = false;
                        Container westPanel = container2;
                        boolean bl3 = false;
                        westPanel.dispatchEvent(SwingUtilities.convertMouseEvent(e.getComponent(), e, westPanel));
                    }
                }
            }
        })).installOn((Component)((Object)it32));
        MouseDragHelper.setComponentDraggable((JComponent)((JComponent)((Object)it32)), (boolean)true);
        ToolWindowContentUi.initMouseListeners((JComponent)((Object)it32), this.myUi, true);
        ToolWindowContentUi toolWindowContentUi4 = this.myUi;
        Intrinsics.checkNotNullExpressionValue((Object)toolWindowContentUi4, (String)"myUi");
        toolWindowContentUi4.getTabComponent().add((Component)((Object)it32));
        unit = Unit.INSTANCE;
        singleContentLayout.wrapper = (JComponent)((Object)singleContentLayout2);
        this.isSingleContentView = true;
        supplier2.init(this.toolbars.get((Object)ToolbarType.MAIN), this.toolbars.get((Object)ToolbarType.CLOSE_GROUP));
        supplier2.customize(this.wrapper);
    }

    private final void updateSingleContentView(Content content2, SingleContentSupplier supplier2) {
        TabAdapter tabAdapter = this.tabAdapter;
        if (Intrinsics.areEqual((Object)(tabAdapter != null ? tabAdapter.getJbTabs() : null), (Object)supplier2.getTabs()) ^ true) {
            this.resetSingleContentView();
            this.initSingleContentView(content2, supplier2);
        } else {
            Map<ToolbarType, ActionToolbar> $this$forEach$iv = this.toolbars;
            boolean $i$f$forEach = false;
            Map<ToolbarType, ActionToolbar> map2 = $this$forEach$iv;
            boolean bl = false;
            Iterator<Map.Entry<ToolbarType, ActionToolbar>> iterator2 = map2.entrySet().iterator();
            while (iterator2.hasNext()) {
                Map.Entry<ToolbarType, ActionToolbar> element$iv;
                Map.Entry<ToolbarType, ActionToolbar> $dstr$_u24__u24$toolbar = element$iv = iterator2.next();
                boolean bl2 = false;
                Map.Entry<ToolbarType, ActionToolbar> entry2 = $dstr$_u24__u24$toolbar;
                boolean bl3 = false;
                ActionToolbar toolbar = entry2.getValue();
                toolbar.updateActionsImmediately();
            }
            supplier2.customize(this.wrapper);
            ToolWindowContentUi toolWindowContentUi = this.myUi;
            Intrinsics.checkNotNullExpressionValue((Object)toolWindowContentUi, (String)"myUi");
            toolWindowContentUi.getTabComponent().repaint();
        }
    }

    private final void resetSingleContentView() {
        block3: {
            TabAdapter tabAdapter = this.tabAdapter;
            if (tabAdapter == null) {
                String string = "Adapter must not be null";
                boolean bl = false;
                throw (Throwable)new IllegalStateException(string.toString());
            }
            TabAdapter adapter = tabAdapter;
            this.tabAdapter = null;
            ToolWindowContentUi toolWindowContentUi = this.myUi;
            Intrinsics.checkNotNullExpressionValue((Object)toolWindowContentUi, (String)"myUi");
            toolWindowContentUi.getTabComponent().remove((Component)((Object)adapter));
            Disposer.dispose((Disposable)adapter);
            Iterable $this$forEach$iv = this.toolbars.values();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                ActionToolbar it = (ActionToolbar)element$iv;
                boolean bl = false;
                ToolWindowContentUi toolWindowContentUi2 = this.myUi;
                Intrinsics.checkNotNullExpressionValue((Object)toolWindowContentUi2, (String)"myUi");
                toolWindowContentUi2.getTabComponent().remove(it.getComponent());
            }
            this.toolbars.clear();
            ToolWindowContentUi toolWindowContentUi3 = this.myUi;
            Intrinsics.checkNotNullExpressionValue((Object)toolWindowContentUi3, (String)"myUi");
            JComponent jComponent = this.wrapper;
            if (jComponent == null) {
                String string = "Wrapper must not be null";
                boolean bl = false;
                throw (Throwable)new IllegalStateException(string.toString());
            }
            toolWindowContentUi3.getTabComponent().remove(jComponent);
            this.wrapper = null;
            this.isSingleContentView = false;
            SingleContentSupplier singleContentSupplier = this.getSupplier(adapter.getContent());
            if (singleContentSupplier == null) break block3;
            singleContentSupplier.reset();
        }
    }

    private final ActionToolbar createToolbar(String place, ActionGroup group2, JComponent target2) {
        ActionToolbar actionToolbar = ActionManager.getInstance().createActionToolbar(place, group2, true);
        Intrinsics.checkNotNullExpressionValue((Object)actionToolbar, (String)"ActionManager.getInstanc\u2026olbar(place, group, true)");
        ActionToolbar toolbar = actionToolbar;
        toolbar.setTargetComponent(target2);
        JComponent jComponent = toolbar.getComponent();
        Intrinsics.checkNotNullExpressionValue((Object)jComponent, (String)"toolbar.component");
        jComponent.setOpaque(false);
        return toolbar;
    }

    static /* synthetic */ ActionToolbar createToolbar$default(SingleContentLayout singleContentLayout, String string, ActionGroup actionGroup2, JComponent jComponent, int n, Object object) {
        if ((n & 4) != 0) {
            jComponent = null;
        }
        return singleContentLayout.createToolbar(string, actionGroup2, jComponent);
    }

    @Override
    @NotNull
    protected TabContentLayout.TabsDrawMode isToDrawTabs() {
        TabContentLayout.TabsDrawMode tabsDrawMode;
        if (this.isSingleContentView) {
            tabsDrawMode = TabContentLayout.TabsDrawMode.HIDE;
        } else {
            TabContentLayout.TabsDrawMode tabsDrawMode2 = super.isToDrawTabs();
            tabsDrawMode = tabsDrawMode2;
            Intrinsics.checkNotNullExpressionValue((Object)((Object)tabsDrawMode2), (String)"super.isToDrawTabs()");
        }
        return tabsDrawMode;
    }

    @Override
    public void layout() {
        block5: {
            Object object;
            Object object2;
            Object $this$apply;
            boolean bl;
            super.layout();
            if (!this.isSingleContentView) break block5;
            ToolWindowContentUi toolWindowContentUi = this.myUi;
            Intrinsics.checkNotNullExpressionValue((Object)toolWindowContentUi, (String)"myUi");
            JPanel jPanel2 = toolWindowContentUi.getTabComponent();
            Intrinsics.checkNotNullExpressionValue((Object)jPanel2, (String)"myUi.tabComponent");
            JPanel component2 = jPanel2;
            Rectangle rectangle = component2.getBounds();
            boolean bl2 = false;
            boolean bl3 = false;
            Rectangle rectangle2 = rectangle;
            JPanel jPanel3 = component2;
            boolean bl4 = false;
            Container container = component2.getParent();
            Intrinsics.checkNotNullExpressionValue((Object)container, (String)"component.parent");
            $this$apply.width = container.getWidth();
            Unit unit = Unit.INSTANCE;
            jPanel3.setBounds(rectangle);
            BaseLabel baseLabel = this.myIdLabel;
            Intrinsics.checkNotNullExpressionValue((Object)baseLabel, (String)"myIdLabel");
            int n = baseLabel.getX();
            BaseLabel baseLabel2 = this.myIdLabel;
            Intrinsics.checkNotNullExpressionValue((Object)baseLabel2, (String)"myIdLabel");
            int labelWidth = n + baseLabel2.getPreferredSize().width;
            Object object3 = this.tabAdapter;
            int tabsWidth = object3 != null && (object3 = object3.getPreferredSize()) != null ? ((Dimension)object3).width : 0;
            Object object4 = this.toolbars.get((Object)ToolbarType.MAIN);
            int mainToolbarWidth = object4 != null && (object4 = object4.getComponent()) != null && (object4 = ((JComponent)object4).getPreferredSize()) != null ? ((Dimension)object4).width : 0;
            Object object5 = this.toolbars.get((Object)ToolbarType.CLOSE_GROUP);
            int contentToolbarWidth = object5 != null && (object5 = object5.getComponent()) != null && (object5 = ((JComponent)object5).getPreferredSize()) != null ? ((Dimension)object5).width : 0;
            Object object6 = this.tabAdapter;
            int minTabWidth = object6 != null && (object6 = ((TabAdapter)object6).getMinimumSize()) != null ? ((Dimension)object6).width : 0;
            int fixedWidth = labelWidth + mainToolbarWidth + contentToolbarWidth;
            int freeWidth = component2.getBounds().width - fixedWidth;
            if (freeWidth < minTabWidth) {
                mainToolbarWidth += freeWidth - minTabWidth;
            }
            int n2 = tabsWidth;
            int n3 = 0;
            n2 = Math.min(freeWidth, n2);
            n3 = 0;
            tabsWidth = Math.max(minTabWidth, n2);
            n3 = 0;
            int n4 = freeWidth - tabsWidth;
            boolean bl5 = false;
            int wrapperWidth = Math.max(n3, n4);
            int x = labelWidth;
            TabAdapter tabAdapter = this.tabAdapter;
            if (tabAdapter != null) {
                TabAdapter tabAdapter2 = tabAdapter;
                bl5 = false;
                bl = false;
                $this$apply = tabAdapter2;
                boolean bl6 = false;
                $this$apply.setBounds(new Rectangle(x, 0, tabsWidth, component2.getHeight()));
                x += tabsWidth;
            }
            if ((object2 = this.toolbars.get((Object)ToolbarType.MAIN)) != null && (object2 = object2.getComponent()) != null) {
                Object object7 = object2;
                bl5 = false;
                bl = false;
                $this$apply = object7;
                boolean bl7 = false;
                ((Component)$this$apply).setBounds(new Rectangle(x, 0, mainToolbarWidth, component2.getHeight()));
                x += mainToolbarWidth;
            }
            JComponent jComponent = this.wrapper;
            if (jComponent != null) {
                JComponent jComponent2 = jComponent;
                bl5 = false;
                bl = false;
                $this$apply = jComponent2;
                boolean bl8 = false;
                ((Component)$this$apply).setBounds(new Rectangle(x, 0, wrapperWidth, component2.getHeight()));
                x += wrapperWidth;
            }
            if ((object = this.toolbars.get((Object)ToolbarType.CLOSE_GROUP)) != null && (object = object.getComponent()) != null) {
                Object object8 = object;
                bl5 = false;
                bl = false;
                $this$apply = object8;
                boolean bl9 = false;
                ((Component)$this$apply).setBounds(new Rectangle(x, 0, contentToolbarWidth, component2.getHeight()));
                x += contentToolbarWidth;
            }
        }
    }

    @Override
    protected void updateIdLabel(@NotNull BaseLabel label2) {
        Intrinsics.checkNotNullParameter((Object)label2, (String)"label");
        if (!this.isSingleContentView) {
            label2.setIcon(null);
            label2.setToolTipText(null);
            super.updateIdLabel(label2);
        } else if (this.myTabs.size() == 1) {
            Object e = this.myTabs.get(0);
            Intrinsics.checkNotNullExpressionValue(e, (String)"myTabs[0]");
            Content content2 = ((ContentTabLabel)e).getContent();
            Intrinsics.checkNotNullExpressionValue((Object)content2, (String)"myTabs[0].content");
            label2.setIcon(content2.getIcon());
            Object e2 = this.myTabs.get(0);
            Intrinsics.checkNotNullExpressionValue(e2, (String)"myTabs[0]");
            Content content3 = ((ContentTabLabel)e2).getContent();
            Intrinsics.checkNotNullExpressionValue((Object)content3, (String)"myTabs[0].content");
            String displayName = content3.getDisplayName();
            ToolWindowImpl toolWindowImpl = this.myUi.window;
            Intrinsics.checkNotNullExpressionValue((Object)toolWindowImpl, (String)"myUi.window");
            String string = toolWindowImpl.getStripeTitle();
            String string2 = displayName;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"displayName");
            String string3 = string2;
            String string4 = string;
            label2.setText(this.createProcessName(string3, string4));
            label2.setToolTipText(displayName);
            label2.setBorder((Border)JBUI.Borders.empty((int)0, (int)2, (int)0, (int)7));
        }
    }

    @NlsSafe
    private final String createProcessName(String title2, String prefix) {
        String string;
        block3: {
            block2: {
                string = prefix;
                if (string == null) break block2;
                String string2 = string;
                boolean bl = false;
                boolean bl2 = false;
                String it = string2;
                boolean bl3 = false;
                string = it + ':';
                if (string != null) break block3;
            }
            string = title2;
        }
        return string;
    }

    static /* synthetic */ String createProcessName$default(SingleContentLayout singleContentLayout, String string, String string2, int n, Object object) {
        if ((n & 2) != 0) {
            string2 = null;
        }
        return singleContentLayout.createProcessName(string, string2);
    }

    public SingleContentLayout(@NotNull ToolWindowContentUi ui2) {
        Intrinsics.checkNotNullParameter((Object)ui2, (String)"ui");
        super(ui2);
        boolean bl = false;
        this.toolbars = new LinkedHashMap();
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u00bb\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\b\u0003\n\u0002\b\u0007\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0003*\u0003\u0011\u0014\u001f\b\u0082\u0004\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u00032\u00020\u00042\u00020\u00052\u00020\u0006:\u0001LB%\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\r\u001a\u00020\u000e\u00a2\u0006\u0002\u0010\u000fJ\b\u0010'\u001a\u00020(H\u0016J\b\u0010)\u001a\u00020*H\u0002J\u0016\u0010+\u001a\u00020*2\u0006\u0010,\u001a\u00020-2\u0006\u0010.\u001a\u00020/J\b\u00100\u001a\u00020*H\u0016J\u0012\u00101\u001a\u0004\u0018\u0001022\u0006\u00103\u001a\u000204H\u0016J\b\u00105\u001a\u000206H\u0016J\u0014\u00107\u001a\u0004\u0018\u0001082\b\u00109\u001a\u0004\u0018\u00010\nH\u0002J\u0010\u0010:\u001a\u00020*2\u0006\u0010;\u001a\u00020<H\u0014J\u0010\u0010=\u001a\u00020*2\u0006\u0010>\u001a\u00020?H\u0016J\u0018\u0010@\u001a\u00020-2\u000e\u0010A\u001a\n0\u001cR\u00060\u0000R\u00020\u001dH\u0002J\b\u0010B\u001a\u00020*H\u0016J\u001e\u0010C\u001a\u00020*2\u0006\u0010D\u001a\u00020E2\u0006\u0010F\u001a\u00020G2\u0006\u0010H\u001a\u00020GJ\u001c\u0010I\u001a\u00020*2\u0014\u0010\u001a\u001a\u0010\u0012\f\u0012\n0\u001cR\u00060\u0000R\u00020\u001d0JJ\u0006\u0010K\u001a\u00020*R\u0010\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0012R\u0010\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0015R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u001c\u0010\u001a\u001a\u0010\u0012\f\u0012\n0\u001cR\u00060\u0000R\u00020\u001d0\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001e\u001a\u00020\u001fX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010 R\u000e\u0010!\u001a\u00020\"X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010$R\u0011\u0010\r\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b%\u0010&\u00a8\u0006M"}, d2={"Lcom/intellij/openapi/wm/impl/content/SingleContentLayout$TabAdapter;", "Lcom/intellij/ui/components/panels/NonOpaquePanel;", "Lcom/intellij/ui/tabs/TabsListener;", "Ljava/beans/PropertyChangeListener;", "Lcom/intellij/openapi/actionSystem/DataProvider;", "Lcom/intellij/ui/tabs/impl/MorePopupAware;", "Lcom/intellij/openapi/Disposable;", "content", "Lcom/intellij/ui/content/Content;", "jbTabs", "Lcom/intellij/ui/tabs/JBTabs;", "tabPainter", "Lcom/intellij/ui/tabs/JBTabPainter;", "twcui", "Lcom/intellij/openapi/wm/impl/content/ToolWindowContentUi;", "(Lcom/intellij/openapi/wm/impl/content/SingleContentLayout;Lcom/intellij/ui/content/Content;Lcom/intellij/ui/tabs/JBTabs;Lcom/intellij/ui/tabs/JBTabPainter;Lcom/intellij/openapi/wm/impl/content/ToolWindowContentUi;)V", "closeHandler", "com/intellij/openapi/wm/impl/content/SingleContentLayout$TabAdapter$closeHandler$1", "Lcom/intellij/openapi/wm/impl/content/SingleContentLayout$TabAdapter$closeHandler$1;", "containerListener", "com/intellij/openapi/wm/impl/content/SingleContentLayout$TabAdapter$containerListener$1", "Lcom/intellij/openapi/wm/impl/content/SingleContentLayout$TabAdapter$containerListener$1;", "getContent", "()Lcom/intellij/ui/content/Content;", "getJbTabs", "()Lcom/intellij/ui/tabs/JBTabs;", "labels", "", "Lcom/intellij/openapi/wm/impl/content/SingleContentLayout$TabAdapter$MyContentTabLabel;", "Lcom/intellij/openapi/wm/impl/content/SingleContentLayout;", "popupHandler", "com/intellij/openapi/wm/impl/content/SingleContentLayout$TabAdapter$popupHandler$1", "Lcom/intellij/openapi/wm/impl/content/SingleContentLayout$TabAdapter$popupHandler$1;", "popupToolbar", "Ljavax/swing/JComponent;", "getTabPainter", "()Lcom/intellij/ui/tabs/JBTabPainter;", "getTwcui", "()Lcom/intellij/openapi/wm/impl/content/ToolWindowContentUi;", "canShowMorePopup", "", "checkAndUpdate", "", "copyValues", "from", "Lcom/intellij/ui/tabs/TabInfo;", "to", "Lcom/intellij/openapi/wm/impl/content/ContentLabel;", "dispose", "getData", "", "dataId", "", "getMinimumSize", "Ljava/awt/Dimension;", "getPopupMenu", "Lcom/intellij/openapi/actionSystem/ActionPopupMenu;", "tabs", "paintComponent", "g", "Ljava/awt/Graphics;", "propertyChange", "evt", "Ljava/beans/PropertyChangeEvent;", "retrieveInfo", "label", "showMorePopup", "showPopup", "component", "Ljava/awt/Component;", "x", "", "y", "updateLabels", "", "updateTabs", "MyContentTabLabel", "intellij.platform.ide.impl"})
    private final class TabAdapter
    extends NonOpaquePanel
    implements TabsListener,
    PropertyChangeListener,
    DataProvider,
    MorePopupAware,
    Disposable {
        private final List<MyContentTabLabel> labels;
        private final JComponent popupToolbar;
        private final popupHandler.1 popupHandler;
        private final closeHandler.1 closeHandler;
        private final containerListener.1 containerListener;
        @NotNull
        private final Content content;
        @NotNull
        private final JBTabs jbTabs;
        @NotNull
        private final JBTabPainter tabPainter;
        @NotNull
        private final ToolWindowContentUi twcui;

        private final TabInfo retrieveInfo(MyContentTabLabel label2) {
            return label2.getContent().getInfo();
        }

        /*
         * WARNING - void declaration
         */
        private final void checkAndUpdate() {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Content currentContent;
            Content content2 = currentContent = SingleContentLayout.this.getSingleContentOrNull();
            SingleContentSupplier currentSupplier = content2 != null ? SingleContentLayout.this.getSupplier(content2) : null;
            Object object = currentSupplier;
            if (object == null || (object = object.getTabs()) == null || (object = object.getTabs()) == null) {
                return;
            }
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"currentSupplier?.getTabs()?.tabs ?: return");
            Object src = object;
            Iterable iterable = this.labels;
            TabAdapter tabAdapter = this;
            boolean $i$f$map = false;
            void var8_7 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void p1;
                MyContentTabLabel myContentTabLabel = (MyContentTabLabel)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                TabInfo tabInfo = tabAdapter.retrieveInfo((MyContentTabLabel)p1);
                collection.add(tabInfo);
            }
            List dst = (List)destination$iv$iv;
            if (!ContainerUtil.equalsIdentity((List)src, (List)dst)) {
                this.updateTabs();
            }
            SingleContentLayout.this.updateSingleContentView(currentContent, currentSupplier);
            this.updateLabels(this.labels);
            this.revalidate();
        }

        /*
         * WARNING - void declaration
         */
        public final void updateTabs() {
            CollectionsKt.removeAll(this.labels, (Function1)((Function1)new Function1<MyContentTabLabel, Boolean>(this){
                final /* synthetic */ TabAdapter this$0;

                public final boolean invoke(@NotNull MyContentTabLabel it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    TabAdapter.access$retrieveInfo(this.this$0, it).getChangeSupport().removePropertyChangeListener(this.this$0);
                    this.this$0.remove(it);
                    return true;
                }
                {
                    this.this$0 = tabAdapter;
                    super(1);
                }
            }));
            Object object = SingleContentLayout.this.getSingleContentOrNull();
            if (object == null || (object = SingleContentLayout.this.getSupplier(object)) == null) {
                return;
            }
            Object supplier2 = object;
            if (this.jbTabs.getTabs().size() > 1) {
                void $this$forEach$iv;
                Collection<MyContentTabLabel> collection;
                void $this$mapTo$iv$iv;
                Iterable $this$map$iv;
                List list2 = this.jbTabs.getTabs();
                Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"jbTabs.tabs");
                Iterable iterable = list2;
                List<MyContentTabLabel> list3 = this.labels;
                boolean $i$f$map = false;
                void var4_6 = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void info2;
                    TabInfo tabInfo = (TabInfo)item$iv$iv;
                    collection = destination$iv$iv;
                    boolean bl = false;
                    void v2 = info2;
                    Intrinsics.checkNotNullExpressionValue((Object)v2, (String)"info");
                    v2.getChangeSupport().addPropertyChangeListener(this);
                    MyContentTabLabel myContentTabLabel = new MyContentTabLabel(new FakeContent((SingleContentSupplier)supplier2, (TabInfo)info2), SingleContentLayout.this);
                    boolean bl2 = false;
                    boolean bl3 = false;
                    MyContentTabLabel $this$apply = myContentTabLabel;
                    boolean bl4 = false;
                    $this$apply.addMouseListener(this.closeHandler);
                    MyContentTabLabel myContentTabLabel2 = myContentTabLabel;
                    collection.add(myContentTabLabel2);
                }
                collection = (List)destination$iv$iv;
                list3.addAll(collection);
                $this$map$iv = this.labels;
                TabAdapter tabAdapter = this;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    Component p1 = (Component)element$iv;
                    boolean bl = false;
                    tabAdapter.add(p1);
                }
            }
            this.updateLabels(this.labels);
        }

        /*
         * WARNING - void declaration
         */
        public final void updateLabels(@NotNull List<MyContentTabLabel> labels) {
            void $this$associateByTo$iv$iv;
            Intrinsics.checkNotNullParameter(labels, (String)"labels");
            Iterable $this$associateBy$iv = labels;
            boolean $i$f$associateBy = false;
            int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
            Iterable iterable = $this$associateBy$iv;
            Map destination$iv$iv = new LinkedHashMap(capacity$iv);
            boolean $i$f$associateByTo = false;
            for (Object element$iv$iv : $this$associateByTo$iv$iv) {
                void it;
                MyContentTabLabel myContentTabLabel = (MyContentTabLabel)element$iv$iv;
                Map map2 = destination$iv$iv;
                boolean bl = false;
                TabInfo tabInfo = it.getContent().getInfo();
                map2.put(tabInfo, element$iv$iv);
            }
            Function2 function2 = (Function2)new Function2<TabInfo, ContentLabel, Unit>(this){

                public final void invoke(@NotNull TabInfo p1, @NotNull ContentLabel p2) {
                    Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
                    Intrinsics.checkNotNullParameter((Object)p2, (String)"p2");
                    ((TabAdapter)this.receiver).copyValues(p1, p2);
                }
            };
            destination$iv$iv.forEach(new BiConsumer(function2){
                private final /* synthetic */ Function2 function;
                {
                    this.function = function2;
                }

                public final /* synthetic */ void accept(Object p0, Object p1) {
                    Intrinsics.checkNotNullExpressionValue((Object)this.function.invoke(p0, p1), (String)"invoke(...)");
                }
            });
        }

        public void dispose() {
            Iterable $this$forEach$iv = this.labels;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                MyContentTabLabel it = (MyContentTabLabel)element$iv;
                boolean bl = false;
                this.retrieveInfo(it).getChangeSupport().removePropertyChangeListener(this);
            }
            this.jbTabs.getComponent().removeContainerListener(this.containerListener);
        }

        @NotNull
        public Dimension getMinimumSize() {
            if (this.isMinimumSizeSet()) {
                Dimension dimension = super.getMinimumSize();
                Intrinsics.checkNotNullExpressionValue((Object)dimension, (String)"super.getMinimumSize()");
                return dimension;
            }
            int minWidth = this.labels.isEmpty() ? 0 : this.popupToolbar.getPreferredSize().width;
            return new Dimension(minWidth, 0);
        }

        public final void copyValues(@NotNull TabInfo from2, @NotNull ContentLabel to) {
            Intrinsics.checkNotNullParameter((Object)from2, (String)"from");
            Intrinsics.checkNotNullParameter((Object)to, (String)"to");
            to.setIcon(from2.getIcon());
            to.setText(from2.getText());
        }

        public final void showPopup(@NotNull Component component2, int x, int y) {
            SingleContentSupplier supplier2;
            TabInfo info2;
            Intrinsics.checkNotNullParameter((Object)component2, (String)"component");
            Component component3 = component2;
            if (!(component3 instanceof ContentTabLabel)) {
                component3 = null;
            }
            ContentTabLabel contentTabLabel = (ContentTabLabel)component3;
            Object object = contentTabLabel != null ? contentTabLabel.getContent() : null;
            if (!(object instanceof FakeContent)) {
                object = null;
            }
            FakeContent fakeContent = (FakeContent)object;
            Object object2 = info2 = fakeContent != null ? fakeContent.getInfo() : null;
            if (info2 == null) {
                boolean $i$f$logger = false;
                Logger logger = Logger.getInstance(SingleContentLayout.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"Logger.getInstance(T::class.java)");
                logger.warn("Cannot resolve label popup component. Event will be ignored");
                return;
            }
            Content content2 = SingleContentLayout.this.getSingleContentOrNull();
            SingleContentSupplier singleContentSupplier = supplier2 = content2 != null ? SingleContentLayout.this.getSupplier(content2) : null;
            ActionPopupMenu actionPopupMenu = this.getPopupMenu((JBTabs)(singleContentSupplier != null ? singleContentSupplier.getTabs() : null));
            if (actionPopupMenu == null) {
                return;
            }
            ActionPopupMenu toShow = actionPopupMenu;
            toShow.setTargetComponent((JComponent)component2);
            JBPopupMenu.showAt((RelativePoint)new RelativePoint(component2, new Point(x, y)), (JPopupMenu)toShow.getComponent());
        }

        private final ActionPopupMenu getPopupMenu(JBTabs tabs) {
            JBTabs jBTabs = tabs;
            if (!(jBTabs instanceof JBTabsImpl)) {
                jBTabs = null;
            }
            JBTabsImpl jBTabsImpl = (JBTabsImpl)jBTabs;
            if (jBTabsImpl == null) {
                return null;
            }
            JBTabsImpl jbTabsImpl = jBTabsImpl;
            ActionGroup actionGroup2 = jbTabsImpl.getPopupGroup();
            if (actionGroup2 == null) {
                return null;
            }
            Intrinsics.checkNotNullExpressionValue((Object)actionGroup2, (String)"jbTabsImpl.popupGroup ?: return null");
            ActionGroup popup2 = actionGroup2;
            String string = jbTabsImpl.getPopupPlace();
            if (string == null) {
                string = "unknown";
            }
            String popupPlace = string;
            DefaultActionGroup group2 = new DefaultActionGroup();
            group2.addAll(popup2);
            group2.addSeparator();
            group2.addAll(jbTabsImpl.getNavigationActions());
            return ActionManager.getInstance().createActionPopupMenu(popupPlace, (ActionGroup)group2);
        }

        protected void paintComponent(@NotNull Graphics g) {
            Intrinsics.checkNotNullParameter((Object)g, (String)"g");
            if (g instanceof Graphics2D) {
                Iterable $this$forEach$iv = this.labels;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    MyContentTabLabel comp = (MyContentTabLabel)element$iv;
                    boolean bl = false;
                    Rectangle labelBounds = comp.getBounds();
                    if (Intrinsics.areEqual((Object)this.jbTabs.getSelectedInfo(), (Object)this.retrieveInfo(comp))) {
                        Graphics2D graphics2D = (Graphics2D)g;
                        Rectangle rectangle = labelBounds;
                        Intrinsics.checkNotNullExpressionValue((Object)rectangle, (String)"labelBounds");
                        ToolWindowImpl toolWindowImpl = this.twcui.window;
                        Intrinsics.checkNotNullExpressionValue((Object)toolWindowImpl, (String)"twcui.window");
                        this.tabPainter.paintSelectedTab(JBTabsPosition.top, graphics2D, rectangle, 1, null, toolWindowImpl.isActive(), comp.isHovered());
                        continue;
                    }
                    Graphics2D graphics2D = (Graphics2D)g;
                    Rectangle rectangle = labelBounds;
                    Intrinsics.checkNotNullExpressionValue((Object)rectangle, (String)"labelBounds");
                    ToolWindowImpl toolWindowImpl = this.twcui.window;
                    Intrinsics.checkNotNullExpressionValue((Object)toolWindowImpl, (String)"twcui.window");
                    this.tabPainter.paintTab(JBTabsPosition.top, graphics2D, rectangle, 1, null, toolWindowImpl.isActive(), comp.isHovered());
                }
            }
            super.paintComponent(g);
        }

        @Override
        public void propertyChange(@NotNull PropertyChangeEvent evt) {
            Object v2;
            boolean bl;
            Object object;
            TabInfo source;
            block4: {
                Intrinsics.checkNotNullParameter((Object)evt, (String)"evt");
                Object object2 = evt.getSource();
                if (!(object2 instanceof TabInfo)) {
                    object2 = null;
                }
                TabInfo tabInfo = (TabInfo)object2;
                if (tabInfo == null) {
                    String string = "Bad event source";
                    boolean bl2 = false;
                    throw (Throwable)new IllegalStateException(string.toString());
                }
                source = tabInfo;
                object = this.labels;
                bl = false;
                Iterable iterable = object;
                boolean bl3 = false;
                for (Object t : iterable) {
                    MyContentTabLabel it = (MyContentTabLabel)t;
                    boolean bl4 = false;
                    if (!Intrinsics.areEqual((Object)it.getContent().getInfo(), (Object)source)) continue;
                    v2 = t;
                    break block4;
                }
                v2 = null;
            }
            MyContentTabLabel myContentTabLabel = v2;
            if (myContentTabLabel == null) {
                object = "Cannot find label for " + source;
                bl = false;
                throw (Throwable)new IllegalStateException(object.toString());
            }
            MyContentTabLabel label2 = myContentTabLabel;
            this.copyValues(source, label2);
        }

        @Override
        @Nullable
        public Object getData(@NotNull String dataId) {
            Intrinsics.checkNotNullParameter((Object)dataId, (String)"dataId");
            if (MorePopupAware.KEY.is(dataId)) {
                return this;
            }
            return null;
        }

        public boolean canShowMorePopup() {
            return true;
        }

        /*
         * WARNING - void declaration
         */
        public void showMorePopup() {
            void $this$mapTo$iv$iv;
            MyContentTabLabel it;
            Iterable $this$filterTo$iv$iv;
            Iterable $this$filter$iv = this.labels;
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                it = (MyContentTabLabel)element$iv$iv;
                boolean bl = false;
                if (!(it.getBounds().width <= 0)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            Iterable $this$map$iv = (List)destination$iv$iv;
            boolean $i$f$map = false;
            $this$filterTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void p1;
                it = (MyContentTabLabel)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                FakeContent fakeContent = p1.getContent();
                collection.add(fakeContent);
            }
            List contentToShow = (List)destination$iv$iv;
            BaseListPopupStep<FakeContent> step2 = new BaseListPopupStep<FakeContent>(this, contentToShow, null, contentToShow){
                final /* synthetic */ TabAdapter this$0;
                final /* synthetic */ List $contentToShow;

                @Nullable
                public PopupStep<?> onChosen(@NotNull FakeContent selectedValue, boolean finalChoice) {
                    Intrinsics.checkNotNullParameter((Object)selectedValue, (String)"selectedValue");
                    this.this$0.getJbTabs().select(selectedValue.getInfo(), true);
                    return BaseListPopupStep.FINAL_CHOICE;
                }

                @Nullable
                public Icon getIconFor(@NotNull FakeContent value2) {
                    Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
                    return value2.getIcon();
                }

                @NotNull
                public String getTextFor(@NotNull FakeContent value2) {
                    Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
                    return value2.getDisplayName();
                }
                {
                    this.this$0 = this$0;
                    this.$contentToShow = $captured_local_variable$1;
                    super($super_call_param$2, $super_call_param$3);
                }
            };
            JBPopupFactory.getInstance().createListPopup((ListPopupStep)step2).show(RelativePoint.getSouthWestOf((JComponent)this.popupToolbar));
        }

        @NotNull
        public final Content getContent() {
            return this.content;
        }

        @NotNull
        public final JBTabs getJbTabs() {
            return this.jbTabs;
        }

        @NotNull
        public final JBTabPainter getTabPainter() {
            return this.tabPainter;
        }

        @NotNull
        public final ToolWindowContentUi getTwcui() {
            return this.twcui;
        }

        /*
         * WARNING - void declaration
         */
        public TabAdapter(@NotNull Content content2, @NotNull JBTabs jbTabs, @NotNull JBTabPainter tabPainter, ToolWindowContentUi twcui) {
            void $this$apply;
            Intrinsics.checkNotNullParameter((Object)content2, (String)"content");
            Intrinsics.checkNotNullParameter((Object)jbTabs, (String)"jbTabs");
            Intrinsics.checkNotNullParameter((Object)tabPainter, (String)"tabPainter");
            Intrinsics.checkNotNullParameter((Object)twcui, (String)"twcui");
            this.content = content2;
            this.jbTabs = jbTabs;
            this.tabPainter = tabPainter;
            this.twcui = twcui;
            boolean bl = false;
            this.labels = new ArrayList();
            this.popupHandler = new PopupHandler(this){
                final /* synthetic */ TabAdapter this$0;

                public void invokePopup(@NotNull Component comp, int x, int y) {
                    Intrinsics.checkNotNullParameter((Object)comp, (String)"comp");
                    this.this$0.showPopup(comp, x, y);
                }
                {
                    this.this$0 = this$0;
                }
            };
            this.closeHandler = new MouseAdapter(){

                public void mouseReleased(@NotNull MouseEvent e) {
                    Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                    if (UIUtil.isCloseClick((MouseEvent)e, (int)502)) {
                        MyContentTabLabel tabLabel;
                        Component component2 = e.getComponent();
                        if (!(component2 instanceof MyContentTabLabel)) {
                            component2 = null;
                        }
                        if ((tabLabel = (MyContentTabLabel)component2) != null && tabLabel.getContent().isCloseable()) {
                            tabLabel.closeContent();
                        }
                    }
                }
            };
            this.containerListener = new ContainerListener(this){
                final /* synthetic */ TabAdapter this$0;

                public void componentAdded(@NotNull ContainerEvent e) {
                    Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                    this.update(e);
                }

                public void componentRemoved(@NotNull ContainerEvent e) {
                    Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                    this.update(e);
                }

                private final void update(ContainerEvent e) {
                    if (e.getChild() instanceof TabLabel) {
                        TabAdapter.access$checkAndUpdate(this.this$0);
                    }
                }
                {
                    this.this$0 = this$0;
                }
            };
            this.updateTabs();
            this.jbTabs.addListener(new TabsListener(){

                public void selectionChanged(@Nullable TabInfo oldSelection, @Nullable TabInfo newSelection) {
                    this.checkAndUpdate();
                }

                public void tabRemoved(@NotNull TabInfo tabToRemove) {
                    Intrinsics.checkNotNullParameter((Object)tabToRemove, (String)"tabToRemove");
                    this.checkAndUpdate();
                }

                public void tabsMoved() {
                    this.checkAndUpdate();
                }
            }, (Disposable)this);
            this.jbTabs.getComponent().addContainerListener(this.containerListener);
            AnAction tabList = ActionManager.getInstance().getAction("TabList");
            DefaultActionGroup tabListGroup = new DefaultActionGroup(new AnAction[]{tabList, (AnAction)Separator.create(), (AnAction)new MyInvisibleAction()});
            ActionToolbar actionToolbar = SingleContentLayout.this.createToolbar("ToolwindowPopup", (ActionGroup)tabListGroup, (JComponent)((Object)this));
            boolean bl2 = false;
            boolean bl3 = false;
            ActionToolbar actionToolbar2 = actionToolbar;
            TabAdapter tabAdapter = this;
            boolean bl4 = false;
            $this$apply.setReservePlaceAutoPopupIcon(false);
            $this$apply.setLayoutPolicy(0);
            Unit unit = Unit.INSTANCE;
            JComponent jComponent = actionToolbar.getComponent();
            Intrinsics.checkNotNullExpressionValue((Object)jComponent, (String)"createToolbar(ActionPlac\u2026_POLICY\n      }.component");
            tabAdapter.popupToolbar = jComponent;
            this.setLayout((LayoutManager)((Object)new HorizontalTabLayoutWithHiddenControl((Function0<? extends JComponent>)((Function0)new Function0<JComponent>(){

                @Nullable
                public final JComponent invoke() {
                    Object v0;
                    block1: {
                        Iterable iterable = labels;
                        boolean bl = false;
                        Iterable iterable2 = iterable;
                        boolean bl2 = false;
                        for (Object t : iterable2) {
                            MyContentTabLabel it = (MyContentTabLabel)t;
                            boolean bl3 = false;
                            if (!Intrinsics.areEqual((Object)it.getContent().getInfo(), (Object)this.getJbTabs().getSelectedInfo())) continue;
                            v0 = t;
                            break block1;
                        }
                        v0 = null;
                    }
                    return v0;
                }
            }))));
            this.add(this.popupToolbar, "ControlComponent");
        }

        @Metadata(mv={1, 5, 1}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\u00020\u00012\u00020\u0002B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\b\u0010\b\u001a\u00020\tH\u0016J\b\u0010\n\u001a\u00020\u0004H\u0016J\u0012\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\b\u0010\u000f\u001a\u00020\tH\u0014\u00a8\u0006\u0010"}, d2={"Lcom/intellij/openapi/wm/impl/content/SingleContentLayout$TabAdapter$MyContentTabLabel;", "Lcom/intellij/openapi/wm/impl/content/ContentTabLabel;", "Lcom/intellij/openapi/actionSystem/DataProvider;", "content", "Lcom/intellij/openapi/wm/impl/content/SingleContentLayout$FakeContent;", "layout", "Lcom/intellij/openapi/wm/impl/content/TabContentLayout;", "(Lcom/intellij/openapi/wm/impl/content/SingleContentLayout$TabAdapter;Lcom/intellij/openapi/wm/impl/content/SingleContentLayout$FakeContent;Lcom/intellij/openapi/wm/impl/content/TabContentLayout;)V", "closeContent", "", "getContent", "getData", "", "dataId", "", "selectContent", "intellij.platform.ide.impl"})
        private final class MyContentTabLabel
        extends ContentTabLabel
        implements DataProvider {
            @Override
            protected void selectContent() {
                TabInfo tabInfo = TabAdapter.this.retrieveInfo(this);
                boolean bl = false;
                boolean bl2 = false;
                TabInfo it = tabInfo;
                boolean bl3 = false;
                TabAdapter.this.getJbTabs().select(it, true);
            }

            @Override
            public void closeContent() {
                block0: {
                    TabInfo tabInfo = TabAdapter.this.retrieveInfo(this);
                    boolean bl = false;
                    boolean bl2 = false;
                    TabInfo info2 = tabInfo;
                    boolean bl3 = false;
                    Object object = SingleContentLayout.this.getSingleContentOrNull();
                    if (object == null || (object = SingleContentLayout.this.getSupplier((Content)object)) == null) break block0;
                    object.close(info2);
                }
            }

            @Override
            @Nullable
            public Object getData(@NotNull String dataId) {
                Intrinsics.checkNotNullParameter((Object)dataId, (String)"dataId");
                if (JBTabsEx.NAVIGATION_ACTIONS_KEY.is(dataId)) {
                    return TabAdapter.this.getJbTabs();
                }
                DataProvider dataProvider = DataManagerImpl.getDataProviderEx(TabAdapter.this.retrieveInfo(this).getComponent());
                return dataProvider != null ? dataProvider.getData(dataId) : null;
            }

            @Override
            @NotNull
            public FakeContent getContent() {
                Content content2 = super.getContent();
                if (content2 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type com.intellij.openapi.wm.impl.content.SingleContentLayout.FakeContent");
                }
                return (FakeContent)content2;
            }

            public MyContentTabLabel(@NotNull FakeContent content2, TabContentLayout layout) {
                Intrinsics.checkNotNullParameter((Object)content2, (String)"content");
                Intrinsics.checkNotNullParameter((Object)layout, (String)"layout");
                super(content2, layout);
                this.addMouseListener((MouseListener)((Object)TabAdapter.this.popupHandler));
            }
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0002\u0018\u00002\u00020\u0001B#\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0012\u0010\u0004\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00060\u0005\"\u00020\u0006\u00a2\u0006\u0002\u0010\u0007R\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\n"}, d2={"Lcom/intellij/openapi/wm/impl/content/SingleContentLayout$ExtendedTitleActionsGroup;", "Lcom/intellij/openapi/actionSystem/DefaultActionGroup;", "originActions", "Lcom/intellij/openapi/actionSystem/ActionGroup;", "extendedActions", "", "Lcom/intellij/openapi/actionSystem/AnAction;", "(Lcom/intellij/openapi/actionSystem/ActionGroup;[Lcom/intellij/openapi/actionSystem/AnAction;)V", "getOriginActions", "()Lcom/intellij/openapi/actionSystem/ActionGroup;", "intellij.platform.ide.impl"})
    private static final class ExtendedTitleActionsGroup
    extends DefaultActionGroup {
        @Nullable
        private final ActionGroup originActions;

        @Nullable
        public final ActionGroup getOriginActions() {
            return this.originActions;
        }

        /*
         * WARNING - void declaration
         */
        public ExtendedTitleActionsGroup(@Nullable ActionGroup originActions, AnAction ... extendedActions) {
            block1: {
                void $this$forEach$iv;
                Intrinsics.checkNotNullParameter((Object)extendedActions, (String)"extendedActions");
                this.originActions = originActions;
                ActionGroup actionGroup2 = extendedActions;
                ExtendedTitleActionsGroup extendedTitleActionsGroup = this;
                boolean $i$f$forEach = false;
                void var6_6 = $this$forEach$iv;
                int n = ((void)var6_6).length;
                for (int j = 0; j < n; ++j) {
                    void element$iv;
                    void p1 = element$iv = var6_6[j];
                    boolean bl = false;
                    extendedTitleActionsGroup.add((AnAction)p1);
                }
                ActionGroup actionGroup3 = this.originActions;
                if (actionGroup3 == null) break block1;
                actionGroup2 = actionGroup3;
                extendedTitleActionsGroup = this;
                boolean bl = false;
                boolean bl2 = false;
                ActionGroup p1 = actionGroup2;
                boolean bl3 = false;
                extendedTitleActionsGroup.addAll(p1);
            }
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\b\u0010\u0007\u001a\u00020\bH\u0002J\u0010\u0010\t\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\n"}, d2={"Lcom/intellij/openapi/wm/impl/content/SingleContentLayout$CloseCurrentContentAction;", "Lcom/intellij/openapi/project/DumbAwareAction;", "(Lcom/intellij/openapi/wm/impl/content/SingleContentLayout;)V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "isPinned", "", "update", "intellij.platform.ide.impl"})
    private final class CloseCurrentContentAction
    extends DumbAwareAction {
        public void actionPerformed(@NotNull AnActionEvent e) {
            block2: {
                Content content2;
                block1: {
                    Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                    content2 = SingleContentLayout.this.getSingleContentOrNull();
                    if (content2 == null || !content2.isPinned()) break block1;
                    content2.setPinned(false);
                    break block2;
                }
                Content content3 = content2;
                if (content3 == null) break block2;
                Content content4 = content3;
                boolean bl = false;
                boolean bl2 = false;
                Content it = content4;
                boolean bl3 = false;
                ContentManager contentManager2 = it.getManager();
                if (contentManager2 != null) {
                    contentManager2.removeContent(it, true);
                }
            }
        }

        public void update(@NotNull AnActionEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            Presentation presentation2 = e.getPresentation();
            Intrinsics.checkNotNullExpressionValue((Object)presentation2, (String)"e.presentation");
            Content content2 = SingleContentLayout.this.getSingleContentOrNull();
            presentation2.setEnabledAndVisible(content2 != null && content2.isCloseable());
            if (this.isPinned()) {
                Presentation presentation3 = e.getPresentation();
                Intrinsics.checkNotNullExpressionValue((Object)presentation3, (String)"e.presentation");
                presentation3.setIcon(AllIcons.General.Pin_tab);
                Presentation presentation4 = e.getPresentation();
                Intrinsics.checkNotNullExpressionValue((Object)presentation4, (String)"e.presentation");
                presentation4.setText(IdeBundle.message((String)"action.unpin.tab", (Object[])new Object[0]));
            } else {
                Presentation presentation5 = e.getPresentation();
                Intrinsics.checkNotNullExpressionValue((Object)presentation5, (String)"e.presentation");
                presentation5.setIcon(AllIcons.Actions.Cancel);
                Presentation presentation6 = e.getPresentation();
                Intrinsics.checkNotNullExpressionValue((Object)presentation6, (String)"e.presentation");
                presentation6.setText(CommonBundle.message((String)"action.close", (Object[])new Object[0]));
            }
        }

        private final boolean isPinned() {
            Content content2 = SingleContentLayout.this.getSingleContentOrNull();
            return content2 != null && content2.isPinned();
        }

        public CloseCurrentContentAction() {
            super(CommonBundle.messagePointer((String)"action.close", (Object[])new Object[0]), AllIcons.Actions.Cancel);
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u0082\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b&\n\u0002\u0018\u0002\n\u0002\b\n\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0012\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0016J\b\u0010\u0011\u001a\u00020\u000eH\u0016J\b\u0010\u0012\u001a\u00020\u000eH\u0016J\n\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u0016J\n\u0010\u0015\u001a\u0004\u0018\u00010\u0016H\u0016J\n\u0010\u0017\u001a\u0004\u0018\u00010\u0018H\u0016J\n\u0010\u0019\u001a\u0004\u0018\u00010\u001aH\u0016J\b\u0010\u001b\u001a\u00020\u0016H\u0016J\n\u0010\u001c\u001a\u0004\u0018\u00010\u001dH\u0016J\b\u0010\u001e\u001a\u00020\u001dH\u0017J\n\u0010\u001f\u001a\u0004\u0018\u00010 H\u0016J\b\u0010!\u001a\u00020\"H\u0016J\n\u0010#\u001a\u0004\u0018\u00010$H\u0016J\n\u0010%\u001a\u0004\u0018\u00010&H\u0016J\b\u0010'\u001a\u00020\u001dH\u0016J\n\u0010(\u001a\u0004\u0018\u00010$H\u0016J\n\u0010)\u001a\u0004\u0018\u00010\u0016H\u0016J\n\u0010*\u001a\u0004\u0018\u00010\u0016H\u0016J\b\u0010+\u001a\u00020\u001dH\u0016J\b\u0010,\u001a\u00020\u001dH\u0016J\b\u0010-\u001a\u00020\u001dH\u0016J#\u0010.\u001a\u0004\u0018\u0001H/\"\u0004\b\u0000\u0010/2\f\u00100\u001a\b\u0012\u0004\u0012\u0002H/01H\u0016\u00a2\u0006\u0002\u00102J\b\u00103\u001a\u000204H\u0016J\b\u00105\u001a\u000204H\u0016J\b\u00106\u001a\u000204H\u0016J\b\u00107\u001a\u000204H\u0016J\b\u00108\u001a\u000204H\u0016J+\u00109\u001a\u00020\u000e\"\u0004\b\u0000\u0010/2\f\u00100\u001a\b\u0012\u0004\u0012\u0002H/012\b\u0010:\u001a\u0004\u0018\u0001H/H\u0016\u00a2\u0006\u0002\u0010;J\b\u0010<\u001a\u00020\u000eH\u0016J\u0012\u0010=\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0016J&\u0010>\u001a\u00020\u000e2\b\u0010?\u001a\u0004\u0018\u00010\u00142\b\u0010@\u001a\u0004\u0018\u00010\u001d2\b\u0010A\u001a\u0004\u0018\u00010\u0016H\u0016J\u0012\u0010B\u001a\u00020\u000e2\b\u0010C\u001a\u0004\u0018\u00010\u0018H\u0016J\u0012\u0010D\u001a\u00020\u000e2\b\u0010E\u001a\u0004\u0018\u00010\u001aH\u0016J\u0010\u0010F\u001a\u00020\u000e2\u0006\u0010G\u001a\u000204H\u0016J\u0012\u0010H\u001a\u00020\u000e2\b\u0010I\u001a\u0004\u0018\u00010\u0016H\u0016J\u0012\u0010J\u001a\u00020\u000e2\b\u0010K\u001a\u0004\u0018\u00010\u001dH\u0016J\u0012\u0010L\u001a\u00020\u000e2\b\u0010M\u001a\u0004\u0018\u00010\u001dH\u0016J\u0010\u0010N\u001a\u00020\u000e2\u0006\u0010O\u001a\u00020 H\u0016J\u0010\u0010P\u001a\u00020\u000e2\u0006\u0010Q\u001a\u00020\"H\u0016J\u0012\u0010R\u001a\u00020\u000e2\b\u0010C\u001a\u0004\u0018\u00010$H\u0016J\u0010\u0010S\u001a\u00020\u000e2\u0006\u0010T\u001a\u000204H\u0016J\u0010\u0010U\u001a\u00020\u000e2\u0006\u0010V\u001a\u000204H\u0016J\u0012\u0010W\u001a\u00020\u000e2\b\u0010C\u001a\u0004\u0018\u00010$H\u0016J\u0012\u0010X\u001a\u00020\u000e2\b\u0010I\u001a\u0004\u0018\u00010\u0016H\u0016J\u001a\u0010Y\u001a\u00020\u000e2\u0010\u0010Z\u001a\f\u0012\u0006\b\u0001\u0012\u00020\u0016\u0018\u00010[H\u0016J\u0012\u0010\\\u001a\u00020\u000e2\b\u0010]\u001a\u0004\u0018\u00010\u0016H\u0016J\u0012\u0010^\u001a\u00020\u000e2\b\u0010_\u001a\u0004\u0018\u00010\u001dH\u0016J\u0010\u0010`\u001a\u00020\u000e2\u0006\u0010:\u001a\u000204H\u0016J\u0012\u0010a\u001a\u00020\u000e2\b\u0010b\u001a\u0004\u0018\u00010\u001dH\u0016J\u0012\u0010c\u001a\u00020\u000e2\b\u0010d\u001a\u0004\u0018\u00010\u001dH\u0016R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006e"}, d2={"Lcom/intellij/openapi/wm/impl/content/SingleContentLayout$FakeContent;", "Lcom/intellij/ui/content/Content;", "supplier", "Lcom/intellij/openapi/wm/impl/content/SingleContentSupplier;", "info", "Lcom/intellij/ui/tabs/TabInfo;", "(Lcom/intellij/openapi/wm/impl/content/SingleContentSupplier;Lcom/intellij/ui/tabs/TabInfo;)V", "getInfo", "()Lcom/intellij/ui/tabs/TabInfo;", "pcs", "Ljava/beans/PropertyChangeSupport;", "getSupplier", "()Lcom/intellij/openapi/wm/impl/content/SingleContentSupplier;", "addPropertyChangeListener", "", "l", "Ljava/beans/PropertyChangeListener;", "dispose", "fireAlert", "getActions", "Lcom/intellij/openapi/actionSystem/ActionGroup;", "getActionsContextComponent", "Ljavax/swing/JComponent;", "getAlertIcon", "Lcom/intellij/ui/content/AlertIcon;", "getBusyObject", "Lcom/intellij/openapi/util/BusyObject;", "getComponent", "getDescription", "", "getDisplayName", "getDisposer", "Lcom/intellij/openapi/Disposable;", "getExecutionId", "", "getIcon", "Ljavax/swing/Icon;", "getManager", "Lcom/intellij/ui/content/ContentManager;", "getPlace", "getPopupIcon", "getPreferredFocusableComponent", "getSearchComponent", "getSeparator", "getTabName", "getToolwindowTitle", "getUserData", "T", "key", "Lcom/intellij/openapi/util/Key;", "(Lcom/intellij/openapi/util/Key;)Ljava/lang/Object;", "isCloseable", "", "isPinnable", "isPinned", "isSelected", "isValid", "putUserData", "value", "(Lcom/intellij/openapi/util/Key;Ljava/lang/Object;)V", "release", "removePropertyChangeListener", "setActions", "actions", "place", "contextComponent", "setAlertIcon", "icon", "setBusyObject", "object", "setCloseable", "closeable", "setComponent", "component", "setDescription", "description", "setDisplayName", "displayName", "setDisposer", "disposer", "setExecutionId", "executionId", "setIcon", "setPinnable", "pinnable", "setPinned", "locked", "setPopupIcon", "setPreferredFocusableComponent", "setPreferredFocusedComponent", "computable", "Lcom/intellij/openapi/util/Computable;", "setSearchComponent", "comp", "setSeparator", "separator", "setShouldDisposeContent", "setTabName", "tabName", "setToolwindowTitle", "toolwindowTitle", "intellij.platform.ide.impl"})
    private static final class FakeContent
    implements Content {
        private final PropertyChangeSupport pcs;
        @NotNull
        private final SingleContentSupplier supplier;
        @NotNull
        private final TabInfo info;

        public void addPropertyChangeListener(@Nullable PropertyChangeListener l) {
            this.pcs.addPropertyChangeListener(l);
        }

        public void removePropertyChangeListener(@Nullable PropertyChangeListener l) {
            this.pcs.removePropertyChangeListener(l);
        }

        public boolean isSelected() {
            return Intrinsics.areEqual((Object)this.supplier.getTabs().getSelectedInfo(), (Object)this.info);
        }

        public boolean isCloseable() {
            return this.supplier.isClosable(this.info);
        }

        public boolean isPinned() {
            return false;
        }

        @Nullable
        public ContentManager getManager() {
            return null;
        }

        @Nullable
        public Icon getIcon() {
            return this.info.getIcon();
        }

        @NlsSafe
        @NotNull
        public String getDisplayName() {
            String string = this.info.getText();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"info.text");
            return string;
        }

        @Nullable
        public <T> T getUserData(@NotNull Key<T> key) {
            Intrinsics.checkNotNullParameter(key, (String)"key");
            String string = "An operation is not supported";
            boolean bl = false;
            throw (Throwable)new IllegalStateException(string.toString());
        }

        public <T> void putUserData(@NotNull Key<T> key, @Nullable T value2) {
            Intrinsics.checkNotNullParameter(key, (String)"key");
            String string = "An operation is not supported";
            boolean bl = false;
            throw (Throwable)new IllegalStateException(string.toString());
        }

        public void dispose() {
            String string = "An operation is not supported";
            boolean bl = false;
            throw (Throwable)new IllegalStateException(string.toString());
        }

        @NotNull
        public JComponent getComponent() {
            String string = "An operation is not supported";
            boolean bl = false;
            throw (Throwable)new IllegalStateException(string.toString());
        }

        @Nullable
        public JComponent getPreferredFocusableComponent() {
            String string = "An operation is not supported";
            boolean bl = false;
            throw (Throwable)new IllegalStateException(string.toString());
        }

        public void setComponent(@Nullable JComponent component2) {
            String string = "An operation is not supported";
            boolean bl = false;
            throw (Throwable)new IllegalStateException(string.toString());
        }

        public void setPreferredFocusableComponent(@Nullable JComponent component2) {
            String string = "An operation is not supported";
            boolean bl = false;
            throw (Throwable)new IllegalStateException(string.toString());
        }

        public void setPreferredFocusedComponent(@Nullable Computable<? extends JComponent> computable) {
            String string = "An operation is not supported";
            boolean bl = false;
            throw (Throwable)new IllegalStateException(string.toString());
        }

        public void setIcon(@Nullable Icon icon2) {
            String string = "An operation is not supported";
            boolean bl = false;
            throw (Throwable)new IllegalStateException(string.toString());
        }

        public void setDisplayName(@Nullable String displayName) {
            String string = "An operation is not supported";
            boolean bl = false;
            throw (Throwable)new IllegalStateException(string.toString());
        }

        public void setTabName(@Nullable String tabName) {
            String string = "An operation is not supported";
            boolean bl = false;
            throw (Throwable)new IllegalStateException(string.toString());
        }

        @NotNull
        public String getTabName() {
            String string = "An operation is not supported";
            boolean bl = false;
            throw (Throwable)new IllegalStateException(string.toString());
        }

        @NotNull
        public String getToolwindowTitle() {
            String string = "An operation is not supported";
            boolean bl = false;
            throw (Throwable)new IllegalStateException(string.toString());
        }

        public void setToolwindowTitle(@Nullable String toolwindowTitle) {
            String string = "An operation is not supported";
            boolean bl = false;
            throw (Throwable)new IllegalStateException(string.toString());
        }

        @Nullable
        public Disposable getDisposer() {
            String string = "An operation is not supported";
            boolean bl = false;
            throw (Throwable)new IllegalStateException(string.toString());
        }

        public void setDisposer(@NotNull Disposable disposer2) {
            Intrinsics.checkNotNullParameter((Object)disposer2, (String)"disposer");
            String string = "An operation is not supported";
            boolean bl = false;
            throw (Throwable)new IllegalStateException(string.toString());
        }

        public void setShouldDisposeContent(boolean value2) {
            String string = "An operation is not supported";
            boolean bl = false;
            throw (Throwable)new IllegalStateException(string.toString());
        }

        @Nullable
        public String getDescription() {
            String string = "An operation is not supported";
            boolean bl = false;
            throw (Throwable)new IllegalStateException(string.toString());
        }

        public void setDescription(@Nullable String description) {
            String string = "An operation is not supported";
            boolean bl = false;
            throw (Throwable)new IllegalStateException(string.toString());
        }

        public void release() {
            String string = "An operation is not supported";
            boolean bl = false;
            throw (Throwable)new IllegalStateException(string.toString());
        }

        public boolean isValid() {
            String string = "An operation is not supported";
            boolean bl = false;
            throw (Throwable)new IllegalStateException(string.toString());
        }

        public void setPinned(boolean locked) {
            String string = "An operation is not supported";
            boolean bl = false;
            throw (Throwable)new IllegalStateException(string.toString());
        }

        public void setPinnable(boolean pinnable) {
            String string = "An operation is not supported";
            boolean bl = false;
            throw (Throwable)new IllegalStateException(string.toString());
        }

        public boolean isPinnable() {
            String string = "An operation is not supported";
            boolean bl = false;
            throw (Throwable)new IllegalStateException(string.toString());
        }

        public void setCloseable(boolean closeable) {
            String string = "An operation is not supported";
            boolean bl = false;
            throw (Throwable)new IllegalStateException(string.toString());
        }

        public void setActions(@Nullable ActionGroup actions2, @Nullable String place, @Nullable JComponent contextComponent) {
            String string = "An operation is not supported";
            boolean bl = false;
            throw (Throwable)new IllegalStateException(string.toString());
        }

        @Nullable
        public ActionGroup getActions() {
            String string = "An operation is not supported";
            boolean bl = false;
            throw (Throwable)new IllegalStateException(string.toString());
        }

        public void setSearchComponent(@Nullable JComponent comp) {
            String string = "An operation is not supported";
            boolean bl = false;
            throw (Throwable)new IllegalStateException(string.toString());
        }

        @Nullable
        public JComponent getSearchComponent() {
            String string = "An operation is not supported";
            boolean bl = false;
            throw (Throwable)new IllegalStateException(string.toString());
        }

        @NotNull
        public String getPlace() {
            String string = "An operation is not supported";
            boolean bl = false;
            throw (Throwable)new IllegalStateException(string.toString());
        }

        @Nullable
        public JComponent getActionsContextComponent() {
            String string = "An operation is not supported";
            boolean bl = false;
            throw (Throwable)new IllegalStateException(string.toString());
        }

        public void setAlertIcon(@Nullable AlertIcon icon2) {
            String string = "An operation is not supported";
            boolean bl = false;
            throw (Throwable)new IllegalStateException(string.toString());
        }

        @Nullable
        public AlertIcon getAlertIcon() {
            String string = "An operation is not supported";
            boolean bl = false;
            throw (Throwable)new IllegalStateException(string.toString());
        }

        public void fireAlert() {
            String string = "An operation is not supported";
            boolean bl = false;
            throw (Throwable)new IllegalStateException(string.toString());
        }

        @Nullable
        public BusyObject getBusyObject() {
            String string = "An operation is not supported";
            boolean bl = false;
            throw (Throwable)new IllegalStateException(string.toString());
        }

        public void setBusyObject(@Nullable BusyObject object) {
            String string = "An operation is not supported";
            boolean bl = false;
            throw (Throwable)new IllegalStateException(string.toString());
        }

        @NotNull
        public String getSeparator() {
            String string = "An operation is not supported";
            boolean bl = false;
            throw (Throwable)new IllegalStateException(string.toString());
        }

        public void setSeparator(@Nullable String separator2) {
            String string = "An operation is not supported";
            boolean bl = false;
            throw (Throwable)new IllegalStateException(string.toString());
        }

        public void setPopupIcon(@Nullable Icon icon2) {
            String string = "An operation is not supported";
            boolean bl = false;
            throw (Throwable)new IllegalStateException(string.toString());
        }

        @Nullable
        public Icon getPopupIcon() {
            String string = "An operation is not supported";
            boolean bl = false;
            throw (Throwable)new IllegalStateException(string.toString());
        }

        public void setExecutionId(long executionId) {
            String string = "An operation is not supported";
            boolean bl = false;
            throw (Throwable)new IllegalStateException(string.toString());
        }

        public long getExecutionId() {
            String string = "An operation is not supported";
            boolean bl = false;
            throw (Throwable)new IllegalStateException(string.toString());
        }

        @NotNull
        public final SingleContentSupplier getSupplier() {
            return this.supplier;
        }

        @NotNull
        public final TabInfo getInfo() {
            return this.info;
        }

        public FakeContent(@NotNull SingleContentSupplier supplier2, @NotNull TabInfo info2) {
            Intrinsics.checkNotNullParameter((Object)supplier2, (String)"supplier");
            Intrinsics.checkNotNullParameter((Object)info2, (String)"info");
            this.supplier = supplier2;
            this.info = info2;
            this.pcs = new PropertyChangeSupport(this);
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u0000 \u00152\u00020\u0001:\u0001\u0015B\u0015\u0012\u000e\u0010\u0002\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J\u001c\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\u00072\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0016J\u0010\u0010\u000f\u001a\u00020\u000b2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0012\u0010\u0014\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\u0007H\u0016R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0019\u0010\u0002\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0016"}, d2={"Lcom/intellij/openapi/wm/impl/content/SingleContentLayout$HorizontalTabLayoutWithHiddenControl;", "Lcom/intellij/util/ui/AbstractLayoutManager;", "selected", "Lkotlin/Function0;", "Ljavax/swing/JComponent;", "(Lkotlin/jvm/functions/Function0;)V", "control", "Ljava/awt/Component;", "getSelected", "()Lkotlin/jvm/functions/Function0;", "addLayoutComponent", "", "comp", "constraints", "", "layoutContainer", "parent", "Ljava/awt/Container;", "preferredLayoutSize", "Ljava/awt/Dimension;", "removeLayoutComponent", "Companion", "intellij.platform.ide.impl"})
    private static final class HorizontalTabLayoutWithHiddenControl
    extends AbstractLayoutManager {
        private Component control;
        @NotNull
        private final Function0<JComponent> selected;
        @NotNull
        public static final String CONTROL = "ControlComponent";
        @NotNull
        public static final Companion Companion = new Companion(null);

        public void addLayoutComponent(@Nullable Component comp, @Nullable Object constraints2) {
            if (Intrinsics.areEqual((Object)constraints2, (Object)CONTROL)) {
                boolean bl = this.control == null;
                boolean bl2 = false;
                if (_Assertions.ENABLED && !bl) {
                    boolean bl3 = false;
                    String string = "Cannot add a second control component";
                    throw (Throwable)((Object)new AssertionError((Object)string));
                }
                this.control = comp;
            }
            super.addLayoutComponent(comp, constraints2);
        }

        public void removeLayoutComponent(@Nullable Component comp) {
            if (this.control == comp) {
                this.control = null;
            }
            super.removeLayoutComponent(comp);
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public Dimension preferredLayoutSize(@NotNull Container parent) {
            void $this$fold$iv;
            Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
            Object[] objectArray = parent.getComponents();
            Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"parent.components");
            Sequence sequence = SequencesKt.map((Sequence)SequencesKt.filterNot((Sequence)ArraysKt.asSequence((Object[])objectArray), (Function1)((Function1)new Function1<Component, Boolean>(this){
                final /* synthetic */ HorizontalTabLayoutWithHiddenControl this$0;

                public final boolean invoke(Component it) {
                    return it == HorizontalTabLayoutWithHiddenControl.access$getControl$p(this.this$0);
                }
                {
                    this.this$0 = horizontalTabLayoutWithHiddenControl;
                    super(1);
                }
            })), (Function1)preferredLayoutSize.2.INSTANCE);
            Dimension initial$iv = new Dimension();
            boolean $i$f$fold = false;
            Dimension accumulator$iv = initial$iv;
            for (Object element$iv : $this$fold$iv) {
                void size;
                Dimension dimension = (Dimension)element$iv;
                Dimension acc = accumulator$iv;
                boolean bl = false;
                Dimension dimension2 = acc;
                boolean bl2 = false;
                boolean bl3 = false;
                Dimension $this$apply = dimension2;
                boolean bl4 = false;
                $this$apply.width += size.width;
                int n = acc.height;
                int n2 = size.height;
                int n3 = parent.getHeight();
                boolean bl5 = false;
                int n4 = 0;
                n4 = Math.max(n2, n3);
                boolean bl6 = false;
                $this$apply.height = Math.max(n, n4);
                accumulator$iv = dimension2;
            }
            return accumulator$iv;
        }

        public void layoutContainer(@NotNull Container parent) {
            block7: {
                Component it;
                Sequence children2;
                int eachX;
                block6: {
                    Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
                    eachX = 0;
                    boolean canFitAllComponents = parent.getPreferredSize().width <= parent.getBounds().width;
                    Object[] objectArray = parent.getComponents();
                    Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"parent.components");
                    children2 = SequencesKt.filterNot((Sequence)ArraysKt.asSequence((Object[])objectArray), (Function1)((Function1)new Function1<Component, Boolean>(this){
                        final /* synthetic */ HorizontalTabLayoutWithHiddenControl this$0;

                        public final boolean invoke(Component it) {
                            return it == HorizontalTabLayoutWithHiddenControl.access$getControl$p(this.this$0);
                        }
                        {
                            this.this$0 = horizontalTabLayoutWithHiddenControl;
                            super(1);
                        }
                    }));
                    if (!canFitAllComponents) break block6;
                    Sequence $this$forEach$iv = children2;
                    boolean $i$f$forEach = false;
                    for (Object element$iv : $this$forEach$iv) {
                        Component it2 = (Component)element$iv;
                        boolean bl22 = false;
                        Component component2 = it2;
                        Intrinsics.checkNotNullExpressionValue((Object)component2, (String)"it");
                        Dimension dim = component2.getPreferredSize();
                        it2.setBounds(new Rectangle(eachX, 0, dim.width, parent.getHeight()));
                        eachX += dim.width;
                    }
                    Component component3 = this.control;
                    if (component3 == null) break block7;
                    component3.setBounds(new Rectangle(0, 0, 0, 0));
                    break block7;
                }
                List toLayout = SequencesKt.toMutableList((Sequence)children2);
                boolean bl = false;
                List toRemove2 = new ArrayList();
                Iterable element$iv = toLayout;
                boolean it2 = false;
                int bl22 = 0;
                for (Object t : element$iv) {
                    Component component4 = (Component)t;
                    int n = bl22;
                    boolean bl3 = false;
                    void v3 = it;
                    Intrinsics.checkNotNullExpressionValue((Object)v3, (String)"it");
                    int n2 = v3.getPreferredSize().width;
                    bl22 = n + n2;
                }
                int requiredWidth = bl22;
                JComponent selected2 = (JComponent)this.selected.invoke();
                Serializable serializable = this.control;
                int toFitWidth = parent.getBounds().width - (serializable != null && (serializable = serializable.getPreferredSize()) != null ? ((Dimension)serializable).width : 0);
                while (requiredWidth > toFitWidth && toLayout.size() > 1) {
                    boolean bl4;
                    Object dim;
                    Collection bl22;
                    if (Intrinsics.areEqual((Object)((Component)CollectionsKt.first((List)toLayout)), (Object)selected2) ^ true) {
                        Object object = CollectionsKt.first((List)toLayout);
                        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"toLayout.first()");
                        requiredWidth -= ((Component)object).getPreferredSize().width + 1;
                        bl22 = toRemove2;
                        dim = CollectionsKt.first((List)toLayout);
                        bl4 = false;
                        bl22.add(dim);
                        CollectionsKt.removeFirst((List)toLayout);
                        continue;
                    }
                    if (!(Intrinsics.areEqual((Object)((Component)CollectionsKt.last((List)toLayout)), (Object)selected2) ^ true)) break;
                    Object object = CollectionsKt.last((List)toLayout);
                    Intrinsics.checkNotNullExpressionValue((Object)object, (String)"toLayout.last()");
                    requiredWidth -= ((Component)object).getPreferredSize().width + 1;
                    bl22 = toRemove2;
                    dim = CollectionsKt.last((List)toLayout);
                    bl4 = false;
                    bl22.add(dim);
                    CollectionsKt.removeLast((List)toLayout);
                }
                Iterable $this$forEach$iv = toLayout;
                boolean $i$f$forEach = false;
                for (Object element$iv2 : $this$forEach$iv) {
                    Component it3 = (Component)element$iv2;
                    boolean bl5 = false;
                    Component component5 = it3;
                    Intrinsics.checkNotNullExpressionValue((Object)component5, (String)"it");
                    Dimension prefSize = component5.getPreferredSize();
                    int n = prefSize.width;
                    int n3 = toFitWidth;
                    boolean bl6 = false;
                    it3.setBounds(new Rectangle(eachX, 0, Math.min(n, n3), parent.getHeight()));
                    eachX += prefSize.width;
                }
                $this$forEach$iv = toRemove2;
                $i$f$forEach = false;
                for (Object element$iv2 : $this$forEach$iv) {
                    Component it4 = (Component)element$iv2;
                    boolean bl7 = false;
                    it4.setBounds(new Rectangle(0, 0, 0, 0));
                }
                Component component6 = this.control;
                if (component6 == null) break block7;
                Component component7 = component6;
                boolean bl8 = false;
                boolean bl9 = false;
                it = component7;
                boolean bl10 = false;
                it.setBounds(new Rectangle(new Point(toFitWidth, 0), it.getPreferredSize()));
            }
        }

        @NotNull
        public final Function0<JComponent> getSelected() {
            return this.selected;
        }

        public HorizontalTabLayoutWithHiddenControl(@NotNull Function0<? extends JComponent> selected2) {
            Intrinsics.checkNotNullParameter(selected2, (String)"selected");
            this.selected = selected2;
        }

        public static final /* synthetic */ Component access$getControl$p(HorizontalTabLayoutWithHiddenControl $this) {
            return $this.control;
        }

        public static final /* synthetic */ void access$setControl$p(HorizontalTabLayoutWithHiddenControl $this, Component component2) {
            $this.control = component2;
        }

        @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/intellij/openapi/wm/impl/content/SingleContentLayout$HorizontalTabLayoutWithHiddenControl$Companion;", "", "()V", "CONTROL", "", "intellij.platform.ide.impl"})
        public static final class Companion {
            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016\u00a8\u0006\u000e"}, d2={"Lcom/intellij/openapi/wm/impl/content/SingleContentLayout$MyInvisibleAction;", "Lcom/intellij/openapi/project/DumbAwareAction;", "Lcom/intellij/openapi/actionSystem/ex/CustomComponentAction;", "()V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "createCustomComponent", "Ljavax/swing/JComponent;", "presentation", "Lcom/intellij/openapi/actionSystem/Presentation;", "place", "", "intellij.platform.ide.impl"})
    private static final class MyInvisibleAction
    extends DumbAwareAction
    implements CustomComponentAction {
        public void actionPerformed(@NotNull AnActionEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            String string = "An operation is not supported";
            boolean bl = false;
            throw (Throwable)new IllegalStateException(string.toString());
        }

        @NotNull
        public JComponent createCustomComponent(@NotNull Presentation presentation2, @NotNull String place) {
            Intrinsics.checkNotNullParameter((Object)presentation2, (String)"presentation");
            Intrinsics.checkNotNullParameter((Object)place, (String)"place");
            return (JComponent)new NonOpaquePanel();
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\t\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002B\u0019\u0012\u0012\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004\u00a2\u0006\u0002\u0010\u0007J\u000e\u0010\n\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\fJ\u0010\u0010\r\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u0005H\u0016J\u0010\u0010\u000f\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u0005H\u0016J\u0010\u0010\u0010\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u0005H\u0016J\u0010\u0010\u0011\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u0005H\u0016J\u0010\u0010\u0012\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u0005H\u0016J\u0010\u0010\u0013\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u0005H\u0016J\u0010\u0010\u0014\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u0005H\u0016R\u001d\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0015"}, d2={"Lcom/intellij/openapi/wm/impl/content/SingleContentLayout$MyRedispatchMouseEventListener;", "Ljava/awt/event/MouseListener;", "Ljava/awt/event/MouseMotionListener;", "redispatch", "Lkotlin/Function1;", "Ljava/awt/event/MouseEvent;", "", "(Lkotlin/jvm/functions/Function1;)V", "getRedispatch", "()Lkotlin/jvm/functions/Function1;", "installOn", "component", "Ljava/awt/Component;", "mouseClicked", "e", "mouseDragged", "mouseEntered", "mouseExited", "mouseMoved", "mousePressed", "mouseReleased", "intellij.platform.ide.impl"})
    private static final class MyRedispatchMouseEventListener
    implements MouseListener,
    MouseMotionListener {
        @NotNull
        private final Function1<MouseEvent, Unit> redispatch;

        public final void installOn(@NotNull Component component2) {
            Intrinsics.checkNotNullParameter((Object)component2, (String)"component");
            component2.addMouseListener(this);
            component2.addMouseMotionListener(this);
        }

        @Override
        public void mouseClicked(@NotNull MouseEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            this.redispatch.invoke((Object)e);
        }

        @Override
        public void mousePressed(@NotNull MouseEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            this.redispatch.invoke((Object)e);
        }

        @Override
        public void mouseReleased(@NotNull MouseEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            this.redispatch.invoke((Object)e);
        }

        @Override
        public void mouseEntered(@NotNull MouseEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            this.redispatch.invoke((Object)e);
        }

        @Override
        public void mouseExited(@NotNull MouseEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            this.redispatch.invoke((Object)e);
        }

        @Override
        public void mouseDragged(@NotNull MouseEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            this.redispatch.invoke((Object)e);
        }

        @Override
        public void mouseMoved(@NotNull MouseEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            this.redispatch.invoke((Object)e);
        }

        @NotNull
        public final Function1<MouseEvent, Unit> getRedispatch() {
            return this.redispatch;
        }

        public MyRedispatchMouseEventListener(@NotNull Function1<? super MouseEvent, Unit> redispatch) {
            Intrinsics.checkNotNullParameter(redispatch, (String)"redispatch");
            this.redispatch = redispatch;
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0004\b\u0082\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004\u00a8\u0006\u0005"}, d2={"Lcom/intellij/openapi/wm/impl/content/SingleContentLayout$ToolbarType;", "", "(Ljava/lang/String;I)V", "MAIN", "CLOSE_GROUP", "intellij.platform.ide.impl"})
    private static final class ToolbarType
    extends Enum<ToolbarType> {
        public static final /* enum */ ToolbarType MAIN;
        public static final /* enum */ ToolbarType CLOSE_GROUP;
        private static final /* synthetic */ ToolbarType[] $VALUES;

        static {
            ToolbarType[] toolbarTypeArray = new ToolbarType[2];
            ToolbarType[] toolbarTypeArray2 = toolbarTypeArray;
            toolbarTypeArray[0] = MAIN = new ToolbarType();
            toolbarTypeArray[1] = CLOSE_GROUP = new ToolbarType();
            $VALUES = toolbarTypeArray;
        }

        public static ToolbarType[] values() {
            return (ToolbarType[])$VALUES.clone();
        }

        public static ToolbarType valueOf(String string) {
            return Enum.valueOf(ToolbarType.class, string);
        }
    }
}

