/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.templates;

import com.intellij.icons.AllIcons;
import com.intellij.ide.fileTemplates.impl.UrlUtil;
import com.intellij.ide.util.projectWizard.WizardContext;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.platform.ProjectTemplate;
import com.intellij.platform.ProjectTemplatesFactory;
import com.intellij.platform.templates.LocalArchivedTemplate;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ArchivedTemplatesFactory
extends ProjectTemplatesFactory {
    private static final Logger LOG = Logger.getInstance(ArchivedTemplatesFactory.class);
    static final String ZIP = ".zip";

    @NotNull
    private static URL getCustomTemplatesURL() {
        URL uRL;
        try {
            uRL = new File(ArchivedTemplatesFactory.getCustomTemplatesPath()).toURI().toURL();
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
        if (uRL == null) {
            ArchivedTemplatesFactory.$$$reportNull$$$0(0);
        }
        return uRL;
    }

    @NotNull
    static String getCustomTemplatesPath() {
        String string = PathManager.getConfigPath() + "/projectTemplates";
        if (string == null) {
            ArchivedTemplatesFactory.$$$reportNull$$$0(1);
        }
        return string;
    }

    @NotNull
    public static Path getTemplateFile(String name2) {
        Path path2 = Paths.get(ArchivedTemplatesFactory.getCustomTemplatesPath(), name2 + ZIP);
        if (path2 == null) {
            ArchivedTemplatesFactory.$$$reportNull$$$0(2);
        }
        return path2;
    }

    @Override
    public String @NotNull [] getGroups() {
        String[] stringArray = new String[]{"User-defined"};
        if (stringArray == null) {
            ArchivedTemplatesFactory.$$$reportNull$$$0(3);
        }
        return stringArray;
    }

    @Override
    public ProjectTemplate @NotNull [] createTemplates(@Nullable String group2, @NotNull WizardContext context2) {
        if (context2 == null) {
            ArchivedTemplatesFactory.$$$reportNull$$$0(4);
        }
        ProjectTemplate[] projectTemplateArray = this.createTemplates(group2);
        if (projectTemplateArray == null) {
            ArchivedTemplatesFactory.$$$reportNull$$$0(5);
        }
        return projectTemplateArray;
    }

    public ProjectTemplate @NotNull [] createTemplates(@Nullable String group2) {
        if (!"User-defined".equals(group2)) {
            if (ProjectTemplate.EMPTY_ARRAY == null) {
                ArchivedTemplatesFactory.$$$reportNull$$$0(6);
            }
            return ProjectTemplate.EMPTY_ARRAY;
        }
        List templates = null;
        URL url = ArchivedTemplatesFactory.getCustomTemplatesURL();
        try {
            for (String child2 : UrlUtil.getChildrenRelativePaths(url)) {
                if (!child2.endsWith(ZIP)) continue;
                if (templates == null) {
                    templates = new SmartList();
                }
                templates.add(new LocalArchivedTemplate(new URL(url.toExternalForm() + "/" + child2), ClassLoader.getSystemClassLoader()));
            }
        }
        catch (IOException e) {
            LOG.error((Throwable)e);
        }
        ProjectTemplate[] projectTemplateArray = ContainerUtil.isEmpty(templates) ? ProjectTemplate.EMPTY_ARRAY : templates.toArray(ProjectTemplate.EMPTY_ARRAY);
        if (projectTemplateArray == null) {
            ArchivedTemplatesFactory.$$$reportNull$$$0(7);
        }
        return projectTemplateArray;
    }

    @Override
    public int getGroupWeight(String group2) {
        return "User-defined".equals(group2) ? -2 : 0;
    }

    @Override
    public Icon getGroupIcon(String group2) {
        return "User-defined".equals(group2) ? AllIcons.General.User : super.getGroupIcon(group2);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 4: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 4: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/platform/templates/ArchivedTemplatesFactory";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getCustomTemplatesURL";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getCustomTemplatesPath";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getTemplateFile";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getGroups";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/platform/templates/ArchivedTemplatesFactory";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "createTemplates";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createTemplates";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 4: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

