/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.formatter.common;

import com.intellij.formatting.Alignment;
import com.intellij.formatting.Block;
import com.intellij.formatting.FormattingContext;
import com.intellij.formatting.FormattingModel;
import com.intellij.formatting.FormattingModelBuilder;
import com.intellij.formatting.Indent;
import com.intellij.formatting.Wrap;
import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageFormatting;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.formatter.common.InjectedLanguageBlockWrapper;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class InjectedLanguageBlockBuilder {
    private static final Logger LOG = Logger.getInstance(InjectedLanguageBlockBuilder.class);

    @NotNull
    public Block createInjectedBlock(@NotNull ASTNode node2, @NotNull Block originalBlock, Indent indent, int offset, TextRange range2, @NotNull Language language2) {
        if (node2 == null) {
            InjectedLanguageBlockBuilder.$$$reportNull$$$0(0);
        }
        if (originalBlock == null) {
            InjectedLanguageBlockBuilder.$$$reportNull$$$0(1);
        }
        if (language2 == null) {
            InjectedLanguageBlockBuilder.$$$reportNull$$$0(2);
        }
        return new InjectedLanguageBlockWrapper(originalBlock, offset, range2, indent, language2);
    }

    public abstract CodeStyleSettings getSettings();

    protected boolean supportsMultipleFragments() {
        return false;
    }

    public abstract boolean canProcessFragment(String var1, ASTNode var2);

    public abstract Block createBlockBeforeInjection(ASTNode var1, Wrap var2, Alignment var3, Indent var4, TextRange var5);

    public abstract Block createBlockAfterInjection(ASTNode var1, Wrap var2, Alignment var3, Indent var4, TextRange var5);

    public boolean addInjectedBlocks(List<? super Block> result2, ASTNode injectionHost, Wrap wrap2, Alignment alignment, Indent indent) {
        Ref lastInjectionEndOffset = new Ref((Object)0);
        PsiLanguageInjectionHost.InjectedPsiVisitor injectedPsiVisitor = (injectedPsi, places) -> {
            Language childLanguage;
            FormattingModelBuilder builder2;
            String childText;
            if (places.isEmpty() || places.size() != 1 && !this.supportsMultipleFragments()) {
                return;
            }
            PsiLanguageInjectionHost.Shred firstShred = (PsiLanguageInjectionHost.Shred)places.get(0);
            PsiLanguageInjectionHost.Shred lastShred = (PsiLanguageInjectionHost.Shred)places.get(places.size() - 1);
            PsiLanguageInjectionHost shredHost = firstShred.getHost();
            if (shredHost == null) {
                return;
            }
            for (PsiLanguageInjectionHost.Shred place : places) {
                if (place.getHost() == shredHost) continue;
                return;
            }
            TextRange injectionRange = new TextRange(firstShred.getRangeInsideHost().getStartOffset(), lastShred.getRangeInsideHost().getEndOffset());
            ASTNode node2 = shredHost.getNode();
            if (node2 == null || !injectionHost.getTextRange().contains(injectionRange.shiftRight(node2.getStartOffset()))) {
                return;
            }
            if (node2 != injectionHost) {
                int shift = 0;
                boolean canProcess = false;
                ASTNode prev2 = injectionHost;
                for (ASTNode n = injectionHost.getTreeParent(); n != null; n = n.getTreeParent()) {
                    shift += n.getStartOffset() - prev2.getStartOffset();
                    if (n == node2) {
                        injectionRange = injectionRange.shiftRight(shift);
                        canProcess = true;
                        break;
                    }
                    prev2 = n;
                }
                if (!canProcess) {
                    return;
                }
            }
            if ((injectionHost.getTextLength() == injectionRange.getEndOffset() && injectionRange.getStartOffset() == 0 || this.canProcessFragment((childText = injectionHost.getText()).substring(0, injectionRange.getStartOffset()), injectionHost) && this.canProcessFragment(childText.substring(injectionRange.getEndOffset()), injectionHost)) && (builder2 = LanguageFormatting.INSTANCE.forContext(childLanguage = injectedPsi.getLanguage(), injectionHost.getPsi())) != null) {
                int startOffset = injectionRange.getStartOffset();
                int endOffset = injectionRange.getEndOffset();
                TextRange range2 = injectionHost.getTextRange();
                int prefixLength = firstShred.getPrefix().length();
                int suffixLength = lastShred.getSuffix().length();
                int childOffset = range2.getStartOffset();
                if ((Integer)lastInjectionEndOffset.get() < startOffset) {
                    result2.add(this.createBlock(injectionHost, wrap2, alignment, indent, new TextRange(((Integer)lastInjectionEndOffset.get()).intValue(), startOffset)));
                }
                this.addInjectedLanguageBlocks(result2, injectedPsi, indent, childOffset + startOffset, new TextRange(prefixLength, injectedPsi.getTextLength() - suffixLength), places);
                lastInjectionEndOffset.set((Object)endOffset);
            }
        };
        PsiElement injectionHostPsi = injectionHost.getPsi();
        PsiFile containingFile = injectionHostPsi.getContainingFile();
        InjectedLanguageManager.getInstance((Project)containingFile.getProject()).enumerateEx(injectionHostPsi, containingFile, true, injectedPsiVisitor);
        if ((Integer)lastInjectionEndOffset.get() > 0) {
            if ((Integer)lastInjectionEndOffset.get() < injectionHost.getTextLength()) {
                result2.add((Block)this.createBlock(injectionHost, wrap2, alignment, indent, new TextRange(((Integer)lastInjectionEndOffset.get()).intValue(), injectionHost.getTextLength())));
            }
            return true;
        }
        return false;
    }

    private Block createBlock(ASTNode injectionHost, Wrap wrap2, Alignment alignment, Indent indent, TextRange range2) {
        if (range2.getStartOffset() == 0) {
            ASTNode leaf = injectionHost.findLeafElementAt(range2.getEndOffset() - 1);
            return this.createBlockBeforeInjection(leaf, wrap2, alignment, indent, range2.shiftRight(injectionHost.getStartOffset()));
        }
        ASTNode leaf = injectionHost.findLeafElementAt(range2.getStartOffset());
        return this.createBlockAfterInjection(leaf, wrap2, alignment, indent, range2.shiftRight(injectionHost.getStartOffset()));
    }

    protected void addInjectedLanguageBlocks(List<? super Block> result2, PsiFile injectedFile, Indent indent, int offset, TextRange injectedEditableRange, List<PsiLanguageInjectionHost.Shred> shreds) {
        this.addInjectedLanguageBlockWrapper(result2, (ASTNode)injectedFile.getNode(), indent, offset, injectedEditableRange);
    }

    public void addInjectedLanguageBlockWrapper(List<? super Block> result2, ASTNode injectedNode, Indent indent, int offset, @Nullable TextRange range2) {
        if (InjectedLanguageBlockBuilder.isEmptyRange(injectedNode, range2)) {
            return;
        }
        PsiElement childPsi = injectedNode.getPsi();
        Language childLanguage = childPsi.getLanguage();
        FormattingModelBuilder builder2 = LanguageFormatting.INSTANCE.forContext(childLanguage, childPsi);
        LOG.assertTrue(builder2 != null);
        FormattingModel childModel = builder2.createModel(FormattingContext.create((PsiElement)childPsi, (CodeStyleSettings)this.getSettings()));
        Block original = childModel.getRootBlock();
        if (original.isLeaf() && !injectedNode.getText().trim().isEmpty() || !original.getSubBlocks().isEmpty()) {
            result2.add((Block)this.createInjectedBlock(injectedNode, original, indent, offset, range2, childLanguage));
        }
    }

    protected static boolean isEmptyRange(@NotNull ASTNode injectedNode, @Nullable TextRange range2) {
        if (injectedNode == null) {
            InjectedLanguageBlockBuilder.$$$reportNull$$$0(3);
        }
        return range2 != null && (range2.getLength() == 0 || StringUtil.isEmptyOrSpaces((String)range2.substring(injectedNode.getText())));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "originalBlock";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "language";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "injectedNode";
                break;
            }
        }
        objectArray2[1] = "com/intellij/psi/formatter/common/InjectedLanguageBlockBuilder";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "createInjectedBlock";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "isEmptyRange";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

