/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.cache.impl;

import com.intellij.lexer.DelegateLexer;
import com.intellij.lexer.Lexer;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.psi.impl.cache.impl.IndexPatternUtil;
import com.intellij.psi.impl.cache.impl.OccurrenceConsumer;
import com.intellij.psi.impl.cache.impl.id.IdTableBuilding;
import com.intellij.psi.search.IndexPattern;
import com.intellij.util.text.CharArrayUtil;
import gnu.trove.TIntArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class BaseFilterLexer
extends DelegateLexer
implements IdTableBuilding.ScanWordProcessor {
    private static final Logger LOG = Logger.getInstance(BaseFilterLexer.class);
    private final OccurrenceConsumer myOccurrenceConsumer;
    private int myTodoScannedBound = 0;
    private int myOccurenceMask;
    private TodoScanningState myTodoScanningState;
    private CharSequence myCachedBufferSequence;
    private char[] myCachedArraySequence;

    protected BaseFilterLexer(Lexer originalLexer, OccurrenceConsumer occurrenceConsumer) {
        super(originalLexer);
        this.myOccurrenceConsumer = occurrenceConsumer;
    }

    protected final void advanceTodoItemCountsInToken() {
        if (!this.myOccurrenceConsumer.isNeedToDo()) {
            return;
        }
        int start2 = this.getTokenStart();
        int end = this.getTokenEnd();
        if ((start2 = Math.max(start2, this.myTodoScannedBound)) >= end) {
            return;
        }
        CharSequence input = this.myCachedBufferSequence.subSequence(start2, end);
        if (this.myTodoScanningState == null) {
            this.myTodoScanningState = BaseFilterLexer.createTodoScanningState(IndexPatternUtil.getIndexPatterns());
        }
        BaseFilterLexer.advanceTodoItemsCount(input, this.myOccurrenceConsumer, this.myTodoScanningState);
        this.myTodoScannedBound = end;
    }

    @NotNull
    public static TodoScanningState createTodoScanningState(IndexPattern[] patterns) {
        Matcher[] matchers = new Matcher[patterns.length];
        TodoScanningState todoScanningState = new TodoScanningState(patterns, matchers);
        for (int i2 = 0; i2 < patterns.length; ++i2) {
            Pattern pattern = patterns[i2].getOptimizedIndexingPattern();
            if (pattern == null) continue;
            matchers[i2] = pattern.matcher("");
        }
        TodoScanningState todoScanningState2 = todoScanningState;
        if (todoScanningState2 == null) {
            BaseFilterLexer.$$$reportNull$$$0(0);
        }
        return todoScanningState2;
    }

    public static void advanceTodoItemsCount(CharSequence input, OccurrenceConsumer consumer2, TodoScanningState todoScanningState) {
        todoScanningState.myOccurrences.resetQuick();
        for (int i2 = todoScanningState.myMatchers.length - 1; i2 >= 0; --i2) {
            Matcher matcher = todoScanningState.myMatchers[i2];
            if (matcher == null) continue;
            matcher.reset(input);
            try {
                while (matcher.find()) {
                    ProgressManager.checkCanceled();
                    int start2 = matcher.start();
                    if (start2 == matcher.end() || todoScanningState.myOccurrences.indexOf(start2) != -1) continue;
                    consumer2.incTodoOccurrence(todoScanningState.myPatterns[i2]);
                    todoScanningState.myOccurrences.add(start2);
                }
                continue;
            }
            catch (StackOverflowError error) {
                LOG.error((Throwable)error);
            }
        }
    }

    @Override
    public final void run(CharSequence chars, char @Nullable [] charsArray, int start2, int end) {
        this.myOccurrenceConsumer.addOccurrence(chars, charsArray, start2, end, this.myOccurenceMask);
    }

    protected final void addOccurrenceInToken(int occurrenceMask) {
        this.myOccurrenceConsumer.addOccurrence(this.myCachedBufferSequence, this.myCachedArraySequence, this.getTokenStart(), this.getTokenEnd(), occurrenceMask);
    }

    protected final void addOccurrenceInToken(int occurrenceMask, int offset, int length) {
        this.myOccurrenceConsumer.addOccurrence(this.myCachedBufferSequence, this.myCachedArraySequence, this.getTokenStart() + offset, Math.min(this.getTokenStart() + offset + length, this.getTokenEnd()), occurrenceMask);
    }

    protected final void scanWordsInToken(int occurrenceMask, boolean mayHaveFileRefs, boolean mayHaveEscapes) {
        this.myOccurenceMask = occurrenceMask;
        int start2 = this.getTokenStart();
        int end = this.getTokenEnd();
        IdTableBuilding.scanWords(this, this.myCachedBufferSequence, this.myCachedArraySequence, start2, end, mayHaveEscapes);
        if (mayHaveFileRefs) {
            this.processPossibleComplexFileName(this.myCachedBufferSequence, this.myCachedArraySequence, start2, end);
        }
    }

    private void processPossibleComplexFileName(CharSequence chars, char[] cachedArraySequence, int startOffset, int endOffset) {
        int offset = BaseFilterLexer.findCharsWithinRange(chars, startOffset, endOffset, "/\\");
        offset = Math.min(offset, endOffset);
        int start2 = startOffset;
        while (start2 < endOffset) {
            if (start2 != offset) {
                this.myOccurrenceConsumer.addOccurrence(chars, cachedArraySequence, start2, offset, 8);
            }
            start2 = offset + 1;
            offset = Math.min(endOffset, BaseFilterLexer.findCharsWithinRange(chars, start2, endOffset, "/\\"));
        }
    }

    private static int findCharsWithinRange(CharSequence chars, int startOffset, int endOffset, String charsToFind) {
        while (startOffset < endOffset) {
            if (charsToFind.indexOf(chars.charAt(startOffset)) != -1) {
                return startOffset;
            }
            ++startOffset;
        }
        return startOffset;
    }

    public void start(@NotNull CharSequence buffer, int startOffset, int endOffset, int initialState) {
        if (buffer == null) {
            BaseFilterLexer.$$$reportNull$$$0(1);
        }
        super.start(buffer, startOffset, endOffset, initialState);
        this.myCachedBufferSequence = this.getBufferSequence();
        this.myCachedArraySequence = CharArrayUtil.fromSequenceWithoutCopying((CharSequence)this.myCachedBufferSequence);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/impl/cache/impl/BaseFilterLexer";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buffer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "createTodoScanningState";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/impl/cache/impl/BaseFilterLexer";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "start";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class TodoScanningState {
        final IndexPattern[] myPatterns;
        final Matcher[] myMatchers;
        final TIntArrayList myOccurrences;

        public TodoScanningState(IndexPattern[] patterns, Matcher[] matchers) {
            this.myPatterns = patterns;
            this.myMatchers = matchers;
            this.myOccurrences = new TIntArrayList(1);
        }
    }
}

