/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.codeStyle;

import com.intellij.application.options.CodeStyle;
import com.intellij.diagnostic.PluginException;
import com.intellij.formatting.FormatterTagHandler;
import com.intellij.formatting.FormattingRangesInfo;
import com.intellij.lang.ASTNode;
import com.intellij.lang.CompositeLanguage;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageFormatting;
import com.intellij.openapi.diagnostic.Attachment;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.diagnostic.RuntimeExceptionWithAttachments;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.impl.source.codeStyle.PostFormatProcessor;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public class CoreCodeStyleUtil {
    private static final Logger LOG = Logger.getInstance(CoreCodeStyleUtil.class);
    private static final ThreadLocal<ProcessingUnderProgressInfo> SEQUENTIAL_PROCESSING_ALLOWED = ThreadLocal.withInitial(() -> new ProcessingUnderProgressInfo());

    private CoreCodeStyleUtil() {
    }

    public static PsiElement postProcessElement(@NotNull PsiFile file2, @NotNull PsiElement formatted) {
        if (file2 == null) {
            CoreCodeStyleUtil.$$$reportNull$$$0(0);
        }
        if (formatted == null) {
            CoreCodeStyleUtil.$$$reportNull$$$0(1);
        }
        PsiElement result2 = formatted;
        CodeStyleSettings settingsForFile = CodeStyle.getSettings((PsiFile)file2);
        if (settingsForFile.FORMATTER_TAGS_ENABLED && formatted instanceof PsiFile) {
            CoreCodeStyleUtil.postProcessEnabledRanges((PsiFile)formatted, formatted.getTextRange(), settingsForFile);
        } else {
            boolean brokenProcFound = false;
            for (PostFormatProcessor postFormatProcessor : PostFormatProcessor.EP_NAME.getExtensionList()) {
                try {
                    if ((result2 = postFormatProcessor.processElement(result2, settingsForFile)).isValid() || brokenProcFound) continue;
                    LOG.error((Throwable)new RuntimeExceptionWithAttachments(String.format("PSI crash detected: processor=%s, result=%s", postFormatProcessor, result2), new Attachment[]{new Attachment("text", result2.getText())}));
                    brokenProcFound = true;
                }
                catch (ProcessCanceledException e) {
                    throw e;
                }
                catch (Throwable e) {
                    LOG.error((Throwable)PluginException.createByClass((Throwable)e, postFormatProcessor.getClass()));
                }
            }
        }
        return result2;
    }

    public static List<RangeFormatInfo> getRangeFormatInfoList(@NotNull PsiFile file2, @NotNull FormattingRangesInfo ranges) {
        if (file2 == null) {
            CoreCodeStyleUtil.$$$reportNull$$$0(2);
        }
        if (ranges == null) {
            CoreCodeStyleUtil.$$$reportNull$$$0(3);
        }
        SmartPointerManager smartPointerManager = SmartPointerManager.getInstance((Project)file2.getProject());
        ArrayList<RangeFormatInfo> infos = new ArrayList<RangeFormatInfo>();
        for (TextRange range2 : ranges.getTextRanges()) {
            PsiElement start2 = CoreCodeStyleUtil.findElementInTreeWithFormatterEnabled(file2, range2.getStartOffset());
            PsiElement end = CoreCodeStyleUtil.findElementInTreeWithFormatterEnabled(file2, range2.getEndOffset());
            if (start2 != null && !start2.isValid()) {
                LOG.error("start=" + start2 + "; file=" + file2);
            }
            if (end != null && !end.isValid()) {
                LOG.error("end=" + start2 + "; end=" + file2);
            }
            boolean formatFromStart = range2.getStartOffset() == 0;
            boolean formatToEnd = range2.getEndOffset() == file2.getTextLength();
            infos.add(new RangeFormatInfo(start2 == null ? null : smartPointerManager.createSmartPsiElementPointer(start2), end == null ? null : smartPointerManager.createSmartPsiElementPointer(end), formatFromStart, formatToEnd));
        }
        return infos;
    }

    public static void postProcessRanges(@NotNull PsiFile file2, @NotNull List<RangeFormatInfo> rangeFormatInfoList, @NotNull Consumer<TextRange> postProcessFormatter) {
        if (file2 == null) {
            CoreCodeStyleUtil.$$$reportNull$$$0(4);
        }
        if (rangeFormatInfoList == null) {
            CoreCodeStyleUtil.$$$reportNull$$$0(5);
        }
        if (postProcessFormatter == null) {
            CoreCodeStyleUtil.$$$reportNull$$$0(6);
        }
        SmartPointerManager smartPointerManager = SmartPointerManager.getInstance((Project)file2.getProject());
        for (RangeFormatInfo info2 : rangeFormatInfoList) {
            PsiElement endElement;
            PsiElement startElement = info2.startPointer == null ? null : info2.startPointer.getElement();
            PsiElement psiElement = endElement = info2.endPointer == null ? null : info2.endPointer.getElement();
            if ((startElement != null || info2.fromStart) && (endElement != null || info2.toEnd)) {
                TextRange currRange = new TextRange(info2.fromStart ? 0 : startElement.getTextRange().getStartOffset(), info2.toEnd ? file2.getTextLength() : endElement.getTextRange().getEndOffset());
                postProcessFormatter.accept(currRange);
            }
            if (info2.startPointer != null) {
                smartPointerManager.removePointer(info2.startPointer);
            }
            if (info2.endPointer == null) continue;
            smartPointerManager.removePointer(info2.endPointer);
        }
    }

    public static void postProcessText(@NotNull PsiFile file2, @NotNull TextRange textRange) {
        if (file2 == null) {
            CoreCodeStyleUtil.$$$reportNull$$$0(7);
        }
        if (textRange == null) {
            CoreCodeStyleUtil.$$$reportNull$$$0(8);
        }
        if (!CoreCodeStyleUtil.getSettings((PsiFile)file2).FORMATTER_TAGS_ENABLED) {
            TextRange currentRange = textRange;
            for (PostFormatProcessor myPostFormatProcessor : PostFormatProcessor.EP_NAME.getExtensionList()) {
                currentRange = myPostFormatProcessor.processText(file2, currentRange, CoreCodeStyleUtil.getSettings(file2));
            }
        } else {
            CoreCodeStyleUtil.postProcessEnabledRanges(file2, textRange, CoreCodeStyleUtil.getSettings(file2));
        }
    }

    private static void postProcessEnabledRanges(@NotNull PsiFile file2, @NotNull TextRange range2, CodeStyleSettings settings) {
        if (file2 == null) {
            CoreCodeStyleUtil.$$$reportNull$$$0(9);
        }
        if (range2 == null) {
            CoreCodeStyleUtil.$$$reportNull$$$0(10);
        }
        List<TextRange> enabledRanges = new FormatterTagHandler(CoreCodeStyleUtil.getSettings(file2)).getEnabledRanges((ASTNode)file2.getNode(), range2);
        int delta = 0;
        for (TextRange enabledRange : enabledRanges) {
            enabledRange = enabledRange.shiftRight(delta);
            for (PostFormatProcessor processor2 : PostFormatProcessor.EP_NAME.getExtensionList()) {
                TextRange processedRange = processor2.processText(file2, enabledRange, settings);
                delta += processedRange.getLength() - enabledRange.getLength();
            }
        }
    }

    @Nullable
    public static PsiElement findElementInTreeWithFormatterEnabled(PsiFile file2, int offset) {
        PsiElement bottomost = file2.findElementAt(offset);
        if (bottomost != null && LanguageFormatting.INSTANCE.forContext(bottomost) != null) {
            return bottomost;
        }
        Language fileLang = file2.getLanguage();
        if (fileLang instanceof CompositeLanguage) {
            return file2.getViewProvider().findElementAt(offset, fileLang);
        }
        return bottomost;
    }

    @ApiStatus.Internal
    public static void setSequentialProcessingAllowed(boolean allowed) {
        ProcessingUnderProgressInfo info2 = SEQUENTIAL_PROCESSING_ALLOWED.get();
        if (allowed) {
            info2.decrement();
        } else {
            info2.increment();
        }
    }

    static boolean isSequentialProcessingAllowed() {
        return SEQUENTIAL_PROCESSING_ALLOWED.get().isAllowed();
    }

    private static CodeStyleSettings getSettings(@NotNull PsiFile file2) {
        if (file2 == null) {
            CoreCodeStyleUtil.$$$reportNull$$$0(11);
        }
        return CodeStyle.getSettings((PsiFile)file2);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "formatted";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ranges";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rangeFormatInfoList";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "postProcessFormatter";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "textRange";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "range";
                break;
            }
        }
        objectArray2[1] = "com/intellij/psi/impl/source/codeStyle/CoreCodeStyleUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "postProcessElement";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "getRangeFormatInfoList";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "postProcessRanges";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "postProcessText";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "postProcessEnabledRanges";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[2] = "getSettings";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class ProcessingUnderProgressInfo {
        private static final long DURATION_TIME = TimeUnit.MILLISECONDS.convert(5L, TimeUnit.SECONDS);
        private int myCount;
        private long myEndTime;

        private ProcessingUnderProgressInfo() {
        }

        public void increment() {
            if (this.myCount > 0 && System.currentTimeMillis() > this.myEndTime) {
                this.myCount = 0;
            }
            ++this.myCount;
            this.myEndTime = System.currentTimeMillis() + DURATION_TIME;
        }

        public void decrement() {
            if (this.myCount <= 0) {
                return;
            }
            --this.myCount;
        }

        public boolean isAllowed() {
            return this.myCount <= 0 || System.currentTimeMillis() >= this.myEndTime;
        }
    }

    public static class RangeFormatInfo {
        private final SmartPsiElementPointer<?> startPointer;
        private final SmartPsiElementPointer<?> endPointer;
        private final boolean fromStart;
        private final boolean toEnd;

        RangeFormatInfo(@Nullable SmartPsiElementPointer<?> startPointer, @Nullable SmartPsiElementPointer<?> endPointer, boolean fromStart, boolean toEnd) {
            this.startPointer = startPointer;
            this.endPointer = endPointer;
            this.fromStart = fromStart;
            this.toEnd = toEnd;
        }
    }
}

