/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.codeStyle.json;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.intellij.application.options.codeStyle.properties.AbstractCodeStylePropertyMapper;
import com.intellij.application.options.codeStyle.properties.CodeStylePropertyAccessor;
import com.intellij.openapi.options.SchemeExporter;
import com.intellij.openapi.project.Project;
import com.intellij.psi.codeStyle.CodeStyleScheme;
import com.intellij.psi.impl.source.codeStyle.json.CodeStyleSchemeJsonDescriptor;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.lang.reflect.Type;
import java.nio.charset.StandardCharsets;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CodeStyleSchemeJsonExporter
extends SchemeExporter<CodeStyleScheme> {
    public static final String CODE_STYLE_JSON_EXT = "codestyle.json";

    public void exportScheme(@Nullable Project project, @NotNull CodeStyleScheme scheme2, @NotNull OutputStream outputStream) {
        if (scheme2 == null) {
            CodeStyleSchemeJsonExporter.$$$reportNull$$$0(0);
        }
        if (outputStream == null) {
            CodeStyleSchemeJsonExporter.$$$reportNull$$$0(1);
        }
        this.exportScheme(scheme2, outputStream, null);
    }

    public void exportScheme(@NotNull CodeStyleScheme scheme2, @NotNull OutputStream outputStream, @Nullable List<String> languageNames) {
        if (scheme2 == null) {
            CodeStyleSchemeJsonExporter.$$$reportNull$$$0(2);
        }
        if (outputStream == null) {
            CodeStyleSchemeJsonExporter.$$$reportNull$$$0(3);
        }
        GsonBuilder builder2 = new GsonBuilder();
        builder2.setPrettyPrinting();
        builder2.registerTypeAdapter(CodeStyleSchemeJsonDescriptor.PropertyListHolder.class, (Object)new JsonSerializer<CodeStyleSchemeJsonDescriptor.PropertyListHolder>(){

            public JsonElement serialize(CodeStyleSchemeJsonDescriptor.PropertyListHolder src, Type typeOfSrc, JsonSerializationContext context2) {
                JsonObject o = new JsonObject();
                for (AbstractCodeStylePropertyMapper mapper2 : src) {
                    JsonObject langProperties = CodeStyleSchemeJsonExporter.serializeMapper(mapper2);
                    o.add(mapper2.getLanguageDomainId(), (JsonElement)langProperties);
                }
                return o;
            }
        });
        Gson gson2 = builder2.create();
        String json = gson2.toJson((Object)new CodeStyleSchemeJsonDescriptor(scheme2, languageNames));
        try (PrintWriter writer = new PrintWriter(new OutputStreamWriter(outputStream, StandardCharsets.UTF_8));){
            writer.write(json);
        }
    }

    private static JsonObject serializeMapper(AbstractCodeStylePropertyMapper src) {
        JsonObject o = new JsonObject();
        for (String name2 : src.enumProperties()) {
            CodeStylePropertyAccessor accessor2 = src.getAccessor(name2);
            if (accessor2 == null) continue;
            Object externalized = accessor2.get();
            if (externalized instanceof String) {
                o.addProperty(name2, (String)externalized);
                continue;
            }
            if (externalized instanceof Integer) {
                o.addProperty(name2, (Number)((Integer)externalized));
                continue;
            }
            if (externalized instanceof Boolean) {
                o.addProperty(name2, (Boolean)externalized);
                continue;
            }
            if (!(externalized instanceof List)) continue;
            JsonArray array2 = new JsonArray();
            for (Object element2 : (List)externalized) {
                if (element2 instanceof String) {
                    array2.add((String)element2);
                    continue;
                }
                if (!(element2 instanceof Integer)) continue;
                array2.add((Number)((Integer)element2));
            }
            o.add(name2, (JsonElement)array2);
        }
        return o;
    }

    public String getExtension() {
        return CODE_STYLE_JSON_EXT;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "scheme";
                break;
            }
            case 1: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[0] = "outputStream";
                break;
            }
        }
        objectArray[1] = "com/intellij/psi/impl/source/codeStyle/json/CodeStyleSchemeJsonExporter";
        objectArray[2] = "exportScheme";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

