/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.html.dtd;

import com.intellij.documentation.mdn.MdnDocumentationKt;
import com.intellij.documentation.mdn.MdnSymbolDocumentation;
import com.intellij.html.impl.RelaxedHtmlFromSchemaElementDescriptor;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.impl.source.html.dtd.HtmlAttributeDescriptorImpl;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.xml.XmlAttributeDescriptor;
import com.intellij.xml.XmlElementDescriptor;
import com.intellij.xml.XmlNSDescriptor;
import com.intellij.xml.impl.dtd.BaseXmlElementDescriptorImpl;
import com.intellij.xml.impl.schema.XmlNSDescriptorImpl;
import com.intellij.xml.util.HtmlUtil;
import com.intellij.xml.util.XmlUtil;
import java.util.HashMap;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class HtmlElementDescriptorImpl
extends BaseXmlElementDescriptorImpl {
    private final Set<String> ourHtml4DeprecatedTags = ContainerUtil.newHashSet((Object[])new String[]{"applet", "basefont", "center", "dir", "font", "frame", "frameset", "isindex", "menu", "noframes", "s", "strike", "u", "xmp"});
    private final XmlElementDescriptor myDelegate;
    private final boolean myRelaxed;
    private final boolean myCaseSensitive;

    public HtmlElementDescriptorImpl(XmlElementDescriptor _delegate, boolean relaxed, boolean caseSensitive) {
        this.myDelegate = _delegate;
        this.myRelaxed = relaxed;
        this.myCaseSensitive = caseSensitive;
    }

    public String getQualifiedName() {
        return this.myDelegate.getQualifiedName();
    }

    public String getDefaultName() {
        return this.myDelegate.getDefaultName();
    }

    @Override
    protected final XmlElementDescriptor[] doCollectXmlDescriptors(XmlTag context2) {
        XmlElementDescriptor[] elementsDescriptors = this.myDelegate.getElementsDescriptors(context2);
        XmlElementDescriptor[] temp = new XmlElementDescriptor[elementsDescriptors.length];
        for (int i2 = 0; i2 < elementsDescriptors.length; ++i2) {
            temp[i2] = new HtmlElementDescriptorImpl(elementsDescriptors[i2], this.myRelaxed, this.myCaseSensitive);
        }
        return temp;
    }

    @Override
    public XmlElementDescriptor getElementDescriptor(XmlTag element2, XmlTag contextTag) {
        String name2 = this.toLowerCaseIfNeeded(element2.getName());
        XmlElementDescriptor xmlElementDescriptor = this.getElementDescriptor(name2, contextTag);
        if (xmlElementDescriptor == null && "html".equals(this.getName())) {
            XmlElementDescriptor bodyDescriptor;
            XmlElementDescriptor headDescriptor;
            XmlTag head = null;
            XmlTag body = null;
            for (XmlTag child2 : PsiTreeUtil.getChildrenOfTypeAsList((PsiElement)contextTag, XmlTag.class)) {
                if ("head".equals(child2.getName())) {
                    head = child2;
                }
                if (!"body".equals(child2.getName())) continue;
                body = child2;
            }
            if (head == null && (body == null || element2.getTextOffset() < body.getTextOffset()) && (headDescriptor = this.getElementDescriptor("head", contextTag)) != null) {
                xmlElementDescriptor = headDescriptor.getElementDescriptor(element2, contextTag);
            }
            if (xmlElementDescriptor == null && body == null && (bodyDescriptor = this.getElementDescriptor("body", contextTag)) != null) {
                xmlElementDescriptor = bodyDescriptor.getElementDescriptor(element2, contextTag);
            }
        }
        if (xmlElementDescriptor == null && this.myRelaxed) {
            xmlElementDescriptor = RelaxedHtmlFromSchemaElementDescriptor.getRelaxedDescriptor(this, element2);
        }
        return xmlElementDescriptor;
    }

    @Override
    protected HashMap<String, XmlElementDescriptor> collectElementDescriptorsMap(XmlTag element2) {
        XmlElementDescriptor[] elementDescriptors;
        HashMap<String, XmlElementDescriptor> hashMap = new HashMap<String, XmlElementDescriptor>();
        for (XmlElementDescriptor elementDescriptor : elementDescriptors = this.myDelegate.getElementsDescriptors(element2)) {
            hashMap.put(this.toLowerCaseIfNeeded(elementDescriptor.getName((PsiElement)element2)), new HtmlElementDescriptorImpl(elementDescriptor, this.myRelaxed, this.myCaseSensitive));
        }
        return hashMap;
    }

    @Override
    protected XmlAttributeDescriptor[] collectAttributeDescriptors(XmlTag context2) {
        XmlAttributeDescriptor[] attributesDescriptors = this.myDelegate.getAttributesDescriptors(context2);
        XmlAttributeDescriptor[] temp = new XmlAttributeDescriptor[attributesDescriptors.length];
        for (int i2 = 0; i2 < attributesDescriptors.length; ++i2) {
            temp[i2] = new HtmlAttributeDescriptorImpl(attributesDescriptors[i2], this.myCaseSensitive);
        }
        return temp;
    }

    @Override
    public XmlAttributeDescriptor getAttributeDescriptor(String attributeName, XmlTag context2) {
        XmlNSDescriptor nsdescriptor;
        String prefix;
        String caseSensitiveAttributeName = this.toLowerCaseIfNeeded(attributeName);
        XmlAttributeDescriptor descriptor2 = super.getAttributeDescriptor(caseSensitiveAttributeName, context2);
        if (descriptor2 == null) {
            descriptor2 = RelaxedHtmlFromSchemaElementDescriptor.getAttributeDescriptorFromFacelets(attributeName, context2);
        }
        if (descriptor2 == null && "xml".equals(prefix = XmlUtil.findPrefixByQualifiedName(attributeName)) && (nsdescriptor = context2.getNSDescriptor("http://www.w3.org/XML/1998/namespace", true)) instanceof XmlNSDescriptorImpl) {
            descriptor2 = ((XmlNSDescriptorImpl)nsdescriptor).getAttribute(XmlUtil.findLocalNameByQualifiedName(caseSensitiveAttributeName), "http://www.w3.org/XML/1998/namespace", context2);
        }
        if (descriptor2 == null && HtmlUtil.isHtml5Context((XmlElement)context2)) {
            descriptor2 = this.myDelegate.getAttributeDescriptor(attributeName, context2);
        }
        return descriptor2;
    }

    @Override
    protected HashMap<String, XmlAttributeDescriptor> collectAttributeDescriptorsMap(XmlTag context2) {
        XmlAttributeDescriptor[] elementAttributeDescriptors;
        HashMap<String, XmlAttributeDescriptor> hashMap = new HashMap<String, XmlAttributeDescriptor>();
        for (XmlAttributeDescriptor attributeDescriptor : elementAttributeDescriptors = this.myDelegate.getAttributesDescriptors(context2)) {
            hashMap.put(this.toLowerCaseIfNeeded(attributeDescriptor.getName((PsiElement)context2)), new HtmlAttributeDescriptorImpl(attributeDescriptor, this.myCaseSensitive));
        }
        return hashMap;
    }

    public XmlNSDescriptor getNSDescriptor() {
        return this.myDelegate.getNSDescriptor();
    }

    public int getContentType() {
        return this.myDelegate.getContentType();
    }

    public PsiElement getDeclaration() {
        return this.myDelegate.getDeclaration();
    }

    public String getName(PsiElement context2) {
        return this.myDelegate.getName(context2);
    }

    public String getName() {
        return this.myDelegate.getName();
    }

    public void init(PsiElement element2) {
        this.myDelegate.init(element2);
    }

    public Object @NotNull [] getDependencies() {
        Object[] objectArray = this.myDelegate.getDependencies();
        if (objectArray == null) {
            HtmlElementDescriptorImpl.$$$reportNull$$$0(0);
        }
        return objectArray;
    }

    @Override
    public XmlAttributeDescriptor[] getAttributesDescriptors(XmlTag context2) {
        return RelaxedHtmlFromSchemaElementDescriptor.addAttrDescriptorsForFacelets(context2, this.getDefaultAttributeDescriptors(context2));
    }

    public XmlAttributeDescriptor[] getDefaultAttributeDescriptors(XmlTag context2) {
        return super.getAttributesDescriptors(context2);
    }

    public XmlAttributeDescriptor getDefaultAttributeDescriptor(String attributeName, XmlTag context2) {
        String caseSensitiveAttributeName = this.toLowerCaseIfNeeded(attributeName);
        return super.getAttributeDescriptor(caseSensitiveAttributeName, context2);
    }

    public boolean allowElementsFromNamespace(String namespace, XmlTag context2) {
        return true;
    }

    @NotNull
    XmlElementDescriptor getDelegate() {
        XmlElementDescriptor xmlElementDescriptor = this.myDelegate;
        if (xmlElementDescriptor == null) {
            HtmlElementDescriptorImpl.$$$reportNull$$$0(1);
        }
        return xmlElementDescriptor;
    }

    @Override
    public String toString() {
        return this.myDelegate.toString();
    }

    public boolean isCaseSensitive() {
        return this.myCaseSensitive;
    }

    public boolean isDeprecated() {
        boolean deprecatedInHtml5;
        boolean html4Deprecated = this.ourHtml4DeprecatedTags.contains(this.myDelegate.getName());
        MdnSymbolDocumentation documentation = (MdnSymbolDocumentation)ObjectUtils.doIfNotNull((Object)this.myDelegate.getDeclaration(), declaration -> MdnDocumentationKt.getHtmlMdnDocumentation(declaration, null));
        boolean bl = deprecatedInHtml5 = documentation != null && documentation.isDeprecated();
        if (!html4Deprecated && !deprecatedInHtml5) {
            return false;
        }
        boolean inHtml5 = HtmlUtil.isHtml5Schema(this.getNSDescriptor());
        return inHtml5 && deprecatedInHtml5 || !inHtml5 && html4Deprecated;
    }

    private String toLowerCaseIfNeeded(String name2) {
        return this.isCaseSensitive() ? name2 : StringUtil.toLowerCase((String)name2);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/intellij/psi/impl/source/html/dtd/HtmlElementDescriptorImpl";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDependencies";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getDelegate";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

