/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.resolve.reference.impl.providers;

import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.file.FileLookupInfoProvider;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class FileInfoManager {
    public static FileInfoManager getFileInfoManager() {
        return (FileInfoManager)ApplicationManager.getApplication().getService(FileInfoManager.class);
    }

    public static Object getFileLookupItem(PsiElement psiElement) {
        if (!(psiElement instanceof PsiFile) || !psiElement.isPhysical()) {
            return psiElement;
        }
        PsiFile file2 = (PsiFile)psiElement;
        return FileInfoManager._getLookupItem(file2, file2.getName(), file2.getIcon(0));
    }

    @Nullable
    public static String getFileAdditionalInfo(PsiElement psiElement) {
        return FileInfoManager._getInfo(psiElement);
    }

    @Nullable
    private static String _getInfo(PsiElement psiElement) {
        VirtualFile virtualFile2;
        if (!(psiElement instanceof PsiFile) || !psiElement.isPhysical()) {
            return null;
        }
        PsiFile psiFile = (PsiFile)psiElement;
        FileLookupInfoProvider provider2 = (FileLookupInfoProvider)ContainerUtil.find((Iterable)FileLookupInfoProvider.EP_NAME.getExtensionList(), p -> ArrayUtil.find((Object[])p.getFileTypes(), (Object)psiFile.getFileType()) != -1);
        if (provider2 != null && (virtualFile2 = psiFile.getVirtualFile()) != null) {
            Pair info2 = provider2.getLookupInfo(virtualFile2, psiElement.getProject());
            return (String)Pair.getSecond((Pair)info2);
        }
        return null;
    }

    public static LookupElementBuilder getFileLookupItem(PsiElement psiElement, String encoded, Icon icon2) {
        if (!(psiElement instanceof PsiFile) || !psiElement.isPhysical()) {
            return LookupElementBuilder.create((Object)psiElement, (String)encoded).withIcon(icon2);
        }
        return FileInfoManager._getLookupItem((PsiFile)psiElement, encoded, icon2);
    }

    public static LookupElementBuilder _getLookupItem(@NotNull PsiFile file2, String name2, Icon icon2) {
        if (file2 == null) {
            FileInfoManager.$$$reportNull$$$0(0);
        }
        LookupElementBuilder builder2 = LookupElementBuilder.create((Object)file2, (String)name2).withIcon(icon2);
        String info2 = FileInfoManager._getInfo((PsiElement)file2);
        if (info2 != null) {
            return builder2.withTailText(String.format(" (%s)", info2), true);
        }
        return builder2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/psi/impl/source/resolve/reference/impl/providers/FileInfoManager", "_getLookupItem"));
    }
}

