/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.tree;

import com.intellij.lang.ASTNode;
import com.intellij.lang.FileASTNode;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.TokenType;
import com.intellij.psi.impl.CheckUtil;
import com.intellij.psi.impl.DebugUtil;
import com.intellij.psi.impl.source.SourceTreeToPsiMap;
import com.intellij.psi.impl.source.codeStyle.CodeEditUtil;
import com.intellij.psi.impl.source.tree.ChangeUtil;
import com.intellij.psi.impl.source.tree.CompositeElement;
import com.intellij.psi.impl.source.tree.FileElement;
import com.intellij.psi.impl.source.tree.TreeElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.CharTable;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class SharedImplUtil {
    private static final Logger LOG = Logger.getInstance(SharedImplUtil.class);
    private static final boolean CHECK_FOR_READ_ACTION = DebugUtil.DO_EXPENSIVE_CHECKS || ApplicationManager.getApplication().isInternal();

    private SharedImplUtil() {
    }

    public static PsiElement getParent(ASTNode thisElement) {
        if (CHECK_FOR_READ_ACTION && thisElement instanceof TreeElement) {
            ((TreeElement)thisElement).assertReadAccessAllowed();
        }
        return SourceTreeToPsiMap.treeElementToPsi(thisElement.getTreeParent());
    }

    public static PsiElement getFirstChild(@NotNull ASTNode element2) {
        if (element2 == null) {
            SharedImplUtil.$$$reportNull$$$0(0);
        }
        return SourceTreeToPsiMap.treeElementToPsi(element2.getFirstChildNode());
    }

    @Nullable
    public static PsiElement getLastChild(@NotNull ASTNode element2) {
        if (element2 == null) {
            SharedImplUtil.$$$reportNull$$$0(1);
        }
        return SourceTreeToPsiMap.treeElementToPsi(element2.getLastChildNode());
    }

    public static PsiElement getNextSibling(@NotNull ASTNode thisElement) {
        if (thisElement == null) {
            SharedImplUtil.$$$reportNull$$$0(2);
        }
        return SourceTreeToPsiMap.treeElementToPsi(thisElement.getTreeNext());
    }

    public static PsiElement getPrevSibling(@NotNull ASTNode thisElement) {
        if (thisElement == null) {
            SharedImplUtil.$$$reportNull$$$0(3);
        }
        return SourceTreeToPsiMap.treeElementToPsi(thisElement.getTreePrev());
    }

    public static PsiFile getContainingFile(@NotNull ASTNode thisElement) {
        FileASTNode node2;
        PsiElement psi;
        if (thisElement == null) {
            SharedImplUtil.$$$reportNull$$$0(4);
        }
        PsiElement psiElement = psi = (node2 = SharedImplUtil.findFileElement(thisElement)) == null ? null : node2.getPsi();
        if (psi == null || psi instanceof PsiFile) {
            return (PsiFile)psi;
        }
        throw new AssertionError((Object)("Invalid PSI " + psi + " of " + psi.getClass() + " for AST " + node2 + " of " + node2.getClass()));
    }

    public static boolean isValid(ASTNode thisElement) {
        LOG.assertTrue(thisElement instanceof PsiElement);
        PsiFile file2 = SharedImplUtil.getContainingFile(thisElement);
        return file2 != null && file2.isValid();
    }

    public static boolean isWritable(ASTNode thisElement) {
        PsiFile file2 = SharedImplUtil.getContainingFile(thisElement);
        return file2 == null || file2.isWritable();
    }

    public static FileASTNode findFileElement(@NotNull ASTNode element2) {
        if (element2 == null) {
            SharedImplUtil.$$$reportNull$$$0(5);
        }
        for (ASTNode parent = element2.getTreeParent(); parent != null; parent = parent.getTreeParent()) {
            element2 = parent;
        }
        if (CHECK_FOR_READ_ACTION && element2 instanceof TreeElement) {
            ((TreeElement)element2).assertReadAccessAllowed();
        }
        if (element2 instanceof FileASTNode) {
            return (FileASTNode)element2;
        }
        return null;
    }

    @NotNull
    public static CharTable findCharTableByTree(ASTNode tree) {
        for (ASTNode o = tree; o != null; o = o.getTreeParent()) {
            CharTable charTable = (CharTable)o.getUserData(CharTable.CHAR_TABLE_KEY);
            if (charTable != null) {
                CharTable charTable2 = charTable;
                if (charTable2 == null) {
                    SharedImplUtil.$$$reportNull$$$0(6);
                }
                return charTable2;
            }
            if (!(o instanceof FileASTNode)) continue;
            CharTable charTable3 = ((FileASTNode)o).getCharTable();
            if (charTable3 == null) {
                SharedImplUtil.$$$reportNull$$$0(7);
            }
            return charTable3;
        }
        throw new AssertionError((Object)("CharTable not found in: " + tree));
    }

    public static PsiElement addRange(PsiElement thisElement, PsiElement first, PsiElement last, ASTNode anchor2, Boolean before) throws IncorrectOperationException {
        ASTNode element2;
        CheckUtil.checkWritable(thisElement);
        CharTable table = SharedImplUtil.findCharTableByTree(SourceTreeToPsiMap.psiElementToTree(thisElement));
        TreeElement copyFirst = null;
        TreeElement copyLast = null;
        ASTNode next = SourceTreeToPsiMap.psiElementToTree(last).getTreeNext();
        CompositeElement parent = null;
        for (element2 = SourceTreeToPsiMap.psiElementToTree(first); element2 != next; element2 = element2.getTreeNext()) {
            TreeElement elementCopy = ChangeUtil.copyElement((TreeElement)element2, table);
            if (element2 == first.getNode()) {
                copyFirst = elementCopy;
            }
            if (element2 == last.getNode()) {
                copyLast = elementCopy;
            }
            if (parent == null) {
                parent = elementCopy.getTreeParent();
                continue;
            }
            if (elementCopy.getElementType() == TokenType.WHITE_SPACE) {
                CodeEditUtil.setNodeGenerated(elementCopy, true);
            }
            parent.addChild(elementCopy, null);
        }
        if (copyFirst == null) {
            return null;
        }
        copyFirst = ((CompositeElement)SourceTreeToPsiMap.psiElementToTree(thisElement)).addInternal(copyFirst, copyLast, anchor2, before);
        for (element2 = copyFirst; element2 != null; element2 = element2.getTreeNext()) {
            if ((element2 = ChangeUtil.decodeInformation((TreeElement)element2)).getTreePrev() != null) continue;
            copyFirst = element2;
        }
        return SourceTreeToPsiMap.treeElementToPsi(copyFirst);
    }

    public static PsiManager getManagerByTree(ASTNode node2) {
        if (node2 instanceof FileElement) {
            return node2.getPsi().getManager();
        }
        return node2.getTreeParent().getPsi().getManager();
    }

    public static ASTNode @NotNull [] getChildrenOfType(@NotNull ASTNode node2, @NotNull IElementType elementType) {
        int count;
        if (node2 == null) {
            SharedImplUtil.$$$reportNull$$$0(8);
        }
        if (elementType == null) {
            SharedImplUtil.$$$reportNull$$$0(9);
        }
        if ((count = SharedImplUtil.countChildrenOfType(node2, elementType)) == 0) {
            if (ASTNode.EMPTY_ARRAY == null) {
                SharedImplUtil.$$$reportNull$$$0(10);
            }
            return ASTNode.EMPTY_ARRAY;
        }
        ASTNode[] result2 = new ASTNode[count];
        count = 0;
        for (ASTNode child2 = node2.getFirstChildNode(); child2 != null; child2 = child2.getTreeNext()) {
            if (child2.getElementType() != elementType) continue;
            result2[count++] = child2;
        }
        if (result2 == null) {
            SharedImplUtil.$$$reportNull$$$0(11);
        }
        return result2;
    }

    private static int countChildrenOfType(@NotNull ASTNode node2, @NotNull IElementType elementType) {
        if (node2 == null) {
            SharedImplUtil.$$$reportNull$$$0(12);
        }
        if (elementType == null) {
            SharedImplUtil.$$$reportNull$$$0(13);
        }
        int count = 0;
        for (ASTNode child2 = node2.getFirstChildNode(); child2 != null; child2 = child2.getTreeNext()) {
            if (child2.getElementType() != elementType) continue;
            ++count;
        }
        return count;
    }

    public static void acceptChildren(@NotNull PsiElementVisitor visitor, @NotNull ASTNode root2) {
        if (visitor == null) {
            SharedImplUtil.$$$reportNull$$$0(14);
        }
        if (root2 == null) {
            SharedImplUtil.$$$reportNull$$$0(15);
        }
        for (ASTNode childNode = root2.getFirstChildNode(); childNode != null; childNode = childNode.getTreeNext()) {
            PsiElement psi = childNode instanceof PsiElement ? (PsiElement)childNode : childNode.getPsi();
            psi.accept(visitor);
        }
    }

    public static PsiElement doReplace(@NotNull PsiElement psiElement, @NotNull TreeElement treeElement, @NotNull PsiElement newElement) {
        CompositeElement treeParent;
        if (psiElement == null) {
            SharedImplUtil.$$$reportNull$$$0(16);
        }
        if (treeElement == null) {
            SharedImplUtil.$$$reportNull$$$0(17);
        }
        if (newElement == null) {
            SharedImplUtil.$$$reportNull$$$0(18);
        }
        LOG.assertTrue((treeParent = treeElement.getTreeParent()) != null);
        CheckUtil.checkWritable(psiElement);
        TreeElement elementCopy = ChangeUtil.copyToElement(newElement);
        treeParent.replaceChildInternal(treeElement, elementCopy);
        elementCopy = ChangeUtil.decodeInformation(elementCopy);
        return SourceTreeToPsiMap.treeElementToPsi(elementCopy);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 7: 
            case 10: 
            case 11: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 7: 
            case 10: 
            case 11: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "thisElement";
                break;
            }
            case 6: 
            case 7: 
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/impl/source/tree/SharedImplUtil";
                break;
            }
            case 8: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 9: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementType";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiElement";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "treeElement";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/impl/source/tree/SharedImplUtil";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "findCharTableByTree";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildrenOfType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getFirstChild";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getLastChild";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getNextSibling";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getPrevSibling";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getContainingFile";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "findFileElement";
                break;
            }
            case 6: 
            case 7: 
            case 10: 
            case 11: {
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getChildrenOfType";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "countChildrenOfType";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "acceptChildren";
                break;
            }
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "doReplace";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 7: 
            case 10: 
            case 11: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

