/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.tree.injected;

import com.intellij.util.containers.ContainerUtil;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class ClassMapCachingNulls<T> {
    private final Map<Class<?>, T[]> myBackingMap;
    private final T[] myEmptyArray;
    private final List<? extends T> myOrderingArray;
    private final Map<Class<?>, T[]> myMap;

    ClassMapCachingNulls(@NotNull Map<Class<?>, T[]> backingMap, T[] emptyArray, @NotNull List<? extends T> orderingArray) {
        if (backingMap == null) {
            ClassMapCachingNulls.$$$reportNull$$$0(0);
        }
        if (orderingArray == null) {
            ClassMapCachingNulls.$$$reportNull$$$0(1);
        }
        this.myMap = new ConcurrentHashMap();
        this.myBackingMap = backingMap;
        this.myEmptyArray = emptyArray;
        this.myOrderingArray = orderingArray;
    }

    T @Nullable [] get(@NotNull Class<?> aClass) {
        T[] value2;
        if (aClass == null) {
            ClassMapCachingNulls.$$$reportNull$$$0(2);
        }
        if ((value2 = this.myMap.get(aClass)) != null) {
            if (value2 == this.myEmptyArray) {
                return null;
            }
            assert (value2.length != 0);
            return value2;
        }
        return this.cache(aClass, this.getFromBackingMap(aClass));
    }

    private T[] cache(@NotNull Class<?> aClass, @Nullable List<T> result2) {
        T[] value2;
        if (aClass == null) {
            ClassMapCachingNulls.$$$reportNull$$$0(3);
        }
        if (result2 == null) {
            this.myMap.put(aClass, this.myEmptyArray);
            value2 = null;
        } else {
            assert (!result2.isEmpty());
            value2 = result2.toArray(this.myEmptyArray);
            this.myMap.put(aClass, value2);
        }
        return value2;
    }

    @Nullable
    private List<T> getFromBackingMap(@NotNull Class<?> aClass) {
        Class<?> superClass;
        if (aClass == null) {
            ClassMapCachingNulls.$$$reportNull$$$0(4);
        }
        T[] value2 = this.myBackingMap.get(aClass);
        Set result2 = null;
        if (value2 != null) {
            assert (value2.length != 0);
            result2 = new HashSet(value2.length);
            Collections.addAll(result2, value2);
        }
        if ((superClass = aClass.getSuperclass()) != null) {
            result2 = this.addFromUpper(result2, superClass);
        }
        for (Class<?> superInterface : aClass.getInterfaces()) {
            result2 = this.addFromUpper(result2, superInterface);
        }
        return result2 == null ? null : ContainerUtil.findAll(this.myOrderingArray, result2::contains);
    }

    @Nullable
    private Set<T> addFromUpper(@Nullable Set<T> value2, @NotNull Class<?> superclass) {
        T[] fromUpper;
        if (superclass == null) {
            ClassMapCachingNulls.$$$reportNull$$$0(5);
        }
        if ((fromUpper = this.get(superclass)) != null) {
            assert (fromUpper.length != 0);
            if (value2 == null) {
                value2 = new HashSet<T>(fromUpper.length);
            }
            Collections.addAll(value2, fromUpper);
            assert (!value2.isEmpty());
        }
        return value2;
    }

    @NotNull
    Map<Class<?>, T[]> getBackingMap() {
        Map<Class<?>, T[]> map2 = this.myBackingMap;
        if (map2 == null) {
            ClassMapCachingNulls.$$$reportNull$$$0(6);
        }
        return map2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "backingMap";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "orderingArray";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "superclass";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/impl/source/tree/injected/ClassMapCachingNulls";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/impl/source/tree/injected/ClassMapCachingNulls";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getBackingMap";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "get";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "cache";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getFromBackingMap";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "addFromUpper";
                break;
            }
            case 6: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

