/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.search.scope;

import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.List;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public abstract class RangeBasedLocalSearchScope
extends LocalSearchScope {
    private static final Logger ourLogger = Logger.getInstance(RangeBasedLocalSearchScope.class);
    protected final boolean myIgnoreInjectedPsi;
    @NotNull
    @Nls
    protected final String myDisplayName;
    private LocalSearchScope myLocalSearchScope;

    public RangeBasedLocalSearchScope(@NotNull @Nls String displayName, boolean ignoreInjectedPsi) {
        if (displayName == null) {
            RangeBasedLocalSearchScope.$$$reportNull$$$0(0);
        }
        super(PsiElement.EMPTY_ARRAY);
        this.myDisplayName = displayName;
        this.myIgnoreInjectedPsi = ignoreInjectedPsi;
    }

    @NotNull
    public abstract TextRange[] getRanges(@NotNull VirtualFile var1);

    protected static void collectPsiElementsAtRange(PsiFile psiFile, List<PsiElement> elements, int start2, int end) {
        PsiElement endElement;
        PsiElement startElement = psiFile.findElementAt(start2);
        if (startElement == null) {
            return;
        }
        int modifiedEnd = end;
        int length = psiFile.getTextLength();
        if (end > length) {
            ourLogger.error("Range extends beyond the PSI file range. Maybe PSI file is not actual");
        }
        if (end == length) {
            --modifiedEnd;
        }
        if ((endElement = psiFile.findElementAt(modifiedEnd)) == null) {
            return;
        }
        PsiElement parent = PsiTreeUtil.findCommonParent((PsiElement)startElement, (PsiElement)endElement);
        if (parent == null) {
            return;
        }
        PsiElement[] children2 = parent.getChildren();
        TextRange range2 = new TextRange(start2, end);
        if (children2.length == 0) {
            if (parent.getContainingFile() != null && range2.intersects(parent.getTextRange())) {
                elements.add(parent);
            }
        } else {
            for (PsiElement child2 : children2) {
                if (child2 instanceof PsiWhiteSpace || child2.getContainingFile() == null || !range2.intersects(child2.getTextRange())) continue;
                elements.add(child2);
            }
        }
    }

    public boolean isIgnoreInjectedPsi() {
        return this.myIgnoreInjectedPsi;
    }

    @NotNull
    public String getDisplayName() {
        String string = this.myDisplayName;
        if (string == null) {
            RangeBasedLocalSearchScope.$$$reportNull$$$0(1);
        }
        return string;
    }

    protected abstract PsiElement[] getPsiElements();

    private void createIfNeeded() {
        if (this.myLocalSearchScope == null) {
            this.myLocalSearchScope = (LocalSearchScope)ReadAction.compute(() -> new LocalSearchScope(this.getPsiElements(), this.myDisplayName, this.myIgnoreInjectedPsi));
        }
    }

    public PsiElement @NotNull [] getScope() {
        this.createIfNeeded();
        PsiElement[] psiElementArray = this.myLocalSearchScope.getScope();
        if (psiElementArray == null) {
            RangeBasedLocalSearchScope.$$$reportNull$$$0(2);
        }
        return psiElementArray;
    }

    @NotNull
    public LocalSearchScope intersectWith(@NotNull LocalSearchScope scope2) {
        if (scope2 == null) {
            RangeBasedLocalSearchScope.$$$reportNull$$$0(3);
        }
        this.createIfNeeded();
        LocalSearchScope localSearchScope = this.myLocalSearchScope.intersectWith(scope2);
        if (localSearchScope == null) {
            RangeBasedLocalSearchScope.$$$reportNull$$$0(4);
        }
        return localSearchScope;
    }

    @NotNull
    public SearchScope intersectWith(@NotNull SearchScope scope2) {
        if (scope2 == null) {
            RangeBasedLocalSearchScope.$$$reportNull$$$0(5);
        }
        this.createIfNeeded();
        SearchScope searchScope2 = this.myLocalSearchScope.intersectWith(scope2);
        if (searchScope2 == null) {
            RangeBasedLocalSearchScope.$$$reportNull$$$0(6);
        }
        return searchScope2;
    }

    @NotNull
    public SearchScope union(@NotNull SearchScope scope2) {
        if (scope2 == null) {
            RangeBasedLocalSearchScope.$$$reportNull$$$0(7);
        }
        this.createIfNeeded();
        SearchScope searchScope2 = this.myLocalSearchScope.union(scope2);
        if (searchScope2 == null) {
            RangeBasedLocalSearchScope.$$$reportNull$$$0(8);
        }
        return searchScope2;
    }

    public boolean contains(@NotNull VirtualFile file2) {
        if (file2 == null) {
            RangeBasedLocalSearchScope.$$$reportNull$$$0(9);
        }
        this.createIfNeeded();
        return this.myLocalSearchScope.contains(file2);
    }

    public boolean isInScope(@NotNull VirtualFile file2) {
        if (file2 == null) {
            RangeBasedLocalSearchScope.$$$reportNull$$$0(10);
        }
        this.createIfNeeded();
        return this.myLocalSearchScope.isInScope(file2);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 6: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 6: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "displayName";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/search/scope/RangeBasedLocalSearchScope";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope2";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/search/scope/RangeBasedLocalSearchScope";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getScope";
                break;
            }
            case 4: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "intersectWith";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "union";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 6: 
            case 8: {
                break;
            }
            case 3: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "intersectWith";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "union";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "contains";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "isInScope";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 6: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

