/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.stubs;

import com.intellij.lang.Language;
import com.intellij.lang.LanguageParserDefinitions;
import com.intellij.lang.ParserDefinition;
import com.intellij.openapi.diagnostic.Attachment;
import com.intellij.openapi.diagnostic.ControlFlowException;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.diagnostic.RuntimeExceptionWithAttachments;
import com.intellij.openapi.extensions.impl.ExtensionPointImpl;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeExtension;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.roots.impl.PushedFilePropertiesRetriever;
import com.intellij.openapi.util.KeyedExtensionCollector;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.FileAttribute;
import com.intellij.openapi.vfs.newvfs.persistent.FSRecords;
import com.intellij.psi.impl.DebugUtil;
import com.intellij.psi.stubs.BinaryFileStubBuilder;
import com.intellij.psi.stubs.BinaryFileStubBuilders;
import com.intellij.psi.stubs.IndexingStampInfo;
import com.intellij.psi.stubs.ObjectStubSerializer;
import com.intellij.psi.stubs.PrebuiltStubsProvider;
import com.intellij.psi.stubs.SerializationManagerEx;
import com.intellij.psi.stubs.SerializedStubTree;
import com.intellij.psi.stubs.SerializedStubTreeDataExternalizer;
import com.intellij.psi.stubs.SerializerNotFoundException;
import com.intellij.psi.stubs.Stub;
import com.intellij.psi.stubs.StubBuilderType;
import com.intellij.psi.stubs.StubForwardIndexExternalizer;
import com.intellij.psi.stubs.StubIndex;
import com.intellij.psi.stubs.StubIndexEx;
import com.intellij.psi.stubs.StubIndexImpl;
import com.intellij.psi.stubs.StubTreeBuilder;
import com.intellij.psi.stubs.StubUpdatingForwardIndexAccessor;
import com.intellij.psi.stubs.StubUpdatingIndexStorage;
import com.intellij.psi.tree.IFileElementType;
import com.intellij.psi.tree.IStubFileElementType;
import com.intellij.util.BitUtil;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.KeyedLazyInstance;
import com.intellij.util.ObjectUtils;
import com.intellij.util.SystemProperties;
import com.intellij.util.indexing.CustomImplementationFileBasedIndexExtension;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.FileBasedIndexExtension;
import com.intellij.util.indexing.FileBasedIndexImpl;
import com.intellij.util.indexing.FileContent;
import com.intellij.util.indexing.ID;
import com.intellij.util.indexing.IndexDataComparer;
import com.intellij.util.indexing.IndexDataPresenter;
import com.intellij.util.indexing.IndexedFile;
import com.intellij.util.indexing.SingleEntryCompositeIndexer;
import com.intellij.util.indexing.SingleEntryFileBasedIndexExtension;
import com.intellij.util.indexing.SingleEntryIndexer;
import com.intellij.util.indexing.StorageException;
import com.intellij.util.indexing.SubstitutedFileType;
import com.intellij.util.indexing.UpdatableIndex;
import com.intellij.util.indexing.impl.IndexDebugProperties;
import com.intellij.util.indexing.impl.IndexStorage;
import com.intellij.util.indexing.impl.MapReduceIndexMappingException;
import com.intellij.util.indexing.impl.forward.ForwardIndex;
import com.intellij.util.indexing.impl.forward.ForwardIndexAccessor;
import com.intellij.util.indexing.impl.storage.TransientChangesIndexStorage;
import com.intellij.util.indexing.storage.VfsAwareIndexStorageLayout;
import com.intellij.util.io.DataExternalizer;
import com.intellij.util.io.DataInputOutputUtil;
import com.intellij.util.io.DataOutputStream;
import com.intellij.util.io.EnumeratorStringDescriptor;
import com.intellij.util.io.KeyDescriptor;
import com.intellij.util.io.PersistentHashMapValueStorage;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.IOException;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class StubUpdatingIndex
extends SingleEntryFileBasedIndexExtension<SerializedStubTree>
implements CustomImplementationFileBasedIndexExtension<Integer, SerializedStubTree> {
    private static final Logger LOG = Logger.getInstance(StubUpdatingIndex.class);
    private static final boolean DEBUG_PREBUILT_INDICES = SystemProperties.getBooleanProperty((String)"debug.prebuilt.indices", (boolean)false);
    public static final boolean USE_SNAPSHOT_MAPPINGS = false;
    private static final int VERSION = 45 + (PersistentHashMapValueStorage.COMPRESSION_ENABLED ? 1 : 0);
    private static final FileAttribute INDEXED_STAMP = new FileAttribute("stubIndexStamp", 3, true);
    public static final ID<Integer, SerializedStubTree> INDEX_ID = ID.create((String)"Stubs");
    @NotNull
    private final StubForwardIndexExternalizer<?> myStubIndexesExternalizer;
    @NotNull
    private final SerializationManagerEx mySerializationManager;
    private static final FileTypeExtension<PrebuiltStubsProvider> PREBUILT_STUBS_PROVIDER_EP = new FileTypeExtension("com.intellij.filetype.prebuiltStubsProvider");
    private static final byte IS_BINARY_MASK = 1;
    private static final byte BYTE_AND_CHAR_LENGTHS_ARE_THE_SAME_MASK = 2;

    public StubUpdatingIndex() {
        this(StubForwardIndexExternalizer.getIdeUsedExternalizer(), SerializationManagerEx.getInstanceEx());
    }

    public StubUpdatingIndex(@NotNull StubForwardIndexExternalizer<?> stubIndexesExternalizer, @NotNull SerializationManagerEx serializationManager) {
        if (stubIndexesExternalizer == null) {
            StubUpdatingIndex.$$$reportNull$$$0(0);
        }
        if (serializationManager == null) {
            StubUpdatingIndex.$$$reportNull$$$0(1);
        }
        this.myStubIndexesExternalizer = stubIndexesExternalizer;
        this.mySerializationManager = serializationManager;
    }

    public static boolean canHaveStub(@NotNull VirtualFile file2) {
        if (file2 == null) {
            StubUpdatingIndex.$$$reportNull$$$0(2);
        }
        Project project = ProjectUtil.guessProjectForFile((VirtualFile)file2);
        FileType fileType = SubstitutedFileType.substituteFileType(file2, file2.getFileType(), project);
        return StubUpdatingIndex.canHaveStub(file2, fileType);
    }

    private static boolean canHaveStub(@NotNull VirtualFile file2, @NotNull FileType fileType) {
        BinaryFileStubBuilder builder2;
        if (file2 == null) {
            StubUpdatingIndex.$$$reportNull$$$0(3);
        }
        if (fileType == null) {
            StubUpdatingIndex.$$$reportNull$$$0(4);
        }
        if (fileType instanceof LanguageFileType) {
            Language l = ((LanguageFileType)fileType).getLanguage();
            ParserDefinition parserDefinition = (ParserDefinition)LanguageParserDefinitions.INSTANCE.forLanguage(l);
            FileBasedIndexImpl fileBasedIndex = (FileBasedIndexImpl)((Object)ObjectUtils.tryCast((Object)FileBasedIndex.getInstance(), FileBasedIndexImpl.class));
            if (parserDefinition == null) {
                if (fileBasedIndex != null && fileBasedIndex.doTraceStubUpdates()) {
                    FileBasedIndexImpl.LOG.info("No parser definition for " + file2.getName());
                }
                return false;
            }
            IFileElementType elementType = parserDefinition.getFileNodeType();
            if (elementType instanceof IStubFileElementType && ((IStubFileElementType)elementType).shouldBuildStubFor(file2)) {
                if (fileBasedIndex != null && fileBasedIndex.doTraceStubUpdates()) {
                    FileBasedIndexImpl.LOG.info("Should build stub for " + file2.getName());
                }
                return true;
            }
            if (fileBasedIndex != null && fileBasedIndex.doTraceStubUpdates()) {
                FileBasedIndexImpl.LOG.info("Can't build stub using stub file element type " + file2.getName() + ", properties: " + PushedFilePropertiesRetriever.getInstance().dumpSortedPushedProperties(file2));
            }
        }
        return (builder2 = (BinaryFileStubBuilder)BinaryFileStubBuilders.INSTANCE.forFileType(fileType)) != null && builder2.acceptsFile(file2);
    }

    @NotNull
    public ID<Integer, SerializedStubTree> getName() {
        ID<Integer, SerializedStubTree> iD = INDEX_ID;
        if (iD == null) {
            StubUpdatingIndex.$$$reportNull$$$0(5);
        }
        return iD;
    }

    @NotNull
    public SingleEntryIndexer<SerializedStubTree> getIndexer() {
        return new SingleEntryCompositeIndexer<SerializedStubTree, StubBuilderType, String>(false){

            public boolean requiresContentForSubIndexerEvaluation(@NotNull IndexedFile file2) {
                if (file2 == null) {
                    1.$$$reportNull$$$0(0);
                }
                return StubTreeBuilder.requiresContentToFindBuilder(file2.getFileType());
            }

            @Nullable
            public StubBuilderType calculateSubIndexer(@NotNull IndexedFile file2) {
                if (file2 == null) {
                    1.$$$reportNull$$$0(1);
                }
                return StubTreeBuilder.getStubBuilderType(file2, true);
            }

            @NotNull
            public String getSubIndexerVersion(@NotNull StubBuilderType type) {
                if (type == null) {
                    1.$$$reportNull$$$0(2);
                }
                String string = type.getVersion();
                if (string == null) {
                    1.$$$reportNull$$$0(3);
                }
                return string;
            }

            @NotNull
            public KeyDescriptor<String> getSubIndexerVersionDescriptor() {
                EnumeratorStringDescriptor enumeratorStringDescriptor = EnumeratorStringDescriptor.INSTANCE;
                if (enumeratorStringDescriptor == null) {
                    1.$$$reportNull$$$0(4);
                }
                return enumeratorStringDescriptor;
            }

            @Nullable
            protected SerializedStubTree computeValue(@NotNull FileContent inputData) {
                StubBuilderType subIndexerType;
                if (inputData == null) {
                    1.$$$reportNull$$$0(5);
                }
                if ((subIndexerType = this.calculateSubIndexer((IndexedFile)inputData)) == null) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Stub builder not found for " + inputData.getFile() + ", " + StubUpdatingIndex.calculateIndexingStamp(inputData));
                    }
                    return null;
                }
                return this.computeValue(inputData, Objects.requireNonNull(subIndexerType));
            }

            @Nullable
            protected SerializedStubTree computeValue(@NotNull FileContent inputData, @NotNull StubBuilderType type) {
                SerializedStubTree serializedStubTree;
                Stub stub;
                if (inputData == null) {
                    1.$$$reportNull$$$0(6);
                }
                if (type == null) {
                    1.$$$reportNull$$$0(7);
                }
                try {
                    SerializedStubTree prebuiltTree = StubUpdatingIndex.findPrebuiltSerializedStubTree(inputData);
                    if (prebuiltTree != null) {
                        prebuiltTree = prebuiltTree.reSerialize(StubUpdatingIndex.this.mySerializationManager, StubUpdatingIndex.this.myStubIndexesExternalizer);
                        if (DEBUG_PREBUILT_INDICES) {
                            StubUpdatingIndex.this.assertPrebuiltStubTreeMatchesActualTree(prebuiltTree, inputData, type);
                        }
                        return prebuiltTree;
                    }
                }
                catch (ProcessCanceledException pce) {
                    throw pce;
                }
                catch (Exception e) {
                    LOG.error("Error while indexing: " + inputData.getFileName() + " using prebuilt stub index", (Throwable)e);
                }
                try {
                    stub = StubTreeBuilder.buildStubTree(inputData, type);
                }
                catch (Exception e) {
                    if (e instanceof ControlFlowException) {
                        ExceptionUtil.rethrowUnchecked((Throwable)e);
                    }
                    throw new MapReduceIndexMappingException((Throwable)e, type.getClassToBlameInCaseOfException());
                }
                if (stub == null) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("No stub present for " + inputData.getFile() + ", " + StubUpdatingIndex.calculateIndexingStamp(inputData));
                    }
                    return null;
                }
                try {
                    serializedStubTree = SerializedStubTree.serializeStub(stub, StubUpdatingIndex.this.mySerializationManager, StubUpdatingIndex.this.myStubIndexesExternalizer);
                    if (IndexDebugProperties.DEBUG) {
                        StubUpdatingIndex.assertDeserializedStubMatchesOriginalStub(serializedStubTree, stub);
                    }
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Stub is built for " + inputData.getFile() + ", " + StubUpdatingIndex.calculateIndexingStamp(inputData));
                    }
                }
                catch (Exception e) {
                    ObjectStubSerializer stubType;
                    if (e instanceof ControlFlowException) {
                        ExceptionUtil.rethrowUnchecked((Throwable)e);
                    }
                    Class<?> classToBlame = (stubType = stub.getStubType()) != null ? stubType.getClass() : stub.getClass();
                    throw new MapReduceIndexMappingException((Throwable)e, classToBlame);
                }
                return serializedStubTree;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 3: 
                    case 4: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 3: 
                    case 4: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "file";
                        break;
                    }
                    case 2: 
                    case 7: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "type";
                        break;
                    }
                    case 3: 
                    case 4: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/psi/stubs/StubUpdatingIndex$1";
                        break;
                    }
                    case 5: 
                    case 6: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "inputData";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/psi/stubs/StubUpdatingIndex$1";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getSubIndexerVersion";
                        break;
                    }
                    case 4: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getSubIndexerVersionDescriptor";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "requiresContentForSubIndexerEvaluation";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray;
                        objectArray[2] = "calculateSubIndexer";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray;
                        objectArray[2] = "getSubIndexerVersion";
                        break;
                    }
                    case 3: 
                    case 4: {
                        break;
                    }
                    case 5: 
                    case 6: 
                    case 7: {
                        objectArray = objectArray;
                        objectArray[2] = "computeValue";
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 3: 
                    case 4: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        };
    }

    @Nullable
    private static SerializedStubTree findPrebuiltSerializedStubTree(@NotNull FileContent fileContent) {
        PrebuiltStubsProvider prebuiltStubsProvider;
        if (fileContent == null) {
            StubUpdatingIndex.$$$reportNull$$$0(6);
        }
        if ((prebuiltStubsProvider = (PrebuiltStubsProvider)PREBUILT_STUBS_PROVIDER_EP.forFileType(fileContent.getFileType())) == null) {
            return null;
        }
        return prebuiltStubsProvider.findStub(fileContent);
    }

    private static void assertDeserializedStubMatchesOriginalStub(@NotNull SerializedStubTree stubTree, @NotNull Stub originalStub) {
        Stub deserializedStub;
        if (stubTree == null) {
            StubUpdatingIndex.$$$reportNull$$$0(7);
        }
        if (originalStub == null) {
            StubUpdatingIndex.$$$reportNull$$$0(8);
        }
        try {
            deserializedStub = stubTree.getStub();
        }
        catch (SerializerNotFoundException e) {
            throw new RuntimeException("Failed to deserialize stub tree", e);
        }
        if (!StubUpdatingIndex.areStubsSimilar(originalStub, deserializedStub)) {
            LOG.error("original and deserialized trees are not the same", new Attachment[]{new Attachment("originalStub.txt", DebugUtil.stubTreeToString(originalStub)), new Attachment("deserializedStub.txt", DebugUtil.stubTreeToString(deserializedStub))});
        }
    }

    private static boolean areStubsSimilar(@NotNull Stub stub, @NotNull Stub stub2) {
        if (stub == null) {
            StubUpdatingIndex.$$$reportNull$$$0(9);
        }
        if (stub2 == null) {
            StubUpdatingIndex.$$$reportNull$$$0(10);
        }
        if (stub.getStubType() != stub2.getStubType()) {
            return false;
        }
        List stubs = stub.getChildrenStubs();
        List stubs2 = stub2.getChildrenStubs();
        if (stubs.size() != stubs2.size()) {
            return false;
        }
        int len = stubs.size();
        for (int i2 = 0; i2 < len; ++i2) {
            if (StubUpdatingIndex.areStubsSimilar((Stub)stubs.get(i2), (Stub)stubs2.get(i2))) continue;
            return false;
        }
        return true;
    }

    private void assertPrebuiltStubTreeMatchesActualTree(@NotNull SerializedStubTree prebuiltStubTree, @NotNull FileContent fileContent, @NotNull StubBuilderType type) {
        if (prebuiltStubTree == null) {
            StubUpdatingIndex.$$$reportNull$$$0(11);
        }
        if (fileContent == null) {
            StubUpdatingIndex.$$$reportNull$$$0(12);
        }
        if (type == null) {
            StubUpdatingIndex.$$$reportNull$$$0(13);
        }
        try {
            Stub stub = StubTreeBuilder.buildStubTree(fileContent, type);
            if (stub == null) {
                return;
            }
            SerializedStubTree actualTree = SerializedStubTree.serializeStub(stub, this.mySerializationManager, this.myStubIndexesExternalizer);
            if (!IndexDataComparer.INSTANCE.areStubTreesTheSame(actualTree, prebuiltStubTree)) {
                throw new RuntimeExceptionWithAttachments("Prebuilt stub tree does not match actual stub tree", new Attachment[]{new Attachment("actual-stub-tree.txt", IndexDataPresenter.INSTANCE.getPresentableSerializedStubTree(actualTree)), new Attachment("prebuilt-stub-tree.txt", IndexDataPresenter.INSTANCE.getPresentableSerializedStubTree(prebuiltStubTree))});
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @NotNull
    static IndexingStampInfo calculateIndexingStamp(@NotNull FileContent content2) {
        VirtualFile file2;
        boolean isBinary;
        if (content2 == null) {
            StubUpdatingIndex.$$$reportNull$$$0(14);
        }
        int contentLength = (isBinary = (file2 = content2.getFile()).getFileType().isBinary()) ? -1 : content2.getPsiFile().getTextLength();
        long byteLength = file2.getLength();
        return new IndexingStampInfo(file2.getTimeStamp(), byteLength, contentLength, isBinary);
    }

    static void saveIndexingStampInfo(@Nullable IndexingStampInfo indexingStampInfo, int fileId) {
        try (DataOutputStream stream = FSRecords.writeAttribute(fileId, INDEXED_STAMP);){
            if (indexingStampInfo == null) {
                return;
            }
            DataInputOutputUtil.writeTIME((DataOutput)stream, (long)indexingStampInfo.indexingFileStamp);
            DataInputOutputUtil.writeLONG((DataOutput)stream, (long)indexingStampInfo.indexingByteLength);
            boolean lengthsAreTheSame = (long)indexingStampInfo.indexingCharLength == indexingStampInfo.indexingByteLength;
            byte flags = 0;
            flags = BitUtil.set((byte)flags, (byte)1, (boolean)indexingStampInfo.isBinary);
            flags = BitUtil.set((byte)flags, (byte)2, (boolean)lengthsAreTheSame);
            stream.writeByte(flags);
            if (!lengthsAreTheSame && !indexingStampInfo.isBinary) {
                DataInputOutputUtil.writeINT((DataOutput)stream, (int)indexingStampInfo.indexingCharLength);
            }
        }
        catch (IOException e) {
            LOG.error((Throwable)e);
        }
    }

    public int getCacheSize() {
        return super.getCacheSize() * Runtime.getRuntime().availableProcessors();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    static IndexingStampInfo readSavedIndexingStampInfo(@NotNull VirtualFile file2) {
        if (file2 == null) {
            StubUpdatingIndex.$$$reportNull$$$0(15);
        }
        try (DataInputStream stream = INDEXED_STAMP.readAttribute(file2);){
            if (stream == null || stream.available() <= 0) {
                IndexingStampInfo indexingStampInfo2 = null;
                return indexingStampInfo2;
            }
            long stamp = DataInputOutputUtil.readTIME((DataInput)stream);
            long byteLength = DataInputOutputUtil.readLONG((DataInput)stream);
            byte flags = stream.readByte();
            boolean isBinary = BitUtil.isSet((byte)flags, (byte)1);
            boolean readOnlyOneLength = BitUtil.isSet((byte)flags, (byte)2);
            int charLength = isBinary ? -1 : (readOnlyOneLength ? (int)byteLength : DataInputOutputUtil.readINT((DataInput)stream));
            IndexingStampInfo indexingStampInfo = new IndexingStampInfo(stamp, byteLength, charLength, isBinary);
            return indexingStampInfo;
        }
        catch (IOException e) {
            LOG.error((Throwable)e);
            return null;
        }
    }

    @NotNull
    public DataExternalizer<SerializedStubTree> getValueExternalizer() {
        StubUpdatingIndex.ensureSerializationManagerInitialized(this.mySerializationManager);
        return new SerializedStubTreeDataExternalizer(this.mySerializationManager, this.myStubIndexesExternalizer);
    }

    @NotNull
    public FileBasedIndex.InputFilter getInputFilter() {
        return new FileBasedIndex.ProjectSpecificInputFilter(){

            public boolean acceptInput(@NotNull IndexedFile file2) {
                if (file2 == null) {
                    2.$$$reportNull$$$0(0);
                }
                return StubUpdatingIndex.canHaveStub(file2.getFile(), file2.getFileType());
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/psi/stubs/StubUpdatingIndex$2", "acceptInput"));
            }
        };
    }

    public int getVersion() {
        return VERSION;
    }

    public boolean enableWal() {
        return true;
    }

    @Override
    public void handleInitializationError(@NotNull Throwable e) {
        if (e == null) {
            StubUpdatingIndex.$$$reportNull$$$0(16);
        }
        ((StubIndexImpl)StubIndex.getInstance()).initializationFailed(e);
    }

    @Override
    @NotNull
    public UpdatableIndex<Integer, SerializedStubTree, FileContent> createIndexImplementation(final @NotNull FileBasedIndexExtension<Integer, SerializedStubTree> extension2, final @NotNull VfsAwareIndexStorageLayout<Integer, SerializedStubTree> layout) throws StorageException, IOException {
        if (extension2 == null) {
            StubUpdatingIndex.$$$reportNull$$$0(17);
        }
        if (layout == null) {
            StubUpdatingIndex.$$$reportNull$$$0(18);
        }
        ((StubIndexImpl)StubIndex.getInstance()).initializeStubIndexes();
        this.checkNameStorage();
        StubUpdatingIndexStorage index2 = new StubUpdatingIndexStorage(extension2, new VfsAwareIndexStorageLayout<Integer, SerializedStubTree>(){

            @Override
            public void clearIndexData() {
                layout.clearIndexData();
            }

            @NotNull
            public IndexStorage<Integer, SerializedStubTree> openIndexStorage() throws IOException {
                IndexStorage indexStorage = layout.openIndexStorage();
                if (indexStorage == null) {
                    3.$$$reportNull$$$0(0);
                }
                return indexStorage;
            }

            @Nullable
            public ForwardIndex openForwardIndex() throws IOException {
                return layout.openForwardIndex();
            }

            @NotNull
            public ForwardIndexAccessor<Integer, SerializedStubTree> getForwardIndexAccessor() {
                return new StubUpdatingForwardIndexAccessor((FileBasedIndexExtension<Integer, SerializedStubTree>)extension2);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/stubs/StubUpdatingIndex$3", "openIndexStorage"));
            }
        }, this.mySerializationManager);
        if (index2.getStorage() instanceof TransientChangesIndexStorage) {
            TransientChangesIndexStorage memStorage = (TransientChangesIndexStorage)index2.getStorage();
            memStorage.addBufferingStateListener(new TransientChangesIndexStorage.BufferingStateListener(){

                @Override
                public void bufferingStateChanged(boolean newState2) {
                    ((StubIndexImpl)StubIndex.getInstance()).setDataBufferingEnabled(newState2);
                }

                @Override
                public void memoryStorageCleared() {
                    ((StubIndexImpl)StubIndex.getInstance()).cleanupMemoryStorage();
                }
            });
        }
        StubUpdatingIndexStorage stubUpdatingIndexStorage = index2;
        if (stubUpdatingIndexStorage == null) {
            StubUpdatingIndex.$$$reportNull$$$0(19);
        }
        return stubUpdatingIndexStorage;
    }

    private void checkNameStorage() throws StorageException {
        if (this.mySerializationManager.isNameStorageCorrupted()) {
            StorageException exception = new StorageException("NameStorage for stubs serialization has been corrupted");
            this.mySerializationManager.repairNameStorage((Exception)((Object)exception));
            throw exception;
        }
    }

    private static void ensureSerializationManagerInitialized(@NotNull SerializationManagerEx serializationManager) {
        if (serializationManager == null) {
            StubUpdatingIndex.$$$reportNull$$$0(20);
        }
        ProgressManager.getInstance().executeNonCancelableSection(() -> {
            StubUpdatingIndex.instantiateElementTypesFromFields();
            StubIndexEx.initExtensions();
            serializationManager.initSerializers();
        });
    }

    private static void instantiateElementTypesFromFields() {
        FileTypeRegistry.getInstance().getRegisteredFileTypes();
        StubUpdatingIndex.getExtensions(BinaryFileStubBuilders.INSTANCE, builder2 -> {});
        StubUpdatingIndex.getExtensions(LanguageParserDefinitions.INSTANCE, ParserDefinition::getFileNodeType);
    }

    private static <T> void getExtensions(@NotNull KeyedExtensionCollector<T, ?> collector, @NotNull Consumer<? super T> consumer2) {
        ExtensionPointImpl point;
        if (collector == null) {
            StubUpdatingIndex.$$$reportNull$$$0(21);
        }
        if (consumer2 == null) {
            StubUpdatingIndex.$$$reportNull$$$0(22);
        }
        if ((point = (ExtensionPointImpl)collector.getPoint()) != null) {
            for (KeyedLazyInstance instance2 : point) {
                consumer2.accept(instance2.getInstance());
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 19: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 19: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stubIndexesExternalizer";
                break;
            }
            case 1: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "serializationManager";
                break;
            }
            case 2: 
            case 3: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileType";
                break;
            }
            case 5: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/stubs/StubUpdatingIndex";
                break;
            }
            case 6: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileContent";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stubTree";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "originalStub";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stub";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stub2";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prebuiltStubTree";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "content";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extension";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "layout";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "collector";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/stubs/StubUpdatingIndex";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "createIndexImplementation";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "canHaveStub";
                break;
            }
            case 5: 
            case 19: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "findPrebuiltSerializedStubTree";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "assertDeserializedStubMatchesOriginalStub";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "areStubsSimilar";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "assertPrebuiltStubTreeMatchesActualTree";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "calculateIndexingStamp";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "readSavedIndexingStampInfo";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "handleInitializationError";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "createIndexImplementation";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "ensureSerializationManagerInitialized";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "getExtensions";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 19: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

