/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring;

import com.intellij.codeInsight.actions.VcsFacade;
import com.intellij.find.findUsages.PsiElement2UsageTargetAdapter;
import com.intellij.history.LocalHistory;
import com.intellij.history.LocalHistoryAction;
import com.intellij.ide.DataManager;
import com.intellij.lang.Language;
import com.intellij.model.ModelBranch;
import com.intellij.model.ModelPatch;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.application.ex.ApplicationEx;
import com.intellij.openapi.application.ex.ApplicationManagerEx;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.command.UndoConfirmationPolicy;
import com.intellij.openapi.command.undo.BasicUndoableAction;
import com.intellij.openapi.command.undo.UndoManager;
import com.intellij.openapi.command.undo.UndoableAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.impl.NonProjectFileWritingAccessProvider;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.UnloadedModuleDescription;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogBuilder;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Factory;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.impl.status.StatusBarUtil;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.RefactoringHelper;
import com.intellij.refactoring.listeners.RefactoringEventData;
import com.intellij.refactoring.listeners.RefactoringEventListener;
import com.intellij.refactoring.listeners.RefactoringListenerManager;
import com.intellij.refactoring.listeners.impl.RefactoringListenerManagerImpl;
import com.intellij.refactoring.listeners.impl.RefactoringTransaction;
import com.intellij.refactoring.suggested.SuggestedRefactoringProvider;
import com.intellij.refactoring.ui.ConflictsDialog;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.usageView.UsageInfo;
import com.intellij.usageView.UsageViewBundle;
import com.intellij.usageView.UsageViewDescriptor;
import com.intellij.usageView.UsageViewUtil;
import com.intellij.usages.Usage;
import com.intellij.usages.UsageInfo2UsageAdapter;
import com.intellij.usages.UsageInfoSearcherAdapter;
import com.intellij.usages.UsageSearcher;
import com.intellij.usages.UsageTarget;
import com.intellij.usages.UsageView;
import com.intellij.usages.UsageViewManager;
import com.intellij.usages.UsageViewPresentation;
import com.intellij.usages.impl.UnknownUsagesInUnloadedModules;
import com.intellij.usages.impl.UsageViewImpl;
import com.intellij.usages.rules.PsiElementUsage;
import com.intellij.util.Processor;
import com.intellij.util.SlowOperations;
import com.intellij.util.ThrowableRunnable;
import com.intellij.util.containers.MultiMap;
import it.unimi.dsi.fastutil.objects.ReferenceOpenHashSet;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JComponent;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public abstract class BaseRefactoringProcessor
implements Runnable {
    private static final Logger LOG = Logger.getInstance(BaseRefactoringProcessor.class);
    private static boolean PREVIEW_IN_TESTS = true;
    protected final Project myProject;
    @NotNull
    protected final SearchScope myRefactoringScope;
    private RefactoringTransaction myTransaction;
    private boolean myIsPreviewUsages;
    protected Runnable myPrepareSuccessfulSwingThreadCallback;
    private UsageView myUsageView;

    protected BaseRefactoringProcessor(@NotNull Project project) {
        if (project == null) {
            BaseRefactoringProcessor.$$$reportNull$$$0(0);
        }
        this(project, null);
    }

    protected BaseRefactoringProcessor(@NotNull Project project, @Nullable Runnable prepareSuccessfulCallback) {
        if (project == null) {
            BaseRefactoringProcessor.$$$reportNull$$$0(1);
        }
        this(project, (SearchScope)GlobalSearchScope.projectScope((Project)project), prepareSuccessfulCallback);
    }

    protected BaseRefactoringProcessor(@NotNull Project project, @NotNull SearchScope refactoringScope, @Nullable Runnable prepareSuccessfulCallback) {
        if (project == null) {
            BaseRefactoringProcessor.$$$reportNull$$$0(2);
        }
        if (refactoringScope == null) {
            BaseRefactoringProcessor.$$$reportNull$$$0(3);
        }
        this.myProject = project;
        this.myPrepareSuccessfulSwingThreadCallback = prepareSuccessfulCallback;
        this.myRefactoringScope = refactoringScope;
    }

    @NotNull
    protected abstract UsageViewDescriptor createUsageViewDescriptor(UsageInfo @NotNull [] var1);

    protected abstract UsageInfo @NotNull [] findUsages();

    protected void refreshElements(PsiElement @NotNull [] elements) {
        if (elements == null) {
            BaseRefactoringProcessor.$$$reportNull$$$0(4);
        }
    }

    protected boolean preprocessUsages(@NotNull Ref<UsageInfo[]> refUsages) {
        if (refUsages == null) {
            BaseRefactoringProcessor.$$$reportNull$$$0(5);
        }
        this.prepareSuccessful();
        return true;
    }

    protected boolean isPreviewUsages(UsageInfo @NotNull [] usages) {
        if (usages == null) {
            BaseRefactoringProcessor.$$$reportNull$$$0(6);
        }
        return this.myIsPreviewUsages;
    }

    protected boolean isPreviewUsages() {
        return this.myIsPreviewUsages;
    }

    private Set<UnloadedModuleDescription> computeUnloadedModulesFromUseScope(UsageViewDescriptor descriptor2) {
        if (ModuleManager.getInstance((Project)this.myProject).getUnloadedModuleDescriptions().isEmpty()) {
            return Collections.emptySet();
        }
        LinkedHashSet<UnloadedModuleDescription> unloadedModulesInUseScope = new LinkedHashSet<UnloadedModuleDescription>();
        for (PsiElement element2 : descriptor2.getElements()) {
            SearchScope useScope = element2.getUseScope();
            if (!(useScope instanceof GlobalSearchScope)) continue;
            unloadedModulesInUseScope.addAll(((GlobalSearchScope)useScope).getUnloadedModulesBelongingToScope());
        }
        return unloadedModulesInUseScope;
    }

    public void setPreviewUsages(boolean isPreviewUsages) {
        this.myIsPreviewUsages = isPreviewUsages;
    }

    public void setPrepareSuccessfulSwingThreadCallback(Runnable prepareSuccessfulSwingThreadCallback) {
        this.myPrepareSuccessfulSwingThreadCallback = prepareSuccessfulSwingThreadCallback;
    }

    protected RefactoringTransaction getTransaction() {
        return this.myTransaction;
    }

    protected abstract void performRefactoring(UsageInfo @NotNull [] var1);

    @ApiStatus.Experimental
    protected boolean canPerformRefactoringInBranch() {
        return false;
    }

    @ApiStatus.Experimental
    protected void performRefactoringInBranch(UsageInfo @NotNull [] usages, ModelBranch branch) {
        if (usages == null) {
            BaseRefactoringProcessor.$$$reportNull$$$0(7);
        }
        throw new UnsupportedOperationException();
    }

    @NotNull
    @NlsContexts.Command
    protected abstract String getCommandName();

    protected void doRun() {
        boolean isPreview;
        if (!PsiDocumentManager.getInstance((Project)this.myProject).commitAllDocumentsUnderProgress()) {
            return;
        }
        Ref refUsages = new Ref();
        Ref refErrorLanguage = new Ref();
        Ref refProcessCanceled = new Ref();
        Ref anyException = new Ref();
        Ref indexNotReadyException = new Ref();
        DumbService.getInstance((Project)this.myProject).completeJustSubmittedTasks();
        Runnable findUsagesRunnable = () -> {
            try {
                refUsages.set((Object)((UsageInfo[])ReadAction.compute(this::findUsages)));
            }
            catch (UnknownReferenceTypeException e) {
                refErrorLanguage.set((Object)e.getElementLanguage());
            }
            catch (ProcessCanceledException e) {
                refProcessCanceled.set((Object)Boolean.TRUE);
            }
            catch (IndexNotReadyException e) {
                indexNotReadyException.set((Object)Boolean.TRUE);
            }
            catch (Throwable e) {
                anyException.set((Object)Boolean.TRUE);
                LOG.error(e);
            }
        };
        if (!ProgressManager.getInstance().runProcessWithProgressSynchronously(findUsagesRunnable, RefactoringBundle.message((String)"progress.text"), true, this.myProject)) {
            return;
        }
        if (!refErrorLanguage.isNull()) {
            Messages.showErrorDialog((Project)this.myProject, (String)RefactoringBundle.message((String)"unsupported.refs.found", (Object[])new Object[]{((Language)refErrorLanguage.get()).getDisplayName()}), (String)RefactoringBundle.message((String)"error.title"));
            return;
        }
        if (!indexNotReadyException.isNull() || DumbService.isDumb((Project)this.myProject)) {
            DumbService.getInstance((Project)this.myProject).showDumbModeNotification(RefactoringBundle.message((String)"refactoring.dumb.mode.notification"));
            return;
        }
        if (!refProcessCanceled.isNull()) {
            Messages.showErrorDialog((Project)this.myProject, (String)RefactoringBundle.message((String)"refactoring.index.corruption.notifiction"), (String)RefactoringBundle.message((String)"error.title"));
            return;
        }
        if (!anyException.isNull()) {
            return;
        }
        assert (!refUsages.isNull()) : "Null usages from processor " + this;
        if (!this.preprocessUsages((Ref<UsageInfo[]>)refUsages)) {
            return;
        }
        UsageInfo[] usages = (UsageInfo[])refUsages.get();
        assert (usages != null);
        UsageViewDescriptor descriptor2 = this.createUsageViewDescriptor(usages);
        boolean bl = isPreview = this.isPreviewUsages(usages) || !this.computeUnloadedModulesFromUseScope(descriptor2).isEmpty();
        if (!isPreview) {
            boolean bl2 = isPreview = !this.ensureElementsWritable(usages, descriptor2) || UsageViewUtil.hasReadOnlyUsages(usages);
            if (isPreview) {
                StatusBarUtil.setStatusBarInfo(this.myProject, RefactoringBundle.message((String)"readonly.occurences.found"));
            }
        }
        if (isPreview) {
            for (UsageInfo usage : usages) {
                LOG.assertTrue(usage != null, this.getClass());
            }
            this.previewRefactoring(usages);
        } else {
            this.execute(usages);
        }
    }

    @TestOnly
    public static <T extends Throwable> void runWithDisabledPreview(ThrowableRunnable<T> runnable2) throws T {
        PREVIEW_IN_TESTS = false;
        try {
            runnable2.run();
        }
        finally {
            PREVIEW_IN_TESTS = true;
        }
    }

    protected void previewRefactoring(UsageInfo @NotNull [] usages) {
        if (usages == null) {
            BaseRefactoringProcessor.$$$reportNull$$$0(8);
        }
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            if (!PREVIEW_IN_TESTS) {
                throw new RuntimeException("Unexpected preview in tests: " + StringUtil.join((Object[])usages, UsageInfo::toString, (String)", "));
            }
            this.ensureElementsWritable(usages, this.createUsageViewDescriptor(usages));
            this.execute(usages);
            return;
        }
        UsageViewDescriptor viewDescriptor = this.createUsageViewDescriptor(usages);
        final PsiElement[] elements = viewDescriptor.getElements();
        final PsiElement2UsageTargetAdapter[] targets2 = PsiElement2UsageTargetAdapter.convert(elements);
        Factory factory2 = () -> new UsageInfoSearcherAdapter(){

            public void generate(@NotNull Processor<? super Usage> processor2) {
                if (processor2 == null) {
                    1.$$$reportNull$$$0(0);
                }
                ApplicationManager.getApplication().runReadAction(() -> {
                    for (int i2 = 0; i2 < elements.length; ++i2) {
                        elements2[i2] = targets2[i2].getElement();
                    }
                    BaseRefactoringProcessor.this.refreshElements(elements);
                });
                this.processUsages(processor2, BaseRefactoringProcessor.this.myProject);
            }

            protected UsageInfo @NotNull [] findUsages() {
                UsageInfo[] usageInfoArray = BaseRefactoringProcessor.this.findUsages();
                if (usageInfoArray == null) {
                    1.$$$reportNull$$$0(1);
                }
                return usageInfoArray;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 1: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 1: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "processor";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/refactoring/BaseRefactoringProcessor$1";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/refactoring/BaseRefactoringProcessor$1";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "findUsages";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "generate";
                        break;
                    }
                    case 1: {
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 1: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        };
        this.showUsageView(viewDescriptor, (Factory<? extends UsageSearcher>)factory2, usages);
    }

    protected boolean skipNonCodeUsages() {
        return false;
    }

    private boolean ensureElementsWritable(UsageInfo @NotNull [] usages, @NotNull UsageViewDescriptor descriptor2) {
        if (descriptor2 == null) {
            BaseRefactoringProcessor.$$$reportNull$$$0(9);
        }
        if (usages == null) {
            BaseRefactoringProcessor.$$$reportNull$$$0(10);
        }
        ReferenceOpenHashSet elements = new ReferenceOpenHashSet();
        for (UsageInfo usage : usages) {
            PsiElement element2;
            assert (usage != null) : "Found null element in usages array";
            if (this.skipNonCodeUsages() && usage.isNonCodeUsage() || (element2 = usage.getElement()) == null) continue;
            elements.add(element2);
        }
        elements.addAll(this.getElementsToWrite(descriptor2));
        return BaseRefactoringProcessor.ensureFilesWritable(this.myProject, (Collection<? extends PsiElement>)elements);
    }

    private static boolean ensureFilesWritable(@NotNull Project project, @NotNull Collection<? extends PsiElement> elements) {
        if (project == null) {
            BaseRefactoringProcessor.$$$reportNull$$$0(11);
        }
        if (elements == null) {
            BaseRefactoringProcessor.$$$reportNull$$$0(12);
        }
        PsiElement[] psiElements = PsiUtilCore.toPsiElementArray(elements);
        return CommonRefactoringUtil.checkReadOnlyStatus((Project)project, (PsiElement[])psiElements);
    }

    public void executeEx(UsageInfo @NotNull [] usages) {
        if (usages == null) {
            BaseRefactoringProcessor.$$$reportNull$$$0(13);
        }
        this.execute(usages);
    }

    protected void execute(UsageInfo @NotNull [] usages) {
        if (usages == null) {
            BaseRefactoringProcessor.$$$reportNull$$$0(14);
        }
        CommandProcessor.getInstance().executeCommand(this.myProject, () -> {
            LinkedHashSet<UsageInfo> usageInfos = new LinkedHashSet<UsageInfo>(Arrays.asList(usages));
            this.doRefactoring(usageInfos);
            if (this.isGlobalUndoAction()) {
                CommandProcessor.getInstance().markCurrentCommandAsGlobal(this.myProject);
            }
            SuggestedRefactoringProvider.getInstance((Project)this.myProject).reset();
        }, this.getCommandName(), null, this.getUndoConfirmationPolicy());
    }

    protected boolean isGlobalUndoAction() {
        return CommonDataKeys.EDITOR.getData(DataManager.getInstance().getDataContext()) == null;
    }

    @NotNull
    protected UndoConfirmationPolicy getUndoConfirmationPolicy() {
        UndoConfirmationPolicy undoConfirmationPolicy = UndoConfirmationPolicy.DEFAULT;
        if (undoConfirmationPolicy == null) {
            BaseRefactoringProcessor.$$$reportNull$$$0(15);
        }
        return undoConfirmationPolicy;
    }

    @NotNull
    private static UsageViewPresentation createPresentation(@NotNull UsageViewDescriptor descriptor2, Usage @NotNull [] usages) {
        if (descriptor2 == null) {
            BaseRefactoringProcessor.$$$reportNull$$$0(16);
        }
        if (usages == null) {
            BaseRefactoringProcessor.$$$reportNull$$$0(17);
        }
        UsageViewPresentation presentation2 = new UsageViewPresentation();
        presentation2.setTabText(RefactoringBundle.message((String)"usageView.tabText"));
        presentation2.setTargetsNodeText(descriptor2.getProcessedElementsHeader());
        presentation2.setShowReadOnlyStatusAsRed(true);
        presentation2.setShowCancelButton(true);
        presentation2.setUsagesString(RefactoringBundle.message((String)"usageView.usagesText"));
        int codeUsageCount = 0;
        int nonCodeUsageCount = 0;
        int dynamicUsagesCount = 0;
        HashSet<PsiFile> codeFiles = new HashSet<PsiFile>();
        HashSet<PsiFile> nonCodeFiles = new HashSet<PsiFile>();
        HashSet<PsiFile> dynamicUsagesCodeFiles = new HashSet<PsiFile>();
        for (Usage usage : usages) {
            PsiElementUsage elementUsage;
            PsiElement element2;
            if (!(usage instanceof PsiElementUsage) || (element2 = (elementUsage = (PsiElementUsage)usage).getElement()) == null) continue;
            PsiFile containingFile = element2.getContainingFile();
            if (usage instanceof UsageInfo2UsageAdapter && ((UsageInfo2UsageAdapter)usage).getUsageInfo().isDynamicUsage()) {
                ++dynamicUsagesCount;
                dynamicUsagesCodeFiles.add(containingFile);
                continue;
            }
            if (elementUsage.isNonCodeUsage()) {
                ++nonCodeUsageCount;
                nonCodeFiles.add(containingFile);
                continue;
            }
            ++codeUsageCount;
            codeFiles.add(containingFile);
        }
        codeFiles.remove(null);
        nonCodeFiles.remove(null);
        dynamicUsagesCodeFiles.remove(null);
        presentation2.setCodeUsagesString(UsageViewBundle.message((String)"usage.view.results.node.prefix", (Object[])new Object[]{UsageViewBundle.message((String)"usage.view.results.node.code", (Object[])new Object[0]), descriptor2.getCodeReferencesText(codeUsageCount, codeFiles.size())}));
        presentation2.setNonCodeUsagesString(UsageViewBundle.message((String)"usage.view.results.node.prefix", (Object[])new Object[]{UsageViewBundle.message((String)"usage.view.results.node.non.code", (Object[])new Object[0]), descriptor2.getCodeReferencesText(nonCodeUsageCount, nonCodeFiles.size())}));
        presentation2.setDynamicUsagesString(UsageViewBundle.message((String)"usage.view.results.node.prefix", (Object[])new Object[]{UsageViewBundle.message((String)"usage.view.results.node.dynamic", (Object[])new Object[0]), descriptor2.getCodeReferencesText(dynamicUsagesCount, dynamicUsagesCodeFiles.size())}));
        UsageViewPresentation usageViewPresentation = presentation2;
        if (usageViewPresentation == null) {
            BaseRefactoringProcessor.$$$reportNull$$$0(18);
        }
        return usageViewPresentation;
    }

    public static boolean processConflicts(@NotNull Project project, @NotNull MultiMap<PsiElement, String> conflicts) {
        if (project == null) {
            BaseRefactoringProcessor.$$$reportNull$$$0(19);
        }
        if (conflicts == null) {
            BaseRefactoringProcessor.$$$reportNull$$$0(20);
        }
        if (conflicts.isEmpty()) {
            return true;
        }
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            if (ConflictsInTestsException.isTestIgnore()) {
                return true;
            }
            throw new ConflictsInTestsException(conflicts.values());
        }
        ConflictsDialog conflictsDialog = new ConflictsDialog(project, conflicts);
        return conflictsDialog.showAndGet();
    }

    private void showUsageView(@NotNull UsageViewDescriptor viewDescriptor, @NotNull Factory<? extends UsageSearcher> factory2, UsageInfo @NotNull [] usageInfos) {
        if (viewDescriptor == null) {
            BaseRefactoringProcessor.$$$reportNull$$$0(21);
        }
        if (factory2 == null) {
            BaseRefactoringProcessor.$$$reportNull$$$0(22);
        }
        if (usageInfos == null) {
            BaseRefactoringProcessor.$$$reportNull$$$0(23);
        }
        UsageViewManager viewManager = UsageViewManager.getInstance((Project)this.myProject);
        PsiElement[] initialElements = viewDescriptor.getElements();
        PsiElement2UsageTargetAdapter[] targets2 = PsiElement2UsageTargetAdapter.convert(initialElements);
        Ref convertUsagesRef = new Ref();
        if (!ProgressManager.getInstance().runProcessWithProgressSynchronously(() -> ApplicationManager.getApplication().runReadAction(() -> convertUsagesRef.set((Object)UsageInfo2UsageAdapter.convert((UsageInfo[])usageInfos))), RefactoringBundle.message((String)"refactoring.preprocess.usages.progress"), true, this.myProject)) {
            return;
        }
        if (convertUsagesRef.isNull()) {
            return;
        }
        Usage[] usages = (Usage[])convertUsagesRef.get();
        UsageViewPresentation presentation2 = BaseRefactoringProcessor.createPresentation(viewDescriptor, usages);
        if (this.myUsageView == null) {
            this.myUsageView = viewManager.showUsages((UsageTarget[])targets2, usages, presentation2, factory2);
            this.customizeUsagesView(viewDescriptor, this.myUsageView);
        } else {
            this.myUsageView.removeUsagesBulk((Collection)this.myUsageView.getUsages());
            ((UsageViewImpl)this.myUsageView).appendUsagesInBulk(Arrays.asList(usages));
        }
        Set<UnloadedModuleDescription> unloadedModules = this.computeUnloadedModulesFromUseScope(viewDescriptor);
        if (!unloadedModules.isEmpty()) {
            this.myUsageView.appendUsage((Usage)new UnknownUsagesInUnloadedModules(unloadedModules));
        }
    }

    protected void customizeUsagesView(@NotNull UsageViewDescriptor viewDescriptor, @NotNull UsageView usageView) {
        if (viewDescriptor == null) {
            BaseRefactoringProcessor.$$$reportNull$$$0(24);
        }
        if (usageView == null) {
            BaseRefactoringProcessor.$$$reportNull$$$0(25);
        }
        Runnable refactoringRunnable2 = () -> {
            Set<UsageInfo> usagesToRefactor = UsageViewUtil.getNotExcludedUsageInfos(usageView);
            UsageInfo[] infos = usagesToRefactor.toArray(UsageInfo.EMPTY_ARRAY);
            if (this.ensureElementsWritable(infos, viewDescriptor)) {
                this.execute(infos);
            }
        };
        String canNotMakeString = RefactoringBundle.message((String)"usageView.need.reRun");
        this.addDoRefactoringAction(usageView, refactoringRunnable2, canNotMakeString);
        usageView.setRerunAction((Action)new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BaseRefactoringProcessor.this.run();
            }
        });
    }

    private void addDoRefactoringAction(@NotNull UsageView usageView, @NotNull Runnable refactoringRunnable2, @NotNull String canNotMakeString) {
        if (usageView == null) {
            BaseRefactoringProcessor.$$$reportNull$$$0(26);
        }
        if (refactoringRunnable2 == null) {
            BaseRefactoringProcessor.$$$reportNull$$$0(27);
        }
        if (canNotMakeString == null) {
            BaseRefactoringProcessor.$$$reportNull$$$0(28);
        }
        usageView.addPerformOperationAction(refactoringRunnable2, this.getCommandName(), canNotMakeString, RefactoringBundle.message((String)"usageView.doAction"), false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doRefactoring(@NotNull Collection<UsageInfo> usageInfoSet) {
        int count;
        if (usageInfoSet == null) {
            BaseRefactoringProcessor.$$$reportNull$$$0(29);
        }
        Iterator<UsageInfo> iterator2 = usageInfoSet.iterator();
        while (iterator2.hasNext()) {
            UsageInfo usageInfo = iterator2.next();
            PsiElement element2 = usageInfo.getElement();
            if (element2 != null && this.isToBeChanged(usageInfo)) continue;
            iterator2.remove();
        }
        String commandName2 = this.getCommandName();
        LocalHistoryAction action2 = LocalHistory.getInstance().startAction(commandName2);
        UsageInfo[] writableUsageInfos = usageInfoSet.toArray(UsageInfo.EMPTY_ARRAY);
        try {
            boolean inBranch;
            PsiDocumentManager.getInstance((Project)this.myProject).commitAllDocuments();
            RefactoringListenerManagerImpl listenerManager = (RefactoringListenerManagerImpl)RefactoringListenerManager.getInstance((Project)this.myProject);
            this.myTransaction = listenerManager.startTransaction();
            LinkedHashMap preparedData = new LinkedHashMap();
            Runnable prepareHelpersRunnable = () -> {
                RefactoringEventData data2 = (RefactoringEventData)ReadAction.compute(() -> this.getBeforeData());
                PsiElement primaryElement = data2 != null ? (PsiElement)data2.getUserData(RefactoringEventData.PSI_ELEMENT_KEY) : null;
                for (RefactoringHelper helper2 : RefactoringHelper.EP_NAME.getExtensionList()) {
                    Object operation = ReadAction.compute(() -> primaryElement != null ? helper2.prepareOperation(writableUsageInfos, primaryElement) : helper2.prepareOperation(writableUsageInfos));
                    preparedData.put(helper2, operation);
                }
            };
            ProgressManager.getInstance().runProcessWithProgressSynchronously(prepareHelpersRunnable, RefactoringBundle.message((String)"refactoring.prepare.progress"), false, this.myProject);
            ApplicationEx app2 = ApplicationManagerEx.getApplicationEx();
            boolean bl = inBranch = Registry.is((String)"run.refactorings.in.model.branch") && this.canPerformRefactoringInBranch();
            if (inBranch) {
                this.callPerformRefactoring(writableUsageInfos, () -> this.performInBranch(writableUsageInfos));
            } else if (Registry.is((String)"run.refactorings.under.progress")) {
                app2.runWriteActionWithNonCancellableProgressInDispatchThread(commandName2, this.myProject, null, indicator2 -> this.callPerformRefactoring(writableUsageInfos, () -> this.performRefactoring(writableUsageInfos)));
            } else {
                app2.runWriteAction(() -> this.callPerformRefactoring(writableUsageInfos, () -> this.performRefactoring(writableUsageInfos)));
            }
            DumbService.getInstance((Project)this.myProject).completeJustSubmittedTasks();
            for (Map.Entry e : preparedData.entrySet()) {
                ((RefactoringHelper)e.getKey()).performOperation(this.myProject, e.getValue());
            }
            this.myTransaction.commit();
            if (!inBranch) {
                if (Registry.is((String)"run.refactorings.under.progress")) {
                    app2.runWriteActionWithNonCancellableProgressInDispatchThread(commandName2, this.myProject, null, indicator2 -> this.performPsiSpoilingRefactoring());
                } else {
                    app2.runWriteAction(this::performPsiSpoilingRefactoring);
                }
            }
        }
        finally {
            action2.finish();
        }
        if ((count = writableUsageInfos.length) > 0) {
            StatusBarUtil.setStatusBarInfo(this.myProject, RefactoringBundle.message((String)"statusBar.refactoring.result", (Object[])new Object[]{count}));
        } else if (!this.isPreviewUsages(writableUsageInfos)) {
            StatusBarUtil.setStatusBarInfo(this.myProject, RefactoringBundle.message((String)"statusBar.noUsages"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void callPerformRefactoring(UsageInfo[] usageInfos, Runnable perform2) {
        String refactoringId = this.getRefactoringId();
        if (refactoringId != null) {
            RefactoringEventData data2 = this.getBeforeData();
            if (data2 != null) {
                data2.addUsages(Arrays.asList(usageInfos));
            }
            ((RefactoringEventListener)this.myProject.getMessageBus().syncPublisher(RefactoringEventListener.REFACTORING_EVENT_TOPIC)).refactoringStarted(refactoringId, data2);
        }
        try {
            if (refactoringId != null) {
                UndoRefactoringAction action1 = new UndoRefactoringAction(this.myProject, refactoringId);
                UndoManager.getInstance((Project)this.myProject).undoableActionPerformed((UndoableAction)action1);
            }
            perform2.run();
        }
        finally {
            if (refactoringId != null) {
                ((RefactoringEventListener)this.myProject.getMessageBus().syncPublisher(RefactoringEventListener.REFACTORING_EVENT_TOPIC)).refactoringDone(refactoringId, this.getAfterData(usageInfos));
            }
        }
    }

    private void performInBranch(UsageInfo[] usageInfos) {
        ThrowableComputable computable = () -> (ModelPatch)ReadAction.compute(() -> ModelBranch.performInBranch((Project)this.myProject, branch -> this.performRefactoringInBranch(usageInfos, (ModelBranch)branch)));
        ModelPatch patch2 = (ModelPatch)ProgressManager.getInstance().runProcessWithProgressSynchronously(computable, this.getCommandName(), true, this.myProject);
        if (!ApplicationManager.getApplication().isUnitTestMode() && this.isPreviewUsages()) {
            this.displayPreview(patch2);
        }
        WriteAction.run(() -> patch2.applyBranchChanges());
    }

    private void displayPreview(ModelPatch patch2) throws ProcessCanceledException {
        DialogBuilder builder2;
        JComponent preview2 = VcsFacade.getInstance().createPatchPreviewComponent(this.myProject, patch2);
        if (preview2 != null && (builder2 = new DialogBuilder(this.myProject).title(RefactoringBundle.message((String)"usageView.tabText")).centerPanel(preview2)).show() != 0) {
            throw new ProcessCanceledException();
        }
    }

    protected boolean isToBeChanged(@NotNull UsageInfo usageInfo) {
        if (usageInfo == null) {
            BaseRefactoringProcessor.$$$reportNull$$$0(30);
        }
        return usageInfo.isWritable();
    }

    protected void performPsiSpoilingRefactoring() {
    }

    protected void prepareSuccessful() {
        if (this.myPrepareSuccessfulSwingThreadCallback != null) {
            try {
                ApplicationManager.getApplication().invokeAndWait(this.myPrepareSuccessfulSwingThreadCallback);
            }
            catch (RuntimeException e) {
                LOG.error((Throwable)e);
            }
        }
    }

    @Override
    public final void run() {
        Runnable runnable2;
        Runnable baseRunnable = () -> SlowOperations.allowSlowOperations(this::doRun);
        Runnable runnable3 = runnable2 = this.shouldDisableAccessChecks() ? () -> NonProjectFileWritingAccessProvider.disableChecksDuring(baseRunnable) : baseRunnable;
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            ApplicationManager.getApplication().assertIsWriteThread();
            runnable2.run();
            return;
        }
        if (ApplicationManager.getApplication().isWriteAccessAllowed()) {
            LOG.error("Refactorings should not be started inside write action\n because they start progress inside and any read action from the progress task would cause the deadlock", (Throwable)new Exception());
            DumbService.getInstance((Project)this.myProject).smartInvokeLater(runnable2);
        } else {
            runnable2.run();
        }
    }

    protected boolean shouldDisableAccessChecks() {
        return false;
    }

    protected boolean showConflicts(@NotNull MultiMap<PsiElement, String> conflicts, UsageInfo @Nullable [] usages) {
        if (conflicts == null) {
            BaseRefactoringProcessor.$$$reportNull$$$0(31);
        }
        if (!conflicts.isEmpty() && ApplicationManager.getApplication().isUnitTestMode()) {
            if (!ConflictsInTestsException.isTestIgnore()) {
                throw new ConflictsInTestsException(conflicts.values());
            }
            return true;
        }
        if (this.myPrepareSuccessfulSwingThreadCallback != null && !conflicts.isEmpty()) {
            ConflictsDialog conflictsDialog;
            String refactoringId = this.getRefactoringId();
            if (refactoringId != null) {
                RefactoringEventData conflictUsages = new RefactoringEventData();
                conflictUsages.putUserData(RefactoringEventData.CONFLICTS_KEY, (Object)conflicts.values());
                ((RefactoringEventListener)this.myProject.getMessageBus().syncPublisher(RefactoringEventListener.REFACTORING_EVENT_TOPIC)).conflictsDetected(refactoringId, conflictUsages);
            }
            if (!(conflictsDialog = this.prepareConflictsDialog(conflicts, usages)).showAndGet()) {
                if (conflictsDialog.isShowConflicts()) {
                    this.prepareSuccessful();
                }
                return false;
            }
        }
        this.prepareSuccessful();
        return true;
    }

    @NotNull
    protected ConflictsDialog prepareConflictsDialog(@NotNull MultiMap<PsiElement, String> conflicts, UsageInfo @Nullable [] usages) {
        if (conflicts == null) {
            BaseRefactoringProcessor.$$$reportNull$$$0(32);
        }
        ConflictsDialog conflictsDialog = this.createConflictsDialog(conflicts, usages);
        conflictsDialog.setCommandName(this.getCommandName());
        ConflictsDialog conflictsDialog2 = conflictsDialog;
        if (conflictsDialog2 == null) {
            BaseRefactoringProcessor.$$$reportNull$$$0(33);
        }
        return conflictsDialog2;
    }

    @Nullable
    protected RefactoringEventData getBeforeData() {
        return null;
    }

    @Nullable
    protected RefactoringEventData getAfterData(UsageInfo @NotNull [] usages) {
        if (usages == null) {
            BaseRefactoringProcessor.$$$reportNull$$$0(34);
        }
        return null;
    }

    @NonNls
    @Nullable
    protected String getRefactoringId() {
        return null;
    }

    @NotNull
    protected ConflictsDialog createConflictsDialog(@NotNull MultiMap<PsiElement, String> conflicts, UsageInfo @Nullable [] usages) {
        if (conflicts == null) {
            BaseRefactoringProcessor.$$$reportNull$$$0(35);
        }
        return new ConflictsDialog(this.myProject, conflicts, usages == null ? null : () -> this.execute(usages), false, true);
    }

    @NotNull
    protected Collection<? extends PsiElement> getElementsToWrite(@NotNull UsageViewDescriptor descriptor2) {
        if (descriptor2 == null) {
            BaseRefactoringProcessor.$$$reportNull$$$0(36);
        }
        List<PsiElement> list2 = Arrays.asList(descriptor2.getElements());
        if (list2 == null) {
            BaseRefactoringProcessor.$$$reportNull$$$0(37);
        }
        return list2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 15: 
            case 18: 
            case 33: 
            case 37: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 15: 
            case 18: 
            case 33: 
            case 37: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refactoringScope";
                break;
            }
            case 4: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refUsages";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 13: 
            case 14: 
            case 17: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "usages";
                break;
            }
            case 9: 
            case 16: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 15: 
            case 18: 
            case 33: 
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/refactoring/BaseRefactoringProcessor";
                break;
            }
            case 20: 
            case 31: 
            case 32: 
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "conflicts";
                break;
            }
            case 21: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "viewDescriptor";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "factory";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "usageInfos";
                break;
            }
            case 25: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "usageView";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refactoringRunnable";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "canNotMakeString";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "usageInfoSet";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "usageInfo";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/refactoring/BaseRefactoringProcessor";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getUndoConfirmationPolicy";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "createPresentation";
                break;
            }
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "prepareConflictsDialog";
                break;
            }
            case 37: {
                objectArray = objectArray2;
                objectArray2[1] = "getElementsToWrite";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "refreshElements";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "preprocessUsages";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isPreviewUsages";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "performRefactoringInBranch";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "previewRefactoring";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "ensureElementsWritable";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "ensureFilesWritable";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "executeEx";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "execute";
                break;
            }
            case 15: 
            case 18: 
            case 33: 
            case 37: {
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "createPresentation";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "processConflicts";
                break;
            }
            case 21: 
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "showUsageView";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "customizeUsagesView";
                break;
            }
            case 26: 
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "addDoRefactoringAction";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "doRefactoring";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "isToBeChanged";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "showConflicts";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "prepareConflictsDialog";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "getAfterData";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "createConflictsDialog";
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "getElementsToWrite";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 15: 
            case 18: 
            case 33: 
            case 37: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class UndoRefactoringAction
    extends BasicUndoableAction {
        private final Project myProject;
        private final String myRefactoringId;

        UndoRefactoringAction(@NotNull Project project, @NotNull String refactoringId) {
            if (project == null) {
                UndoRefactoringAction.$$$reportNull$$$0(0);
            }
            if (refactoringId == null) {
                UndoRefactoringAction.$$$reportNull$$$0(1);
            }
            this.myProject = project;
            this.myRefactoringId = refactoringId;
        }

        public void undo() {
            ((RefactoringEventListener)this.myProject.getMessageBus().syncPublisher(RefactoringEventListener.REFACTORING_EVENT_TOPIC)).undoRefactoring(this.myRefactoringId);
        }

        public void redo() {
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "project";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "refactoringId";
                    break;
                }
            }
            objectArray[1] = "com/intellij/refactoring/BaseRefactoringProcessor$UndoRefactoringAction";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class UnknownReferenceTypeException
    extends RuntimeException {
        private final Language myElementLanguage;

        public UnknownReferenceTypeException(@NotNull Language elementLanguage) {
            if (elementLanguage == null) {
                UnknownReferenceTypeException.$$$reportNull$$$0(0);
            }
            this.myElementLanguage = elementLanguage;
        }

        @NotNull
        Language getElementLanguage() {
            Language language2 = this.myElementLanguage;
            if (language2 == null) {
                UnknownReferenceTypeException.$$$reportNull$$$0(1);
            }
            return language2;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "elementLanguage";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/refactoring/BaseRefactoringProcessor$UnknownReferenceTypeException";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/refactoring/BaseRefactoringProcessor$UnknownReferenceTypeException";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getElementLanguage";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static final class ConflictsInTestsException
    extends RuntimeException {
        private final Collection<? extends String> messages;
        private static boolean myTestIgnore;

        public ConflictsInTestsException(@NotNull Collection<? extends String> messages) {
            if (messages == null) {
                ConflictsInTestsException.$$$reportNull$$$0(0);
            }
            this.messages = messages;
        }

        public static boolean isTestIgnore() {
            return myTestIgnore;
        }

        @TestOnly
        public static <T extends Throwable> void withIgnoredConflicts(@NotNull ThrowableRunnable<T> r) throws T {
            if (r == null) {
                ConflictsInTestsException.$$$reportNull$$$0(1);
            }
            try {
                myTestIgnore = true;
                r.run();
            }
            finally {
                myTestIgnore = false;
            }
        }

        @NotNull
        public Collection<String> getMessages() {
            ArrayList<String> result2 = new ArrayList<String>(this.messages);
            for (int i2 = 0; i2 < this.messages.size(); ++i2) {
                result2.set(i2, ((String)result2.get(i2)).replaceAll("<[^>]+>", ""));
            }
            ArrayList<String> arrayList = result2;
            if (arrayList == null) {
                ConflictsInTestsException.$$$reportNull$$$0(2);
            }
            return arrayList;
        }

        @Override
        public String getMessage() {
            ArrayList<? extends String> result2 = new ArrayList<String>(this.messages);
            Collections.sort(result2);
            return StringUtil.join(result2, (String)"\n");
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "messages";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "r";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/refactoring/BaseRefactoringProcessor$ConflictsInTestsException";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/refactoring/BaseRefactoringProcessor$ConflictsInTestsException";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getMessages";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "withIgnoredConflicts";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

