/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.move.moveFilesOrDirectories;

import com.intellij.ide.util.EditorHelper;
import com.intellij.lang.FileASTNode;
import com.intellij.model.BranchableUsageInfo;
import com.intellij.model.ModelBranch;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.paths.PsiDynaReference;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReference;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.refactoring.BaseRefactoringProcessor;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.listeners.RefactoringElementListener;
import com.intellij.refactoring.listeners.RefactoringEventData;
import com.intellij.refactoring.move.FileReferenceContextUtil;
import com.intellij.refactoring.move.MoveCallback;
import com.intellij.refactoring.move.moveFilesOrDirectories.MoveFileHandler;
import com.intellij.refactoring.move.moveFilesOrDirectories.MoveFilesOrDirectoriesDialog;
import com.intellij.refactoring.move.moveFilesOrDirectories.MoveFilesOrDirectoriesUtil;
import com.intellij.refactoring.move.moveFilesOrDirectories.MoveFilesOrDirectoriesViewDescriptor;
import com.intellij.refactoring.rename.RenameUtil;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.refactoring.util.NonCodeUsageInfo;
import com.intellij.usageView.UsageInfo;
import com.intellij.usageView.UsageViewDescriptor;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import java.io.IOException;
import java.lang.ref.Reference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.Icon;
import one.util.streamex.EntryStream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MoveFilesOrDirectoriesProcessor
extends BaseRefactoringProcessor {
    private static final Logger LOG = Logger.getInstance(MoveFilesOrDirectoriesProcessor.class);
    protected final PsiElement[] myElementsToMove;
    private final boolean mySearchForReferences;
    protected final boolean mySearchInComments;
    protected final boolean mySearchInNonJavaFiles;
    private final PsiDirectory myNewParent;
    private final MoveCallback myMoveCallback;
    private NonCodeUsageInfo[] myNonCodeUsages;
    private final Map<PsiFile, List<UsageInfo>> myFoundUsages;

    public MoveFilesOrDirectoriesProcessor(@NotNull Project project, PsiElement @NotNull [] elements, @NotNull PsiDirectory newParent, boolean searchInComments, boolean searchInNonJavaFiles, MoveCallback moveCallback, Runnable prepareSuccessfulCallback) {
        if (project == null) {
            MoveFilesOrDirectoriesProcessor.$$$reportNull$$$0(0);
        }
        if (newParent == null) {
            MoveFilesOrDirectoriesProcessor.$$$reportNull$$$0(1);
        }
        if (elements == null) {
            MoveFilesOrDirectoriesProcessor.$$$reportNull$$$0(2);
        }
        this(project, elements, newParent, true, searchInComments, searchInNonJavaFiles, moveCallback, prepareSuccessfulCallback);
    }

    public MoveFilesOrDirectoriesProcessor(@NotNull Project project, PsiElement @NotNull [] elements, @NotNull PsiDirectory newParent, boolean searchForReferences, boolean searchInComments, boolean searchInNonJavaFiles, MoveCallback moveCallback, Runnable prepareSuccessfulCallback) {
        if (project == null) {
            MoveFilesOrDirectoriesProcessor.$$$reportNull$$$0(3);
        }
        if (newParent == null) {
            MoveFilesOrDirectoriesProcessor.$$$reportNull$$$0(4);
        }
        if (elements == null) {
            MoveFilesOrDirectoriesProcessor.$$$reportNull$$$0(5);
        }
        super(project, prepareSuccessfulCallback);
        this.myFoundUsages = new HashMap<PsiFile, List<UsageInfo>>();
        this.myElementsToMove = elements;
        this.myNewParent = newParent;
        this.mySearchForReferences = searchForReferences;
        this.mySearchInComments = searchInComments;
        this.mySearchInNonJavaFiles = searchInNonJavaFiles;
        this.myMoveCallback = moveCallback;
    }

    @Override
    @NotNull
    protected UsageViewDescriptor createUsageViewDescriptor(UsageInfo @NotNull [] usages) {
        if (usages == null) {
            MoveFilesOrDirectoriesProcessor.$$$reportNull$$$0(6);
        }
        return new MoveFilesOrDirectoriesViewDescriptor(this.myElementsToMove, this.myNewParent);
    }

    @Override
    protected UsageInfo @NotNull [] findUsages() {
        ArrayList<MyUsageInfo> result2 = new ArrayList<MyUsageInfo>();
        for (PsiElement element2 : this.myElementsToMove) {
            if (this.mySearchForReferences) {
                for (PsiReference reference2 : ReferencesSearch.search((PsiElement)element2, (SearchScope)GlobalSearchScope.projectScope((Project)this.myProject))) {
                    result2.add(new MyUsageInfo(reference2, element2));
                }
            }
            this.findElementUsages(result2, element2);
        }
        UsageInfo[] usageInfoArray = result2.toArray(UsageInfo.EMPTY_ARRAY);
        if (usageInfoArray == null) {
            MoveFilesOrDirectoriesProcessor.$$$reportNull$$$0(7);
        }
        return usageInfoArray;
    }

    private void findElementUsages(@NotNull List<? super UsageInfo> result2, @NotNull PsiElement element2) {
        if (result2 == null) {
            MoveFilesOrDirectoriesProcessor.$$$reportNull$$$0(8);
        }
        if (element2 == null) {
            MoveFilesOrDirectoriesProcessor.$$$reportNull$$$0(9);
        }
        if (!this.mySearchForReferences) {
            return;
        }
        if (element2 instanceof PsiFile) {
            List<UsageInfo> usages = MoveFileHandler.forElement((PsiFile)element2).findUsages((PsiFile)element2, this.myNewParent, this.mySearchInComments, this.mySearchInNonJavaFiles);
            if (usages != null) {
                result2.addAll(usages);
                this.myFoundUsages.put((PsiFile)element2, usages);
            }
        } else if (element2 instanceof PsiDirectory) {
            for (PsiElement childElement : element2.getChildren()) {
                this.findElementUsages(result2, childElement);
            }
        }
    }

    @Override
    protected void refreshElements(PsiElement @NotNull [] elements) {
        if (elements == null) {
            MoveFilesOrDirectoriesProcessor.$$$reportNull$$$0(10);
        }
        LOG.assertTrue(elements.length == this.myElementsToMove.length);
        System.arraycopy(elements, 0, this.myElementsToMove, 0, elements.length);
    }

    @Override
    protected void performPsiSpoilingRefactoring() {
        if (this.myNonCodeUsages != null) {
            RenameUtil.renameNonCodeUsages(this.myProject, this.myNonCodeUsages);
        }
    }

    @Override
    protected boolean canPerformRefactoringInBranch() {
        return this.getClass() == MoveFilesOrDirectoriesProcessor.class;
    }

    @Override
    protected void performRefactoring(UsageInfo @NotNull [] usages) {
        if (usages == null) {
            MoveFilesOrDirectoriesProcessor.$$$reportNull$$$0(11);
        }
        this.performRefactoringInBranch(usages, null);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void performRefactoringInBranch(UsageInfo @NotNull [] _usages, @Nullable ModelBranch branch) {
        if (_usages == null) {
            MoveFilesOrDirectoriesProcessor.$$$reportNull$$$0(12);
        }
        try {
            ArrayList<void> toChange = new ArrayList<void>();
            for (PsiElement psiElement : this.myElementsToMove) {
                void var7_11;
                if (branch != null) {
                    PsiElement psiElement2 = branch.obtainPsiCopy(psiElement);
                }
                toChange.add(var7_11);
            }
            PsiDirectory newParent = branch != null ? (PsiDirectory)branch.obtainPsiCopy((PsiElement)this.myNewParent) : this.myNewParent;
            ArrayList<void> codeUsages = new ArrayList<void>();
            ArrayList<NonCodeUsageInfo> nonCodeUsages = new ArrayList<NonCodeUsageInfo>();
            for (UsageInfo usageInfo : _usages) {
                void var10_20;
                if (branch != null) {
                    UsageInfo usageInfo2 = ((BranchableUsageInfo)usageInfo).obtainBranchCopy(branch);
                }
                if (var10_20 instanceof NonCodeUsageInfo) {
                    nonCodeUsages.add((NonCodeUsageInfo)var10_20);
                    continue;
                }
                codeUsages.add(var10_20);
            }
            Map map2 = branch == null ? this.myFoundUsages : EntryStream.of(this.myFoundUsages).mapValues(infos -> ContainerUtil.map((Collection)infos, info2 -> ((BranchableUsageInfo)info2).obtainBranchCopy(branch))).toMap();
            LinkedHashMap<SmartPsiElementPointer<PsiFile>, FileASTNode> movedFiles = new LinkedHashMap<SmartPsiElementPointer<PsiFile>, FileASTNode>();
            HashMap<PsiElement, PsiElement> oldToNewMap = new HashMap<PsiElement, PsiElement>();
            if (this.mySearchForReferences) {
                for (PsiElement psiElement : toChange) {
                    if (psiElement instanceof PsiDirectory) {
                        MoveFilesOrDirectoriesProcessor.encodeDirectoryFiles(psiElement, movedFiles);
                        continue;
                    }
                    if (!(psiElement instanceof PsiFile)) continue;
                    FileReferenceContextUtil.encodeFileReferences(psiElement);
                }
            }
            List list2 = ContainerUtil.map((Object[])this.myElementsToMove, item -> this.getTransaction().getElementListener((PsiElement)item));
            ArrayList<Runnable> arrayList = new ArrayList<Runnable>();
            for (int i2 = 0; i2 < this.myElementsToMove.length; ++i2) {
                PsiElement element4 = (PsiElement)toChange.get(i2);
                if (element4 instanceof PsiDirectory) {
                    MoveFilesOrDirectoriesUtil.doMoveDirectory((PsiDirectory)element4, newParent);
                    for (PsiElement psiElement : element4.getChildren()) {
                        MoveFilesOrDirectoriesProcessor.processDirectoryFiles(movedFiles, oldToNewMap, psiElement);
                    }
                } else if (element4 instanceof PsiFile) {
                    PsiFile psiFile = (PsiFile)element4;
                    FileASTNode node2 = psiFile.getNode();
                    MoveFileHandler.forElement(psiFile).prepareMovedFile(psiFile, newParent, oldToNewMap);
                    PsiFile moving = newParent.findFile(psiFile.getName());
                    if (moving == null) {
                        MoveFilesOrDirectoriesUtil.doMoveFile(psiFile, newParent);
                    }
                    if ((moving = newParent.findFile(psiFile.getName())) != null) {
                        movedFiles.put((SmartPsiElementPointer<PsiFile>)SmartPointerManager.createPointer((PsiElement)moving), moving.getNode());
                        Reference.reachabilityFence(node2);
                    }
                }
                if (!element4.isValid()) continue;
                RefactoringElementListener refactoringElementListener = (RefactoringElementListener)list2.get(i2);
                SmartPsiElementPointer pointer = SmartPointerManager.createPointer((PsiElement)element4);
                arrayList.add(() -> {
                    PsiElement restored = pointer.getElement();
                    if (branch != null && restored != null) {
                        restored = branch.findOriginalPsi(restored);
                    }
                    if (restored != null) {
                        listener2.elementMoved(restored);
                    }
                });
            }
            UsageInfo[] usages = codeUsages.toArray(UsageInfo.EMPTY_ARRAY);
            CommonRefactoringUtil.sortDepthFirstRightLeftOrder((UsageInfo[])usages);
            if (branch == null) {
                DumbService.getInstance((Project)this.myProject).completeJustSubmittedTasks();
            }
            for (SmartPsiElementPointer smartPsiElementPointer : movedFiles.keySet()) {
                PsiFile movedFile = (PsiFile)smartPsiElementPointer.getElement();
                if (movedFile == null) continue;
                MoveFileHandler.forElement(movedFile).updateMovedFile(movedFile);
                if (!this.mySearchForReferences) continue;
                FileReferenceContextUtil.decodeFileReferences((PsiElement)movedFile);
            }
            this.retargetUsages(usages, oldToNewMap);
            for (Map.Entry entry2 : map2.entrySet()) {
                MoveFileHandler.forElement((PsiFile)entry2.getKey()).retargetUsages((List)entry2.getValue(), oldToNewMap);
            }
            if (branch != null) {
                RenameUtil.renameNonCodeUsages(this.myProject, nonCodeUsages.toArray(new NonCodeUsageInfo[0]));
            } else {
                this.myNonCodeUsages = nonCodeUsages.toArray(new NonCodeUsageInfo[0]);
            }
            if (branch != null) {
                branch.runAfterMerge(() -> {
                    PsiDocumentManager.getInstance((Project)this.myProject).commitAllDocuments();
                    this.afterMove(branch, movedFiles.keySet(), notifyListeners);
                });
            } else {
                this.afterMove(null, movedFiles.keySet(), arrayList);
            }
        }
        catch (IncorrectOperationException e) {
            Throwable cause = e.getCause();
            if (cause instanceof IOException) {
                LOG.info((Throwable)e);
                ApplicationManager.getApplication().invokeLater(() -> Messages.showMessageDialog((Project)this.myProject, (String)cause.getMessage(), (String)RefactoringBundle.message((String)"error.title"), (Icon)Messages.getErrorIcon()));
            }
            LOG.error((Throwable)e);
        }
    }

    @Override
    protected boolean preprocessUsages(@NotNull Ref<UsageInfo[]> refUsages) {
        if (refUsages == null) {
            MoveFilesOrDirectoriesProcessor.$$$reportNull$$$0(13);
        }
        MultiMap conflicts = new MultiMap();
        UsageInfo[] usages = (UsageInfo[])refUsages.get();
        if (!ProgressManager.getInstance().runProcessWithProgressSynchronously(() -> ReadAction.run(() -> MoveFileHandler.detectConflicts(this.myElementsToMove, usages, this.myNewParent, (MultiMap<PsiElement, String>)conflicts)), RefactoringBundle.message((String)"detecting.possible.conflicts"), true, this.myProject)) {
            return false;
        }
        return this.showConflicts((MultiMap<PsiElement, String>)conflicts, usages);
    }

    private void afterMove(@Nullable ModelBranch branch, Set<SmartPsiElementPointer<PsiFile>> movedFiles, List<Runnable> notifyListeners) {
        notifyListeners.forEach(Runnable::run);
        if (this.myMoveCallback != null) {
            this.myMoveCallback.refactoringCompleted();
        }
        if (MoveFilesOrDirectoriesDialog.isOpenInEditorProperty()) {
            List justFiles = ContainerUtil.mapNotNull(movedFiles, pointer -> {
                PsiFile element2 = (PsiFile)pointer.getElement();
                return branch == null || element2 == null ? element2 : (PsiFile)branch.findOriginalPsi((PsiElement)element2);
            });
            ApplicationManager.getApplication().invokeLater(() -> EditorHelper.openFilesInEditor((PsiElement[])((PsiFile[])justFiles.stream().filter(PsiElement::isValid).toArray(PsiFile[]::new))));
        }
    }

    @Override
    @Nullable
    protected String getRefactoringId() {
        return "refactoring.move";
    }

    @Override
    @Nullable
    protected RefactoringEventData getBeforeData() {
        RefactoringEventData data2 = new RefactoringEventData();
        data2.addElements(this.myElementsToMove);
        return data2;
    }

    @Override
    @Nullable
    protected RefactoringEventData getAfterData(UsageInfo @NotNull [] usages) {
        if (usages == null) {
            MoveFilesOrDirectoriesProcessor.$$$reportNull$$$0(14);
        }
        RefactoringEventData data2 = new RefactoringEventData();
        data2.addElement((PsiElement)this.myNewParent);
        return data2;
    }

    private static void encodeDirectoryFiles(@NotNull PsiElement psiElement, @NotNull Map<SmartPsiElementPointer<PsiFile>, FileASTNode> movedFiles) {
        if (psiElement == null) {
            MoveFilesOrDirectoriesProcessor.$$$reportNull$$$0(15);
        }
        if (movedFiles == null) {
            MoveFilesOrDirectoriesProcessor.$$$reportNull$$$0(16);
        }
        if (psiElement instanceof PsiFile) {
            movedFiles.put((SmartPsiElementPointer<PsiFile>)SmartPointerManager.createPointer((PsiElement)((PsiFile)psiElement)), ((PsiFile)psiElement).getNode());
            FileReferenceContextUtil.encodeFileReferences(psiElement);
        } else if (psiElement instanceof PsiDirectory) {
            for (PsiElement element2 : psiElement.getChildren()) {
                MoveFilesOrDirectoriesProcessor.encodeDirectoryFiles(element2, movedFiles);
            }
        }
    }

    private static void processDirectoryFiles(@NotNull Map<SmartPsiElementPointer<PsiFile>, FileASTNode> movedFiles, @NotNull Map<PsiElement, PsiElement> oldToNewMap, @NotNull PsiElement psiElement) {
        if (movedFiles == null) {
            MoveFilesOrDirectoriesProcessor.$$$reportNull$$$0(17);
        }
        if (oldToNewMap == null) {
            MoveFilesOrDirectoriesProcessor.$$$reportNull$$$0(18);
        }
        if (psiElement == null) {
            MoveFilesOrDirectoriesProcessor.$$$reportNull$$$0(19);
        }
        if (psiElement instanceof PsiFile) {
            PsiFile movedFile = (PsiFile)psiElement;
            movedFiles.put((SmartPsiElementPointer<PsiFile>)SmartPointerManager.createPointer((PsiElement)movedFile), movedFile.getNode());
            MoveFileHandler.forElement(movedFile).prepareMovedFile(movedFile, movedFile.getParent(), oldToNewMap);
        } else if (psiElement instanceof PsiDirectory) {
            for (PsiElement element2 : psiElement.getChildren()) {
                MoveFilesOrDirectoriesProcessor.processDirectoryFiles(movedFiles, oldToNewMap, element2);
            }
        }
    }

    protected void retargetUsages(UsageInfo @NotNull [] usages, @NotNull Map<PsiElement, PsiElement> oldToNewMap) {
        if (oldToNewMap == null) {
            MoveFilesOrDirectoriesProcessor.$$$reportNull$$$0(20);
        }
        if (usages == null) {
            MoveFilesOrDirectoriesProcessor.$$$reportNull$$$0(21);
        }
        for (UsageInfo usageInfo : usages) {
            PsiElement refElement;
            PsiFile usageFile;
            PsiFile psiFile;
            PsiElement usageElement;
            if (!(usageInfo instanceof MyUsageInfo)) continue;
            MyUsageInfo info2 = (MyUsageInfo)usageInfo;
            PsiElement element2 = info2.myTarget;
            if ((info2.getReference() instanceof FileReference || info2.getReference() instanceof PsiDynaReference) && (usageElement = info2.getElement()) != null && (psiFile = (usageFile = usageElement.getContainingFile()).getViewProvider().getPsi(usageFile.getViewProvider().getBaseLanguage())) != null && psiFile.equals(element2) || !(refElement = info2.myReference.getElement()).isValid()) continue;
            info2.myReference.bindToElement(element2);
        }
    }

    @Override
    @NotNull
    protected String getCommandName() {
        String string = RefactoringBundle.message((String)"move.title");
        if (string == null) {
            MoveFilesOrDirectoriesProcessor.$$$reportNull$$$0(22);
        }
        return string;
    }

    @Override
    protected boolean shouldDisableAccessChecks() {
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: 
            case 22: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: 
            case 22: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newParent";
                break;
            }
            case 2: 
            case 5: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 6: 
            case 11: 
            case 14: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "usages";
                break;
            }
            case 7: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/refactoring/move/moveFilesOrDirectories/MoveFilesOrDirectoriesProcessor";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "_usages";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refUsages";
                break;
            }
            case 15: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiElement";
                break;
            }
            case 16: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "movedFiles";
                break;
            }
            case 18: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "oldToNewMap";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/refactoring/move/moveFilesOrDirectories/MoveFilesOrDirectoriesProcessor";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "findUsages";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getCommandName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "createUsageViewDescriptor";
                break;
            }
            case 7: 
            case 22: {
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "findElementUsages";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "refreshElements";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "performRefactoring";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "performRefactoringInBranch";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "preprocessUsages";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getAfterData";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "encodeDirectoryFiles";
                break;
            }
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "processDirectoryFiles";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "retargetUsages";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 7: 
            case 22: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class MyUsageInfo
    extends UsageInfo
    implements BranchableUsageInfo {
        private final PsiElement myTarget;
        final PsiReference myReference;

        MyUsageInfo(@NotNull PsiReference reference2, @NotNull PsiElement target2) {
            if (reference2 == null) {
                MyUsageInfo.$$$reportNull$$$0(0);
            }
            if (target2 == null) {
                MyUsageInfo.$$$reportNull$$$0(1);
            }
            super(reference2);
            this.myReference = reference2;
            this.myTarget = target2;
        }

        @NotNull
        public UsageInfo obtainBranchCopy(@NotNull ModelBranch branch) {
            if (branch == null) {
                MyUsageInfo.$$$reportNull$$$0(2);
            }
            return new MyUsageInfo(branch.obtainReferenceCopy(this.myReference), branch.obtainPsiCopy(this.myTarget));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "reference";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "target";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "branch";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/refactoring/move/moveFilesOrDirectories/MoveFilesOrDirectoriesProcessor$MyUsageInfo";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "obtainBranchCopy";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

