/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.rename;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.GeneratedSourcesFilter;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiDirectoryContainer;
import com.intellij.psi.PsiElement;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.refactoring.BaseRefactoringProcessor;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.rename.DirectoryRenameHandlerBase;
import com.intellij.refactoring.rename.PsiElementRenameHandler;
import com.intellij.refactoring.rename.RenameDialog;
import com.intellij.refactoring.rename.RenameUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Function;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.swing.Icon;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class DirectoryAsPackageRenameHandlerBase<T extends PsiDirectoryContainer>
extends DirectoryRenameHandlerBase {
    private static final Logger LOG = Logger.getInstance(DirectoryAsPackageRenameHandlerBase.class);

    protected abstract VirtualFile[] occursInPackagePrefixes(T var1);

    protected abstract boolean isIdentifier(String var1, Project var2);

    protected abstract String getQualifiedName(T var1);

    @Nullable
    protected abstract T getPackage(PsiDirectory var1);

    protected abstract BaseRefactoringProcessor createProcessor(String var1, Project var2, PsiDirectory[] var3, boolean var4, boolean var5);

    @Override
    protected boolean isSuitableDirectory(PsiDirectory directory) {
        return this.getPackage(directory) != null;
    }

    @Override
    protected void doRename(PsiElement element2, Project project, PsiElement nameSuggestionContext, Editor editor2) {
        String qualifiedName;
        PsiDirectory psiDirectory = (PsiDirectory)element2;
        T aPackage = this.getPackage(psiDirectory);
        String string = qualifiedName = aPackage != null ? this.getQualifiedName(aPackage) : "";
        if (aPackage == null || qualifiedName.length() == 0 || !this.isIdentifier(psiDirectory.getName(), project)) {
            PsiElementRenameHandler.rename(element2, project, nameSuggestionContext, editor2);
        } else {
            PsiDirectory[] directories = aPackage.getDirectories();
            VirtualFile[] virtualFiles = this.occursInPackagePrefixes(aPackage);
            if (virtualFiles.length == 0 && directories.length == 1) {
                PsiElementRenameHandler.rename(aPackage, project, nameSuggestionContext, editor2);
            } else {
                int ret;
                PsiDirectory[] projectDirectories = aPackage.getDirectories(GlobalSearchScope.projectScope((Project)project));
                if (virtualFiles.length == 0 && projectDirectories.length == 1) {
                    this.renameDirs(project, nameSuggestionContext, editor2, psiDirectory, aPackage, psiDirectory);
                    return;
                }
                @Nls StringBuffer message2 = new StringBuffer();
                RenameUtil.buildPackagePrefixChangedMessage(virtualFiles, message2, qualifiedName);
                Module module = Objects.requireNonNull(ModuleUtilCore.findModuleForFile((VirtualFile)psiDirectory.getVirtualFile(), (Project)project));
                DirectoryAsPackageRenameHandlerBase.buildMultipleDirectoriesInPackageMessage(message2, this.getQualifiedName(aPackage), projectDirectories, psiDirectory);
                PsiDirectory[] moduleDirectories = aPackage.getDirectories(GlobalSearchScope.moduleScope((Module)module));
                message2.append(RefactoringBundle.message((String)"directories.and.all.references.to.package.will.be.renamed"));
                ArrayList<String> options2 = new ArrayList<String>();
                options2.add(RefactoringBundle.message((String)"rename.package.button.text"));
                if (projectDirectories.length > moduleDirectories.length) {
                    options2.add(RefactoringBundle.message((String)"rename.directory.button.text"));
                }
                if (moduleDirectories.length > 1) {
                    options2.add(RefactoringBundle.message((String)"rename.source.root.button.text"));
                }
                if ((ret = Messages.showDialog((Project)project, (String)message2.toString(), (String)RefactoringBundle.message((String)"dialog.title.rename.package.directories"), (String[])ArrayUtil.toStringArray(options2), (int)0, (Icon)Messages.getQuestionIcon())) == 0) {
                    if (directories.length > projectDirectories.length) {
                        this.renameDirs(project, nameSuggestionContext, editor2, psiDirectory, aPackage, projectDirectories);
                    } else {
                        PsiElementRenameHandler.rename(aPackage, project, nameSuggestionContext, editor2);
                    }
                } else if (ret == 1) {
                    PsiDirectory[] psiDirectoryArray;
                    if (projectDirectories.length > moduleDirectories.length) {
                        psiDirectoryArray = moduleDirectories;
                    } else {
                        PsiDirectory[] psiDirectoryArray2 = new PsiDirectory[1];
                        psiDirectoryArray = psiDirectoryArray2;
                        psiDirectoryArray2[0] = psiDirectory;
                    }
                    PsiDirectory[] dirsToRename = psiDirectoryArray;
                    this.renameDirs(project, nameSuggestionContext, editor2, psiDirectory, aPackage, dirsToRename);
                } else if (ret == 2) {
                    this.renameDirs(project, nameSuggestionContext, editor2, psiDirectory, aPackage, psiDirectory);
                }
            }
        }
    }

    private void renameDirs(Project project, PsiElement nameSuggestionContext, Editor editor2, PsiDirectory contextDirectory, T aPackage, PsiDirectory ... dirsToRename) {
        RenameDialog dialog2 = new RenameDialog(project, (PsiElement)contextDirectory, nameSuggestionContext, editor2, (PsiDirectoryContainer)aPackage, project, dirsToRename){
            final /* synthetic */ PsiDirectoryContainer val$aPackage;
            final /* synthetic */ Project val$project;
            final /* synthetic */ PsiDirectory[] val$dirsToRename;
            {
                this.val$aPackage = psiDirectoryContainer;
                this.val$project = project2;
                this.val$dirsToRename = psiDirectoryArray;
                super(project, psiElement, nameSuggestionContext, editor2);
            }

            @Override
            protected void doAction() {
                String newQName = StringUtil.getQualifiedName((String)StringUtil.getPackageName((String)DirectoryAsPackageRenameHandlerBase.this.getQualifiedName(this.val$aPackage)), (String)this.getNewName());
                BaseRefactoringProcessor moveProcessor = DirectoryAsPackageRenameHandlerBase.this.createProcessor(newQName, this.val$project, this.val$dirsToRename, this.isSearchInComments(), this.isSearchInNonJavaFiles());
                this.invokeRefactoring(moveProcessor);
            }
        };
        dialog2.show();
    }

    public static void buildMultipleDirectoriesInPackageMessage(StringBuffer message2, String packageQname, PsiDirectory[] directories, @Nullable PsiDirectory currentVDirectory) {
        message2.append(RefactoringBundle.message((String)"multiple.directories.correspond.to.package", (Object[])new Object[]{packageQname}));
        ArrayList<PsiDirectory> generated = new ArrayList<PsiDirectory>();
        ArrayList<PsiDirectory> source = new ArrayList<PsiDirectory>();
        for (PsiDirectory directory2 : directories) {
            VirtualFile virtualFile2 = directory2.getVirtualFile();
            if (GeneratedSourcesFilter.isGeneratedSourceByAnyFilter((VirtualFile)virtualFile2, (Project)directory2.getProject())) {
                generated.add(directory2);
                continue;
            }
            source.add(directory2);
        }
        if (currentVDirectory != null && source.indexOf(currentVDirectory) > 0) {
            source.remove(currentVDirectory);
            source.add(0, currentVDirectory);
        }
        Function directoryPresentation = directory -> DirectoryAsPackageRenameHandlerBase.presentableUrl(currentVDirectory, directory);
        DirectoryAsPackageRenameHandlerBase.appendRoots(message2, source, (Function<PsiDirectory, String>)directoryPresentation);
        if (!generated.isEmpty()) {
            message2.append("\n\n").append(RefactoringBundle.message((String)"also.generated")).append("\n");
            DirectoryAsPackageRenameHandlerBase.appendRoots(message2, generated, (Function<PsiDirectory, String>)directoryPresentation);
        }
    }

    @NotNull
    @Nls
    private static String presentableUrl(@Nullable PsiDirectory currentVDirectory, PsiDirectory directory) {
        Project project = directory.getProject();
        VirtualFile virtualFile2 = directory.getVirtualFile();
        VirtualFile root2 = ProjectFileIndex.SERVICE.getInstance((Project)project).getContentRootForFile(virtualFile2);
        Object presentableUrl = null;
        if (root2 != null && (presentableUrl = VfsUtilCore.getRelativePath((VirtualFile)virtualFile2, (VirtualFile)root2, (char)'/')) != null) {
            presentableUrl = "/" + (String)presentableUrl;
        }
        if (presentableUrl == null) {
            presentableUrl = virtualFile2.getPresentableUrl();
        }
        if (directory.equals(currentVDirectory)) {
            String string = (String)presentableUrl + " (" + RefactoringBundle.message((String)"multiple.directories.correspond.to.package.current.marker") + ")";
            if (string == null) {
                DirectoryAsPackageRenameHandlerBase.$$$reportNull$$$0(0);
            }
            return string;
        }
        String string = presentableUrl;
        if (string == null) {
            DirectoryAsPackageRenameHandlerBase.$$$reportNull$$$0(1);
        }
        return string;
    }

    private static void appendRoots(StringBuffer message2, List<PsiDirectory> source, Function<PsiDirectory, String> directoryPresentation) {
        int limit = Math.min(source.size(), 10);
        message2.append(StringUtil.join(source.subList(0, limit), directoryPresentation, (String)"\n"));
        if (limit < source.size()) {
            message2.append("\n...\n");
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/refactoring/rename/DirectoryAsPackageRenameHandlerBase", "presentableUrl"));
    }
}

