/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.rename;

import com.intellij.ide.IdeEventQueue;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiFile;
import com.intellij.refactoring.actions.BaseRefactoringAction;
import com.intellij.refactoring.actions.RenameElementAction;
import com.intellij.refactoring.rename.RenameHandler;
import com.intellij.refactoring.rename.RenameHandler2Renamer;
import com.intellij.refactoring.rename.RenameHandlerRegistry;
import com.intellij.refactoring.rename.Renamer;
import com.intellij.refactoring.rename.RenamerFactory;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public final class RenameHandlerRenamerFactory
implements RenamerFactory {
    private static boolean isEnabledOnDataContext(@NotNull DataContext dataContext) {
        if (dataContext == null) {
            RenameHandlerRenamerFactory.$$$reportNull$$$0(0);
        }
        return RenameHandlerRegistry.getInstance().hasAvailableHandler(dataContext);
    }

    private static boolean isAvailable(@NotNull DataContext dataContext) {
        PsiFile file2;
        if (dataContext == null) {
            RenameHandlerRenamerFactory.$$$reportNull$$$0(1);
        }
        if ((file2 = (PsiFile)dataContext.getData(CommonDataKeys.PSI_FILE)) instanceof PsiCompiledElement) {
            return false;
        }
        Editor editor2 = (Editor)dataContext.getData(CommonDataKeys.EDITOR);
        if (editor2 == null) {
            return RenameHandlerRenamerFactory.isEnabledOnDataContext(dataContext) || RenameElementAction.isRenameEnabledOnElements(BaseRefactoringAction.getPsiElementArray(dataContext));
        }
        return file2 != null && RenameHandlerRenamerFactory.isEnabledOnDataContext(dataContext) && BaseRefactoringAction.findRefactoringTargetInEditor(dataContext, language2 -> true) != null;
    }

    @NotNull
    public @NotNull Collection<? extends @NotNull Renamer> createRenamers(@NotNull DataContext dataContext) {
        Project project;
        if (dataContext == null) {
            RenameHandlerRenamerFactory.$$$reportNull$$$0(2);
        }
        if ((project = (Project)dataContext.getData(CommonDataKeys.PROJECT)) == null) {
            List list2 = Collections.emptyList();
            if (list2 == null) {
                RenameHandlerRenamerFactory.$$$reportNull$$$0(3);
            }
            return list2;
        }
        if (!RenameHandlerRenamerFactory.isAvailable(dataContext)) {
            List list3 = Collections.emptyList();
            if (list3 == null) {
                RenameHandlerRenamerFactory.$$$reportNull$$$0(4);
            }
            return list3;
        }
        int eventCount = IdeEventQueue.getInstance().getEventCount();
        List list4 = ContainerUtil.map(RenameHandlerRegistry.getInstance().getRenameHandlers(dataContext), renameHandler -> new RenameHandler2Renamer(project, dataContext, (RenameHandler)renameHandler, eventCount));
        if (list4 == null) {
            RenameHandlerRenamerFactory.$$$reportNull$$$0(5);
        }
        return list4;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataContext";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/refactoring/rename/RenameHandlerRenamerFactory";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/refactoring/rename/RenameHandlerRenamerFactory";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "createRenamers";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isEnabledOnDataContext";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "createRenamers";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

