/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.rename.impl;

import com.intellij.injected.editor.DocumentWindow;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.refactoring.suggested.UtilsKt;
import com.intellij.util.DocumentUtil;
import com.intellij.util.io.PathKt;
import com.intellij.util.text.StringOperation;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\r\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010$\n\u0002\b\u0002\b\u0007\u0018\u0000 \u00162\u00020\u0001:\u0001\u0016Ba\u0012\u0018\u0010\u0002\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u00040\u0003\u0012\u0018\u0010\u0007\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u00050\u00040\u0003\u0012\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\b0\u0003\u0012\u0018\u0010\n\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u00060\u00040\u0003\u00a2\u0006\u0002\u0010\fJ\u0006\u0010\u0012\u001a\u00020\u0013J\u0012\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u00060\u0015R#\u0010\n\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u00060\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR#\u0010\u0002\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u000eR#\u0010\u0007\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u00050\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000eR\u0017\u0010\t\u001a\b\u0012\u0004\u0012\u00020\b0\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u000e\u00a8\u0006\u0017"}, d2={"Lcom/intellij/refactoring/rename/impl/FileUpdates;", "", "filesToAdd", "", "Lkotlin/Pair;", "Ljava/nio/file/Path;", "", "filesToMove", "Lcom/intellij/openapi/vfs/VirtualFile;", "filesToRemove", "documentModifications", "Lcom/intellij/openapi/editor/RangeMarker;", "(Ljava/util/List;Ljava/util/List;Ljava/util/List;Ljava/util/List;)V", "getDocumentModifications", "()Ljava/util/List;", "getFilesToAdd", "getFilesToMove", "getFilesToRemove", "doUpdate", "", "preview", "", "Companion", "intellij.platform.lang.impl"})
@ApiStatus.Internal
public final class FileUpdates {
    @NotNull
    private final List<Pair<Path, CharSequence>> filesToAdd;
    @NotNull
    private final List<Pair<VirtualFile, Path>> filesToMove;
    @NotNull
    private final List<VirtualFile> filesToRemove;
    @NotNull
    private final List<Pair<RangeMarker, CharSequence>> documentModifications;
    @NotNull
    private static final Logger LOG;
    @NotNull
    public static final Companion Companion;

    /*
     * WARNING - void declaration
     */
    public final void doUpdate() {
        Path virtualFile2;
        VirtualFile document;
        Map byDocument;
        Map $this$groupByTo$iv$iv;
        ApplicationManager.getApplication().assertWriteAccessAllowed();
        for (VirtualFile virtualFile3 : this.filesToRemove) {
            if (!virtualFile3.isValid()) {
                LOG.warn("Cannot apply rename patch: invalid file to remove. File: " + virtualFile3);
                continue;
            }
            virtualFile3.delete((Object)this);
        }
        Iterable iterable = this.documentModifications;
        boolean $i$f$groupBy = false;
        Iterable iterable2 = iterable;
        Map destination$iv$iv232 = new LinkedHashMap();
        boolean $i$f$groupByTo22 = false;
        Iterator iterator2 = $this$groupByTo$iv$iv.iterator();
        while (iterator2.hasNext()) {
            Object object;
            Object element$iv$iv = iterator2.next();
            Pair $dstr$rangeMarker$_u24__u24 = (Pair)element$iv$iv;
            boolean bl = false;
            RangeMarker rangeMarker = (RangeMarker)$dstr$rangeMarker$_u24__u24.component1();
            Document key$iv$iv = rangeMarker.getDocument();
            Map $this$getOrPut$iv$iv$iv = destination$iv$iv232;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl2 = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object = answer$iv$iv$iv;
            } else {
                object = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object;
            list$iv$iv.add(element$iv$iv);
        }
        $this$groupByTo$iv$iv = byDocument = destination$iv$iv232;
        boolean destination$iv$iv232 = false;
        Iterator iterator3 = $this$groupByTo$iv$iv.entrySet().iterator();
        while (iterator3.hasNext()) {
            Map.Entry entry2;
            Map.Entry $i$f$groupByTo22 = entry2 = iterator3.next();
            boolean bl = false;
            $this$groupByTo$iv$iv = (Document)$i$f$groupByTo22.getKey();
            $i$f$groupByTo22 = entry2;
            bl = false;
            List modifications = (List)$i$f$groupByTo22.getValue();
            DocumentUtil.executeInBulk((Document)document, new Runnable(modifications, (Document)document){
                final /* synthetic */ List $modifications;
                final /* synthetic */ Document $document;

                /*
                 * WARNING - void declaration
                 */
                public final void run() {
                    for (Pair pair : this.$modifications) {
                        void rangeMarker;
                        RangeMarker rangeMarker2 = (RangeMarker)pair.component1();
                        CharSequence replacement = (CharSequence)pair.component2();
                        if (!rangeMarker.isValid()) {
                            FileUpdates.Companion.getLOG$intellij_platform_lang_impl().warn("Cannot apply rename patch: invalid range marker. Document: " + this.$document + ", marker: " + rangeMarker);
                            continue;
                        }
                        this.$document.replaceString(rangeMarker.getStartOffset(), rangeMarker.getEndOffset(), replacement);
                        rangeMarker.dispose();
                    }
                }
                {
                    this.$modifications = list2;
                    this.$document = document;
                }
            });
        }
        for (Pair pair : this.filesToMove) {
            VirtualFile parentFile;
            Path parentPath;
            document = (VirtualFile)pair.component1();
            Path path2 = (Path)pair.component2();
            if (!virtualFile2.isValid()) {
                LOG.warn("Cannot apply rename patch: invalid file to move. File: " + virtualFile2);
                continue;
            }
            if (path2.getParent() == null) {
                continue;
            }
            if (VfsUtil.findFile((Path)parentPath, (boolean)false) == null) {
                continue;
            }
            virtualFile2.move(this, parentFile);
            String newFileName = ((Object)path2.getFileName()).toString();
            if (!(Intrinsics.areEqual((Object)virtualFile2.getName(), (Object)newFileName) ^ true)) continue;
            virtualFile2.rename(this, newFileName);
        }
        for (Pair pair : this.filesToAdd) {
            void path3;
            virtualFile2 = (Path)pair.component1();
            CharSequence content2 = (CharSequence)pair.component2();
            PathKt.write$default((Path)path3, (CharSequence)content2, null, (boolean)false, (int)6, null);
        }
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Map<VirtualFile, CharSequence> preview() {
        Object $this$getOrPut$iv232;
        Object value$iv$iv$iv;
        void $this$groupByTo$iv$iv;
        ApplicationManager.getApplication().assertReadAccessAllowed();
        Iterable $this$groupBy$iv = this.documentModifications;
        boolean bl = false;
        Map.Entry entry222 = $this$groupBy$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        for (Object element$iv$iv : $this$groupByTo$iv$iv) {
            Object object;
            Pair $dstr$rangeMarker$_u24__u24 = (Pair)element$iv$iv;
            boolean bl2 = false;
            RangeMarker rangeMarker = (RangeMarker)$dstr$rangeMarker$_u24__u24.component1();
            Document key$iv$iv = rangeMarker.getDocument();
            Map $this$getOrPut$iv$iv$iv = destination$iv$iv;
            boolean $i$f$getOrPut = false;
            value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl22 = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object = answer$iv$iv$iv;
            } else {
                object = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object;
            list$iv$iv.add(element$iv$iv);
        }
        Map byDocument = destination$iv$iv;
        HashMap documentOperations = new HashMap(byDocument.size());
        destination$iv$iv = byDocument;
        $i$f$groupByTo = false;
        for (Map.Entry entry2 : destination$iv$iv.entrySet()) {
            Object object;
            void document;
            void $this$mapNotNullTo$iv$iv;
            Object object2 = entry2;
            boolean element$iv$iv = false;
            destination$iv$iv = (Document)object2.getKey();
            object2 = entry2;
            element$iv$iv = false;
            List modifications = (List)object2.getValue();
            Object $this$mapNotNull$iv = modifications;
            boolean $i$f$mapNotNull = false;
            Iterable bl2 = $this$mapNotNull$iv;
            Collection destination$iv$iv2 = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            value$iv$iv$iv = $this$forEach$iv$iv$iv.iterator();
            while (value$iv$iv$iv.hasNext()) {
                StringOperation stringOperation;
                void rangeMarker;
                Object element$iv$iv$iv;
                Object element$iv$iv2 = element$iv$iv$iv = value$iv$iv$iv.next();
                boolean bl3 = false;
                Pair $dstr$rangeMarker$replacement = (Pair)element$iv$iv2;
                boolean bl4 = false;
                RangeMarker rangeMarker2 = (RangeMarker)$dstr$rangeMarker$replacement.component1();
                CharSequence replacement = (CharSequence)$dstr$rangeMarker$replacement.component2();
                if (UtilsKt.getRange((RangeMarker)rangeMarker) != null) {
                    TextRange textRange;
                    boolean bl5 = false;
                    boolean bl6 = false;
                    TextRange range2 = textRange;
                    boolean bl7 = false;
                    stringOperation = StringOperation.replace((TextRange)range2, (CharSequence)replacement);
                } else {
                    stringOperation = null;
                }
                if (stringOperation == null) continue;
                StringOperation stringOperation2 = stringOperation;
                boolean bl8 = false;
                boolean bl9 = false;
                StringOperation it$iv$iv = stringOperation2;
                boolean bl10 = false;
                destination$iv$iv2.add(it$iv$iv);
            }
            List operations = (List)destination$iv$iv2;
            if (document instanceof DocumentWindow) {
                void $this$flatMapTo$iv$iv;
                Object object3;
                Document key$iv;
                Collection $this$getOrPut$iv;
                $this$mapNotNull$iv = documentOperations;
                Intrinsics.checkNotNullExpressionValue((Object)((DocumentWindow)document).getDelegate(), (String)"document.delegate");
                boolean $i$f$getOrPut = false;
                Object value$iv = $this$getOrPut$iv.get(key$iv);
                if (value$iv == null) {
                    boolean bl11 = false;
                    List answer$iv = new ArrayList();
                    $this$getOrPut$iv.put(key$iv, answer$iv);
                    object3 = answer$iv;
                } else {
                    object3 = value$iv;
                }
                $this$getOrPut$iv = (List)object3;
                Iterable $this$flatMap$iv = operations;
                boolean $i$f$flatMap = false;
                value$iv = $this$flatMap$iv;
                Collection destination$iv$iv3 = new ArrayList();
                boolean $i$f$flatMapTo = false;
                for (Object element$iv$iv3 : $this$flatMapTo$iv$iv) {
                    TextRange range3;
                    StringOperation operation = (StringOperation)element$iv$iv3;
                    boolean bl12 = false;
                    Intrinsics.checkNotNullExpressionValue((Object)operation.getRange(), (String)"operation.range");
                    Iterable list$iv$iv = ((DocumentWindow)document).prepareReplaceString(range3.getStartOffset(), range3.getEndOffset(), operation.getReplacement());
                    CollectionsKt.addAll((Collection)destination$iv$iv3, (Iterable)list$iv$iv);
                }
                $this$flatMap$iv = (List)destination$iv$iv3;
                $i$f$flatMap = false;
                CollectionsKt.addAll((Collection)$this$getOrPut$iv, (Iterable)$this$flatMap$iv);
                continue;
            }
            $this$getOrPut$iv232 = documentOperations;
            boolean $i$f$getOrPut = false;
            Object value$iv = $this$getOrPut$iv232.get(document);
            if (value$iv == null) {
                boolean bl13 = false;
                List answer$iv = new ArrayList();
                $this$getOrPut$iv232.put(document, answer$iv);
                object = answer$iv;
            } else {
                object = value$iv;
            }
            $this$getOrPut$iv232 = (List)object;
            boolean bl14 = false;
            CollectionsKt.addAll((Collection)$this$getOrPut$iv232, (Iterable)operations);
        }
        HashMap hashMap = new HashMap(byDocument.size());
        Map modifications = documentOperations;
        boolean operations = false;
        for (Map.Entry entry222 : modifications.entrySet()) {
            void document;
            $this$getOrPut$iv232 = entry222;
            boolean bl3 = false;
            modifications = (Document)$this$getOrPut$iv232.getKey();
            $this$getOrPut$iv232 = entry222;
            bl3 = false;
            List operations2 = (List)$this$getOrPut$iv232.getValue();
            boolean $this$getOrPut$iv232 = !(document instanceof DocumentWindow);
            bl3 = false;
            boolean bl15 = false;
            bl15 = false;
            boolean bl16 = false;
            if (!$this$getOrPut$iv232) {
                boolean bl17 = false;
                String string = "Check failed.";
                throw (Throwable)new IllegalStateException(string.toString());
            }
            VirtualFile virtualFile2 = FileDocumentManager.getInstance().getFile((Document)document);
            bl15 = false;
            bl16 = false;
            bl16 = false;
            boolean bl18 = false;
            if (virtualFile2 == null) {
                boolean bl19 = false;
                String string = "Required value was null.";
                throw (Throwable)new IllegalArgumentException(string.toString());
            }
            VirtualFile virtualFile3 = virtualFile2;
            Map map2 = hashMap;
            CharSequence charSequence = StringOperation.applyOperations((CharSequence)document.getCharsSequence(), (Collection)operations2);
            Intrinsics.checkNotNullExpressionValue((Object)charSequence, (String)"StringOperation.applyOpe\u2026harsSequence, operations)");
            map2.put(virtualFile3, charSequence);
        }
        return hashMap;
    }

    @NotNull
    public final List<Pair<Path, CharSequence>> getFilesToAdd() {
        return this.filesToAdd;
    }

    @NotNull
    public final List<Pair<VirtualFile, Path>> getFilesToMove() {
        return this.filesToMove;
    }

    @NotNull
    public final List<VirtualFile> getFilesToRemove() {
        return this.filesToRemove;
    }

    @NotNull
    public final List<Pair<RangeMarker, CharSequence>> getDocumentModifications() {
        return this.documentModifications;
    }

    public FileUpdates(@NotNull List<? extends Pair<? extends Path, ? extends CharSequence>> filesToAdd, @NotNull List<? extends Pair<? extends VirtualFile, ? extends Path>> filesToMove, @NotNull List<? extends VirtualFile> filesToRemove2, @NotNull List<? extends Pair<? extends RangeMarker, ? extends CharSequence>> documentModifications) {
        Intrinsics.checkNotNullParameter(filesToAdd, (String)"filesToAdd");
        Intrinsics.checkNotNullParameter(filesToMove, (String)"filesToMove");
        Intrinsics.checkNotNullParameter(filesToRemove2, (String)"filesToRemove");
        Intrinsics.checkNotNullParameter(documentModifications, (String)"documentModifications");
        this.filesToAdd = filesToAdd;
        this.filesToMove = filesToMove;
        this.filesToRemove = filesToRemove2;
        this.documentModifications = documentModifications;
    }

    static {
        Companion = new Companion(null);
        Logger logger = Logger.getInstance(FileUpdates.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"Logger.getInstance(FileUpdates::class.java)");
        LOG = logger;
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\u0007\u001a\u0004\u0018\u00010\b2\b\u0010\t\u001a\u0004\u0018\u00010\b2\b\u0010\n\u001a\u0004\u0018\u00010\bR\u0014\u0010\u0003\u001a\u00020\u0004X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u000b"}, d2={"Lcom/intellij/refactoring/rename/impl/FileUpdates$Companion;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "getLOG$intellij_platform_lang_impl", "()Lcom/intellij/openapi/diagnostic/Logger;", "merge", "Lcom/intellij/refactoring/rename/impl/FileUpdates;", "left", "right", "intellij.platform.lang.impl"})
    public static final class Companion {
        @NotNull
        public final Logger getLOG$intellij_platform_lang_impl() {
            return LOG;
        }

        @Nullable
        public final FileUpdates merge(@Nullable FileUpdates left, @Nullable FileUpdates right) {
            return left == null ? right : (right == null ? left : new FileUpdates(CollectionsKt.plus((Collection)left.getFilesToAdd(), (Iterable)right.getFilesToAdd()), CollectionsKt.plus((Collection)left.getFilesToMove(), (Iterable)right.getFilesToMove()), CollectionsKt.plus((Collection)left.getFilesToRemove(), (Iterable)right.getFilesToRemove()), CollectionsKt.plus((Collection)left.getDocumentModifications(), (Iterable)right.getDocumentModifications())));
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

