/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.rename.inplace;

import com.intellij.codeInsight.highlighting.HighlightManager;
import com.intellij.codeInsight.template.Template;
import com.intellij.codeInsight.template.impl.TemplateState;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.refactoring.rename.impl.TextOptions;
import com.intellij.refactoring.rename.inplace.InplaceTemplateHighlighting;
import java.util.ArrayList;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=2, d1={"\u0000,\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a0\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0000\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"NO_HIGHLIGHTING", "Lcom/intellij/openapi/editor/colors/TextAttributesKey;", "highlightTemplateVariables", "Lcom/intellij/refactoring/rename/inplace/InplaceTemplateHighlighting;", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "template", "Lcom/intellij/codeInsight/template/Template;", "templateState", "Lcom/intellij/codeInsight/template/impl/TemplateState;", "textOptions", "Lcom/intellij/refactoring/rename/impl/TextOptions;", "intellij.platform.lang.impl"})
public final class HighlightingKt {
    private static final TextAttributesKey NO_HIGHLIGHTING;

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final InplaceTemplateHighlighting highlightTemplateVariables(@NotNull Project project, @NotNull Editor editor2, @NotNull Template template, @NotNull TemplateState templateState2, @NotNull TextOptions textOptions) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)template, (String)"template");
        Intrinsics.checkNotNullParameter((Object)templateState2, (String)"templateState");
        Intrinsics.checkNotNullParameter((Object)textOptions, (String)"textOptions");
        HighlightManager highlightManager = HighlightManager.getInstance((Project)project);
        Intrinsics.checkNotNullExpressionValue((Object)highlightManager, (String)"HighlightManager.getInstance(project)");
        HighlightManager highlightManager2 = highlightManager;
        ArrayList usageHighlighters = new ArrayList();
        ArrayList commentStringHighlighters = new ArrayList();
        ArrayList textHighlighters = new ArrayList();
        int n = 0;
        int n2 = templateState2.getSegmentsCount();
        while (n < n2) {
            String variableName;
            void i2;
            TextRange range2 = templateState2.getSegmentRange((int)i2);
            Intrinsics.checkNotNullExpressionValue((Object)template.getSegmentName((int)i2), (String)"template.getSegmentName(i)");
            TextAttributesKey key = Intrinsics.areEqual((Object)variableName, (Object)"PrimaryVariable") ? EditorColors.WRITE_SEARCH_RESULT_ATTRIBUTES : EditorColors.SEARCH_RESULT_ATTRIBUTES;
            ArrayList highlighters = StringsKt.startsWith$default((String)variableName, (String)"comment_string_usage_", (boolean)false, (int)2, null) ? commentStringHighlighters : (StringsKt.startsWith$default((String)variableName, (String)"plain_text_usage_", (boolean)false, (int)2, null) ? textHighlighters : usageHighlighters);
            TextRange textRange = range2;
            Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"range");
            highlightManager2.addOccurrenceHighlight(editor2, textRange.getStartOffset(), range2.getEndOffset(), key, 0, (Collection)highlighters);
            ++i2;
        }
        for (RangeHighlighter highlighter : CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)usageHighlighters, (Iterable)commentStringHighlighters), (Iterable)textHighlighters)) {
            highlighter.setGreedyToLeft(true);
            highlighter.setGreedyToRight(true);
        }
        return new InplaceTemplateHighlighting(editor2, highlightManager2, usageHighlighters, commentStringHighlighters, textHighlighters);
    }

    static {
        TextAttributesKey textAttributesKey = TextAttributesKey.createTextAttributesKey((String)"no_highlighting");
        Intrinsics.checkNotNullExpressionValue((Object)textAttributesKey, (String)"TextAttributesKey.create\u2026tesKey(\"no_highlighting\")");
        NO_HIGHLIGHTING = textAttributesKey;
    }

    public static final /* synthetic */ TextAttributesKey access$getNO_HIGHLIGHTING$p() {
        return NO_HIGHLIGHTING;
    }
}

