/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.rename.inplace;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.markup.HighlighterTargetArea;
import com.intellij.openapi.editor.markup.MarkupModel;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.JBPopupListener;
import com.intellij.openapi.ui.popup.LightweightWindowEvent;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.rename.RenameUsagesCollector;
import com.intellij.testFramework.TestModeFlags;
import com.intellij.ui.SimpleListCellRenderer;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.ListCellRenderer;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public abstract class RenameChooser {
    @NonNls
    private static final String CODE_OCCURRENCES = "rename.string.select.code.occurrences";
    @NonNls
    private static final String ALL_OCCURRENCES = "rename.string.select.all.occurrences";
    public static final Key<Boolean> CHOOSE_ALL_OCCURRENCES_IN_TEST = Key.create((String)"RenameChooser.CHOOSE_ALL_OCCURRENCES_IN_TEST");
    private final Set<RangeHighlighter> myRangeHighlighters = new HashSet<RangeHighlighter>();
    private final Editor myEditor;

    RenameChooser(Editor editor2) {
        this.myEditor = editor2;
    }

    protected abstract void runRenameTemplate(Collection<Pair<PsiElement, TextRange>> var1);

    public void showChooser(Collection<? extends PsiReference> refs, Collection<Pair<PsiElement, TextRange>> stringUsages) {
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            this.runRenameTemplate(TestModeFlags.is(CHOOSE_ALL_OCCURRENCES_IN_TEST) ? stringUsages : new ArrayList());
            return;
        }
        JBPopupFactory.getInstance().createPopupChooserBuilder((List)ContainerUtil.newArrayList((Object[])new String[]{CODE_OCCURRENCES, ALL_OCCURRENCES})).setItemSelectedCallback(selectedValue -> {
            RangeHighlighter rangeHighlighter;
            TextRange textRange;
            if (selectedValue == null) {
                return;
            }
            this.dropHighlighters();
            MarkupModel markupModel = this.myEditor.getMarkupModel();
            if (selectedValue.equals(ALL_OCCURRENCES)) {
                for (Pair pair : stringUsages) {
                    textRange = ((TextRange)pair.second).shiftRight(((PsiElement)pair.first).getTextOffset());
                    rangeHighlighter = markupModel.addRangeHighlighter(EditorColors.SEARCH_RESULT_ATTRIBUTES, textRange.getStartOffset(), textRange.getEndOffset(), 5999, HighlighterTargetArea.EXACT_RANGE);
                    this.myRangeHighlighters.add(rangeHighlighter);
                }
            }
            for (PsiReference reference2 : refs) {
                textRange = reference2.getAbsoluteRange();
                rangeHighlighter = markupModel.addRangeHighlighter(EditorColors.SEARCH_RESULT_ATTRIBUTES, textRange.getStartOffset(), textRange.getEndOffset(), 5999, HighlighterTargetArea.EXACT_RANGE);
                this.myRangeHighlighters.add(rangeHighlighter);
            }
        }).setTitle(RefactoringBundle.message((String)"rename.string.occurrences.found.title")).setRenderer((ListCellRenderer)SimpleListCellRenderer.create((String)"", RefactoringBundle::message)).setMovable(false).setResizable(false).setRequestFocus(true).setItemChosenCallback(selectedValue -> {
            RenameUsagesCollector.localSearchInCommentsEvent.log((Object)ALL_OCCURRENCES.equals(selectedValue));
            this.runRenameTemplate(ALL_OCCURRENCES.equals(selectedValue) ? stringUsages : new ArrayList());
        }).addListener(new JBPopupListener(){

            public void onClosed(@NotNull LightweightWindowEvent event) {
                if (event == null) {
                    1.$$$reportNull$$$0(0);
                }
                RenameChooser.this.dropHighlighters();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/refactoring/rename/inplace/RenameChooser$1", "onClosed"));
            }
        }).createPopup().showInBestPositionFor(this.myEditor);
    }

    private void dropHighlighters() {
        for (RangeHighlighter highlight : this.myRangeHighlighters) {
            highlight.dispose();
        }
        this.myRangeHighlighters.clear();
    }
}

