/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.remote;

import com.intellij.ide.IdeBundle;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkType;
import com.intellij.openapi.projectRoots.impl.ProjectJdkImpl;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.remote.RemoteSdkAdditionalData;
import com.intellij.remote.RemoteSdkException;
import com.intellij.remote.RemoteSdkFactory;
import java.util.Collection;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class RemoteSdkFactoryImpl<T extends RemoteSdkAdditionalData>
implements RemoteSdkFactory<T> {
    @Override
    public Sdk createRemoteSdk(@Nullable Project project, @NotNull T data2, @Nullable String sdkName, Collection<Sdk> existingSdks) throws RemoteSdkException {
        if (data2 == null) {
            RemoteSdkFactoryImpl.$$$reportNull$$$0(0);
        }
        String sdkVersion = this.getSdkVersion(project, data2);
        String name2 = StringUtil.isNotEmpty((String)sdkName) ? sdkName : this.getSdkName(data2, sdkVersion);
        SdkType sdkType = this.getSdkType(data2);
        ProjectJdkImpl sdk2 = this.createSdk(existingSdks, sdkType, data2, name2);
        sdk2.setVersionString(sdkVersion);
        data2.setValid(true);
        return sdk2;
    }

    @Override
    public String generateSdkHomePath(@NotNull T data2) {
        if (data2 == null) {
            RemoteSdkFactoryImpl.$$$reportNull$$$0(1);
        }
        return data2.getSdkId();
    }

    @NotNull
    protected abstract SdkType getSdkType(@NotNull T var1);

    @NotNull
    protected abstract String getSdkName(@NotNull T var1, @Nullable String var2) throws RemoteSdkException;

    @Nullable
    protected abstract String getSdkVersion(Project var1, @NotNull T var2) throws RemoteSdkException;

    @Override
    @NotNull
    public Sdk createUnfinished(T data2, Collection<Sdk> existingSdks) {
        String name2 = this.getDefaultUnfinishedName();
        SdkType sdkType = this.getSdkType(data2);
        ProjectJdkImpl sdk2 = this.createSdk(existingSdks, sdkType, data2, name2);
        data2.setValid(false);
        ProjectJdkImpl projectJdkImpl = sdk2;
        if (projectJdkImpl == null) {
            RemoteSdkFactoryImpl.$$$reportNull$$$0(2);
        }
        return projectJdkImpl;
    }

    @NotNull
    protected abstract ProjectJdkImpl createSdk(@NotNull Collection<Sdk> var1, @NotNull SdkType var2, @NotNull T var3, @Nullable String var4);

    @Override
    public abstract String getDefaultUnfinishedName();

    @Override
    public boolean canSaveUnfinished() {
        return false;
    }

    @NotNull
    @Nls
    public static String getDefaultUnfinishedInterpreterName(@NotNull String sdkName) {
        if (sdkName == null) {
            RemoteSdkFactoryImpl.$$$reportNull$$$0(3);
        }
        String string = IdeBundle.message((String)"interpreter.default.name", (Object[])new Object[]{sdkName});
        if (string == null) {
            RemoteSdkFactoryImpl.$$$reportNull$$$0(4);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/remote/RemoteSdkFactoryImpl";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdkName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/remote/RemoteSdkFactoryImpl";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createUnfinished";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultUnfinishedInterpreterName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createRemoteSdk";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "generateSdkHomePath";
                break;
            }
            case 2: 
            case 4: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getDefaultUnfinishedInterpreterName";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

