/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.remoteDev.downloader;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.intellij.openapi.application.ApplicationInfo;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.remoteDev.connection.CodeWithMeSessionInfoProvider;
import com.intellij.remoteDev.connection.StunTurnServerInfo;
import com.intellij.remoteDev.downloader.ThinClientSessionInfoFetcher;
import com.intellij.util.UriUtilKt;
import com.intellij.util.io.HttpRequests;
import com.intellij.util.system.CpuArch;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URLConnection;
import java.util.List;
import java.util.Set;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u00c7\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002J\b\u0010\n\u001a\u00020\u0007H\u0002J\b\u0010\u000b\u001a\u00020\u0007H\u0002J\u000e\u0010\f\u001a\u00020\r2\u0006\u0010\b\u001a\u00020\tR\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/intellij/remoteDev/downloader/ThinClientSessionInfoFetcher;", "", "()V", "objectMapper", "Lkotlin/Lazy;", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "createUrl", "", "joinLinkUrl", "Ljava/net/URI;", "currentBuildNumber", "currentPlatform", "getSessionUrl", "Lcom/intellij/remoteDev/connection/CodeWithMeSessionInfoProvider;", "intellij.remoteDev.util"})
@ApiStatus.Experimental
public final class ThinClientSessionInfoFetcher {
    private static final Lazy<ObjectMapper> objectMapper;
    @NotNull
    public static final ThinClientSessionInfoFetcher INSTANCE;

    @NotNull
    public final CodeWithMeSessionInfoProvider getSessionUrl(@NotNull URI joinLinkUrl) {
        Intrinsics.checkNotNullParameter((Object)joinLinkUrl, (String)"joinLinkUrl");
        String url = this.createUrl(joinLinkUrl);
        ObjectNode objectNode = ((ObjectMapper)objectMapper.getValue()).createObjectNode();
        boolean bl = false;
        boolean bl2 = false;
        ObjectNode $this$apply = objectNode;
        boolean bl3 = false;
        $this$apply.put("clientBuildNumber", INSTANCE.currentBuildNumber());
        $this$apply.put("clientPlatform", INSTANCE.currentPlatform());
        String requestString = objectNode.toPrettyString();
        Object object = HttpRequests.post((String)url, (String)"application/json; charset=utf-8").throwStatusCodeException(false).productNameAsUserAgent().connect(new HttpRequests.RequestProcessor(requestString, url){
            final /* synthetic */ String $requestString;
            final /* synthetic */ String $url;

            public final getSessionUrl.1 process(@NotNull HttpRequests.Request request2) {
                Intrinsics.checkNotNullParameter((Object)request2, (String)"request");
                request2.write(this.$requestString);
                URLConnection uRLConnection = request2.getConnection();
                if (uRLConnection == null) {
                    throw new NullPointerException("null cannot be cast to non-null type java.net.HttpURLConnection");
                }
                HttpURLConnection connection = (HttpURLConnection)uRLConnection;
                String string = request2.readString();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"request.readString()");
                String responseString = string;
                if (connection.getResponseCode() >= 400) {
                    throw (Throwable)new Exception("Request to " + this.$url + " failed with status code " + connection.getResponseCode());
                }
                JsonNode sessionInfo2 = ((ObjectMapper)ThinClientSessionInfoFetcher.access$getObjectMapper$p(ThinClientSessionInfoFetcher.INSTANCE).getValue()).reader().readTree(responseString);
                return new CodeWithMeSessionInfoProvider(sessionInfo2){
                    private final String hostBuildNumber;
                    private final String compatibleClientName;
                    private final String compatibleClientUrl;
                    private final String compatibleJreName;
                    private final boolean isUnattendedMode;
                    private final String compatibleJreUrl;
                    @Nullable
                    private final Set<String> hostFeaturesToEnable;
                    @Nullable
                    private final List<StunTurnServerInfo> stunTurnServers;
                    @Nullable
                    private final String downloadPgpPublicKeyUrl;
                    final /* synthetic */ JsonNode $sessionInfo;

                    public String getHostBuildNumber() {
                        return this.hostBuildNumber;
                    }

                    public String getCompatibleClientName() {
                        return this.compatibleClientName;
                    }

                    public String getCompatibleClientUrl() {
                        return this.compatibleClientUrl;
                    }

                    public String getCompatibleJreName() {
                        return this.compatibleJreName;
                    }

                    public boolean isUnattendedMode() {
                        return this.isUnattendedMode;
                    }

                    public String getCompatibleJreUrl() {
                        return this.compatibleJreUrl;
                    }

                    @Nullable
                    public Set<String> getHostFeaturesToEnable() {
                        return this.hostFeaturesToEnable;
                    }

                    @Nullable
                    public List<StunTurnServerInfo> getStunTurnServers() {
                        return this.stunTurnServers;
                    }

                    @Nullable
                    public String getDownloadPgpPublicKeyUrl() {
                        return this.downloadPgpPublicKeyUrl;
                    }
                    {
                        this.$sessionInfo = $captured_local_variable$0;
                        this.hostBuildNumber = $captured_local_variable$0.get("hostBuildNumber").asText();
                        this.compatibleClientName = $captured_local_variable$0.get("compatibleClientName").asText();
                        this.compatibleClientUrl = $captured_local_variable$0.get("compatibleClientUrl").asText();
                        this.compatibleJreName = $captured_local_variable$0.get("compatibleJreName").asText();
                        this.compatibleJreUrl = $captured_local_variable$0.get("compatibleJreUrl").asText();
                    }
                };
            }
            {
                this.$requestString = string;
                this.$url = string2;
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"HttpRequests.post(url, H\u2026 = null\n        }\n      }");
        return (CodeWithMeSessionInfoProvider)object;
    }

    private final String createUrl(URI joinLinkUrl) {
        String string = UriUtilKt.withFragment(joinLinkUrl, null).toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"joinLinkUrl.withFragment(null).toString()");
        String baseLink = StringsKt.trimEnd((String)string, (char[])new char[]{'/'});
        return baseLink + "/info";
    }

    private final String currentBuildNumber() {
        ApplicationInfo applicationInfo = ApplicationInfo.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)applicationInfo, (String)"ApplicationInfo.getInstance()");
        String string = applicationInfo.getBuild().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"ApplicationInfo.getInstance().build.toString()");
        return string;
    }

    private final String currentPlatform() {
        String string;
        if (SystemInfo.isMac && CpuArch.isArm64()) {
            string = "osx-aarch64";
        } else if (SystemInfo.isMac && CpuArch.isIntel64()) {
            string = "osx-x64";
        } else if (SystemInfo.isLinux && CpuArch.isIntel64()) {
            string = "linux-x64";
        } else if (SystemInfo.isWindows && CpuArch.isIntel64()) {
            string = "windows-x64";
        } else {
            String string2 = "Unsupported OS type: " + SystemInfo.OS_NAME + ", CpuArch: " + CpuArch.CURRENT;
            boolean bl = false;
            throw (Throwable)new IllegalStateException(string2.toString());
        }
        return string;
    }

    private ThinClientSessionInfoFetcher() {
    }

    static {
        ThinClientSessionInfoFetcher thinClientSessionInfoFetcher;
        INSTANCE = thinClientSessionInfoFetcher = new ThinClientSessionInfoFetcher();
        objectMapper = LazyKt.lazy((Function0)objectMapper.1.INSTANCE);
    }

    public static final /* synthetic */ Lazy access$getObjectMapper$p(ThinClientSessionInfoFetcher $this) {
        ThinClientSessionInfoFetcher thinClientSessionInfoFetcher = $this;
        return objectMapper;
    }
}

