/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.remoteDev.util;

import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\b\b\b\u00c7\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0006\u001a\u00020\u00042\u0012\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\bJ\u001a\u0010\t\u001a\u00020\u00042\u0012\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\bJ\u001a\u0010\u000b\u001a\u00020\u00042\u0012\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\bJ\u001a\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\b2\u0006\u0010\u0007\u001a\u00020\u0004J\u0010\u0010\r\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u0004H\u0002J\u0010\u0010\u000f\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u0004H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/intellij/remoteDev/util/RemoteDevProtocolUtil;", "", "()V", "gatewayPrefix", "", "httpPrefix", "buildParamsString", "params", "", "createGatewayUrl", "parameters", "createHttpUrl", "parseParamsString", "urlDecode", "value", "urlEncode", "intellij.remoteDev.util"})
@ApiStatus.Experimental
public final class RemoteDevProtocolUtil {
    @NotNull
    public static final String gatewayPrefix = "jetbrains-gateway://connect";
    @NotNull
    public static final String httpPrefix = "https://code-with-me.jetbrains.com/remoteDev";
    @NotNull
    public static final RemoteDevProtocolUtil INSTANCE;

    @NotNull
    public final String createGatewayUrl(@NotNull Map<String, String> parameters2) {
        Intrinsics.checkNotNullParameter(parameters2, (String)"parameters");
        return "jetbrains-gateway://connect#" + this.buildParamsString(parameters2);
    }

    @NotNull
    public final String createHttpUrl(@NotNull Map<String, String> parameters2) {
        Intrinsics.checkNotNullParameter(parameters2, (String)"parameters");
        return "https://code-with-me.jetbrains.com/remoteDev#" + this.buildParamsString(parameters2);
    }

    private final String urlEncode(String value2) {
        String string = URLEncoder.encode(value2, StandardCharsets.UTF_8.toString());
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"URLEncoder.encode(value,\u2026harsets.UTF_8.toString())");
        return string;
    }

    private final String urlDecode(String value2) {
        String string = URLDecoder.decode(value2, StandardCharsets.UTF_8.toString());
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"URLDecoder.decode(value,\u2026harsets.UTF_8.toString())");
        return string;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final String buildParamsString(@NotNull Map<String, String> params) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(params, (String)"params");
        Map<String, String> $this$map$iv = params;
        boolean $i$f$map = false;
        Map<String, String> map2 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.size());
        boolean $i$f$mapTo = false;
        void var7_7 = $this$mapTo$iv$iv;
        boolean bl = false;
        Iterator iterator2 = var7_7.entrySet().iterator();
        while (iterator2.hasNext()) {
            void it;
            Map.Entry item$iv$iv;
            Map.Entry entry2 = item$iv$iv = iterator2.next();
            Collection collection = destination$iv$iv;
            boolean bl2 = false;
            String string = (String)it.getKey() + '=' + INSTANCE.urlEncode((String)it.getValue());
            collection.add(string);
        }
        return CollectionsKt.joinToString$default((Iterable)((List)destination$iv$iv), (CharSequence)"&", null, null, (int)0, null, null, (int)62, null);
    }

    @NotNull
    public final Map<String, String> parseParamsString(@NotNull String params) {
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        boolean bl = false;
        Map parameters2 = new LinkedHashMap();
        for (String parameterPair : StringsKt.split$default((CharSequence)params, (String[])new String[]{"&"}, (boolean)false, (int)0, (int)6, null)) {
            int index2 = StringsKt.indexOf$default((CharSequence)parameterPair, (String)"=", (int)0, (boolean)false, (int)6, null);
            if (index2 == -1) {
                parameters2.put(parameterPair, "");
                continue;
            }
            String string = parameterPair;
            int n = 0;
            boolean bl2 = false;
            String string2 = string;
            if (string2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
            }
            String string3 = string2.substring(n, index2);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
            string = parameterPair;
            n = index2 + 1;
            bl2 = false;
            String string4 = string;
            if (string4 == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
            }
            String string5 = string4.substring(n);
            Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"(this as java.lang.String).substring(startIndex)");
            parameters2.put(string3, this.urlDecode(string5));
        }
        return parameters2;
    }

    private RemoteDevProtocolUtil() {
    }

    static {
        RemoteDevProtocolUtil remoteDevProtocolUtil;
        INSTANCE = remoteDevProtocolUtil = new RemoteDevProtocolUtil();
    }
}

