/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.remoteServer.impl.configuration;

import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.remoteServer.CloudBundle;
import com.intellij.remoteServer.configuration.RemoteServer;
import com.intellij.remoteServer.runtime.ServerConnection;
import com.intellij.remoteServer.runtime.ServerConnectionManager;
import com.intellij.remoteServer.runtime.ServerConnector;
import com.intellij.remoteServer.runtime.deployment.ServerRuntimeInstance;
import com.intellij.util.concurrency.Semaphore;
import java.util.concurrent.atomic.AtomicReference;
import org.jetbrains.annotations.NotNull;

public class RemoteServerConnectionTester {
    private final RemoteServer<?> myServer;

    public RemoteServerConnectionTester(@NotNull RemoteServer<?> server) {
        if (server == null) {
            RemoteServerConnectionTester.$$$reportNull$$$0(0);
        }
        this.myServer = server;
    }

    public void testConnection(final @NotNull Callback callback2) {
        if (callback2 == null) {
            RemoteServerConnectionTester.$$$reportNull$$$0(1);
        }
        final ServerConnection connection = ServerConnectionManager.getInstance().createTemporaryConnection(this.myServer);
        final AtomicReference<Object> connectedRef = new AtomicReference<Object>(null);
        final Semaphore semaphore = new Semaphore();
        semaphore.down();
        connection.connectIfNeeded(new ServerConnector.ConnectionCallback(){

            public void connected(@NotNull ServerRuntimeInstance serverRuntimeInstance) {
                if (serverRuntimeInstance == null) {
                    1.$$$reportNull$$$0(0);
                }
                connectedRef.set(true);
                semaphore.up();
                connection.disconnect();
            }

            public void errorOccurred(@NotNull String errorMessage) {
                if (errorMessage == null) {
                    1.$$$reportNull$$$0(1);
                }
                connectedRef.set(false);
                semaphore.up();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "serverRuntimeInstance";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "errorMessage";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/remoteServer/impl/configuration/RemoteServerConnectionTester$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "connected";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "errorOccurred";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        new Task.Backgroundable(null, CloudBundle.message((String)"task.title.connecting", (Object[])new Object[0]), true){

            public void run(@NotNull ProgressIndicator indicator2) {
                if (indicator2 == null) {
                    2.$$$reportNull$$$0(0);
                }
                indicator2.setIndeterminate(true);
                while (!indicator2.isCanceled() && !semaphore.waitFor(500L)) {
                }
                Boolean connected = (Boolean)connectedRef.get();
                if (connected == null) {
                    return;
                }
                callback2.connectionTested(connected, connection.getStatusText());
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/remoteServer/impl/configuration/RemoteServerConnectionTester$2", "run"));
            }
        }.queue();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "server";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callback";
                break;
            }
        }
        objectArray2[1] = "com/intellij/remoteServer/impl/configuration/RemoteServerConnectionTester";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "testConnection";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static interface Callback {
        public void connectionTested(boolean var1, @NotNull String var2);
    }
}

