/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.remoteServer.impl.configuration.deployment;

import com.intellij.configurationStore.ComponentSerializationUtil;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.Executor;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.LocatableConfiguration;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.RunConfigurationBase;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.configurations.RuntimeConfigurationException;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.options.SettingsEditorGroup;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.remoteServer.CloudBundle;
import com.intellij.remoteServer.ServerType;
import com.intellij.remoteServer.configuration.RemoteServer;
import com.intellij.remoteServer.configuration.RemoteServersManager;
import com.intellij.remoteServer.configuration.ServerConfiguration;
import com.intellij.remoteServer.configuration.deployment.DeploymentConfiguration;
import com.intellij.remoteServer.configuration.deployment.DeploymentConfigurator;
import com.intellij.remoteServer.configuration.deployment.DeploymentSource;
import com.intellij.remoteServer.configuration.deployment.DeploymentSourceType;
import com.intellij.remoteServer.configuration.deployment.SingletonDeploymentSourceType;
import com.intellij.remoteServer.impl.configuration.deployment.DeployToServerRunConfigurationExtensionsManager;
import com.intellij.remoteServer.impl.configuration.deployment.DeployToServerSettingsEditor;
import com.intellij.remoteServer.impl.runtime.DeployToServerState;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xmlb.SerializationFilter;
import com.intellij.util.xmlb.SkipDefaultValuesSerializationFilters;
import com.intellij.util.xmlb.XmlSerializer;
import com.intellij.util.xmlb.annotations.Attribute;
import com.intellij.util.xmlb.annotations.Tag;
import java.util.List;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DeployToServerRunConfiguration<S extends ServerConfiguration, D extends DeploymentConfiguration>
extends RunConfigurationBase<Element>
implements LocatableConfiguration {
    private static final Logger LOG = Logger.getInstance(DeployToServerRunConfiguration.class);
    private static final String DEPLOYMENT_SOURCE_TYPE_ATTRIBUTE = "type";
    @NonNls
    public static final String SETTINGS_ELEMENT = "settings";
    private static final SkipDefaultValuesSerializationFilters SERIALIZATION_FILTERS = new SkipDefaultValuesSerializationFilters();
    private final String myServerTypeId;
    private final DeploymentConfigurator<D, S> myDeploymentConfigurator;
    private String myServerName;
    private boolean myDeploymentSourceIsLocked;
    private DeploymentSource myDeploymentSource;
    private D myDeploymentConfiguration;

    public DeployToServerRunConfiguration(Project project, ConfigurationFactory factory2, String name2, ServerType<S> serverType, DeploymentConfigurator<D, S> deploymentConfigurator) {
        super(project, factory2, name2);
        this.myServerTypeId = serverType.getId();
        this.myDeploymentConfigurator = deploymentConfigurator;
    }

    void lockDeploymentSource(@NotNull SingletonDeploymentSourceType theOnlySourceType) {
        if (theOnlySourceType == null) {
            DeployToServerRunConfiguration.$$$reportNull$$$0(0);
        }
        this.myDeploymentSourceIsLocked = true;
        this.myDeploymentSource = theOnlySourceType.getSingletonSource();
    }

    @NotNull
    public ServerType<S> getServerType() {
        ServerType result2 = (ServerType)ServerType.EP_NAME.findFirstSafe(next -> next.getId().equals(this.myServerTypeId));
        assert (result2 != null) : "Server type `" + this.myServerTypeId + "` had been unloaded already";
        ServerType serverType = result2;
        if (serverType == null) {
            DeployToServerRunConfiguration.$$$reportNull$$$0(1);
        }
        return serverType;
    }

    public String getServerName() {
        return this.myServerName;
    }

    @NotNull
    private DeploymentConfigurator<D, S> getDeploymentConfigurator() {
        DeploymentConfigurator<D, S> deploymentConfigurator = this.myDeploymentConfigurator;
        if (deploymentConfigurator == null) {
            DeployToServerRunConfiguration.$$$reportNull$$$0(2);
        }
        return deploymentConfigurator;
    }

    @NotNull
    public SettingsEditor<DeployToServerRunConfiguration> getConfigurationEditor() {
        ServerType<S> serverType = this.getServerType();
        DeployToServerSettingsEditor commonEditor = this.myDeploymentSourceIsLocked ? new DeployToServerSettingsEditor.LockedSource<S, D>(serverType, this.myDeploymentConfigurator, this.getProject(), this.myDeploymentSource) : new DeployToServerSettingsEditor.AnySource<S, D>(serverType, this.myDeploymentConfigurator, this.getProject());
        SettingsEditorGroup group2 = new SettingsEditorGroup();
        group2.addEditor(CloudBundle.message((String)"DeployToServerRunConfiguration.tab.title.deployment", (Object[])new Object[0]), commonEditor);
        DeployToServerRunConfigurationExtensionsManager.getInstance().appendEditors(this, group2);
        commonEditor.addSettingsEditorListener(e -> group2.bulkUpdate(() -> {}));
        SettingsEditorGroup settingsEditorGroup = group2;
        if (settingsEditorGroup == null) {
            DeployToServerRunConfiguration.$$$reportNull$$$0(3);
        }
        return settingsEditorGroup;
    }

    @Nullable
    public RunProfileState getState(@NotNull Executor executor, @NotNull ExecutionEnvironment env) throws ExecutionException {
        String serverName;
        if (executor == null) {
            DeployToServerRunConfiguration.$$$reportNull$$$0(4);
        }
        if (env == null) {
            DeployToServerRunConfiguration.$$$reportNull$$$0(5);
        }
        if ((serverName = this.getServerName()) == null) {
            throw new ExecutionException(CloudBundle.message((String)"DeployToServerRunConfiguration.error.server.required", (Object[])new Object[0]));
        }
        RemoteServer<S> server = this.findServer();
        if (server == null) {
            throw new ExecutionException(CloudBundle.message((String)"DeployToServerRunConfiguration.error.server.not.found", (Object[])new Object[]{serverName}));
        }
        if (this.myDeploymentSource == null) {
            throw new ExecutionException(CloudBundle.message((String)"DeployToServerRunConfiguration.error.deployment.not.selected", (Object[])new Object[0]));
        }
        return new DeployToServerState<S, D>(server, this.myDeploymentSource, this.myDeploymentConfiguration, env);
    }

    public void checkConfiguration() throws RuntimeConfigurationException {
        RemoteServer<S> server = this.findServer();
        if (server == null) {
            return;
        }
        if (this.myDeploymentSource == null) {
            return;
        }
        this.myDeploymentConfiguration.checkConfiguration(server, this.myDeploymentSource, this.getProject());
    }

    private RemoteServer<S> findServer() {
        String serverName = this.getServerName();
        if (serverName == null) {
            return null;
        }
        return RemoteServersManager.getInstance().findByName(serverName, this.getServerType());
    }

    public void setServerName(String serverName) {
        this.myServerName = serverName;
    }

    public DeploymentSource getDeploymentSource() {
        return this.myDeploymentSource;
    }

    public void setDeploymentSource(DeploymentSource deploymentSource) {
        if (this.myDeploymentSourceIsLocked) assert (deploymentSource != null && deploymentSource == this.myDeploymentSource) : "Can't replace locked " + this.myDeploymentSource + " with " + deploymentSource;
        this.myDeploymentSource = deploymentSource;
    }

    public D getDeploymentConfiguration() {
        return this.myDeploymentConfiguration;
    }

    public void setDeploymentConfiguration(D deploymentConfiguration) {
        this.myDeploymentConfiguration = deploymentConfiguration;
    }

    public boolean isGeneratedName() {
        return this.getDeploymentSource() != null && this.getDeploymentConfiguration() != null && this.getDeploymentConfigurator().isGeneratedConfigurationName(this.getName(), this.getDeploymentSource(), this.getDeploymentConfiguration());
    }

    @Nullable
    public String suggestedName() {
        if (this.getDeploymentSource() == null || this.getDeploymentConfiguration() == null) {
            return null;
        }
        return this.getDeploymentConfigurator().suggestConfigurationName(this.getDeploymentSource(), this.getDeploymentConfiguration());
    }

    public void readExternal(@NotNull Element element2) throws InvalidDataException {
        if (element2 == null) {
            DeployToServerRunConfiguration.$$$reportNull$$$0(6);
        }
        super.readExternal(element2);
        ConfigurationState state = (ConfigurationState)XmlSerializer.deserialize((Element)element2, ConfigurationState.class);
        this.myServerName = null;
        this.myDeploymentSource = null;
        this.myServerName = state.myServerName;
        Element deploymentTag = state.myDeploymentTag;
        if (deploymentTag != null) {
            String typeId = deploymentTag.getAttributeValue(DEPLOYMENT_SOURCE_TYPE_ATTRIBUTE);
            DeploymentSourceType<?> type = DeployToServerRunConfiguration.findDeploymentSourceType(typeId);
            if (type != null) {
                this.myDeploymentSource = (DeploymentSource)ReadAction.compute(() -> type.load(deploymentTag, this.getProject()));
                this.myDeploymentConfiguration = this.myDeploymentConfigurator.createDefaultConfiguration(this.myDeploymentSource);
                ComponentSerializationUtil.loadComponentState((PersistentStateComponent)this.myDeploymentConfiguration.getSerializer(), (Element)deploymentTag.getChild(SETTINGS_ELEMENT));
            } else {
                LOG.warn("Cannot load deployment source for '" + this.getName() + "' run configuration: unknown deployment type '" + typeId + "'");
            }
        }
        DeployToServerRunConfigurationExtensionsManager.getInstance().readExternal(this, element2);
    }

    @Nullable
    private static DeploymentSourceType<?> findDeploymentSourceType(@Nullable String id2) {
        for (DeploymentSourceType type : (DeploymentSourceType[])DeploymentSourceType.EP_NAME.getExtensions()) {
            if (!type.getId().equals(id2)) continue;
            return type;
        }
        return null;
    }

    public void writeExternal(@NotNull Element element2) throws WriteExternalException {
        if (element2 == null) {
            DeployToServerRunConfiguration.$$$reportNull$$$0(7);
        }
        ConfigurationState state = new ConfigurationState();
        state.myServerName = this.myServerName;
        if (this.myDeploymentSource != null) {
            Object configurationState;
            DeploymentSourceType type = this.myDeploymentSource.getType();
            Element deploymentTag = new Element("deployment").setAttribute(DEPLOYMENT_SOURCE_TYPE_ATTRIBUTE, type.getId());
            type.save(this.myDeploymentSource, deploymentTag);
            if (this.myDeploymentConfiguration != null && (configurationState = this.myDeploymentConfiguration.getSerializer().getState()) != null) {
                Element settingsTag = new Element(SETTINGS_ELEMENT);
                XmlSerializer.serializeInto((Object)configurationState, (Element)settingsTag, (SerializationFilter)SERIALIZATION_FILTERS);
                deploymentTag.addContent(settingsTag);
            }
            state.myDeploymentTag = deploymentTag;
        }
        XmlSerializer.serializeInto((Object)state, (Element)element2, (SerializationFilter)SERIALIZATION_FILTERS);
        super.writeExternal(element2);
        DeployToServerRunConfigurationExtensionsManager.getInstance().writeExternal(this, element2);
    }

    public RunConfiguration clone() {
        Element element2 = new Element("tag");
        try {
            this.writeExternal(element2);
        }
        catch (WriteExternalException e) {
            LOG.error((Throwable)e);
        }
        DeployToServerRunConfiguration result2 = (DeployToServerRunConfiguration)super.clone();
        if (this.myDeploymentSourceIsLocked) {
            result2.lockDeploymentSource((SingletonDeploymentSourceType)this.myDeploymentSource.getType());
        }
        try {
            result2.readExternal(element2);
        }
        catch (InvalidDataException e) {
            LOG.error((Throwable)e);
        }
        return result2;
    }

    public void onNewConfigurationCreated() {
        DeploymentConfigurator<D, S> deploymentConfigurator;
        List sources;
        DeploymentSource source;
        RemoteServer server;
        if (this.getServerName() == null && (server = (RemoteServer)ContainerUtil.getFirstItem((List)RemoteServersManager.getInstance().getServers(this.getServerType()))) != null) {
            this.setServerName(server.getName());
        }
        if (this.getDeploymentSource() == null && (source = (DeploymentSource)ContainerUtil.getFirstItem((List)(sources = (deploymentConfigurator = this.getDeploymentConfigurator()).getAvailableDeploymentSources()))) != null) {
            this.setDeploymentSource(source);
            this.setDeploymentConfiguration(deploymentConfigurator.createDefaultConfiguration(source));
            DeploymentSourceType type = source.getType();
            type.setBuildBeforeRunTask((RunConfiguration)this, source);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "theOnlySourceType";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/remoteServer/impl/configuration/deployment/DeployToServerRunConfiguration";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "executor";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "env";
                break;
            }
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/remoteServer/impl/configuration/deployment/DeployToServerRunConfiguration";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getServerType";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getDeploymentConfigurator";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getConfigurationEditor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "lockDeploymentSource";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getState";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "readExternal";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "writeExternal";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class ConfigurationState {
        @Attribute(value="server-name")
        public String myServerName;
        @Tag(value="deployment")
        public Element myDeploymentTag;
    }
}

