/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spellchecker;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.spellchecker.StreamLoader;
import com.intellij.spellchecker.dictionary.Loader;
import java.io.File;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;

public final class FileLoader
implements Loader {
    private static final Logger LOG = Logger.getInstance(FileLoader.class);
    private final String url;
    private final String name;

    public FileLoader(String url, String name2) {
        this.url = url;
        this.name = name2;
    }

    public FileLoader(String url) {
        this(url, url);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void load(@NotNull Consumer<String> consumer2) {
        VirtualFile file2;
        if (consumer2 == null) {
            FileLoader.$$$reportNull$$$0(0);
        }
        if ((file2 = VfsUtil.findFileByIoFile((File)new File(this.url), (boolean)true)) == null || file2.isDirectory()) {
            return;
        }
        Charset charset = file2.getCharset();
        try (InputStream stream = file2.getInputStream();){
            StreamLoader.doLoad(stream, consumer2, charset);
        }
        catch (Exception e) {
            LOG.error((Throwable)e);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "com/intellij/spellchecker/FileLoader", "load"));
    }
}

