/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spellchecker.grazie.dictionary;

import ai.grazie.spell.lists.WordList;
import ai.grazie.spell.utils.Distances;
import com.intellij.spellchecker.dictionary.Dictionary;
import com.intellij.spellchecker.grazie.dictionary.EditableWordListAdapter;
import com.intellij.util.Consumer;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0005H\u0016J\u000e\u0010\t\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J \u0010\n\u001a\u0012\u0012\u0004\u0012\u00020\u00070\u000bj\b\u0012\u0004\u0012\u00020\u0007`\f2\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\r"}, d2={"Lcom/intellij/spellchecker/grazie/dictionary/WordListAdapter;", "Lai/grazie/spell/lists/WordList;", "Lcom/intellij/spellchecker/grazie/dictionary/EditableWordListAdapter;", "()V", "contains", "", "word", "", "caseSensitive", "isAlien", "suggest", "Ljava/util/LinkedHashSet;", "Lkotlin/collections/LinkedHashSet;", "intellij.spellchecker"})
public final class WordListAdapter
extends EditableWordListAdapter
implements WordList {
    public final boolean isAlien(@NotNull String word) {
        boolean bl;
        block3: {
            Intrinsics.checkNotNullParameter((Object)word, (String)"word");
            Collection<Dictionary> collection = this.getDictionaries().values();
            Intrinsics.checkNotNullExpressionValue(collection, (String)"dictionaries.values");
            Iterable $this$all$iv = collection;
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$all$iv) {
                    Dictionary it = (Dictionary)element$iv;
                    boolean bl2 = false;
                    if (it.contains(word) == null) continue;
                    bl = false;
                    break block3;
                }
                bl = true;
            }
        }
        return bl && !WordList.DefaultImpls.contains$default((WordList)this.getAggregator(), (String)word, (boolean)false, (int)2, null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean contains(@NotNull String word, boolean caseSensitive) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)word, (String)"word");
        if (caseSensitive) {
            Collection<Dictionary> collection = this.getDictionaries().values();
            Intrinsics.checkNotNullExpressionValue(collection, (String)"dictionaries.values");
            Iterable $this$any$iv = collection;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    Dictionary it = (Dictionary)element$iv;
                    boolean bl2 = false;
                    Boolean bl3 = it.contains(word);
                    if (!(bl3 != null ? bl3 : false)) continue;
                    return true;
                }
                bl = false;
            }
        } else {
            String $i$f$any = word;
            boolean bl4 = false;
            String string = $i$f$any.toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"(this as java.lang.Strin\u2026.toLowerCase(Locale.ROOT)");
            String lowered = string;
            Collection<Dictionary> collection = this.getDictionaries().values();
            Intrinsics.checkNotNullExpressionValue(collection, (String)"dictionaries.values");
            Iterable $this$any$iv = collection;
            boolean $i$f$any2 = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    Dictionary it = (Dictionary)element$iv;
                    boolean bl5 = false;
                    Boolean bl6 = it.contains(word);
                    if (bl6 != null ? bl6 : false) return true;
                    Boolean bl7 = it.contains(lowered);
                    if (bl7 != null ? bl7 : false) {
                        return true;
                    }
                    boolean bl8 = false;
                    if (!bl8) continue;
                    return true;
                }
                bl = false;
            }
        }
        boolean inDictionary = bl;
        if (inDictionary) return true;
        if (!this.getAggregator().contains(word, caseSensitive)) return false;
        return true;
    }

    @NotNull
    public LinkedHashSet<String> suggest(@NotNull String word) {
        Intrinsics.checkNotNullParameter((Object)word, (String)"word");
        LinkedHashSet<String> result2 = new LinkedHashSet<String>();
        for (Dictionary dictionary : this.getDictionaries().values()) {
            dictionary.consumeSuggestions(word, (Consumer<String>)new Consumer(word, result2){
                final /* synthetic */ String $word;
                final /* synthetic */ LinkedHashSet $result;

                public final void consume(String it) {
                    double distance2 = Distances.INSTANCE.getLevenshtein().distance(this.$word, it, 4);
                    if (distance2 <= (double)3) {
                        this.$result.add(it);
                    }
                }
                {
                    this.$word = string;
                    this.$result = linkedHashSet;
                }
            });
        }
        result2.addAll((Collection)this.getAggregator().suggest(word));
        return result2;
    }
}

