/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.task.impl;

import com.intellij.internal.statistic.StructuredIdeActivity;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.OrderEnumerator;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectModelBuildableElement;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.task.ModuleBuildTask;
import com.intellij.task.ProjectTask;
import com.intellij.task.ProjectTaskContext;
import com.intellij.task.ProjectTaskListener;
import com.intellij.task.ProjectTaskManager;
import com.intellij.task.ProjectTaskRunner;
import com.intellij.task.ProjectTaskState;
import com.intellij.task.TaskRunnerResults;
import com.intellij.task.impl.AbstractProjectTask;
import com.intellij.task.impl.ModuleBuildTaskImpl;
import com.intellij.task.impl.ModuleFilesBuildTaskImpl;
import com.intellij.task.impl.ProjectModelBuildTaskImpl;
import com.intellij.task.impl.ProjectTaskList;
import com.intellij.task.impl.ProjectTaskManagerListener;
import com.intellij.task.impl.ProjectTaskManagerStatisticsCollector;
import com.intellij.task.impl.ProjectTaskScope;
import com.intellij.tracing.Tracer;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.ModalityUiUtil;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiPredicate;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.AsyncPromise;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;

public final class ProjectTaskManagerImpl
extends ProjectTaskManager {
    private static final Logger LOG = Logger.getInstance(ProjectTaskManager.class);
    private final ProjectTaskRunner myDummyTaskRunner;
    private final ProjectTaskListener myEventPublisher;
    private final List<ProjectTaskManagerListener> myListeners;

    public ProjectTaskManagerImpl(@NotNull Project project) {
        if (project == null) {
            ProjectTaskManagerImpl.$$$reportNull$$$0(0);
        }
        super(project);
        this.myDummyTaskRunner = new DummyTaskRunner();
        this.myListeners = new CopyOnWriteArrayList<ProjectTaskManagerListener>();
        this.myEventPublisher = (ProjectTaskListener)project.getMessageBus().syncPublisher(ProjectTaskListener.TOPIC);
    }

    public Promise<ProjectTaskManager.Result> build(Module @NotNull [] modules2) {
        if (modules2 == null) {
            ProjectTaskManagerImpl.$$$reportNull$$$0(1);
        }
        return this.run(this.createModulesBuildTask(modules2, true, true, false));
    }

    public Promise<ProjectTaskManager.Result> rebuild(Module @NotNull [] modules2) {
        if (modules2 == null) {
            ProjectTaskManagerImpl.$$$reportNull$$$0(2);
        }
        return this.run(this.createModulesBuildTask(modules2, false, false, false));
    }

    public Promise<ProjectTaskManager.Result> compile(VirtualFile @NotNull [] files2) {
        if (files2 == null) {
            ProjectTaskManagerImpl.$$$reportNull$$$0(3);
        }
        List buildTasks = ContainerUtil.map(Arrays.stream(files2).collect(Collectors.groupingBy(file2 -> ProjectFileIndex.SERVICE.getInstance((Project)this.myProject).getModuleForFile(file2, false))).entrySet(), entry2 -> new ModuleFilesBuildTaskImpl((Module)entry2.getKey(), false, (Collection)entry2.getValue()));
        return this.run(new ProjectTaskList(buildTasks));
    }

    public Promise<ProjectTaskManager.Result> build(ProjectModelBuildableElement @NotNull [] buildableElements) {
        if (buildableElements == null) {
            ProjectTaskManagerImpl.$$$reportNull$$$0(4);
        }
        return this.doBuild(buildableElements, true);
    }

    public Promise<ProjectTaskManager.Result> rebuild(ProjectModelBuildableElement @NotNull [] buildableElements) {
        if (buildableElements == null) {
            ProjectTaskManagerImpl.$$$reportNull$$$0(5);
        }
        return this.doBuild(buildableElements, false);
    }

    public Promise<ProjectTaskManager.Result> buildAllModules() {
        return this.run(this.createAllModulesBuildTask(true, this.myProject));
    }

    public Promise<ProjectTaskManager.Result> rebuildAllModules() {
        return this.run(this.createAllModulesBuildTask(false, this.myProject));
    }

    public ProjectTask createAllModulesBuildTask(boolean isIncrementalBuild, Project project) {
        return this.createModulesBuildTask(ModuleManager.getInstance((Project)project).getModules(), isIncrementalBuild, false, false);
    }

    public ProjectTask createModulesBuildTask(Module module, boolean isIncrementalBuild, boolean includeDependentModules, boolean includeRuntimeDependencies) {
        return this.createModulesBuildTask((Module[])ContainerUtil.ar((Object[])new Module[]{module}), isIncrementalBuild, includeDependentModules, includeRuntimeDependencies);
    }

    public ProjectTask createModulesBuildTask(Module[] modules2, boolean isIncrementalBuild, boolean includeDependentModules, boolean includeRuntimeDependencies) {
        return modules2.length == 1 ? new ModuleBuildTaskImpl(modules2[0], isIncrementalBuild, includeDependentModules, includeRuntimeDependencies) : new ProjectTaskList(ContainerUtil.map(Arrays.asList(modules2), module -> new ModuleBuildTaskImpl((Module)module, isIncrementalBuild, includeDependentModules, includeRuntimeDependencies)));
    }

    public ProjectTask createBuildTask(boolean isIncrementalBuild, ProjectModelBuildableElement ... buildableElements) {
        return buildableElements.length == 1 ? new ProjectModelBuildTaskImpl<ProjectModelBuildableElement>(buildableElements[0], isIncrementalBuild) : new ProjectTaskList(ContainerUtil.map(Arrays.asList(buildableElements), buildableElement -> new ProjectModelBuildTaskImpl<ProjectModelBuildableElement>((ProjectModelBuildableElement)buildableElement, isIncrementalBuild)));
    }

    public Promise<ProjectTaskManager.Result> run(@NotNull ProjectTask projectTask) {
        if (projectTask == null) {
            ProjectTaskManagerImpl.$$$reportNull$$$0(6);
        }
        return this.run(new ProjectTaskContext(), projectTask);
    }

    public Promise<ProjectTaskManager.Result> run(@NotNull ProjectTaskContext context2, @NotNull ProjectTask projectTask) {
        if (context2 == null) {
            ProjectTaskManagerImpl.$$$reportNull$$$0(7);
        }
        if (projectTask == null) {
            ProjectTaskManagerImpl.$$$reportNull$$$0(8);
        }
        Tracer.Span buildSpan = Tracer.start((String)"build");
        AsyncPromise promiseResult = new AsyncPromise();
        SmartList toRun2 = new SmartList();
        Consumer<Collection> taskClassifier = arg_0 -> this.lambda$run$6((List)toRun2, arg_0);
        ProjectTaskManagerImpl.visitTasks((Collection<? extends ProjectTask>)(projectTask instanceof ProjectTaskList ? (ProjectTaskList)projectTask : Collections.singleton(projectTask)), taskClassifier);
        buildSpan.complete();
        context2.putUserData(ProjectTaskScope.KEY, (Object)new ProjectTaskScope((List)toRun2){
            final /* synthetic */ List val$toRun;
            {
                this.val$toRun = list2;
            }

            @Override
            @NotNull
            public <T extends ProjectTask> List<T> getRequestedTasks(@NotNull Class<T> instanceOf) {
                if (instanceOf == null) {
                    1.$$$reportNull$$$0(0);
                }
                ArrayList tasks = new ArrayList();
                this.val$toRun.forEach(pair -> ((Collection)pair.second).stream().filter(instanceOf::isInstance).map(task2 -> task2).forEach(tasks::add));
                ArrayList arrayList = tasks;
                if (arrayList == null) {
                    1.$$$reportNull$$$0(1);
                }
                return arrayList;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 1: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 1: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "instanceOf";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/task/impl/ProjectTaskManagerImpl$1";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/task/impl/ProjectTaskManagerImpl$1";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getRequestedTasks";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "getRequestedTasks";
                        break;
                    }
                    case 1: {
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 1: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        });
        StructuredIdeActivity activity = ProjectTaskManagerStatisticsCollector.BUILD_ACTIVITY.started(this.myProject, () -> ProjectTaskManagerImpl.lambda$run$8((List)toRun2));
        this.myEventPublisher.started(context2);
        Runnable runnable2 = () -> this.lambda$run$13(context2, promiseResult, activity, (List)toRun2);
        if (ApplicationManager.getApplication().isDispatchThread()) {
            ApplicationManager.getApplication().executeOnPooledThread(runnable2);
        } else {
            runnable2.run();
        }
        promiseResult.onProcessed(result2 -> buildSpan.complete());
        return promiseResult;
    }

    @ApiStatus.Experimental
    @Nullable
    public static <T> T waitForPromise(@NotNull Promise<T> promise) {
        if (promise == null) {
            ProjectTaskManagerImpl.$$$reportNull$$$0(9);
        }
        while (true) {
            try {
                return (T)promise.blockingGet(10, TimeUnit.MILLISECONDS);
            }
            catch (TimeoutException timeoutException) {
            }
            catch (ExecutionException e) {
                ExceptionUtil.rethrow((Throwable)e);
            }
            ProgressManager.checkCanceled();
        }
    }

    @NotNull
    private static Supplier<List<String>> moduleOutputPathsProvider(@NotNull Module module) {
        if (module == null) {
            ProjectTaskManagerImpl.$$$reportNull$$$0(10);
        }
        Supplier<List<String>> supplier2 = () -> (List)ReadAction.compute(() -> JBIterable.of((Object[])OrderEnumerator.orderEntries((Module)module).withoutSdk().withoutLibraries().getClassesRoots()).filterMap(file2 -> file2.isDirectory() && !file2.getFileSystem().isReadOnly() ? file2.getPath() : null).toList());
        if (supplier2 == null) {
            ProjectTaskManagerImpl.$$$reportNull$$$0(11);
        }
        return supplier2;
    }

    public void addListener(@NotNull ProjectTaskManagerListener listener2) {
        if (listener2 == null) {
            ProjectTaskManagerImpl.$$$reportNull$$$0(12);
        }
        this.myListeners.add(listener2);
    }

    private static void sendSuccessEmptyResult(@NotNull ProjectTaskContext context2, @NotNull Consumer<? super ProjectTaskManager.Result> resultConsumer) {
        if (context2 == null) {
            ProjectTaskManagerImpl.$$$reportNull$$$0(13);
        }
        if (resultConsumer == null) {
            ProjectTaskManagerImpl.$$$reportNull$$$0(14);
        }
        resultConsumer.accept(new MyResult(context2, Collections.emptyMap(), false, false));
    }

    private static void sendAbortedEmptyResult(@NotNull ProjectTaskContext context2, @NotNull Consumer<? super ProjectTaskManager.Result> resultConsumer) {
        if (context2 == null) {
            ProjectTaskManagerImpl.$$$reportNull$$$0(15);
        }
        if (resultConsumer == null) {
            ProjectTaskManagerImpl.$$$reportNull$$$0(16);
        }
        resultConsumer.accept(new MyResult(context2, Collections.emptyMap(), true, false));
    }

    private static void visitTasks(@NotNull Collection<? extends ProjectTask> tasks, @NotNull Consumer<? super Collection<? extends ProjectTask>> consumer2) {
        if (tasks == null) {
            ProjectTaskManagerImpl.$$$reportNull$$$0(17);
        }
        if (consumer2 == null) {
            ProjectTaskManagerImpl.$$$reportNull$$$0(18);
        }
        if (tasks.isEmpty()) {
            return;
        }
        for (ProjectTask projectTask : tasks) {
            Object taskDependencies = projectTask instanceof AbstractProjectTask ? ((AbstractProjectTask)projectTask).getDependsOn() : (projectTask instanceof ProjectTaskList ? (ProjectTaskList)projectTask : ContainerUtil.emptyList());
            ProjectTaskManagerImpl.visitTasks(taskDependencies, consumer2);
        }
        consumer2.accept(tasks);
    }

    private Promise<ProjectTaskManager.Result> doBuild(ProjectModelBuildableElement @NotNull [] buildableElements, boolean isIncrementalBuild) {
        if (buildableElements == null) {
            ProjectTaskManagerImpl.$$$reportNull$$$0(19);
        }
        return this.run(this.createBuildTask(isIncrementalBuild, buildableElements));
    }

    private /* synthetic */ void lambda$run$13(ProjectTaskContext context2, AsyncPromise promiseResult, StructuredIdeActivity activity, List toRun2) {
        for (ProjectTaskManagerListener listener2 : this.myListeners) {
            try {
                listener2.beforeRun(context2);
            }
            catch (com.intellij.execution.ExecutionException e) {
                ProjectTaskManagerImpl.sendAbortedEmptyResult(context2, new ResultConsumer((AsyncPromise<ProjectTaskManager.Result>)promiseResult));
                activity.finished();
                return;
            }
        }
        if (toRun2.isEmpty()) {
            ProjectTaskManagerImpl.sendSuccessEmptyResult(context2, new ResultConsumer((AsyncPromise<ProjectTaskManager.Result>)promiseResult));
            activity.finished();
            return;
        }
        ProjectTaskResultsAggregator resultsCollector = new ProjectTaskResultsAggregator(context2, new ResultConsumer((AsyncPromise<ProjectTaskManager.Result>)promiseResult), toRun2.size(), activity);
        for (Pair pair : toRun2) {
            Consumer<ProjectTaskRunner.Result> runnerResultConsumer = result2 -> resultsCollector.add((ProjectTaskRunner.Result)result2, (Collection)pair.second);
            if (((Collection)pair.second).isEmpty()) {
                runnerResultConsumer.accept((ProjectTaskRunner.Result)TaskRunnerResults.SUCCESS);
                continue;
            }
            ProjectTaskRunner runner = (ProjectTaskRunner)pair.first;
            if (context2.isCollectionOfGeneratedFilesEnabled() && !runner.isFileGeneratedEventsSupported()) {
                ((Collection)pair.second).stream().filter(ModuleBuildTask.class::isInstance).map(task2 -> ((ModuleBuildTask)task2).getModule()).forEach(module -> context2.addDirtyOutputPathsProvider(ProjectTaskManagerImpl.moduleOutputPathsProvider(module)));
            }
            runner.run(this.myProject, context2, ((Collection)pair.second).toArray(EMPTY_TASKS_ARRAY)).onSuccess(runnerResultConsumer).onError(throwable -> runnerResultConsumer.accept((ProjectTaskRunner.Result)TaskRunnerResults.ABORTED));
        }
    }

    private static /* synthetic */ List lambda$run$8(List toRun2) {
        return Collections.singletonList(ProjectTaskManagerStatisticsCollector.TASK_RUNNER.with((Object)ContainerUtil.map((Collection)toRun2, it -> ((ProjectTaskRunner)it.first).getClass().getName())));
    }

    private /* synthetic */ void lambda$run$6(List toRun2, Collection tasks) {
        Map<ProjectTaskRunner, List<ProjectTask>> toBuild = tasks.stream().collect(Collectors.groupingBy(aTask -> Arrays.stream((ProjectTaskRunner[])ProjectTaskRunner.EP_NAME.getExtensions()).filter(runner -> {
            try {
                return runner.canRun(this.myProject, aTask);
            }
            catch (ProcessCanceledException e) {
                throw e;
            }
            catch (Throwable e) {
                LOG.error("Broken project task runner: " + runner.getClass().getName(), e);
                return false;
            }
        }).findFirst().orElse(this.myDummyTaskRunner)));
        for (Map.Entry<ProjectTaskRunner, List<ProjectTask>> entry2 : toBuild.entrySet()) {
            toRun2.add(Pair.create((Object)entry2.getKey(), (Object)entry2.getValue()));
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 11: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 11: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modules";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
            case 4: 
            case 5: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buildableElements";
                break;
            }
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectTask";
                break;
            }
            case 7: 
            case 13: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "promise";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/task/impl/ProjectTaskManagerImpl";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 14: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resultConsumer";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tasks";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/task/impl/ProjectTaskManagerImpl";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "moduleOutputPathsProvider";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "build";
                break;
            }
            case 2: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "rebuild";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "compile";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "run";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "waitForPromise";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "moduleOutputPathsProvider";
                break;
            }
            case 11: {
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "addListener";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "sendSuccessEmptyResult";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "sendAbortedEmptyResult";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "visitTasks";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "doBuild";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 11: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class ResultWrapper
    implements ProjectTaskManager.Result {
        private final ProjectTaskManager.Result myResult;

        private ResultWrapper(ProjectTaskManager.Result result2) {
            this.myResult = result2;
        }

        @NotNull
        public ProjectTaskContext getContext() {
            ProjectTaskContext projectTaskContext = this.myResult.getContext();
            if (projectTaskContext == null) {
                ResultWrapper.$$$reportNull$$$0(0);
            }
            return projectTaskContext;
        }

        public boolean isAborted() {
            return this.myResult.isAborted();
        }

        public boolean hasErrors() {
            return this.myResult.hasErrors();
        }

        public boolean anyTaskMatches(@NotNull BiPredicate<? super ProjectTask, ? super ProjectTaskState> predicate2) {
            if (predicate2 == null) {
                ResultWrapper.$$$reportNull$$$0(1);
            }
            return this.myResult.anyTaskMatches(predicate2);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/task/impl/ProjectTaskManagerImpl$ResultWrapper";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "predicate";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getContext";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/task/impl/ProjectTaskManagerImpl$ResultWrapper";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "anyTaskMatches";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static final class MyResult
    implements ProjectTaskManager.Result {
        private final ProjectTaskContext myContext;
        private final boolean myAborted;
        private final boolean myErrors;
        private final Map<ProjectTask, ProjectTaskState> myTasksState;

        private MyResult(@NotNull ProjectTaskContext context2, @NotNull Map<ProjectTask, ProjectTaskState> tasksState, boolean isAborted, boolean hasErrors) {
            if (context2 == null) {
                MyResult.$$$reportNull$$$0(0);
            }
            if (tasksState == null) {
                MyResult.$$$reportNull$$$0(1);
            }
            this.myContext = context2;
            this.myTasksState = tasksState;
            this.myAborted = isAborted;
            this.myErrors = hasErrors;
        }

        @NotNull
        public ProjectTaskContext getContext() {
            ProjectTaskContext projectTaskContext = this.myContext;
            if (projectTaskContext == null) {
                MyResult.$$$reportNull$$$0(2);
            }
            return projectTaskContext;
        }

        public boolean isAborted() {
            return this.myAborted;
        }

        public boolean hasErrors() {
            return this.myErrors;
        }

        public boolean anyTaskMatches(@NotNull BiPredicate<? super ProjectTask, ? super ProjectTaskState> predicate2) {
            if (predicate2 == null) {
                MyResult.$$$reportNull$$$0(3);
            }
            return this.myTasksState.entrySet().stream().anyMatch(entry2 -> predicate2.test((ProjectTask)entry2.getKey(), (ProjectTaskState)entry2.getValue()));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "tasksState";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/task/impl/ProjectTaskManagerImpl$MyResult";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "predicate";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/task/impl/ProjectTaskManagerImpl$MyResult";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getContext";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "anyTaskMatches";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static final class ProjectTaskResultsAggregator {
        private final ProjectTaskContext myContext;
        private final ResultConsumer myResultConsumer;
        private final AtomicInteger myProgressCounter;
        private final StructuredIdeActivity myActivity;
        private final AtomicBoolean myErrorsFlag;
        private final AtomicBoolean myAbortedFlag;
        private final Map<ProjectTask, ProjectTaskState> myTasksState;

        private ProjectTaskResultsAggregator(@NotNull ProjectTaskContext context2, @NotNull ResultConsumer resultConsumer, int expectedResults, @NotNull StructuredIdeActivity activity) {
            if (context2 == null) {
                ProjectTaskResultsAggregator.$$$reportNull$$$0(0);
            }
            if (activity == null) {
                ProjectTaskResultsAggregator.$$$reportNull$$$0(1);
            }
            if (resultConsumer == null) {
                ProjectTaskResultsAggregator.$$$reportNull$$$0(2);
            }
            this.myTasksState = new ConcurrentHashMap<ProjectTask, ProjectTaskState>();
            this.myContext = context2;
            this.myResultConsumer = resultConsumer;
            this.myProgressCounter = new AtomicInteger(expectedResults);
            this.myActivity = activity;
            this.myErrorsFlag = new AtomicBoolean(false);
            this.myAbortedFlag = new AtomicBoolean(false);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void add(final @NotNull ProjectTaskRunner.Result result2, @NotNull Collection<? extends ProjectTask> tasks) {
            if (result2 == null) {
                ProjectTaskResultsAggregator.$$$reportNull$$$0(3);
            }
            if (tasks == null) {
                ProjectTaskResultsAggregator.$$$reportNull$$$0(4);
            }
            int inProgress = this.myProgressCounter.decrementAndGet();
            ProjectTaskState state = new ProjectTaskState(){

                public boolean isSkipped() {
                    return result2.isAborted();
                }

                public boolean isFailed() {
                    return result2.hasErrors();
                }
            };
            for (ProjectTask projectTask : tasks) {
                this.myTasksState.put(projectTask, state);
            }
            if (result2.isAborted()) {
                this.myAbortedFlag.set(true);
            }
            if (result2.hasErrors()) {
                this.myErrorsFlag.set(true);
            }
            if (inProgress <= 0) {
                try {
                    this.myResultConsumer.accept(new MyResult(this.myContext, this.myTasksState, this.myAbortedFlag.get(), this.myErrorsFlag.get()));
                }
                finally {
                    this.myActivity.finished();
                }
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "activity";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "resultConsumer";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "result";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "tasks";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/task/impl/ProjectTaskManagerImpl$ProjectTaskResultsAggregator";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "add";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private final class ResultConsumer
    implements Consumer<ProjectTaskManager.Result> {
        @NotNull
        private final AsyncPromise<ProjectTaskManager.Result> myPromise;

        private ResultConsumer(AsyncPromise<ProjectTaskManager.Result> promise) {
            if (promise == null) {
                ResultConsumer.$$$reportNull$$$0(0);
            }
            this.myPromise = promise;
        }

        @Override
        public void accept(@NotNull ProjectTaskManager.Result result2) {
            if (result2 == null) {
                ResultConsumer.$$$reportNull$$$0(1);
            }
            if (!result2.isAborted() && !result2.hasErrors()) {
                ApplicationManager.getApplication().executeOnPooledThread(() -> {
                    try {
                        for (ProjectTaskManagerListener listener2 : ProjectTaskManagerImpl.this.myListeners) {
                            listener2.afterRun(result2);
                        }
                        this.notify(result2);
                    }
                    catch (com.intellij.execution.ExecutionException e) {
                        LOG.debug((Throwable)e);
                        this.notify(new ResultWrapper(result2){

                            @Override
                            public boolean hasErrors() {
                                return true;
                            }
                        });
                    }
                });
            } else {
                this.notify(result2);
            }
        }

        private void notify(@NotNull ProjectTaskManager.Result result2) {
            if (result2 == null) {
                ResultConsumer.$$$reportNull$$$0(2);
            }
            ModalityUiUtil.invokeLaterIfNeeded((ModalityState)ModalityState.defaultModalityState(), () -> {
                if (!ProjectTaskManagerImpl.this.myProject.isDisposed()) {
                    ProjectTaskManagerImpl.this.myEventPublisher.finished(result2);
                }
                this.myPromise.setResult((Object)result2);
            });
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "promise";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "result";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/task/impl/ProjectTaskManagerImpl$ResultConsumer";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "accept";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "notify";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class DummyTaskRunner
    extends ProjectTaskRunner {
        private DummyTaskRunner() {
        }

        public Promise<ProjectTaskRunner.Result> run(@NotNull Project project, @NotNull ProjectTaskContext context2, ProjectTask ... tasks) {
            if (project == null) {
                DummyTaskRunner.$$$reportNull$$$0(0);
            }
            if (context2 == null) {
                DummyTaskRunner.$$$reportNull$$$0(1);
            }
            if (tasks == null) {
                DummyTaskRunner.$$$reportNull$$$0(2);
            }
            return Promises.resolvedPromise((Object)TaskRunnerResults.SUCCESS);
        }

        public boolean canRun(@NotNull ProjectTask projectTask) {
            if (projectTask == null) {
                DummyTaskRunner.$$$reportNull$$$0(3);
            }
            return true;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "tasks";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "projectTask";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/task/impl/ProjectTaskManagerImpl$DummyTaskRunner";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "run";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "canRun";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

