/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.terminal;

import com.intellij.execution.filters.Filter;
import com.intellij.execution.filters.HyperlinkInfo;
import com.intellij.execution.filters.HyperlinkWithHoverInfo;
import com.intellij.execution.filters.HyperlinkWithPopupMenuInfo;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.terminal.CompositeFilterWrapper;
import com.intellij.terminal.JBTerminalPanel;
import com.intellij.terminal.JBTerminalSystemSettingsProviderBase;
import com.intellij.terminal.JBTerminalWidgetListener;
import com.intellij.terminal.TerminalExecutionConsole;
import com.intellij.terminal.actions.TerminalActionUtil;
import com.intellij.ui.SearchTextField;
import com.intellij.ui.components.JBScrollBar;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.util.LineSeparator;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.JBSwingUtilities;
import com.jediterm.terminal.SubstringFinder;
import com.jediterm.terminal.TerminalColor;
import com.jediterm.terminal.TtyConnector;
import com.jediterm.terminal.model.SelectionUtil;
import com.jediterm.terminal.model.StyleState;
import com.jediterm.terminal.model.TerminalSelection;
import com.jediterm.terminal.model.TerminalTextBuffer;
import com.jediterm.terminal.model.hyperlinks.LinkInfo;
import com.jediterm.terminal.model.hyperlinks.LinkResult;
import com.jediterm.terminal.model.hyperlinks.LinkResultItem;
import com.jediterm.terminal.ui.JediTermWidget;
import com.jediterm.terminal.ui.TerminalAction;
import com.jediterm.terminal.ui.TerminalPanel;
import com.jediterm.terminal.ui.settings.SettingsProvider;
import com.jediterm.terminal.util.Pair;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.DefaultFocusTraversalPolicy;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ItemListener;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.util.Collection;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JScrollBar;
import javax.swing.event.DocumentListener;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JBTerminalWidget
extends JediTermWidget
implements Disposable,
DataProvider {
    private static final Logger LOG = Logger.getInstance(JBTerminalWidget.class);
    public static final DataKey<JBTerminalWidget> TERMINAL_DATA_KEY = DataKey.create(JBTerminalWidget.class.getName());
    public static final DataKey<String> SELECTED_TEXT_DATA_KEY = DataKey.create(JBTerminalWidget.class.getName() + " selected text");
    private final CompositeFilterWrapper myCompositeFilterWrapper;
    private JBTerminalWidgetListener myListener;
    private final Project myProject;

    public JBTerminalWidget(@NotNull Project project, @NotNull JBTerminalSystemSettingsProviderBase settingsProvider, @NotNull Disposable parent) {
        if (project == null) {
            JBTerminalWidget.$$$reportNull$$$0(0);
        }
        if (settingsProvider == null) {
            JBTerminalWidget.$$$reportNull$$$0(1);
        }
        if (parent == null) {
            JBTerminalWidget.$$$reportNull$$$0(2);
        }
        this(project, 80, 24, settingsProvider, null, parent);
    }

    public JBTerminalWidget(@NotNull Project project, int columns, int lines2, @NotNull JBTerminalSystemSettingsProviderBase settingsProvider, @Nullable TerminalExecutionConsole console2, @NotNull Disposable parent) {
        if (project == null) {
            JBTerminalWidget.$$$reportNull$$$0(3);
        }
        if (settingsProvider == null) {
            JBTerminalWidget.$$$reportNull$$$0(4);
        }
        if (parent == null) {
            JBTerminalWidget.$$$reportNull$$$0(5);
        }
        super(columns, lines2, (SettingsProvider)settingsProvider);
        this.myCompositeFilterWrapper = new CompositeFilterWrapper(project, console2, this);
        this.myProject = project;
        this.addHyperlinkFilter(line -> this.runFilters(project, line));
        this.setName("terminal");
        Disposer.register((Disposable)parent, (Disposable)this);
        this.setFocusTraversalPolicy(new DefaultFocusTraversalPolicy(){

            @Override
            public Component getDefaultComponent(Container aContainer) {
                return JBTerminalWidget.this.getTerminalPanel();
            }
        });
    }

    @Nullable
    private LinkResult runFilters(@NotNull Project project, @NotNull String line) {
        Filter.Result r;
        if (project == null) {
            JBTerminalWidget.$$$reportNull$$$0(6);
        }
        if (line == null) {
            JBTerminalWidget.$$$reportNull$$$0(7);
        }
        if ((r = (Filter.Result)ReadAction.compute(() -> {
            if (project.isDisposed()) {
                return null;
            }
            try {
                return this.myCompositeFilterWrapper.getCompositeFilter().applyFilter(line, line.length());
            }
            catch (ProcessCanceledException e) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Skipping running filters on " + line, (Throwable)e);
                }
                return null;
            }
        })) != null) {
            return new LinkResult(ContainerUtil.mapNotNull((Collection)r.getResultItems(), item -> this.convertResultItem(project, (Filter.ResultItem)item)));
        }
        return null;
    }

    @Nullable
    private LinkResultItem convertResultItem(@NotNull Project project, @NotNull Filter.ResultItem item) {
        HyperlinkInfo info2;
        if (project == null) {
            JBTerminalWidget.$$$reportNull$$$0(8);
        }
        if (item == null) {
            JBTerminalWidget.$$$reportNull$$$0(9);
        }
        if ((info2 = item.getHyperlinkInfo()) != null) {
            return new LinkResultItem(item.getHighlightStartOffset(), item.getHighlightEndOffset(), this.convertInfo(project, info2));
        }
        return null;
    }

    @NotNull
    private LinkInfo convertInfo(@NotNull Project project, final @NotNull HyperlinkInfo info2) {
        if (project == null) {
            JBTerminalWidget.$$$reportNull$$$0(10);
        }
        if (info2 == null) {
            JBTerminalWidget.$$$reportNull$$$0(11);
        }
        LinkInfo.Builder builder2 = new LinkInfo.Builder().setNavigateCallback(() -> info2.navigate(project));
        if (info2 instanceof HyperlinkWithPopupMenuInfo) {
            builder2.setPopupMenuGroupProvider(new LinkInfo.PopupMenuGroupProvider(){

                @NotNull
                public List<TerminalAction> getPopupMenuGroup(@NotNull MouseEvent event) {
                    ActionGroup group2;
                    if (event == null) {
                        2.$$$reportNull$$$0(0);
                    }
                    Object[] actions2 = (group2 = ((HyperlinkWithPopupMenuInfo)info2).getPopupMenuGroup(event)) != null ? group2.getChildren(null) : AnAction.EMPTY_ARRAY;
                    List list2 = ContainerUtil.map((Object[])actions2, action2 -> TerminalActionUtil.createTerminalAction(JBTerminalWidget.this, action2));
                    if (list2 == null) {
                        2.$$$reportNull$$$0(1);
                    }
                    return list2;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    RuntimeException runtimeException;
                    Object[] objectArray;
                    Object[] objectArray2;
                    int n2;
                    String string;
                    switch (n) {
                        default: {
                            string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                            break;
                        }
                        case 1: {
                            string = "@NotNull method %s.%s must not return null";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            n2 = 3;
                            break;
                        }
                        case 1: {
                            n2 = 2;
                            break;
                        }
                    }
                    Object[] objectArray3 = new Object[n2];
                    switch (n) {
                        default: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "event";
                            break;
                        }
                        case 1: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "com/intellij/terminal/JBTerminalWidget$2";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[1] = "com/intellij/terminal/JBTerminalWidget$2";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[1] = "getPopupMenuGroup";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            objectArray = objectArray;
                            objectArray[2] = "getPopupMenuGroup";
                            break;
                        }
                        case 1: {
                            break;
                        }
                    }
                    String string2 = String.format(string, objectArray);
                    switch (n) {
                        default: {
                            runtimeException = new IllegalArgumentException(string2);
                            break;
                        }
                        case 1: {
                            runtimeException = new IllegalStateException(string2);
                            break;
                        }
                    }
                    throw runtimeException;
                }
            });
        }
        if (info2 instanceof HyperlinkWithHoverInfo) {
            builder2.setHoverConsumer(new LinkInfo.HoverConsumer(){

                public void onMouseEntered(@NotNull JComponent hostComponent, @NotNull Rectangle linkBounds) {
                    if (hostComponent == null) {
                        3.$$$reportNull$$$0(0);
                    }
                    if (linkBounds == null) {
                        3.$$$reportNull$$$0(1);
                    }
                    ((HyperlinkWithHoverInfo)info2).onMouseEntered(hostComponent, linkBounds);
                }

                public void onMouseExited() {
                    ((HyperlinkWithHoverInfo)info2).onMouseExited();
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2 = new Object[3];
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[0] = "hostComponent";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[0] = "linkBounds";
                            break;
                        }
                    }
                    objectArray[1] = "com/intellij/terminal/JBTerminalWidget$3";
                    objectArray[2] = "onMouseEntered";
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            });
        }
        LinkInfo linkInfo = builder2.build();
        if (linkInfo == null) {
            JBTerminalWidget.$$$reportNull$$$0(12);
        }
        return linkInfo;
    }

    public JBTerminalWidgetListener getListener() {
        return this.myListener;
    }

    public void setListener(JBTerminalWidgetListener listener2) {
        this.myListener = listener2;
    }

    @NotNull
    public Project getProject() {
        Project project = this.myProject;
        if (project == null) {
            JBTerminalWidget.$$$reportNull$$$0(13);
        }
        return project;
    }

    protected JBTerminalPanel createTerminalPanel(@NotNull SettingsProvider settingsProvider, @NotNull StyleState styleState, @NotNull TerminalTextBuffer textBuffer) {
        if (settingsProvider == null) {
            JBTerminalWidget.$$$reportNull$$$0(14);
        }
        if (styleState == null) {
            JBTerminalWidget.$$$reportNull$$$0(15);
        }
        if (textBuffer == null) {
            JBTerminalWidget.$$$reportNull$$$0(16);
        }
        JBTerminalPanel panel2 = new JBTerminalPanel((JBTerminalSystemSettingsProviderBase)settingsProvider, textBuffer, styleState);
        Disposer.register((Disposable)this, (Disposable)panel2);
        return panel2;
    }

    @NotNull
    public JBTerminalPanel getTerminalPanel() {
        JBTerminalPanel jBTerminalPanel = (JBTerminalPanel)super.getTerminalPanel();
        if (jBTerminalPanel == null) {
            JBTerminalWidget.$$$reportNull$$$0(17);
        }
        return jBTerminalPanel;
    }

    protected Graphics getComponentGraphics(Graphics graphics) {
        return JBSwingUtilities.runGlobalCGTransform((JComponent)((Object)this), (Graphics)super.getComponentGraphics(graphics));
    }

    protected JScrollBar createScrollBar() {
        JBScrollBar bar = new JBScrollBar(){

            public Color getBackground() {
                return JBTerminalWidget.this.myTerminalPanel.getBackground();
            }
        };
        bar.setOpaque(true);
        bar.putClientProperty(JBScrollPane.Alignment.class, (Object)JBScrollPane.Alignment.RIGHT);
        bar.putClientProperty((Object)JBScrollBar.TRACK, (g, x, y, width, height, object) -> {
            SubstringFinder.FindResult result2 = this.myTerminalPanel.getFindResult();
            if (result2 != null) {
                int modelHeight = bar.getModel().getMaximum() - bar.getModel().getMinimum();
                TerminalColor backgroundColor = this.mySettingsProvider.getFoundPatternColor().getBackground();
                if (backgroundColor != null) {
                    g.setColor(this.mySettingsProvider.getTerminalColorPalette().getBackground(backgroundColor));
                }
                int anchorHeight = Math.max(2, height / modelHeight);
                for (SubstringFinder.FindResult.FindItem r : result2.getItems()) {
                    int where = height * r.getStart().y / modelHeight;
                    g.fillRect(x, y + where, width, anchorHeight);
                }
            }
        });
        return bar;
    }

    public int getFontSize() {
        return this.getSettingsProvider().getUiSettingsManager().getFontSize();
    }

    public void setFontSize(int fontSize) {
        this.getSettingsProvider().getUiSettingsManager().setFontSize(fontSize);
    }

    public void resetFontSize() {
        this.getSettingsProvider().getUiSettingsManager().resetFontSize();
    }

    static boolean isTerminalToolWindow(@Nullable ToolWindow toolWindow2) {
        return toolWindow2 != null && "Terminal".equals(toolWindow2.getId());
    }

    public void dispose() {
        this.close();
    }

    protected JediTermWidget.SearchComponent createSearchComponent() {
        return new JediTermWidget.SearchComponent(){
            private final SearchTextField myTextField = new SearchTextField(false);

            public String getText() {
                return this.myTextField.getText();
            }

            public boolean ignoreCase() {
                return false;
            }

            public JComponent getComponent() {
                this.myTextField.setOpaque(false);
                return this.myTextField;
            }

            public void addDocumentChangeListener(DocumentListener listener2) {
                this.myTextField.addDocumentListener(listener2);
            }

            public void addKeyListener(KeyListener listener2) {
                this.myTextField.addKeyboardListener(listener2);
            }

            public void addIgnoreCaseListener(ItemListener listener2) {
            }

            public void onResultUpdated(SubstringFinder.FindResult result2) {
            }

            public void nextFindResultItem(SubstringFinder.FindResult.FindItem item) {
            }

            public void prevFindResultItem(SubstringFinder.FindResult.FindItem item) {
            }
        };
    }

    public void addMessageFilter(@NotNull Filter filter) {
        if (filter == null) {
            JBTerminalWidget.$$$reportNull$$$0(18);
        }
        this.myCompositeFilterWrapper.addFilter(filter);
    }

    public void start(TtyConnector connector) {
        this.setTtyConnector(connector);
        this.start();
    }

    @NotNull
    public JBTerminalSystemSettingsProviderBase getSettingsProvider() {
        JBTerminalSystemSettingsProviderBase jBTerminalSystemSettingsProviderBase = (JBTerminalSystemSettingsProviderBase)this.mySettingsProvider;
        if (jBTerminalSystemSettingsProviderBase == null) {
            JBTerminalWidget.$$$reportNull$$$0(19);
        }
        return jBTerminalSystemSettingsProviderBase;
    }

    public void moveDisposable(@NotNull Disposable newParent) {
        if (newParent == null) {
            JBTerminalWidget.$$$reportNull$$$0(20);
        }
        Disposer.register((Disposable)newParent, (Disposable)this);
    }

    public void notifyStarted() {
        if (this.myListener != null) {
            this.myListener.onTerminalStarted();
        }
    }

    public void notifyRenamed() {
        if (this.myListener != null) {
            this.myListener.onTerminalRenamed();
        }
    }

    @Override
    @Nullable
    public Object getData(@NotNull String dataId) {
        if (dataId == null) {
            JBTerminalWidget.$$$reportNull$$$0(21);
        }
        if (SELECTED_TEXT_DATA_KEY.is(dataId)) {
            return JBTerminalWidget.getSelectedText(this.getTerminalPanel());
        }
        if (TERMINAL_DATA_KEY.is(dataId)) {
            return this;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    static String getSelectedText(@NotNull TerminalPanel terminalPanel) {
        TerminalSelection selection;
        if (terminalPanel == null) {
            JBTerminalWidget.$$$reportNull$$$0(22);
        }
        if ((selection = terminalPanel.getSelection()) == null) {
            return null;
        }
        TerminalTextBuffer buffer = terminalPanel.getTerminalTextBuffer();
        buffer.lock();
        try {
            Pair points = selection.pointsForRun(terminalPanel.getColumnCount());
            String string = SelectionUtil.getSelectionText((Point)((Point)points.first), (Point)((Point)points.second), (TerminalTextBuffer)buffer);
            return string;
        }
        finally {
            buffer.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    static String getText(@NotNull TerminalPanel terminalPanel) {
        if (terminalPanel == null) {
            JBTerminalWidget.$$$reportNull$$$0(23);
        }
        TerminalTextBuffer buffer = terminalPanel.getTerminalTextBuffer();
        buffer.lock();
        TerminalSelection selection = new TerminalSelection(new Point(0, -buffer.getHistoryLinesCount()), new Point(terminalPanel.getWidth(), buffer.getScreenLinesCount()));
        Pair points = selection.pointsForRun(terminalPanel.getColumnCount());
        String string = SelectionUtil.getSelectionText((Point)((Point)points.first), (Point)((Point)points.second), (TerminalTextBuffer)buffer);
        String string2 = string;
        if (string2 == null) {
            JBTerminalWidget.$$$reportNull$$$0(24);
        }
        return string2;
        finally {
            buffer.unlock();
        }
    }

    public void writePlainMessage(@NotNull @Nls String message2) {
        if (message2 == null) {
            JBTerminalWidget.$$$reportNull$$$0(25);
        }
        String str = StringUtil.convertLineSeparators((String)message2, (String)LineSeparator.LF.getSeparatorString());
        List lines2 = StringUtil.split((String)str, (String)LineSeparator.LF.getSeparatorString(), (boolean)true, (boolean)false);
        boolean first = true;
        for (String line : lines2) {
            if (!first) {
                this.myTerminal.carriageReturn();
                this.myTerminal.newLine();
            }
            this.myTerminal.writeCharacters(line);
            first = false;
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 12: 
            case 13: 
            case 17: 
            case 19: 
            case 24: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 12: 
            case 13: 
            case 17: 
            case 19: 
            case 24: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 4: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settingsProvider";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "line";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "item";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 12: 
            case 13: 
            case 17: 
            case 19: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/terminal/JBTerminalWidget";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "styleState";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "textBuffer";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filter";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newParent";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataId";
                break;
            }
            case 22: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "terminalPanel";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/terminal/JBTerminalWidget";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "convertInfo";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getProject";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getTerminalPanel";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getSettingsProvider";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "runFilters";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "convertResultItem";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "convertInfo";
                break;
            }
            case 12: 
            case 13: 
            case 17: 
            case 19: 
            case 24: {
                break;
            }
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "createTerminalPanel";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "addMessageFilter";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "moveDisposable";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "getData";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "getSelectedText";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "getText";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "writePlainMessage";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 12: 
            case 13: 
            case 17: 
            case 19: 
            case 24: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

