/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.tools;

import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.JDOMExternalizable;
import com.intellij.tools.ToolManager;
import com.intellij.tools.ToolsBundle;
import java.util.Objects;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;

public class FilterInfo
implements JDOMExternalizable {
    @NonNls
    private static final String FILTER_NAME = "NAME";
    @NonNls
    private static final String FILTER_DESCRIPTION = "DESCRIPTION";
    @NonNls
    private static final String FILTER_REGEXP = "REGEXP";
    private String myName = ToolsBundle.message("tools.filters.name.default", new Object[0]);
    private String myDescription;
    private String myRegExp;
    @NonNls
    private static final String ELEMENT_OPTION = "option";
    @NonNls
    private static final String ATTRIBUTE_VALUE = "value";
    @NonNls
    private static final String ATTRIBUTE_NAME = "name";

    public FilterInfo() {
    }

    public FilterInfo(String regExp, String name2, String description) {
        this.myRegExp = regExp;
        this.myName = name2;
        this.myDescription = description;
    }

    public String getDescription() {
        return this.myDescription;
    }

    public void setDescription(String description) {
        this.myDescription = description;
    }

    public String getName() {
        return this.myName;
    }

    public void setName(String name2) {
        this.myName = name2;
    }

    public String getRegExp() {
        return this.myRegExp;
    }

    public void setRegExp(String regExp) {
        this.myRegExp = regExp;
    }

    public int hashCode() {
        return Comparing.hashcode((Object)this.myName) + Comparing.hashcode((Object)this.myDescription) + Comparing.hashcode((Object)this.myRegExp);
    }

    public boolean equals(Object object) {
        if (!(object instanceof FilterInfo)) {
            return false;
        }
        FilterInfo other = (FilterInfo)object;
        return Objects.equals(this.myName, other.myName) && Objects.equals(this.myDescription, other.myDescription) && Objects.equals(this.myRegExp, other.myRegExp);
    }

    public FilterInfo createCopy() {
        return new FilterInfo(this.myRegExp, this.myName, this.myDescription);
    }

    public void readExternal(Element element2) {
        for (Element optionElement : element2.getChildren(ELEMENT_OPTION)) {
            String value2 = optionElement.getAttributeValue(ATTRIBUTE_VALUE);
            String name2 = optionElement.getAttributeValue(ATTRIBUTE_NAME);
            if (FILTER_NAME.equals(name2) && value2 != null) {
                this.myName = FilterInfo.convertString(value2);
            }
            if (FILTER_DESCRIPTION.equals(name2)) {
                this.myDescription = FilterInfo.convertString(value2);
            }
            if (!FILTER_REGEXP.equals(name2)) continue;
            this.myRegExp = FilterInfo.convertString(value2);
        }
    }

    public void writeExternal(Element filterElement) {
        Element option2 = new Element(ELEMENT_OPTION);
        filterElement.addContent(option2);
        option2.setAttribute(ATTRIBUTE_NAME, FILTER_NAME);
        if (this.myName != null) {
            option2.setAttribute(ATTRIBUTE_VALUE, this.myName);
        }
        option2 = new Element(ELEMENT_OPTION);
        filterElement.addContent(option2);
        option2.setAttribute(ATTRIBUTE_NAME, FILTER_DESCRIPTION);
        if (this.myDescription != null) {
            option2.setAttribute(ATTRIBUTE_VALUE, this.myDescription);
        }
        option2 = new Element(ELEMENT_OPTION);
        filterElement.addContent(option2);
        option2.setAttribute(ATTRIBUTE_NAME, FILTER_REGEXP);
        if (this.myRegExp != null) {
            option2.setAttribute(ATTRIBUTE_VALUE, this.myRegExp);
        }
    }

    public static String convertString(String s) {
        return ToolManager.convertString(s);
    }
}

