/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.tools;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.Executor;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.configurations.PtyCommandLine;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.executors.DefaultRunExecutor;
import com.intellij.execution.process.NopProcessHandler;
import com.intellij.execution.process.OSProcessHandler;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.runners.ExecutionEnvironmentBuilder;
import com.intellij.execution.runners.ProgramRunner;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.execution.util.ExecutionErrorDialog;
import com.intellij.execution.wsl.WSLCommandLineOptions;
import com.intellij.execution.wsl.WSLDistribution;
import com.intellij.execution.wsl.WslMacroPathConverter;
import com.intellij.execution.wsl.WslPath;
import com.intellij.ide.macro.Macro;
import com.intellij.ide.macro.MacroManager;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.impl.SimpleDataContext;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.options.SchemeElement;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.tools.FilterInfo;
import com.intellij.tools.ToolProcessAdapter;
import com.intellij.tools.ToolRunProfile;
import com.intellij.tools.ToolsBundle;
import com.intellij.tools.ToolsCustomizer;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Objects;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Tool
implements SchemeElement {
    private static final Logger LOG = Logger.getInstance(Tool.class);
    @NonNls
    public static final String ACTION_ID_PREFIX = "Tool_";
    public static final String DEFAULT_GROUP_NAME = "External Tools";
    protected static final ProcessEvent NOT_STARTED_EVENT = new ProcessEvent((ProcessHandler)new NopProcessHandler(), -1);
    @NlsSafe
    private String myName;
    private String myDescription;
    @NotNull
    private String myGroup = "External Tools";
    private boolean myShownInMainMenu;
    private boolean myShownInEditor;
    private boolean myShownInProjectViews;
    private boolean myShownInSearchResultsPopup;
    private boolean myEnabled;
    private boolean myUseConsole;
    private boolean myShowConsoleOnStdOut;
    private boolean myShowConsoleOnStdErr;
    private boolean mySynchronizeAfterExecution;
    private String myWorkingDirectory;
    private String myProgram;
    private String myParameters;
    private ArrayList<FilterInfo> myOutputFilters = new ArrayList();

    @NlsSafe
    public String getName() {
        return this.myName;
    }

    @NlsSafe
    public String getDescription() {
        return this.myDescription;
    }

    @NlsSafe
    @NotNull
    public String getGroup() {
        String string = this.myGroup;
        if (string == null) {
            Tool.$$$reportNull$$$0(0);
        }
        return string;
    }

    public boolean isShownInMainMenu() {
        return this.myShownInMainMenu;
    }

    public boolean isShownInEditor() {
        return this.myShownInEditor;
    }

    public boolean isShownInProjectViews() {
        return this.myShownInProjectViews;
    }

    public boolean isShownInSearchResultsPopup() {
        return this.myShownInSearchResultsPopup;
    }

    public boolean isEnabled() {
        return this.myEnabled;
    }

    public void setEnabled(boolean enabled) {
        this.myEnabled = enabled;
    }

    public boolean isUseConsole() {
        return this.myUseConsole;
    }

    public boolean isShowConsoleOnStdOut() {
        return this.myShowConsoleOnStdOut;
    }

    public boolean isShowConsoleOnStdErr() {
        return this.myShowConsoleOnStdErr;
    }

    public boolean synchronizeAfterExecution() {
        return this.mySynchronizeAfterExecution;
    }

    public void setName(@NlsSafe String name2) {
        this.myName = name2;
    }

    public void setDescription(@NlsSafe String description) {
        this.myDescription = description;
    }

    public void setGroup(@NonNls @NotNull String group2) {
        if (group2 == null) {
            Tool.$$$reportNull$$$0(1);
        }
        this.myGroup = StringUtil.isEmpty((String)group2) ? DEFAULT_GROUP_NAME : group2;
    }

    public void setShownInMainMenu(boolean shownInMainMenu) {
        this.myShownInMainMenu = shownInMainMenu;
    }

    public void setShownInEditor(boolean shownInEditor) {
        this.myShownInEditor = shownInEditor;
    }

    public void setShownInProjectViews(boolean shownInProjectViews) {
        this.myShownInProjectViews = shownInProjectViews;
    }

    public void setShownInSearchResultsPopup(boolean shownInSearchResultsPopup) {
        this.myShownInSearchResultsPopup = shownInSearchResultsPopup;
    }

    public void setUseConsole(boolean useConsole) {
        this.myUseConsole = useConsole;
    }

    public void setShowConsoleOnStdOut(boolean showConsole) {
        this.myShowConsoleOnStdOut = showConsole;
    }

    public void setShowConsoleOnStdErr(boolean showConsole) {
        this.myShowConsoleOnStdErr = showConsole;
    }

    public void setFilesSynchronizedAfterRun(boolean synchronizeAfterRun) {
        this.mySynchronizeAfterExecution = synchronizeAfterRun;
    }

    public String getWorkingDirectory() {
        return this.myWorkingDirectory;
    }

    public void setWorkingDirectory(String workingDirectory) {
        this.myWorkingDirectory = workingDirectory;
    }

    public String getProgram() {
        return this.myProgram;
    }

    public void setProgram(String program) {
        this.myProgram = program;
    }

    public String getParameters() {
        return this.myParameters;
    }

    public void setParameters(String parameters2) {
        this.myParameters = parameters2;
    }

    public void addOutputFilter(FilterInfo filter) {
        this.myOutputFilters.add(filter);
    }

    public void setOutputFilters(FilterInfo[] filters) {
        this.myOutputFilters = new ArrayList();
        if (filters != null) {
            Collections.addAll(this.myOutputFilters, filters);
        }
    }

    public FilterInfo[] getOutputFilters() {
        return this.myOutputFilters.toArray(new FilterInfo[0]);
    }

    public void copyFrom(Tool source) {
        this.myName = source.getName();
        this.myDescription = source.getDescription();
        this.myGroup = source.getGroup();
        this.myShownInMainMenu = source.isShownInMainMenu();
        this.myShownInEditor = source.isShownInEditor();
        this.myShownInProjectViews = source.isShownInProjectViews();
        this.myShownInSearchResultsPopup = source.isShownInSearchResultsPopup();
        this.myEnabled = source.isEnabled();
        this.myUseConsole = source.isUseConsole();
        this.myShowConsoleOnStdOut = source.isShowConsoleOnStdOut();
        this.myShowConsoleOnStdErr = source.isShowConsoleOnStdErr();
        this.mySynchronizeAfterExecution = source.synchronizeAfterExecution();
        this.myWorkingDirectory = source.getWorkingDirectory();
        this.myProgram = source.getProgram();
        this.myParameters = source.getParameters();
        this.myOutputFilters = new ArrayList<FilterInfo>(Arrays.asList(source.getOutputFilters()));
    }

    public boolean equals(Object obj2) {
        if (!(obj2 instanceof Tool)) {
            return false;
        }
        Tool source = (Tool)obj2;
        return Objects.equals(this.myName, source.myName) && Objects.equals(this.myDescription, source.myDescription) && Objects.equals(this.myGroup, source.myGroup) && this.myShownInMainMenu == source.myShownInMainMenu && this.myShownInEditor == source.myShownInEditor && this.myShownInProjectViews == source.myShownInProjectViews && this.myShownInSearchResultsPopup == source.myShownInSearchResultsPopup && this.myEnabled == source.myEnabled && this.myUseConsole == source.myUseConsole && this.myShowConsoleOnStdOut == source.myShowConsoleOnStdOut && this.myShowConsoleOnStdErr == source.myShowConsoleOnStdErr && this.mySynchronizeAfterExecution == source.mySynchronizeAfterExecution && Objects.equals(this.myWorkingDirectory, source.myWorkingDirectory) && Objects.equals(this.myProgram, source.myProgram) && Objects.equals(this.myParameters, source.myParameters) && Comparing.equal(this.myOutputFilters, source.myOutputFilters);
    }

    @NotNull
    public String getActionId() {
        StringBuilder name2 = new StringBuilder(this.getActionIdPrefix());
        name2.append(this.myGroup);
        name2.append('_');
        if (this.myName != null) {
            name2.append(this.myName);
        }
        String string = name2.toString();
        if (string == null) {
            Tool.$$$reportNull$$$0(2);
        }
        return string;
    }

    protected static void notifyCouldNotStart(@Nullable ProcessListener listener2) {
        if (listener2 != null) {
            listener2.processTerminated(NOT_STARTED_EVENT);
        }
    }

    public void execute(AnActionEvent event, DataContext dataContext, long executionId, @Nullable ProcessListener processListener2) {
        if (!this.executeIfPossible(event, dataContext, executionId, processListener2)) {
            Tool.notifyCouldNotStart(processListener2);
        }
    }

    public boolean executeIfPossible(AnActionEvent event, DataContext dataContext, long executionId, final @Nullable ProcessListener processListener2) {
        Project project = (Project)CommonDataKeys.PROJECT.getData(dataContext);
        if (project == null) {
            return false;
        }
        FileDocumentManager.getInstance().saveAllDocuments();
        try {
            if (this.isUseConsole()) {
                ExecutionEnvironment environment2 = ExecutionEnvironmentBuilder.create((Project)project, (Executor)DefaultRunExecutor.getRunExecutorInstance(), (RunProfile)new ToolRunProfile(this, dataContext)).build(new ProgramRunner.Callback(){

                    public void processStarted(RunContentDescriptor descriptor2) {
                        ProcessHandler processHandler2 = descriptor2.getProcessHandler();
                        if (processHandler2 != null && processListener2 != null) {
                            LOG.assertTrue(!processHandler2.isStartNotified(), (Object)"ProcessHandler is already startNotified, the listener won't be correctly notified");
                            processHandler2.addProcessListener(processListener2);
                        }
                    }
                });
                if (environment2.getState() == null) {
                    return false;
                }
                environment2.setExecutionId(executionId);
                environment2.getRunner().execute(environment2);
            } else {
                GeneralCommandLine commandLine = this.createCommandLine(dataContext);
                if (commandLine == null) {
                    return false;
                }
                OSProcessHandler handler2 = new OSProcessHandler(commandLine);
                handler2.addProcessListener((ProcessListener)new ToolProcessAdapter(project, this.synchronizeAfterExecution(), this.getName()));
                if (processListener2 != null) {
                    handler2.addProcessListener(processListener2);
                }
                handler2.startNotify();
            }
        }
        catch (ExecutionException ex) {
            ExecutionErrorDialog.show((ExecutionException)ex, (String)ToolsBundle.message("tools.process.start.error", new Object[0]), (Project)project);
            return false;
        }
        return true;
    }

    @Nullable
    public GeneralCommandLine createCommandLine(DataContext dataContext) {
        if (StringUtil.isEmpty((String)this.getWorkingDirectory())) {
            this.setWorkingDirectory("$ProjectFileDir$");
        }
        GeneralCommandLine commandLine = Registry.is((String)"use.tty.for.external.tools", (boolean)false) ? new PtyCommandLine().withConsoleMode(true) : new GeneralCommandLine();
        try {
            File exeFile;
            String exePath = MacroManager.getInstance().expandMacrosInString(this.getProgram(), true, dataContext);
            exePath = MacroManager.getInstance().expandMacrosInString(exePath, false, dataContext);
            if (exePath == null) {
                return null;
            }
            WSLDistribution wsl = WslPath.getDistributionByWindowsUncPath(exePath);
            WslMacroPathConverter pathConverter = null;
            if (wsl != null) {
                pathConverter = new WslMacroPathConverter(wsl);
                dataContext = SimpleDataContext.getSimpleContext(MacroManager.PATH_CONVERTER_KEY, pathConverter, dataContext);
            }
            String paramString = MacroManager.getInstance().expandMacrosInString(this.getParameters(), true, dataContext);
            String workingDir = MacroManager.getInstance().expandMacrosInString(this.getWorkingDirectory(), true, dataContext);
            commandLine.getParametersList().addParametersString(MacroManager.getInstance().expandMacrosInString(paramString, false, dataContext));
            String workDirExpanded = MacroManager.getInstance().expandMacrosInString(workingDir, false, dataContext);
            if (!StringUtil.isEmpty((String)workDirExpanded)) {
                commandLine.setWorkDirectory(workDirExpanded);
            }
            if ((exeFile = new File(exePath)).isDirectory() && exeFile.getName().endsWith(".app")) {
                commandLine.setExePath("open");
                commandLine.getParametersList().prependAll(new String[]{"-a", exePath});
            } else if (wsl != null) {
                try {
                    commandLine = Tool.createWslCommandLine((Project)CommonDataKeys.PROJECT.getData(dataContext), wsl, commandLine, workDirExpanded, pathConverter.convertPath(exePath));
                }
                catch (ExecutionException e) {
                    LOG.error("Failed to create wsl command line", (Throwable)e);
                }
            } else {
                commandLine.setExePath(exePath);
            }
        }
        catch (Macro.ExecutionCancelledException ignored) {
            return null;
        }
        return ToolsCustomizer.customizeCommandLine(commandLine, dataContext);
    }

    public void setGroupName(@NotNull String name2) {
        if (name2 == null) {
            Tool.$$$reportNull$$$0(3);
        }
        this.setGroup(name2);
    }

    public String getKey() {
        return this.getName();
    }

    @NotNull
    public SchemeElement copy() {
        Tool copy2 = new Tool();
        copy2.copyFrom(this);
        Tool tool = copy2;
        if (tool == null) {
            Tool.$$$reportNull$$$0(4);
        }
        return tool;
    }

    public String toString() {
        return this.myGroup + ": " + this.myName;
    }

    public String getActionIdPrefix() {
        return ACTION_ID_PREFIX;
    }

    @NotNull
    public static GeneralCommandLine createWslCommandLine(@Nullable Project project, @NotNull WSLDistribution wsl, @NotNull GeneralCommandLine cmd, @Nullable String linuxWorkingDir, @NotNull String linuxExePath) throws ExecutionException {
        if (wsl == null) {
            Tool.$$$reportNull$$$0(5);
        }
        if (cmd == null) {
            Tool.$$$reportNull$$$0(6);
        }
        if (linuxExePath == null) {
            Tool.$$$reportNull$$$0(7);
        }
        cmd.setExePath(linuxExePath);
        WSLCommandLineOptions wslOptions = new WSLCommandLineOptions();
        if (StringUtil.isNotEmpty((String)linuxWorkingDir)) {
            wslOptions.setRemoteWorkingDirectory(linuxWorkingDir);
        }
        cmd.setWorkDirectory((String)null);
        wslOptions.setShellPath(wsl.getShellPath()).setExecuteCommandInInteractiveShell(true);
        GeneralCommandLine generalCommandLine = wsl.patchCommandLine(cmd, project, wslOptions);
        if (generalCommandLine == null) {
            Tool.$$$reportNull$$$0(8);
        }
        return generalCommandLine;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 6: 
            case 7: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 6: 
            case 7: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/tools/Tool";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "group";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "wsl";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cmd";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "linuxExePath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getGroup";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/tools/Tool";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionId";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "copy";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "createWslCommandLine";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "setGroup";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "setGroupName";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "createWslCommandLine";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 6: 
            case 7: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

