/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.tools;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.ExecutionResult;
import com.intellij.execution.Executor;
import com.intellij.execution.configurations.CommandLineState;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.configurations.ModuleRunProfile;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.filters.Filter;
import com.intellij.execution.filters.RegexpFilter;
import com.intellij.execution.filters.TextConsoleBuilder;
import com.intellij.execution.filters.TextConsoleBuilderFactory;
import com.intellij.execution.process.ColoredProcessHandler;
import com.intellij.execution.process.OSProcessHandler;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.execution.process.ProcessTerminatedListener;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.runners.ProgramRunner;
import com.intellij.execution.ui.RunContentManager;
import com.intellij.ide.macro.Macro;
import com.intellij.ide.macro.MacroManager;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.tools.FilterInfo;
import com.intellij.tools.Tool;
import com.intellij.tools.ToolProcessAdapter;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public class ToolRunProfile
implements ModuleRunProfile {
    private static final Logger LOG = Logger.getInstance(ToolRunProfile.class);
    private final Tool myTool;
    private final DataContext myContext;
    private final GeneralCommandLine myCommandLine;

    public ToolRunProfile(Tool tool, DataContext context2) {
        this.myTool = tool;
        this.myContext = context2;
        this.myCommandLine = this.myTool.createCommandLine(context2);
    }

    @NotNull
    public String getName() {
        String string = ToolRunProfile.expandMacrosInName(this.myTool, this.myContext);
        if (string == null) {
            ToolRunProfile.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NlsSafe
    public static String expandMacrosInName(Tool tool, DataContext context2) {
        String name2 = tool.getName();
        if (name2 != null && name2.contains("$")) {
            try {
                return MacroManager.getInstance().expandMacrosInString(name2, true, context2);
            }
            catch (Macro.ExecutionCancelledException e) {
                LOG.info((Throwable)e);
            }
        }
        return name2;
    }

    public Icon getIcon() {
        return null;
    }

    public RunProfileState getState(@NotNull Executor executor, @NotNull ExecutionEnvironment env) {
        FilterInfo[] outputFilters;
        if (executor == null) {
            ToolRunProfile.$$$reportNull$$$0(1);
        }
        if (env == null) {
            ToolRunProfile.$$$reportNull$$$0(2);
        }
        final Project project = env.getProject();
        if (this.myCommandLine == null) {
            return null;
        }
        CommandLineState commandLineState = new CommandLineState(env){

            GeneralCommandLine createCommandLine() {
                return ToolRunProfile.this.myCommandLine;
            }

            @NotNull
            protected OSProcessHandler startProcess() throws ExecutionException {
                GeneralCommandLine commandLine = this.createCommandLine();
                ColoredProcessHandler processHandler2 = new ColoredProcessHandler(commandLine);
                ProcessTerminatedListener.attach((ProcessHandler)processHandler2);
                ColoredProcessHandler coloredProcessHandler = processHandler2;
                if (coloredProcessHandler == null) {
                    1.$$$reportNull$$$0(0);
                }
                return coloredProcessHandler;
            }

            @NotNull
            public ExecutionResult execute(final @NotNull Executor executor, @NotNull ProgramRunner<?> runner) throws ExecutionException {
                ExecutionResult result2;
                ProcessHandler processHandler2;
                if (executor == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (runner == null) {
                    1.$$$reportNull$$$0(2);
                }
                if ((processHandler2 = (result2 = super.execute(executor, runner)).getProcessHandler()) != null) {
                    processHandler2.addProcessListener((ProcessListener)new ToolProcessAdapter(project, ToolRunProfile.this.myTool.synchronizeAfterExecution(), ToolRunProfile.this.getName()));
                    processHandler2.addProcessListener((ProcessListener)new ProcessAdapter(){

                        public void onTextAvailable(@NotNull ProcessEvent event, @NotNull Key outputType) {
                            if (event == null) {
                                1.$$$reportNull$$$0(0);
                            }
                            if (outputType == null) {
                                1.$$$reportNull$$$0(1);
                            }
                            if (outputType == ProcessOutputTypes.STDOUT && ToolRunProfile.this.myTool.isShowConsoleOnStdOut() || outputType == ProcessOutputTypes.STDERR && ToolRunProfile.this.myTool.isShowConsoleOnStdErr()) {
                                RunContentManager.getInstance((Project)project).toFrontRunContent(executor, processHandler2);
                            }
                        }

                        private static /* synthetic */ void $$$reportNull$$$0(int n) {
                            Object[] objectArray;
                            Object[] objectArray2 = new Object[3];
                            switch (n) {
                                default: {
                                    objectArray = objectArray2;
                                    objectArray2[0] = "event";
                                    break;
                                }
                                case 1: {
                                    objectArray = objectArray2;
                                    objectArray2[0] = "outputType";
                                    break;
                                }
                            }
                            objectArray[1] = "com/intellij/tools/ToolRunProfile$1$1";
                            objectArray[2] = "onTextAvailable";
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                        }
                    });
                }
                ExecutionResult executionResult = result2;
                if (executionResult == null) {
                    1.$$$reportNull$$$0(3);
                }
                return executionResult;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                    case 1: 
                    case 2: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 2;
                        break;
                    }
                    case 1: 
                    case 2: {
                        n2 = 3;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/tools/ToolRunProfile$1";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "executor";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "runner";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "startProcess";
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/tools/ToolRunProfile$1";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[1] = "execute";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray = objectArray;
                        objectArray[2] = "execute";
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                    case 1: 
                    case 2: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        };
        TextConsoleBuilder builder2 = TextConsoleBuilderFactory.getInstance().createBuilder(project);
        for (FilterInfo outputFilter : outputFilters = this.myTool.getOutputFilters()) {
            builder2.addFilter((Filter)new RegexpFilter(project, outputFilter.getRegExp()));
        }
        commandLineState.setConsoleBuilder(builder2);
        return commandLineState;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/tools/ToolRunProfile";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "executor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "env";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/tools/ToolRunProfile";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getState";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

