/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class LicensingFacade {
    public String licensedTo;
    public String licenseeEmail;
    public List<String> restrictions;
    public boolean isEvaluation;
    public Date expirationDate;
    public Date perpetualFallbackDate;
    public Map<String, Date> expirationDates;
    public Map<String, String> confirmationStamps;
    public String metadata;
    public static volatile LicensingFacade INSTANCE;
    private static final Gson ourGson;

    @Nullable
    public static LicensingFacade getInstance() {
        return INSTANCE;
    }

    @Nullable
    public String getLicensedToMessage() {
        return this.licensedTo;
    }

    @Nullable
    public String getLicenseeEmail() {
        return this.licenseeEmail;
    }

    @NotNull
    public List<String> getLicenseRestrictionsMessages() {
        List<String> result2 = this.restrictions;
        List<String> list2 = result2 != null ? result2 : Collections.emptyList();
        if (list2 == null) {
            LicensingFacade.$$$reportNull$$$0(0);
        }
        return list2;
    }

    public boolean isEvaluationLicense() {
        return this.isEvaluation;
    }

    public boolean isApplicableForProduct(@NotNull Date releaseDate) {
        if (releaseDate == null) {
            LicensingFacade.$$$reportNull$$$0(1);
        }
        Date expDate = this.expirationDate;
        return this.isPerpetualForProduct(releaseDate) || expDate == null || releaseDate.before(expDate);
    }

    public boolean isPerpetualForProduct(@NotNull Date releaseDate) {
        Date result2;
        if (releaseDate == null) {
            LicensingFacade.$$$reportNull$$$0(2);
        }
        return (result2 = this.perpetualFallbackDate) != null && releaseDate.before(result2);
    }

    @Nullable
    public Date getLicenseExpirationDate() {
        return this.expirationDate;
    }

    @Nullable
    public Date getExpirationDate(String productCode) {
        Map<String, Date> result2 = this.expirationDates;
        return result2 != null ? result2.get(productCode) : null;
    }

    @Nullable
    public String getConfirmationStamp(String productCode) {
        Map<String, String> result2 = this.confirmationStamps;
        return result2 != null ? result2.get(productCode) : null;
    }

    public String toJson() {
        return ourGson.toJson((Object)this);
    }

    @Nullable
    public static LicensingFacade fromJson(String json) {
        try {
            return (LicensingFacade)ourGson.fromJson(json, LicensingFacade.class);
        }
        catch (Throwable e) {
            return null;
        }
    }

    static {
        ourGson = new GsonBuilder().setDateFormat("yyyyMMdd").create();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ui/LicensingFacade";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "releaseDate";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getLicenseRestrictionsMessages";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ui/LicensingFacade";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "isApplicableForProduct";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isPerpetualForProduct";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

