/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.ui.components.JBList;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Enumeration;
import javax.swing.DefaultListModel;
import javax.swing.JFrame;
import javax.swing.ListModel;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import org.jetbrains.annotations.NotNull;

public class TreeList
extends JBList
implements TreeModelListener {
    private final TreeModel myTreeModel;
    private boolean myRootVisible = false;
    private final DefaultListModel myListModel = new DefaultListModel();

    public TreeList(TreeModel treeModel) {
        super.setModel((ListModel)this.myListModel);
        this.myTreeModel = treeModel;
        this.myTreeModel.addTreeModelListener(this);
        Object root2 = this.myTreeModel.getRoot();
        if (root2 instanceof TreeNode) {
            TreeNode node2 = (TreeNode)root2;
            this.myListModel.addElement(node2);
            if (this.myTreeModel instanceof DefaultTreeModel && ((DefaultTreeModel)this.myTreeModel).asksAllowsChildren() && node2.getAllowsChildren()) {
                Enumeration<? extends TreeNode> enumeration = node2.children();
                while (enumeration.hasMoreElements()) {
                    TreeNode object = enumeration.nextElement();
                    this.myListModel.addElement(object);
                }
            }
        }
    }

    public boolean isRootVisible() {
        return this.myRootVisible;
    }

    public void setRootVisible(boolean rootVisible) {
        this.myRootVisible = rootVisible;
    }

    public void setModel(@NotNull ListModel model2) {
        if (model2 == null) {
            TreeList.$$$reportNull$$$0(0);
        }
        throw new UnsupportedOperationException("TreeList accepts only TreeModel as a model");
    }

    @Override
    public void treeNodesChanged(TreeModelEvent e) {
    }

    @Override
    public void treeNodesInserted(TreeModelEvent e) {
    }

    @Override
    public void treeNodesRemoved(TreeModelEvent e) {
    }

    @Override
    public void treeStructureChanged(TreeModelEvent e) {
    }

    public static void main(String[] args) {
        JFrame frame = new JFrame("TreeList Showcase");
        frame.setLocation(0, 0);
        frame.setSize(800, 600);
        frame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                System.exit(0);
            }
        });
        Container contentPane = frame.getContentPane();
        contentPane.setLayout(new BorderLayout());
        DefaultMutableTreeNode rootNode = new DefaultMutableTreeNode("Sample root node");
        for (int i2 = 0; i2 < 5; ++i2) {
            DefaultMutableTreeNode node2 = new DefaultMutableTreeNode("Node #" + (i2 + 1));
            rootNode.add(node2);
        }
        DefaultTreeModel treeModel = new DefaultTreeModel(rootNode, true);
        TreeList treeList = new TreeList(treeModel);
        contentPane.add((Component)((Object)treeList));
        frame.setVisible(true);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/intellij/ui/TreeList", "setModel"));
    }
}

